!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Generic Option tree builder.
!
!
! @author  Unknown / J. Czechowski IV / Neon Ngo
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro s:func s:option

  global LASTBUILDRESULTS ! Global Table holding Build Status for each option tree in MAKE
  invoke l:FAILED  nxm.sys.lib.Build.BUILD_FAILURE    ! 1 - standard script exit code for failure
  invoke l:SUCCESS nxm.sys.lib.Build.BUILD_SUCCESSFUL ! 0 - standard script exit code for success

  ! Make sure a function is specified.
  if func eqs "" then
    warn "Nothing to make"
    stop
  elseif func eqs "ALL" then
    set funclist "CODE,HELP,JAR"
    res  LASTBUILDRESULTS {}       ! clear table
  else
    sedit func funclist GSUBstitute "|" ","
    res LASTBUILDRESULTS {}
  endif

  if option eqs "ALL" then
    set optlist opt.path
  else
    set optlist option
  endif

  set noCode true
  set noDocs true
  set noHelp true
  set noJar  true
  set noBun  true

  ! Determine what things should be built (notice that we are setting the inverse
  ! if we desire the function to be built, as the variables are "noXXXX"
  foreach item inList/delim='|' funclist
    if item EQS "CODE" then
      set noCode false
    elseif item EQS "DOCS" then
      set noDocs false
    elseif func eqs "DOC" then
      warn "DEPRECATED: MAKE: Do not use 'DOC' with MAKE, use 'DOCS'"
      set noDocs false
    elseif item EQS "HELP" then
      set noHelp false
    elseif item EQS "JAR" OR item EQS "JARS" then
      set noJar false
    elseif item EQS "BUNDLE" OR item EQS "BUN" then
      set noBun false
    elseif func eqs "CLEAN" then
      warn "Run 'nm make clean' outside the NeXtMidas shell"
      stop
    else
      error "Unsupported function [^item] specified. Allowable='CODE|DOCS|HELP|JAR|BUNDLE'."
      stop
    endif
  endfor

  if noHelp isTrue AND noDocs isFalse then
    set noHelp false
  endif

  ! NOTE: The /NC=, /NH= and /NJ= switches are immediately after BUILDOPT;SYS to
  !       prevent accidental propagation of them. If a custom buildopt.mm does not
  !       handle the switches and then blindly calls BUILDOPT;SYS, we error on the
  !       side of building everything. See Bug 1257 for details.
  if this.parentContext.macro rexists then
    warn "*************************************************************************"
    warn "** Calling MAKE from a BUILDOPT macro is deprecated, use BUILDOPT;SYS. **"
    warn "*************************************************************************"
    say "--> Using default system buildopt for ^option <--"
    buildopt;sys/nc=^noCode/nh=^noHelp/nj=^noJar ^option
  else
    foreach/rev optionTree inlist optlist
      ! check for user defined buildopt macro
      fname omfn mcr buildopt mm ^optionTree
      if omfn fexists and optionTree neqs "SYS" then
        say "--> Using option specific buildopt for ^optionTree <--"
        buildopt/mfn=omfn/nc=^noCode/nh=^noHelp/nj=^noJar/nb=^noBun ^optionTree
      else
        say "--> Using default system buildopt for ^optionTree <--"
        buildopt;sys/nc=^noCode/nh=^noHelp/nj=^noJar/nb=^noBun ^optionTree
      endif
    endfor
  endif

  if option eqs "ALL" and noHelp isFalse then
    say "--> Building Help Search Index <--"
    help/index
  endif

  ! Create a Summary result for this MAKE/BUILD
  global LASTBUILDRESULTS
  table LASTBUILDRESULTS GETKEYS buildkeys
  res l:buildcode SUCCESS
  FOREACH opttree INTABLE LASTBUILDRESULTS
   if LASTBUILDRESULTS.^{opttree}.STATUS NEQ 0 THEN
     res buildcode FAILED
   endif
  ENDFOR
  table LASTBUILDRESULTS SETKEY ALL {STATUS=^buildcode}

  ! Place the summary status in a unique file in $HOME, so the
  ! NM script can grab the MAKE status and set its EXIT status for $?
  invoke nmPID nxm.sys.lib.Shell.getNmPID()
  file name fullname (^{env.home}) nm_last_cmd_status_^{nmPID} txt
  file open/n/t cmdStatusFile fullname
  file write cmdStatusFile ^{buildcode}
  file close cmdStatusFile

endmacro
