!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! GEOGUI - NeXtMidas Geo Gui Demo Macro
! @author Jeff Schoen
! @version $Id: geogui.mm,v 1.14 2005/01/26 19:31:14 jxc Exp $
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main 

! JC4: Determine if MAP is available, if not then disable the MAP requirements
!      below.
if ",MAP," subs ",^{OPT.PATH}," then
  res mapAvailable 1
else
  say "Add the MAP option tree to path to enable enhanced mapping options."
  res mapAvailable 0
endif


pipe init

panel/setup

plot/id=gplot/theme=wob world|sv1|sv2 options=+contrast 

list/id=lst test3000 

plot/id=plot1 fftdemo view=yx cnt=motion axis=bframe

plot/id=plot2 sinewave view=yx cnt=click axis=bframe

plot/id=rplot apenny axis=frame

layer "Geo" geo {NAME=GEO,SVA=SV1,SVB=SV2,SITE=SITE,&
  FLAGS=ALL,TDOA=0,FDOA=0,DTDOA=0.001,DFDOA=0.010} gplot

gc label  macro "MACRO" 
gc choice macro "State    " "Clear,Reset,Exit" 

gc label  geola "Display" 
gc choice view  "View    " "LatLon,Geodetic" Lat

if mapAvailable then ! The "Detail" maps are in MAP.
  gc choice maps  "Maps    " "Coarse,Detail,Cities,Clear" Coarse
else
  gc choice maps  "Maps    " "Coarse,Cities,Clear" Coarse
endif
gc choice feat  "Features" "New,Move,Clear" 

gc label  geoevent  "GeoEvent" 0
set reg.panel.controls.geo {}	! create inner table
gc choice geo.sitemode  "SiteMode  " geo.sitemodelist geo.sitemode
gc choice geo.svecmode  "SVecMode  " geo.svecmodelist geo.svecmode
gc choice geo.tdoamode  "TDOAMode  " geo.tdoamodelist geo.tdoamode
gc choice geo.fdoamode  "FDOAMode  " geo.fdoamodelist geo.fdoamode
gc choice geo.vehicleA  "VehicleA  " "1,2,3,4,5,6,7,8" 1
gc choice geo.vehicleB  "VehicleB  " "1,2,3,4,5,6,7,8" 2
gc tval   geo.time      "CurrTime  " 0 0 86400 1 
gc tval   geo.dtime     "dCurrTime " 60 0 86400 1 
gc dval   geo.tdoa      "TDOA      " geo.tdoa -1 1 1e-3 /fmt="###.### ?sec"
gc dval   geo.dtdoa     "dTDOA     " geo.dtdoa -25 1 1e-3 /fmt="###.### ?sec"
gc dval   geo.fdoa      "FDOA      " geo.fdoa -1 1 1e-3 /fmt="###.### ?Hz"
gc dval   geo.dfdoa     "dFDOA     " geo.dfdoa -25 1000 1 /fmt="###.### ?Hz"
gc dval   geo.flinkT    "FLinkT    " geo.flinkT 0 1e9 1e3 /fmt="###.### ?Hz"
gc dval   geo.flinkA    "FLinkA    " geo.flinkA 0 1e9 1e3 /fmt="###.### ?Hz"
gc dval   geo.flinkB    "FLinkB    " geo.flinkB 0 1e9 1e3 /fmt="###.### ?Hz"

gc label  sri   "Reporting/SRI" 
gc prompt comm  "Comment " "All Java" 

pipe run
pipe wait
pipe off

endmacro


procedure processMessage

!say "Msg ^msg.name = ^msg.data"

if msg.fid eqs "PANEL"
  if msg.name eqs "MACRO"
    if msg.data eqs "EXIT"
      pipe stop
    elseif msg.data eqs "PING"
      message send xm ,, PING
    endif
  elseif msg.name eqs "VIEW"
    set reg.gplot.view msg.data
  elseif msg.name eqs "MAPS"
    if msg.data eqs "COARSE"
      message send gplot ,,  openfile -1 "WORLD"
    elseif msg.data eqs "DETAIL"
      message send gplot ,,  openfile -1 "MAP1|MAP2"
    elseif msg.data eqs "CITIES"
      !message send gplot ,,  openfile 1 "PLACES"
      message send gplot ,,  openfile 1 "CITIES"    ! JC4: use cities.prm
    elseif msg.data eqs "CLEAR"
      message send gplot ,,  closefile ,, "*"
    endif
  elseif msg.name eqs "FEAT"
    if msg.data eqs "NEW"
      set l:nfeat reg.gplot.features.getsize+1
      feature ,,, {NAME=F^nfeat,TYPE=4,X=10,Y=20,DX=2,DY=2,COLOR=red} gplot
    endif
  elseif msg.name eqss "GEO."
    set ^msg.name msg.data
  endif

elseif msg.fid eqs "GPLOT" then
  if msg.name eqs "MARK" then
    set geo.pos msg.data
  endif

elseif msg.fid eqs "PLOT1" OR msg.fid eqs "PLOT2" then
  !No processing of any messages from these plots
  
elseif msg.fid eqss "XM" then
  if msg.name eqs "GET" then
    message send xm ,, RET msg.info msg.data
  elseif msg.name eqs "RET" then
    foreach key intable msg.data
      say "Key ^key = ^msg.data.^key"
    endfor
  endif

else
  say "Unhandled message ^msg.name from ^msg.fid"
endif
return

