! Macro to build the libxm area. Note that this macro should only be launched
! from the X-Midas %BUILDOPT macro for NXM.
!
!  @author  J. Czechowski IV
!  @version $Id: buildopt_libxm.mm,v 1.16 2015/03/30 14:27:10 ntn Exp $
!  @since   NeXtMidas 2.1.0
!
startmacro
  debug on trace

  ! Get X-Midas environment variables
  import XMDISK            XMDISK
  import XM_PATH           XM_PATH
  import XM_VERSION        XM_VERSION
  import XM_FT_COMPILER    XM_FT_COMPILER
  import XM_CC_OPTIONS     XM_CC_OPTIONS
  import XM_BUILD_HEADLESS XM_BUILD_HEADLESS
  ! since 3.5.3 to allow enabling additional debug
  import NM_NEXTOPT_BUILD_DEBUG DEBUG_BUILD DEF=false

  if "^{XMDISK}" NDEXISTS then
    warn "XMDISK directory do not exist at ^{XMDISK}"
  elseif "^{XMDISK}/xm/inc" NDEXISTS then
    warn "XMDISK/xm/inc directory do not exist at ^{XMDISK}/xm/inc"
  elseif "^{XMDISK}/xm/include" NDEXISTS then
    warn "XMDISK/xm/include directory do not exist at ^{XMDISK}/xm/include"
  endif

  ! Build the auto-generated code using CONVERT
  say ""
  say "<GENERATING THE WRAPPER CODE FOR THE X-MIDAS STRUCTURES>"
  CONVERT/PACKAGE/VARIABLE="Mc"/INCLUDE="<midas.h>" &
         ^{XMDISK}/xm/inc/midas.inc   FSTRUCT2JAVA nxm.sys.libxm.Mc.java     "MCOMMON"
  CONVERT/PACKAGE/VARIABLE="Mt"/INCLUDE="<midas.h>,<tables.h>" &
         ^{XMDISK}/xm/inc/tables.inc  FSTRUCT2JAVA nxm.sys.libxm.Mt.java     "MTABLES"
  CONVERT/PACKAGE/CLASSSUB="TypeClass" &
         ^{XMDISK}/xm/inc/headers.inc FSTRUCT2JAVA nxm.sys.libxm.Header.java "HEADER"

  ! Build the auto-generated code using BYTEBUFFER;UCL
  say ""
  say "<GENERATING MESSAGE MAPPINGS FOR OPT=^{XM_PATH}>"
  CONVERT/XMDISK="^{XMDISK}"/PATH="^{XM_PATH}" NXM MSGCFG2TBL

  ! Set the compiler flags
  res CFLAGS XM_CC_OPTIONS
  res CFLAGS "^{CFLAGS} -DXM^{XM_VERSION}"
  res CFLAGS "^{CFLAGS} -D_^{XM_FT_COMPILER}"
! JC4: (18-OCT-06) Need to turn -pedantic off... too many warnings about
!      "$" in identifier (one for every m$... call). Ideally we would use
!      all of -pedantic except this warning.
!  res CFLAGS "^{CFLAGS} --pedantic"           ! JC4: Not sure why we need this.

  ! JC4: The next few lines handle some differences between XM 3.8.3 and 4.2.1. I have
  !      not tried 4.0.X but expect it may need some of these changes too.
  if ^{XM_VERSION} ge 420 then
    res CFLAGS "^{CFLAGS} -w"                 ! JC4: Used to be part of XM_CC_OPTIONS
    res CFLAGS "^{CFLAGS} -DNEW_PNAME_PTR"    ! JC4: Changed pointer for pipe names
  endif

  if XM_BUILD_HEADLESS then
    res CFLAGS "^{CFLAGS} -D_HEADLESS"
  endif

  ! This next based on $XMDISK/xm/unix/xpc - required flag for those using Promula Fortran Compiler
  if ENV.OSNAME eqs LINUX and XM_FT_COMPILER eqs PFC then
    res XM_CC_OPTIONS "^{XM_CC_OPTIONS} -fno-asm"
  endif

  ! Set the table of flags to pass to BLD
  res FLAGS {}
  res FLAGS.FLAGS_UNIX "-I^{ENV.NMROOT}/nxm/sys/libxm -I^{XMDISK}/xm/inc -I^{XMDISK}/xm/include ^{CFLAGS}"

  ! Build everything
  !  JC4: Since some of the files use each others headers we just keep all of
  !       the header files around during the compile and then delete them at
  !       the end.
  say ""
  say "<BUILDING THE LIBXM AREA IN THE NEXTMIDAS SYS OPTION TREE>"
  say ""
  if DEBUG_BUILD isTRUE then
    results/all flags
    say ""
  endif
  BUILD/NOEXIT/VERBOSE/DEBUG=^{DEBUG_BUILD}/BLDFLAGS=^FLAGS all libxm

  say ""
  say "<RETURNING TO X-MIDAS TO BUILD HOST PRIMITIVES>"
endmacro
