/*
   Non-Midas C Application For Sonet Acquisition/Playback

   Author: Bill Owen
*/

/* **********Sonet Module Type Names Were Changed In Version ice318b11 ***************/
/* Uncomment The #define OLDMODNAMES Line If Using Software Prior To ice318b11       */
/* Comment The #define OLDMODNAMES Line If Using Software Version ice318b11 Or Later */
/* If You Use The Wrong Module Names, Error Messages Will Be Reported                */
/*************************************************************************************/
/* #define OLDMODNAMES  1  */  
#ifdef OLDMODNAMES 
#define SR1MOD   "IOM=SNTXD"
#define SR2MOD   "IOM=SNTR2XD"
#define SR4MOD   "IOM=SNTR4XD"
#define SR5MOD   "IOM=SNTR5XD"
#else
#define SR1MOD   "IOM=SNTXD"
#define SR2MOD   "IOM=SNTXDR2"
#define SR4MOD   "IOM=SNTXDR4"
#define SR5MOD   "IOM=SNTXDR5"
#endif

#define DEVN "ICEPIC,DEVNO=%d,%s,%s,%s,,"


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>



#include "icedefs.h"
#include "icelib.h"

#define FLAGS 0


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_u1 answer_yes()
  {
   int keych = 'n';
   int_u4 cont_cfg = 0;

    while (keych != '\n')
     { 
       keych = getchar();
       if ((keych == 'Y') || (keych == 'y'))
         cont_cfg = 1;
       else if ((keych == 'N') || (keych == 'n'))
         cont_cfg = 0;
     }

    if (cont_cfg == 1)
      return(1);

    return(0);     
 } 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
void setup_cards (PICSTRUCT *p,char *modname,int idev,int numport,char *flagstr,int pora )
{
 
  char devname[160];
  int_4 flags = FLAGS;
  int_4 Mcbreak = 0;
  int_4 status,i;
  int_4 vhsflag   = 0;


 /* Setup Card Config String Based On Module Type */
  if (strcmp(modname,"r6")==0)  /* Sonet Rev 6 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        } 
       
      if (pora == 0)
        {
          if (numport == 1) 
            sprintf(devname,DEVN,idev,"IOM=DXSNTR6","MUXCLK=A",flagstr);
          else
            sprintf(devname,DEVN,idev,"IOM=DXSNTR6","MUXCLK=B",flagstr);
        } 
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,"IOM=SNTXDR6","",flagstr);
           else 
            { 
              if (numport == 1)
                sprintf(devname,DEVN,idev,"IOM=SNTXDR6","MUXCLK=A",flagstr);
              else 
                sprintf(devname,DEVN,idev,"IOM=SNTXDR6","MUXCLK=B",flagstr);
            }  
        }
    }
  else if (strcmp(modname,"r5")==0)  /* Sonet Rev 5 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        } 
       
      if (pora == 0)
        {
          if (numport == 1) 
            sprintf(devname,DEVN,idev,"IOM=DXSNTR5","MUXCLK=A",flagstr);
          else
            sprintf(devname,DEVN,idev,"IOM=DXSNTR5","MUXCLK=B",flagstr);
        } 
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,SR5MOD,"",flagstr);
           else 
            { 
              if (numport == 1)
                sprintf(devname,DEVN,idev,SR5MOD,"MUXCLK=A",flagstr);
              else 
                sprintf(devname,DEVN,idev,SR5MOD,"MUXCLK=B",flagstr);
            }  
        }
    }
  else if (strcmp(modname,"r4")==0)  /* Sonet Rev 4 */
    { 
      if (pora == 0)
        {
          if (numport == 1) 
            sprintf(devname,DEVN,idev,"IOM=DXSNTR4","MUXCLK=A",flagstr);
          else
            sprintf(devname,DEVN,idev,"IOM=DXSNTR4","MUXCLK=B",flagstr);
        } 
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,SR4MOD,"MUXCLK=N",flagstr);
           else 
            { 
              if (numport == 1)
                sprintf(devname,DEVN,idev,SR4MOD,"MUXCLK=N",flagstr);
              else 
                sprintf(devname,DEVN,idev,SR4MOD,"MUXCLK=N",flagstr);
            }  
        }
    }
  else if (strcmp(modname,"r2")==0)  /* Sonet Rev 2 */
    {
      if ((strstr(flagstr,"VHS") != NULL) || (strstr(flagstr,"vhs") != NULL))
        {
          vhsflag = 1;
          if (numport == 3)   
            {
              printf("VHS Modes Uses PIC Card Resources From Both Ports\n");
              printf("You Can Only Use VHS Mode For Single Port Acq/Play--NOT Both\n");
            }
        }  
       
      if (pora == 0)
        sprintf(devname,DEVN,idev,"IOM=DXSNTR2","MUXCLK=B",flagstr);
      else
        { 
          if (vhsflag == 0)  
            sprintf(devname,DEVN,idev,SR2MOD,"IOC=II",flagstr);
           else 
            sprintf(devname,DEVN,idev,SR2MOD,"MUXCLK=B",flagstr);
        }
    }
  else   /* Sonet Rev 1 */
    {
      if (pora == 0)
        sprintf(devname,DEVN,idev,"IOM=DXSNT","MUXCLK=B",flagstr);
      else
        sprintf(devname,DEVN,idev,SR1MOD,"IOC=II",flagstr); 
    }

/*  printf ("Starting ICE test on %s with flags=%s\n",devname,flagstr);  */

  /* Open Card For Access */
  status = pic_open (p, devname, &Mcbreak, flags);
  
  
 /* printf ("Finished\n"); */
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int testacq (PICSTRUCT *pi, PICSTRUCT *po, int numport, int testnum)
 {

#define MEGMEMBUF 0       /* Setting MEGMEMBUF To Non-Zero Overrides Memory Calculations Below Based On Sample Rate */
                          /* If Non-zero, Total Memory Allocated Will Be MEGMEMBUF * ONEMEG                         */

#define ONEMEG    1048576
#define VHSMEMBUF 768     /* 6 Byte Aligned For Very High Speed Mode PIC4T & OC24 Rates Only*/
#define ZERO    0


  int_4 dmac[2],nstart[2],nbytes[2],count[2];
  int_4 *data[2];
  int i,status[2],flags;
  int success = -1;
  unsigned char *datab[2];
  unsigned char pattern[2430]; 
  int ii,jj;
  int offset;
  float fjj;
   
  DMAMAP map[2];

  /* reset the card */
  pic_reset (pi, 0);
  pic_reset (po, 0);

  flags = 0;
#if _IEEE
  flags |= FLG_BIGEND;
#endif
      

   /*Acquire */              
  if (pi->type != ICEPIC5)   /* Only Load FPGA If Card Type != PIC5 */          
    pic_loadfile (pi, "*_ii", FLG_IOC);
  else
    pic_loadfile (pi, "*_iix", FLG_IOC);

  if (numport != 2)
    dmac[0] = pic_ioport (pi, IOPT_MODULE, 1, -1, -1, 8,80000000, 0.0,0,0,flags);
  if (numport != 1)
    dmac[0] = pic_ioport (pi, IOPT_MODULE, 2, -1, -1, 8,80000000, 0.0,0,0,flags);                   

  if (dmac[0]<=0)
    {
      printf("Acquisition Port Allocation Failed\n");
      return -1;
     }
 /* map the buffer to physical memory */
  count[0]  = 79626240; /* (16*ONEMEG)/4; */ /*  For Acquisition */
  nbytes[0] = count[0]*4;
  status[0] = pic_mapmem (pi, &map[0], nbytes[0], 1);
  if (status[0] <= 0)
    {
      printf("Program's attempt to allocate memory For Acquisition or Playback Failed!!!\n");
      printf("Option #1: Increase Mappable Memory Using setram Program in $ICEROOT/drv/lnx\n");
      printf("Option #2: Set #define MEGMEMBUF In testsnt.c To Value Lower Than Listed Above And Recompile\n");
      return -1;
    }

  datab[0] = (unsigned char *)map[0].vaddr;  /* Byte Data Pointer From DWORD Pointer */
 
  memset(datab[0],0,8*ONEMEG); 
       
 /* setup the DMA handler For Acquisition*/
  status[0] = pic_dmasetup (pi, dmac[0], -1, &map[0], -1, 0);
   if (status[0] < 0)
     {
       printf("DMA Start Failed Acquisition \n");
       return(-1);
     }       
 


 
 /* Playback */    
  if (po->type != ICEPIC5)  /* Only Load FPGA If Card Type != PIC5 */
    pic_loadfile (po, "*_ooy", FLG_IOC);
  
  if (numport != 2) 
    dmac[1] = pic_ioport (po, IOPT_MODULE, 1, -1, 1, 8, 80000000, 0.0,0,0,flags);             
  if (numport != 1)
    dmac[1] = pic_ioport (po, IOPT_MODULE, 2, -1, 1, 8, 80000000, 0.0,0,0,flags);
 

 if (dmac[1]<=0)
    {
      printf("Playback Port Allocation Failed\n");
      return -1;
    }
 /* map the buffer to physical memory */
  count[1]  = 79626240; /* (64*ONEMEG)/4; */ /*  Size of Our Mem Buffer For Port B in DWORDS */
  nbytes[1] = count[1]*4;
  status[1] = pic_mapmem (po, &map[1], nbytes[1], 1);
  if (status[1] <=0)
    {
      printf("Program's attempt to allocate memory For Acquisition or Playback Failed!!!\n");
      printf("Option #1: Increase Mappable Memory Using setram Program in $ICEROOT/drv/lnx\n");
      printf("Option #2: Set #define MEGMEMBUF In testsnt.c To Value Lower Than Listed Above And Recompile\n");
      return -1;
    }

  datab[1] = (unsigned char *)map[1].vaddr;  /* Byte Data Pointer From DWORD Pointer */
 

 /* Setup Data Pattern */
  for (ii=0;ii<3;ii++) 
    pattern[ii] = 0xF6;
  for (ii=3;ii<6;ii++) 
    pattern[ii] = 0x28;

  if ((testnum % 5) == 1) 
    {
      for (ii=0;ii<24;ii++)  /* Counter */    
        {
          for (jj=0;jj<101;jj++)
            pattern[6+(ii*101)+jj] = jj;
        }
    }
  else if ((testnum % 5) == 2)   
     {
       ii = 6;               /* Low Nibble Counter With High Nibble Inverted */
       while (ii<2430)
         { 
           pattern[ii] = (unsigned char) (ii & 0x000F) | ((((~ii) & 0x000F) << 4) & 0x00F0);
           ++ii;
         }
     } 
   else if ((testnum % 5) == 3)
     {
       for (ii=6;ii<2430;ii++)  /* Walking One */     
          pattern[ii] = (unsigned char)  (0x01 << (ii % 8));   
     }
   else if ((testnum % 5) == 4)
     {
       for (ii=6;ii<2430;ii++)  /* Walking ZERO */     
          pattern[ii] = (unsigned char)  (~(0x01 << (ii % 8)));   
     } 
   else
     {
       jj = 0;                  /* SineWave     */ 
       for (ii=6;ii<2430;ii++)
         {                  
            fjj = (float) jj;
            pattern[ii]   = ((unsigned short int)rint((256 + (127 * sin((2.0 * 3.14159) * (fjj/255.0)))))); 
            jj = (jj+1) % 256;
         } 
      
     }   
   
   memset(datab[0],0x00,nbytes[0]);
   memset(datab[1],0x00,nbytes[1]);

 
  /* Copy Pattern Into Memory */
   for(ii=0;ii<(nbytes[1]/2430);ii++)
     memcpy(datab[1]+(ii*2430),pattern,2430);

  /* Setup DMA Handler For Playback */    
   status[1] = pic_dmasetup (po, dmac[1], 1, &map[1], -1, 0);
   if (status[1] < 0)
     {
       printf("DMA Start Failed Playback\n");
       return(-1);
     }
 
 /* Start Continuous Playback */
  status[1] = pic_dmafunc (po, dmac[1], DMA_CONTINUOUS);
  sleep(5);
/* Start Oneshot Acquistion */
  status[0] = pic_dmafunc (pi, dmac[0], DMA_ONESHOT);
  sleep(5);
 
  status[0] = pic_dmafunc (pi, dmac[0], DMA_CANCEL);                /* Stop ICEPIC DMA Acquisition */
  status[1] = pic_dmafunc (po, dmac[1], DMA_CANCEL);                /* Stop ICEPIC DMA Playback*/

  /* Find F6F6F628 Pattern */ 
   offset = 0;
   for(ii=0;ii<(4*ONEMEG);ii++)
     {     
       if ( (*(datab[0]+ii) == 0xF6) && (*(datab[0]+ii+1) == 0xF6) && (*(datab[0]+ii+2) == 0xF6) && (*(datab[0]+ii+3) == 0x28)) 
          {
            offset = ii;
            break;
          }
      }

 /*
   if (offset != 0) 
    printf("%s%d\n","Offset = ",offset);
 */
  
   /* Fix Tx BIP Calculations */
   ii = 270+offset;
   while(ii < ((40*ONEMEG)+offset))
     { 
       *(datab[0]+ii) = *(datab[1]+270); 
       ii = ii+2430;
     }

  /* Check For Data Correctness */
    if (memcmp(datab[1],datab[0]+offset,40*ONEMEG)==0)   
     success = 1; 
   else
     {
       printf("\tFailure!!!\n");   
       for (jj=0;jj<10;jj++)
         printf("%s%d%s%x%s%x\n","Index = ",jj," Data 0 = ", *(datab[0]+jj)," Data 1 = ",*(datab[1]+jj)); 

       printf("\n\n%s%d\n","Offset = ",offset);
       ii = offset;
       while (*(datab[1]+ii-offset) == *(datab[0]+ii))
          ii = ii +1;
       for (jj=0;jj<10;jj++)
          printf("%s%d%s%x%s%x\n","Index = ",ii+jj," Data 0 = ", *(datab[0]+ii+jj)," Data 1 = ",*(datab[1]+jj+ii-offset));  
             
       return(success);
       
       for(ii=offset;ii<(100+offset);ii++)
        {
         if (*(datab[1]+ii-offset) != *(datab[0]+ii)) 
           printf("%s%d%s%x%s%x\n","Index = ",ii," Data I = ", *(datab[0]+ii)," Data O = ",*(datab[1]+ii-offset));   
        }  
     } 
  
    
    
  status[0] = pic_mapmem (pi, map, nbytes[0], -1);   /* unmap the buffer to physical memory */
  status[1] = pic_mapmem (po, map+1, nbytes[1], -1);   /* unmap the buffer to physical memory */
 
  
 
  /* reset the card       */
  /*  pic_reset (pi, 0);  */
  /* pic_reset (po, 0);   */ 

  return(success);
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int looptest(char *modname,int acqcard,int playcard,int portnum,char *flagstr)
 {
  PICSTRUCT  pi;
  PICSTRUCT  po;
 
  int ii;
  int numcorrect = 0;

  for (ii=0;ii<5;ii++)
    {
      fprintf(stderr,"Performing Test #%d, Results: ",ii+1);      
      setup_cards(&pi,modname,acqcard,portnum,flagstr,1);   /* Acquire */
      setup_cards(&po,modname,playcard,portnum,flagstr,0);  /* Play    */

      if (strstr(flagstr,"SNTMEMTEST") == NULL)
        { 
           if (testacq(&pi,&po,portnum,ii+1) < 0)
             {
               printf("\tFailure!!!\n");
               return(-1); 
             }
           else
             {
               printf("\tSuccess\n");    
               ++numcorrect;
             } 
         }
       else
         { 
          /* reset the card */
           pic_reset (&pi, 0);
           pic_reset (&po, 0); 
           
           printf("\n***********************************\n");
           printf("***** Module On Card #1 *****\n");
           printf("***********************************\n");
           pic_getkeyl (&pi,0,KEY_DUMP);

           printf("\n***********************************\n");
           printf("***** Module On Card #2 *****\n");
           printf("***********************************\n");
           pic_getkeyl (&po,0,KEY_DUMP);
           ii = 5;
         } 

       pic_close(&pi);
       pic_close(&po);
    } 

  
   return(0); 
          
 }
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int main (int argc, char *argv[])
{
  
  char flagstr[360];
  char modname[80];
  int testgroup = 0;
  int maxtest = 8;

  if (argc <= 1) 
   {
    printf("Syntax:  fatsnt <mod type> <test group num>\n");
    printf("              <mod type>       = r1:SonetR1 OR r2:SonetR2 OR r4:SonetR4 OR r5:SonetR5 modules\n");
    printf("              <test group num> = (OPTIONAL) For Conducting A Specific Test Number\n");
    exit(0);
   }

   strcpy(modname,argv[1]);
 
   if (argc > 2) 
    testgroup = atoi(argv[2]);

    
  /* Setup Card Config String Based On Module Type */
  if (strcmp(modname,"r6")==0)  /* Sonet Rev 6 */
    {
      maxtest = 6;
      if (testgroup < 3)
        { 
          printf("Start Test On SonetR6 \n");
          printf("Module 1: Plug 1st Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n");
          printf("Module 2: Plug 2nd Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n"); 
          printf("Ready??? 'y' or 'n' ");
          if (answer_yes() == 0)
            {
              printf("Exiting Test\n");
              exit(-1);
            }  
        }
    
      if (testgroup <= 1)
        { 
          strcpy(flagstr,"OC192|OC3NUM=5|FORCE|SNTWARNOFF");      
          printf("\nPerforming Test Group #1, OC192 Test, Module 1 Card 1 Rx, Card 2 Tx\n");
          if (looptest(modname,0,1,1,flagstr) < 0)
            exit(-1); 
        }
    

      if (testgroup <= 2)
        {
          strcpy(flagstr,"OC192|OC3NUM=5|SNTWARNOFF");
          printf("\nPerforming Test Group #2, OC192 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest(modname,0,1,2,flagstr) < 0)
            exit(-1); 
        }
    

      if (testgroup <= 5)
       {  
         printf("Start Test On SonetR6 \n");
         printf("Module 1: Plug 1st Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n");
         printf("Module 2: Plug 2nd Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n"); 
         printf("***PLUG IN 10 MHZ External Reference Onto Module Clock Port Of Both Cards***\n");
         printf("Ready??? 'y' or 'n' ");
         if (answer_yes() == 0)
           {
             printf("Exiting Test\n");
             exit(-1);
           }
       }    
      
      if (testgroup <= 3)
        {
          strcpy(flagstr,"OC192,OC3NUM=5|FORCE|SNTWARNOFF");
          printf("\nPerforming Test Group #3, OC192 Test, Module: 1 Card 2 Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,1,flagstr) < 0)
            exit(-1);    
        }
      
      if (testgroup <= 4)
        {
          strcpy(flagstr,"OC192,OC3NUM=5|SNTWARNOFF");
          printf("\nPerforming Test Group #4, OC192 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,2,flagstr) < 0)
            exit(-1); 
        }
             
      if (testgroup <= 5)
        {
          strcpy(flagstr,"OC192,OC3NUM=5|SNTWARNOFF|PREFX");
          printf("\nPerforming *PREFX* Test Group #5, OC192 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,2,flagstr) < 0)
            {
              printf("Check 10MHz PREFX Connection On BOTH Modules of BOTH Cards\n");
               exit(-1);
            } 
        }

      if (testgroup <= 6)
        {
          strcpy(flagstr,"OC48,OC3NUM=5|SNTWARNOFF|SNTMEMTEST");
          printf("\nPerforming Test Group #6, Memory Test, Both Cards\n");
          if (looptest(modname,0,1,1,flagstr) < 0)
            exit(-1);    
        }        

    }
   else if (strcmp(modname,"r5")==0)  /* Sonet Rev 5 */
    {
      maxtest = 12;
      if (testgroup < 7)
        {
          printf("Start Test On SonetR5 \n");
          printf("Module 1: Plug 1st Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n");
          printf("Module 2: Plug 2nd Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n"); 
          printf("Ready??? 'y' or 'n' ");
          if (answer_yes() == 0)
            {
              printf("Exiting Test\n");
              exit(-1);
            }
        }
   
     if (testgroup <= 1)
        { 
          printf("\nPerforming Test Group #1, OC48 Test, Module 1: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r5",0,1,1,"OC48,OC3FROMOCX,OC3NUM=5|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 2)
        {
          printf("\nPerforming Test Group #2, OC12 Test, Module 1: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r5",0,1,1,"OC12,OC3FROMOCX,OC3NUM=3|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 3)
        { 
          printf("\nPerforming Test Group #3, OC3  Test, Module 1: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r5",0,1,1,"OC3|FORCE") < 0)
            exit(-1); 
        }
     if (testgroup <= 4)
        {
          printf("\nPerforming Test Group #4, OC48 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r5",0,1,2,"OC48,OC3FROMOCX,OC3NUM=5|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 5)
        {  
          printf("\nPerforming Test Group #5, OC12 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r5",0,1,2,"OC12,OC3FROMOCX,OC3NUM=3|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 6)
        { 
          printf("\nPerforming Test Group #6, OC3  Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r5",0,1,2,"OC3|FORCE") < 0)
            exit(-1);
        }
 
      
      if (testgroup <= maxtest)
       {  
         printf("Start Test On SonetR5\n");
         printf("Module 1: Plug 1st Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n");
         printf("Module 2: Plug 2nd Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n"); 
         printf("Ready??? 'y' or 'n' ");
         if (answer_yes() == 0)
           {
             printf("Exiting Test\n");
             exit(-1);
           }
       }
        
  
     if (testgroup <= 7)
        {
          printf("\nPerforming Test Group #7, OC48 Test, Module 1: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r5",1,0,1,"OC48,OC3FROMOCX,OC3NUM=5|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 8)
        {
          printf("\nPerforming Test Group #8, OC12 Test, Module 1: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r5",1,0,1,"OC12,OC3FROMOCX,OC3NUM=3|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 9)
        {
          printf("\nPerforming Test Group #9, OC3  Test, Module 1: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r5",1,0,1,"OC3|FORCE") < 0)
            exit(-1);
        } 
     if (testgroup <= 10)
        {
          printf("\nPerforming Test Group #10, OC48 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r5",1,0,2,"OC48,OC3FROMOCX,OC3NUM=5|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 11)
        { 
          printf("\nPerforming Test Group #11, OC12 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r5",1,0,2,"OC12,OC3FROMOCX,OC3NUM=3|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 12)
        {
          printf("\nPerforming Test Group #12, OC3  Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r5",1,0,2,"OC3|FORCE") < 0)
            exit(-1);
        }     
    }
   else if (strcmp(modname,"r4")==0)  /* Sonet Rev 4 */
    {
      if (testgroup < 5)
        { 
          printf("Start Test On SonetR4 \n");
          printf("Module 1: Plug 1st Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n");
          printf("Module 2: Plug 2nd Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n"); 
          printf("Ready??? 'y' or 'n' ");
          if (answer_yes() == 0)
            {
              printf("Exiting Test\n");
              exit(-1);
            }  
        }
    
      if (testgroup <= 1)
        { 
          strcpy(flagstr,"OC192|OC3NUM=5|FORCE");      
          printf("\nPerforming Test Group #1, OC192 Test, Module 1 Card 1 Rx, Card 2 Tx\n");
          if (looptest(modname,0,1,1,flagstr) < 0)
            exit(-1); 
        }
    
      if (testgroup <= 2)
        {
          strcpy(flagstr,"OC48|OC3NUM=5|FORCE");
          printf("\nPerforming Test Group #2, OC48 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest(modname,0,1,2,flagstr) < 0)
            exit(-1); 
        }
      if (testgroup <= 3)
        {
          strcpy(flagstr,"OC12|OC3NUM=3|FORCE");
          printf("\nPerforming Test Group #3, OC12 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest(modname,0,1,2,flagstr) < 0)
            exit(-1); 
        }

      if (testgroup <= 4)
        { 
          strcpy(flagstr,"OC3|FORCE");
          printf("\nPerforming Test Group #4, OC3  Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest(modname,0,1,2,flagstr) < 0)
            exit(-1); 
        } 
      
      
      if (testgroup <= maxtest)
       {  
         printf("Start Test On SonetR4 \n");
         printf("Module 1: Plug 1st Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n");
         printf("Module 2: Plug 2nd Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n"); 
         printf("Ready??? 'y' or 'n' ");
         if (answer_yes() == 0)
           {
             printf("Exiting Test\n");
             exit(-1);
           }
       }    
      
      if (testgroup <= 5)
        {
          strcpy(flagstr,"OC192,OC3NUM=5|FORCE");
          printf("\nPerforming Test Group #5, OC192 Test, Module: 1 Card 2 Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,1,flagstr) < 0)
            exit(-1);    
        }
      
      if (testgroup <= 6)
        {
          strcpy(flagstr,"OC48,OC3NUM=5|FORCE");
          printf("\nPerforming Test Group #6, OC48 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,2,flagstr) < 0)
            exit(-1); 
        }
    
      if (testgroup <= 7)
        {
          strcpy(flagstr,"OC12,OC3NUM=3|FORCE");
          printf("\nPerforming Test Group #7, OC12 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,2,flagstr) < 0)
            exit(-1);
         }

      if (testgroup <= 8)
        {
          strcpy(flagstr,"OC3|FORCE");
          printf("\nPerforming Test Group #8, OC3  Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest(modname,1,0,2,flagstr) < 0)
            exit(-1);
        }        
    }
   else if (strcmp(modname,"r2")==0)  /* Sonet Rev 2 */
    {
      if (testgroup < 5)
        {
          printf("Start Test On SonetR2 \n");
          printf("Module 1: Plug 1st Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n");
          printf("Module 2: Plug 2nd Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n"); 
          printf("Ready??? 'y' or 'n' ");
          if (answer_yes() == 0)
            {
              printf("Exiting Test\n");
              exit(-1);
            }
        }   
     if (testgroup <= 1)
        {
          printf("\nPerforming Test Group #1, OC3 Test, Module 1: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r2",0,1,1,"OC3|FORCE") < 0)
            exit(-1);
        } 
     if (testgroup <= 2)
        {
          printf("\nPerforming Test Group #2, OC48 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r2",0,1,2,"OC48,OC3FROMOCX,OC3NUM=5|FORCE") < 0)
            exit(-1);
        }  
     if (testgroup <= 3)
        {
          printf("\nPerforming Test Group #3, OC12 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r2",0,1,2,"OC12,OC3FROMOCX,OC3NUM=3|FORCE") < 0)
            exit(-1); 
        }
     if (testgroup <= 4)
        {
          printf("\nPerforming Test Group #4, OC3 Test, Module 2: Card 1  Rx, Card 2 Tx\n");
          if (looptest("r2",0,1,2,"OC3|FORCE") < 0)
            exit(-1);
        }    
    
     if (testgroup <= maxtest)
       { 
         printf("Start Test On R2 Port 1\n");
         printf("Module 1: Plug 1st Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n");
         printf("Module 2: Plug 2nd Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n"); 
         printf("Ready??? 'y' or 'n' ");
         if (answer_yes() == 0)
           {
             printf("Exiting Test\n");
             exit(-1);
           }
       }   
 
     if (testgroup <= 5)
        {
          printf("\nPerforming Test Group #5, OC3 Test, Module 1: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r2",1,0,1,"OC3|FORCE") < 0)
            exit(-1);
        } 
     if (testgroup <= 6)
        {
          printf("\nPerforming Test Group #6, OC48 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r2",1,0,2,"OC48,OC3FROMOCX,OC3NUM=1|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 7)
        {  
          printf("\nPerforming Test Group #7, OC12 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r2",1,0,2,"OC12,OC3FROMOCX,OC3NUM=1|FORCE") < 0)
            exit(-1);
        }
     if (testgroup <= 8)
        { 
          printf("\nPerforming Test Group #8, OC3 Test, Module 2: Card 2  Rx, Card 1 Tx\n");
          if (looptest("r2",1,0,2,"OC3|FORCE") < 0)
            exit(-1);
        } 
    }
  else   /* Sonet Rev 1 */
    {
      maxtest = 2; 
      printf("Start Test On SonetR1 \n");
      printf("Module 1: Plug 1st Cable Into Rx Port of Card 1, And Into Tx Port Of Card 2.\n");
      printf("Ready??? 'y' or 'n' ");
      if (answer_yes() == 0)
        {
          printf("Exiting Test\n");
          exit(-1);
        }  

      printf("\nPerforming Test Group #1, OC3 Test, Module 1: Card 1  Rx, Card 2 Tx\n");
      if (looptest("r1",0,1,1,"OC3") < 0)
        exit(-1);   

      printf("Start Test On SoentR2 \n");
      printf("Module 1: Plug 1st Cable Into Rx Port of Card 2, And Into Tx Port Of Card 1.\n");
      printf("Ready??? 'y' or 'n' ");
      if (answer_yes() == 0)
        {
          printf("Exiting Test\n");
          exit(-1);
        }  
   
      printf("\nPerforming Test Group #2, OC3 Test, Module 1: Card 2  Rx, Card 1 Tx\n");
      if (looptest("r1",1,0,1,"OC3") < 0)
        exit(-1); 

     }

  if (testgroup == 0)
    printf("\n\nAll Tests SUCCESSFUL!!\n");

  if ((testgroup > 0) && (testgroup <= maxtest))
    printf("\n\nTests For Groups #%d To #%d SUCCESSFUL!!\n",testgroup,maxtest);

  if (testgroup > maxtest)
    printf("Test #%d Greater Than Max Test Number #%d --NO TESTS PERFORMED, RETRY!!!\n",testgroup,maxtest);
 
  printf ("Finished\n");
}



