package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;

/**
  Split off subrecords of a type 3000/5000 file into one or more files

  notes:
    the split in sys does not work with file trimmers or rec name arguments
    if no args - assume /apart for backwards compatibilty with current sys which assumes /apart

  @author Jeff Schoen
  @version $Id: split.java,v 1.3 2021/05/20 17:08:12 schoenj Exp $
*/
public class split extends Primitive {

  private DataFile hi,ho,hos[];
  private int xfer,narg,nri,nro,bpei,bpeo,type;
  private Data dbi,dbo,dbos[];
  private boolean apart,hasArgs;
  private SubRec[] sr;

  private class SubRec {
    int ind,off,bpa,ape,bpe,offo;
    String name,fmt;
  }

  public int open() {

    narg = MA.numberOf();
    hasArgs = (narg>2);	
    apart = MA.getState("/APART",!hasArgs);
    String root = MA.getCS("OUT",MA.getCS("IN")+"_");

    // open input file
    hi = MA.getDataFile("IN","3000,5000","",0);
    hi.open();
    nri  = hi.getNumberSubRecords();
    bpei = hi.getRecLength();
    nro  = hasArgs? narg-2 : nri;
    type = hi.getTypeCodeClass();
    xfer = MA.getL("/TL",4096/bpei);
    dbi  = hi.getDataBuffer(xfer);

    // build output file header per args
    ho = new DataFile (M,root,hi,0);
    ho.setNumberSubRecords(0);
    ho.setRecLength(0);
    sr = new SubRec[nro];
    bpeo = 0;
    for (int i=0; i<nro; i++) {
      SubRec s = new SubRec(); sr[i]=s;
      s.name = hasArgs? MA.getS(3+i) : hi.getRecName(i);
      s.ind  = hi.findRec(s.name); if (s.ind<0) M.error("SubRecord name="+s.name+" not found in "+hi.getURL());
      s.fmt  = hi.getRecFormat(s.ind);
      s.off  = hi.getRecOffset(s.ind);
      s.ape  = hi.getRecElements(s.ind);
      s.bpa  = Data.getBPA(s.fmt);
      s.bpe  = s.ape * s.bpa;
           if (type==3) ho.addSubRec(s.name,s.fmt,bpeo);
      else if (type==5) ho.addComp(s.name,s.fmt,hi.getCompType(s.ind),hi.getCompUnits(s.ind));
      else if (type==6) ho.addSubRec(s.name,s.fmt,bpeo,hi.getRecCompType(s.ind),hi.getRecUnits(s.ind));
      else M.error("Unhandled type class="+type);
      s.offo = bpeo; bpeo += s.bpe;
    }

    if (apart) {			// split into seperate files
      hos = new DataFile[nro];
      dbos = new Data[nro];
      for (int i=0; i<nro; i++) {
        hos[i] = new DataFile(this,root+sr[i].name.toLowerCase(),hi,0);
       	hos[i].setFormat(sr[i].fmt);
	hos[i].setSubSize(sr[i].ape);
	hos[i].setType((sr[i].ape>1)?2000:1000);
        hos[i].open(ho.OUTPUT);
        dbos[i] = hos[i].getDataBuffer(xfer);
      }
    } else {				// open combined output file
      ho.open(ho.OUTPUT);
      dbo = ho.getDataBuffer(xfer);
    }

    return (NORMAL);
  }

  public int process() {

    int n = hi.read(dbi); 		// get the next data buffer
    if (n<=0) return (FINISH);

    if (apart) {
      for (int i=0; i<nro; i++) {
	DataOp.copy (dbi,sr[i].off,bpei, dbos[i],0,sr[i].bpe, sr[i].bpe,n);
        hos[i].write(dbos[i],n);
      }
    } else {
      for (int i=0; i<nro; i++) {
	DataOp.copy (dbi,sr[i].off,bpei, dbo,sr[i].offo,bpeo, sr[i].bpe,n);
      }
      ho.write(dbo,n);
    }

    return (NORMAL);
  }

  public int close() {
    if (apart) for (int i=0; i<nro; i++) hos[i].close();
    else ho.close();
    hi.close();
    return (NORMAL);
  }

}
