package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;

/**
  Fan in multichannel data from seperate pipes.

  @author Jeff Schoen
  @version $Id: icemux.java,v 1.3 2021/05/20 17:08:12 schoenj Exp $
*/
public class icemux extends Primitive {

  private DataFile ho,hi,his[];
  private double tis[],tid[];
  private boolean ctag,strip;
  private int nc,icm,bpe;
  private Data db;

  public int open() {

    nc = MA.getL("NCHAN");
    xfer = MA.getL("/TL",256);
    ctag = MA.getState("/CTAG");
    strip = MA.getState("/STRIP");

    String root = MA.getCS("IN");
    his = new DataFile[nc];
    tis = new double[nc];
    tid = new double[nc];

    icm=-1;
    for (int ic=0; ic<nc; ic++) {
      hi = new DataFile();
      hi.init(this,root+(ic+1),"1000","S#,C#",0);
      if (hi.exists()) hi.open();
      if (hi.isOpen && icm<0) icm=ic;
      his[ic]=hi;
      tis[ic]=hi.getXStart();
      tid[ic]=hi.getXDelta()*xfer;
    }

    ho = MA.getDataFile("OUT",his[icm],0);
    if (strip) ho.setPacketHandler(null);
    ho.open(ho.OUTPUT);
    db = ho.getDataBuffer(xfer);
    bpe = (int)ho.getBPE();

    return (NORMAL);
  }

  public int process() {

    // find the next channel with data
    double tiMin=0; icm=-1;
    for (int ic=0; ic<nc; ic++) {
      hi = his[ic];
      if (!hi.isOpen) continue;
      if (icm<0 || tis[ic]<tiMin) { tiMin=tis[ic]; icm=ic; }
    }
    if (icm<0) return FINISH;
    hi = his[icm];

    // get the next data buffer
    int n = hi.read(db);
    if (n<0) hi.close();

    // copy data to output, mark time of next sample
    if (ctag && n>0) ctag(db.buf,icm,n);
    if (n==xfer) { ho.write(db); tis[icm] += tid[icm]; }

    return (NORMAL);
  }

  public int close() {
    for (int ic=0; ic<nc; ic++) his[ic].close();
    ho.close();
    return (NORMAL);
  }

  private void ctagx (byte[] buf, int ic, int n) {
    int nb = (n*bpe)>>1;
    for (int i=0; i<nb; i++) {
      buf[i+i] = (byte)(((int)buf[i+i]&0xFE) | ((ic>>(i&0x3))&0x1));
    }
  }

  private void ctag (byte[] buf, int ic, int n) {
    int nb = (n*bpe);
    for (int i=0; i<nb; i+=1024) {
      buf[i+0] = (byte)(((int)buf[i+0]&0xFE) | ((ic>>0)&0x1));
      buf[i+2] = (byte)(((int)buf[i+2]&0xFE) | ((ic>>1)&0x1));
      buf[i+4] = (byte)(((int)buf[i+4]&0xFE) | ((ic>>2)&0x1));
      buf[i+6] = (byte)(((int)buf[i+6]&0xFE) | ((ic>>3)&0x1));
    }
  }

}
