///////////////////////////////////////
// Helper functions for NMSSPP pages //
///////////////////////////////////////

// helper for GMENU widgets
function gselect(id,name,items,def) {
  e = document.getElementById(id);
  idp = id+"_p";
  ep = document.getElementById(idp);
  if (ep!=null) return; // already expanded 
  html = "";
  itema = items.split(',',64);
  if (def.length==0) def = itema[0];
  html += "<select id='"+idp+"' onchange=selectItem('"+idp+"','"+name+"','"+def+"')>";
  html += "<option selected>"+def+"</option>";
  html += "<option>&ltCancel&gt</option>";
  for (i=0; i<itema.length; i++) html += "<option>"+itema[i]+"</option>";
  html += "</select>"
  e.innerHTML = html;
}

// handle select of an item
function selectItem(id,name,def) {
  e = document.getElementById(id);
  //console.log("select name="+name+" "+def+" "+e.value);
  url = document.URL;
  i = url.indexOf('?');
  if (i>0) url = url.substring(0,i);
  if (e.value=="<Cancel>") e.value=def;
  else if (e.value=="<Enter>") { e.value=def; gprompt(id,name,def); }
  else if (e.value.indexOf('<')==0) { }
  else gset(id,name,e.value);
}

// helper for GVALUE widgets
function gvalue(id,name,def) {
  e = document.getElementById(id);
  idp = id+"_p";
  ep = document.getElementById(idp);
  if (ep!=null) return; // already expanded 
  html  = "<a style='color:#2288ee' onclick=gset('"+id+"','"+name+"','Min')>&lt</a>&nbsp";
  html += "<a style='color:#2288ee' onclick=gset('"+id+"','"+name+"','Dec')>&lt</a>&nbsp";
  html += "<a style='color:#2288ee' onclick=gprompt('"+id+"','"+name+"','"+def+"') id='"+idp+"' >"+def+"</a>&nbsp"
  html += "<a style='color:#2288ee' onclick=gset('"+id+"','"+name+"','Inc')>&gt</a>&nbsp";
  html += "<a style='color:#2288ee' onclick=gset('"+id+"','"+name+"','Max')>&gt</a>&nbsp";
  e.innerHTML = html;
}

// handle inc/dec of value
function gset(id,name,value) {
  localStorage.setItem("gReloadId",id);
  url=document.URL;
  iq=url.indexOf('?');
  if (iq>0) url = url.substring(0,iq);
  if (id==null) location.replace(url+"?Reload");
  else location.replace(url+"?"+name+"="+value);
  //console.log("GSet "+name+" "+value);
}

// clean page refresh
function grefresh() {
  gset(null,"","");
}

// this does take input keystrokes
function gprompt(id,name,seed) {
  value = window.prompt(name,seed);
  if (value!=null && value!=seed) gset(id,name,value);
}

// helper for NOEDIT flagged  widgets
function gnoedit(id) {
  e = document.getElementById(id);
  idp = id+"_p";
  ep = document.getElementById(idp);
  if (ep!=null) return; // already expanded 
  def = e.innerHTML;
  html  = "<span id='"+idp+"' onclick=galert('This_control_is_not_editable') style='color:#2288ee'>"+def+"</span>";
  e.innerHTML = html;
}

//function galert(text) {
function galert(text) {
  text = text.replace(/_/g," ");
  value = window.alert(text);
}

// refresh page in msec if url indicates this page initiated a control change to reflect responses 
function syncRefresh(msec) {
  url=document.URL;
  iq=url.indexOf('?');
  ie=url.indexOf('=');
  if (iq>0 && ie>0 && msec>0) {
    rurl = url.substring(0,iq)+"?Reload";
    rcmd = "location.replace('"+rurl+"');"
    setTimeout(rcmd,msec);
  }
  gid=localStorage.getItem("gReloadId");
  if (gid!=null && gid!="null") glastid(gid);
  document.onmousedown=setMouseXY;
//  console.log("Loaded URL="+url+" "+iq+" "+ie+" gid="+gid);
}
function glastid(id) {
  ip = id.indexOf('_p');
  if (ip>0) id=id.substring(0,ip);
  simulateMouseEvent(id,"mouseover",0,0,0);
}
function simulateMouseEvent(id,type,bc,x,y) {
  e = document.getElementById(id);
  evt = document.createEvent("MouseEvents");
  evt.initMouseEvent(type,true,true,window, bc, x,y,x,y, false,false,false,false, 0,null);
  if (e!=null) e.dispatchEvent(evt);
//  console.log("Simulate "+type+" at "+x+" "+y);
}
function setMouseXY(e) {
  mouseX = e.pageX;
  mouseY = e.pageY;
}


// UNUSED STUFF

// popup selection handler
var popup_id="NONE";
var popup_name,popup_html;

// this doesnt seem to take input keystrokes
function gpromptX(id,name,seed) {
  gundo();
  e = document.getElementById(id);
  popup_id   = id;
  popup_name = name;
  popup_html = e.innerHTML;
  html = "<input type='text' size=20 value='"+seed+"'></input>";
  e.innerHTML = html;
}

function gundo() {
  if (popup_id=="NONE") return;
  e = document.getElementById(popup_id);
  e.innerHTML = popup_html;
  popup_id="NONE";
}

// Mouse event manipulators
function greclick(id) {
  simulateMouseEvent(id,"mouseup",0,mouseX,mouseY);
  simulateMouseEvent(id,"mousedown",0,mouseX,mouseY);
}

function selectItemX(id,name,def) {
  e = document.getElementById(id);
  //console.log("select name="+name+" "+def+" "+e.value);
  url = document.URL;
  i = url.indexOf('?');
  if (i>0) url = url.substring(0,i);
  if (e.value=="<Cancel>") e.value=def;
  else if (e.value=="<Enter>") { e.value=def; gprompt(id,name,def); }
  else if (e.value.indexOf('<')==0) {
    val = e.value;
    e.value=def;
    ic = val.indexOf(':');
    if (ic>0) { // send to set named method of the control widget
      key   = val.substring(1,ic);
      name  = "GC."+name+"."+key;
      items = val.substring(ic+1,val.length-1);
      items = items.replace(/\|/g,",");
      id    = id.replace(/_p/g,"q");
      gselect(id,key+"@"+name,items,"");
    }
  }
  else gset(id,name,e.value);
}

