package nxm.ice.net;

import nxm.sys.lib.*;
import nxm.ice.lib.Archiver;

import java.util.Date;
import java.net.HttpURLConnection;

//import nxm.sys.inc.InternalUseOnly;

/** A class to return the contents of a file to a Browser.
    @author Jeff Schoen / Neon Ngo
    @version $Id: HArchive.java,v 1.21 2014/09/23 15:13:49 ntn Exp $
*/
public class HArchive extends HSource {

  private Midas M;
  private static boolean debug = false; // enable to turn on debug messages

  public HArchive (String name, Midas M) {
    if (!name.endsWith("/")) name += '/';
    this.name = name;
    this.M = M;
  }

  public boolean handleHeadRequest () { return true; }

  public void handleRequest (String uri, HPage hp) {
    Archiver ha = null;
    BaseFile bf = null;
    DataFile df = null;
    boolean isOpen;
    String name = getName();
    String path = uri.substring(name.length());
    int i=path.indexOf('?');	// access as Archive file
    int j=path.indexOf('(');	// access as Data file for file trimmers 
    boolean hasArgs = (i>0);
    if (hasArgs) { // convert args to qualifiers
      path = path.substring(0,i)+"{"+path.substring(i+1).replaceAll("&",",")+"}";
    }
    boolean isImport = path.startsWith("Import/");
    boolean isExport = path.startsWith("Export/");
    boolean isHeadRequest = hp.getMethod().equals("HEAD");
    long offset = (long)hp.getHeaderD("Range"); // NOTE: we only support first-byte-pos, last-byte-pos is ignored
    long tbytes=0;
    if (offset<0) offset=0;
    if (debug) Shell.writeln("HArchive.handle() "+hp.getMethod()+" path="+path);
    byte[] hdr = new byte[512];
    if (isImport) hp_read(hdr,0,512,hp);
    if (isImport||isExport) {
      int dir = isImport? 1 : isExport? -1 : 0;
      ha = Archiver.openForExport(M,path.substring(7),hdr,dir);
      isOpen = ha.isOpen;
      tbytes = ha.getExportSize();
    } else if (j>0) {
      df = new DataFile (M,path);
      isOpen = df.open(DataFile.INPUT|DataFile.NOABORT);
      tbytes = 512 + (long)(df.getSize()*df.dbpe);
    } else {
      bf = new BaseFile (M,path);
      isOpen = bf.open(BaseFile.INPUT|BaseFile.NOABORT);
      tbytes = (long)bf.getSize();
      bf.seek(offset);
    }
    if (!isOpen) {
      hp.setStatus(HttpURLConnection.HTTP_NOT_FOUND);
      hp.open();
      if (!isHeadRequest) hp.writeNotFound();
      hp.close();
      return;
    }
    if (debug) Shell.writeln("HArchive.handle() "+hp.getMethod()+" path="+path+" off="+offset+" size="+tbytes);
    if (offset>0) hp.setContentRange(offset,tbytes-1,tbytes); // set Content-Range and status of 206 (Partial Content)
    hp.setContentType("application/octet-stream");
    hp.setContentLength(tbytes-offset);
    if (isHeadRequest) { // DO NOT return content back for HEAD request
      hp.open();         // <-- this sends HTTP response headers back to client
      hp.close();
    }
    else {
      int bytes=0, bufsize=1024*1024;
      byte[] buf = new byte[bufsize];
      hp.open();
      if (isImport) { hp.write(hdr,0,512); hp.flush(); offset=512; } /* already read header */
      for (; offset<tbytes; offset+=bytes) {
	bytes = (int)Math.min(tbytes-offset,bufsize);
	if (isImport) bytes = hp_read (buf,0,bytes,hp);
	else if (isExport) bytes = ha.readExport(buf,offset,bytes);
	else if (df!=null) bytes = df_read(df,buf,offset,bytes);
	else bytes = bf.read(buf,0,bytes);
	if (bytes<0) break;
	if (isImport) ha.writeExport(buf,bytes);
	else if (hp.write(buf,0,bytes)<0) break;
      }
      hp.close();
    }
    if (df!=null) df.close();
    if (bf!=null) bf.close();
    if (ha!=null) ha.close();
  }

  public int hp_read (byte[] buf, int off, int bytes, HPage hp) {
    int total=0;
    try { 
      while (total<bytes) {
        int status = hp.getInputStream().read(buf,total,bytes-total);
        if (status>0) total += status;
	else if (status==0) Thread.sleep(1,0);
	else if (status<0) break;
      }
    }
    catch (Exception e) { if (total==0) total=-1; }
    return total;
  }

  static int OFF_DETACHED=12, OFF_EXTSIZE=28, OFF_DATASTART=32, OFF_DATASIZE=40;
  public int df_read (DataFile df, byte[] buf, long off, int bytes) {
    if (off==0) {
      bytes=512;
      System.arraycopy(df.hb,0, buf,0, bytes);
      Convert.packL(buf,OFF_EXTSIZE, 0);
      Convert.packL(buf,OFF_DETACHED, 0);
      Convert.packD(buf,OFF_DATASTART, 512.0);
      Convert.packD(buf,OFF_DATASIZE, df.getSize()*df.dbpe);
    }
    else {
      bytes = df.read(buf,0,bytes);
    }
    return bytes;
  }

}
