!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! SNAPPER Snapshot/Archive/Analysis macro for ICE cards !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main l:port[9011]

pipe on

rmif/prange=5 port 

panel/setup/controls=gc

plot/id=plot 
list/id=list 
shellgui/id=term/attach

gcontrol button "TEST"   "TivoTest" "Join,Leave,Info,Log,SDDS,Report,Data,Status,Plot,Exit" /nc=2
gcontrol label  "SRV"    "Server"
gcontrol prompt "SNAP"   "SnapNode" "icebox:9000"
gcontrol prompt "AFNAME" "AFName"   "sddsout"
gcontrol prompt "CHAN"   "Channel"  "193.4.23.40:5401"
gcontrol label  "DWN"    "DownLoad"
gcontrol choice "PROTO"  "Protocol" "Local,Http,Mftp" "MFTP"
gcontrol prompt "LFNAME" "FileName" "myfile"
gcontrol tval   "ATCT"   "Start"   0 1 -1 1 
gcontrol tval   "ATCL"   "Length" 10 1 -1 1 

pipe off

endmacro

procedure open
message send "RMIF" ,, "ADDR" ,, {ID=ICESERV,HP=^gc.SNAP.v}
return

procedure processMessage

if msg.name eqs "TEST" then
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "JOIN" then
    message send "ICESERV" ,, "SET" ,, {JOIN=^gc.CHAN.v}
  elseif msg.data eqs "LEAVE" then
    message send "ICESERV" ,, "SET" ,, {LEAVE=^gc.CHAN.v}
  elseif msg.data eqs "INFO" then
    gc/temp prompt "LOGINFO" "Info Text: " "My message"
  elseif msg.data eqs "LOG" then
    call getFile ^{gc.AFNAME.v}.mlog ^gc.LFNAME.v
    message send "LIST" ,, "OPENFILE" -1 "^gc.LFNAME.v"
  elseif msg.data eqs "REPORT" then
    call getFile ^{gc.AFNAME.v}_toc.tmp ^gc.LFNAME.v
    message send "LIST" ,, "OPENFILE" -1 "^gc.LFNAME.v"
  elseif msg.data eqs "DATA" then
    set l:irec reg.list.selectedrow
    if irec lt 0 then
      gc/temp alert ,,, "No report row selected"
    else
      call getData ^{gc.AFNAME.v}_^{irec}.tmp(~^gc.ATCT.v:+~^gc.ATCL.v) ^gc.LFNAME.v
    endif
  elseif msg.data eqs "SDDS" then
    keyword/scope=main ^gc.LFNAME.v put "PACKET" "SDDS/ICE"
  elseif msg.data eqs "STATUS" then
    status gc.LFNAME.v
  elseif msg.data eqs "PLOT" then
    if file(gc.LFNAME.v).type/1000 eq 1
      message send "PLOT" ,, "OPENFILE" -1 "^gc.LFNAME.v"
    else
      gc/temp alert ,,, "Cannot plot type 3000 files"
    endif
  endif

elseif msg.name eqs "SNAP" then
  message send "RMIF" ,, "ADDR" ,, {ID=ICESERV,HP=^gc.SNAP.v}

elseif msg.name eqs "LOGINFO" then
  message send "ICESERV" ,, "SET" ,, {INFO=^msg.data}

elseif msg.name eqs "RET" then
  say "Message ^msg.name = ^msg.data from ^msg.fid"
  res sets msg.data
  foreach key intable sets
    if key eqs "HEAD" 
      set gc.ATCT.v sets.HEAD.time
      set gc.ATCL.v sets.HEAD.length
    elseif key eqs "DATA" 
      set gc.ATCT.v sets.DATA.time
      set gc.ATCL.v sets.DATA.length
    endif
  endfor

elseif msg.fid eqs "PLOT" or msg.fid eqs "LIST" then 
  ! do nothing

else
  say "Message ^msg.name = ^msg.data from ^msg.fid"
endif

return

procedure getFile fn:remotefile fn:localfile
if gc.PROTO.v eqs "LOCAL" then
  noop remotefile localfile 
elseif gc.PROTO.v eqs "HTTP" then
  noop http://^gc.SNAP.v/Files/^remotefile localfile
elseif gc.PROTO.v eqs "MFTP" then
  noop mftp://^gc.SNAP.v/^remotefile localfile
endif
return

procedure getData fn:remotefile fn:localfile
if gc.PROTO.v eqs "LOCAL" then
  noop/gpw/bg remotefile localfile 
elseif gc.PROTO.v eqs "HTTP" then
  noop/gpw/bg http://^gc.SNAP.v/Files/^remotefile localfile
elseif gc.PROTO.v eqs "MFTP" then
  noop/gpw/bg mftp://^gc.SNAP.v/^remotefile localfile
endif
return
