!!!!!!!!!!!!!!!!!!!!!!!!"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  SNAPPER Snapshot/Archive/Analysis/Playback macro for ICE cards
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/stats=1/tll=128/tlt=.1/gc=config u:card cs:cflags t:config

global hwalias
invoke parent=this.M.parent.getMacro()
if parent nisnull set parent parent.name

! init config settings
if config isnull then
 if parent isnull then global snapset
 if snapset nrexists and parent isnull and "^env.home/snapset.tbl" fexists then
  ask ans "Found ~/snapset.tbl from a previous session. Load it ? Y/[N]: "
  if ans eqss "Y" then set t:snapset "^env.home/snapset.tbl"
 endif
 if snapset nrexists then
  set t:snapset {card=PIC1AUTO,port=MODULE1,format=CI,rate=50,clock=P,length=1.0,dec=1,&
	freq=1,baud=1,gain=0,nfft=2048,psdr=25,psda=5,dspr=5,expa=0,frame=512,wave=none,afname="archive"}
 endif
 set config snapset	! need above for prespecs
 set config.card card
else
 if config.card nrexists set config.card card
 set card config.card
endif

if /play then
  res ports "Module1,Module2,Module3,Core1,Core2"
  set xcvr "AT18-at"
else
  res ports "Module1,Module2,Module3,Tuner1,Tuner2"
  set xcvr "AR26-ar"
endif
switch "XCVR" s:xcvr get ,, xcvr /cs
if config.xcvr rexists set xcvr config.xcvr

res l:archiving 0
switch "AFLAGS" aflags get cflags
switch "RF" rcvr get "AUTO" "ICE"
switch "RCVR" rcvr get rcvr "ICE"
switch "NIC" nic get "NONE" env.hostaddr
switch "TC" tcm get "NONE" "CPU"
switch "SDDS" l:sdds get 0 1
switch "RATIO" d:ratio get -1 1
switch "MCS" l:mcs get -1 1
switch "POLLSTR" pollstr get "NULL"
switch "GCX" t:ogc get 
switch "AGCM" s:agc get "NONE" "GAIN"
switch "CLICKTUNE" l:clicktune get -1 1
switch "WIND" s:wind get "HANN" 
switch "FFTCORE" l:fftcore get (/PMFFT)

if sdds istrue then call addToSetIf {NPKT=SDDS,SOCK=29495}
if ogc nisnull then table config MERGE config ogc
if agc neqs "NONE" and config.agc rexists then set config.agc agc

if fftcore gt 0
elseif config.dspr rexists
  calc l:config.psdr config.dspr*config.psda
elseif config.psdr rexists
  calc l:config.dspr config.psdr/config.psda 1 max
endif

if card eqs "AUTO" then
  picd numdev /stat=nc
  set card "PIC1AUTO"
  set cards card
  do nn 2 nc
    sedit cards cards "APPEND" ",PIC^{nn}AUTO"
  enddo
endif

if card eqss "NIC" then set nic card
iceutil "CARETS" config.afname config.afname
if config.afqual nrexists then set s:config.afqual ""
if /dual and config.port eqss "MODULE" then set config.port "MODULE"
if card eqss "NIC" and config.port neqss "STREAM" then set config.port "STREAM1"
sedit config.port lportc "RANGE" 0 0

call prespecs

if /rereset gt 0
  info "Presetting ^card ... "
  picd/flags=flg reset ^card 
endif

! check card initialization status
res l:active -1
call cleanlist
set iomtbl "NONE"
set iocsig "XX"

if nic eqs "NONE" and /client isFalse then
  picd get card "ACTIVE" active
  if active lt 0 then
     say "Performing initial reset on card=^card"
     picd/flags=flg reset card
     picd get card "ACTIVE" active
  endif
  picd/flags=flg get card "FPGASIG" iocsig /str
  if ( /nio istrue and /play isfalse ) or iocsig eqss "RR" then
    picd/flags=flg get card "NIOP" niop 
    do n 1 niop
      sedit ports ports "APPEND" ",Stream^n"
    enddo
  endif
endif

! init menus, plot list, and client macro switches
set otherband ""
set l:ntbc 1
set l:mult 1
calc l:nexp 1
if config.expa rexists calc l:nexp config.expa 1 max
set cswitches ""
set s:tbm "NONE"
if /tb gt 0 then		! tuner bank mode
  set l:ntbc 16
  if active ge 0 then
    picd/flags=flg get card "CHNS" ntbc
    if config.port neqs "TBANK3" res l:ntbc ntbc/2
  endif
  switch "TB" l:ntbc get,,ntbc	! use specified # channels
  switch "TBM" tbm get "FTTM" 	! tuner bank mode
  if tbm eqs "MULTI" then
    set l:mult ntbc
    res ports "Tuner1,Tuner2,Pm1Tuner1,Pm1Tuner2,Pm2Tuner1,Pm2Tuner2"
  elseif tbm eqs "MSP" then
    res ports "Tuner,Pm1Tuner,Pm2Tuner"
  elseif /dual then			! dual input mode
    res ports "TBank1,TBank2"
    res plist "_CB1|_CB2"
    res cswitches "DUAL/TB=^ntbc"
    if "TBANK" nsubs config.port set config.port "TBANK1"
  else					! single input mode
    res ports "TBank1,TBank2,TBank3"
    res plist "_CB"
    res cswitches "TB=^ntbc"
    if "TBANK" nsubs config.port set config.port "TBANK1"
  endif
elseif /mcs gt 0 then		! multi channel stream mode
  switch "MCS" l:ntbc get
  if /play then
    res ports "MCStream1,MCStream2"
  else
    res ports "MCStream11,MCStream12,MCStream13,MCStream14,MCStream21,MCStream22,MCStream23,MCStream24"
  endif
  res plist "_CB"
  res cswitches "MCS=^ntbc"
elseif /scan then
  res ports "Module1,Module2"
  set l:ntbc (/scan)
  set l:dchan -1
elseif /dual then               ! dual channel mode
  res ports "Module,Tuner,TBank,Core,Core0,Core1,Core2"
  res plist "_CB1|_CB2|_CB1F|_CB2F|_CBXF"
  res cswitches "DUAL"
elseif /nbp then		! narrow band plot
  res ports "Module1,Module2"
  res plist "_CBF|_CBNF"
elseif /wbp then		! wide band plot
  res ports "Tuner1,Tuner2,TBank1,TBank2,Core1,Core2"
  res plist "_CBF|_CBWF"
elseif /loopback then
  res ports "Module1,Module2"
elseif nic neqs "NONE" then	! network interface card
  res ports "Stream1,Stream2,Stream3,Stream4"
  res cswitches "NIC"
  res plist "_CB|_CBF"
elseif card eqs "NONE" then	! no ice card
  res ports "Module1,Tuner1"
  res cswitches "NOPIC"
  res plist "_CB|_CBF"
else				! default mode
  if active ge 0 then
    picd/flags=flg get card "PMTYPE1" value
    if value ne 0 res ports "^ports,Pm0Tuner1,Pm0Tuner2,Pm1Tuner1,Pm1Tuner2,Pm1Core1,Pm1Core2,Pm1MCore1,Pm1MCore2"
    picd/flags=flg get card "PMTYPE2" value
    if value ne 0 res ports "^ports,Pm2Tuner1,Pm2Tuner2,Pm2Core1,Pm2Core2,Pm2MCore1,Pm2MCore2"
  endif
  if /tsp then			! time series plots only
    res plist "_CB"
    res cswitches "TSP"
  else
    res plist "_CB|_CBF"
  endif
endif
if /nbp then
  set cswitches "^cswitches/NBP"
  res otherband "NarrowBandRam"
endif
if /wbp then
  if config.wafname nrexists then set s:config.wafname ""
  if config.wafqual nrexists then set s:config.wafqual ""
  set cswitches "^cswitches/WBP"
  res otherband "WideBandRam"
endif
if /play then
  set function "Playback"
  set modes "Setup,RTMemory,OneShot,Compose,Exit,RTPlayback,DeArchive,Other"
elseif /client gt 0 then
  set function "Monitor"
  set modes "DownLoad,Exit"
  set modes "Setup,RTMemory,Offline,Exit,RTArchive,DownLoad"
else
  set function "Acquire"
  set modes "Setup,RTMemory,OneShot,OneShotArch,Exit,RTArchive,Archive,Other"
endif
switch "MODES" modes get modes

! menu lists
res formats "SB,CB,SI,CI,SL,CL,SN,CN,SX,SP,CJ,C12b,C12b16"
res rates   "1,2,3.125,5,6.25,10,12.5,20,25,30,40,50,60,64,70,80,90,100,105,125,150,200,250,500,750,1000,1250,1500"
res lengths "0.1,0.25,0.5,1.0,2.0,5.0,10.0,20.0"
res clocks  "P-Program,PX-P/ExtRef,X-External,A-Module,B-Module,I-Int40/N,C-Crystal,D-Crystal/N,N-NoMuxClk"
res decs    "1,2,4,8,16,32,50,64,100,128,256,512,1000,1K"
res nffts   "256,512,1K,2K,4K,8K,16K,64K,256K,1M"
res affts   "1K,2K,4K,8K,16K,32K,64K"
res frames  "256,500,512,1000,1024,2048,4096,8192,16384"
res dsprs   "1,2,5,10,25,50"
res psdrs   "1,2,5,10,25,50,100"
res psdas   "1,2,5,10,25,50"
res rfbws   ".1,.5,1,2,5,10,20,25,40,50,60,80,100,120,150,200"
invoke waves=nxm.ice.prim.icewave.shapeList
invoke winds=nxm.sys.libm.Window.nameList
invoke icw=nxm.ice.prim.icewave.NOTCH

if fftcore gt 0 then	! PSD engine prep
  res nffts   "256,512,1K,2K,4K,8K,16K"
  res psdrs   "5,10,25,50,100,200,250,500,1000"
endif

! get the archive switches with defaults 
switch "ATL"   l:atl get 1M
switch "AAUX"  s:aux0 get aux.write
switch "AAUX1" s:aux1 get aux0
switch "AAUX2" s:aux2 get aux0
switch "RAUX"  s:raux get "^aux1|^aux2"
sedit aux.read auxes "APPEND" "|" "APPEND" raux gsubs "|" ","

! local state variables
res s:rclock "Z"	! clock at reset
res s:afn "NULL"	! archive file name
res s:lafn "NULL"	! last archive file name
res s:lmode "NULL"	! last mode setting
res l:ptl 64k		! practical transfer length
res d:mfl 0		! multiple file length
res d:mfw 0		! multiple file wrap
set l:filesAreOk 0	! keeps track of need to recreate ICE disk files
set d:scale 128		! this must be adjusted before data reaches the time plotter
calc fscale scale log 10 *
switch "FIXRANGE" frange get 80
switch "PSDOFORM" s:ofb get "F" "F"	! output Float/Byte format for PSDs

timex now sec=timecode
res apktdef "OFF"
if tcm neqs "NONE" set apktdef "ON"
switch "LTYPE" ltype get "LINE"

! status logger
sedit "snapper_^{card}_^{config.port}" logfn "LOCASE"
if /client gt 0 then res logfn "OFF"
switch "MLOG" s:logfn get "OFF" logfn
switch "MCFL" l:mcfl get 1M 1M
if logfn neqs "OFF" then report on logfn{CFL=^mcfl}

pipe on

if /client gt 0
  env get "SERVER" remote
  icermif/id=rmif/prange=5 /client ,, {ID=ICESRV,HP=^remote} q:ack|^plist
  if aux0 neqs aux.write set aux.^aux0 "http://^remote/Files/^aux0/"
  if aux1 neqs aux0      set aux.^aux1 "http://^remote/Files/^aux1/"
  if aux2 neqs aux0      set aux.^aux2 "http://^remote/Files/^aux2/"
elseif /server gt 0
  icermif/id=rmif/http ^/server ^plist
  system/id=sys disk /pause=5
  set cswitches "^cswitches/AAUX=^aux0"
  if aux1 neqs aux0 then set cswitches "^cswitches/AAUX1=^aux1"
  if aux2 neqs aux0 then set cswitches "^cswitches/AAUX2=^aux2"
else
  system/id=sys disk /pause=5
endif

! panel and plotter setup

if /headless then
  panel/controls=gc	! this will inherit the headless switch and not show

elseif /tb gt 0 or /mcs gt 0 or /scan then			! multi channel plots
  res l:mcf 256
  if ntbc gt 200 res l:mcf 128
  if ntbc gt 400 res l:mcf 64
  switch mcf mcf get mcf
  set t:lmlt {LT="nxm.ice.libg.LayerMC",TYPE=LINE,PROCESS=RAW,NFFT=mcf,NAVG=nexp,NCHAN=ntbc,MCS=mcs,MAX=scale,MIN=-scale,MINRANGE=100}
  set t:lmlf {LT="nxm.ice.libg.LayerMC",TYPE=RAST,PROCESS=FFT,NFFT=mcf,NAVG=nexp,NCHAN=ntbc,MCS=mcs,MAX=fscale,MIN=fscale-frange}
  table lmlt setmode "KV"	! so conversion from FB to KV doesnt happen during dual access
  table lmlf setmode "KV"
  if /xyp then set lmlt.TYPE "POINT" lmlf.TYPE "XYPOINT" lmlf.PROCESS "RAW" lmlf.MAX "SCALE" lmlf.MIN "-SCALE" lmlf.KEEP "NFSX/FRAME"
  if /dual then
    if /altsetup then
      panel/setup=tb2a/controls=gc/logger
      set lmlf.TYPE "LINE" lmlf.NX "ntbc" lmlf.NY "1"
    else
      panel/setup=tb2/controls=gc/logger
    endif
    if /wbp then
      plot/id=tdlp1 _cbwf type=line axis=trframe 
      plot/id=tdlp2 _cbnf type=line axis=trframe 
    else
      plot/id=tdlp1 _cb1 view=iyx axis=frame layer=lmlt
      plot/id=tdlp2 _cb2 view=iyx axis=frame layer=lmlt
    endif
    plot/id=fdrp1 _cb1 view=iyx axis=frame layer=lmlf
    plot/id=fdrp2 _cb2 view=iyx axis=frame layer=lmlf
  elseif /noplot then
    panel/setup=tbro/controls=gc/logger
  elseif /rponly or /rpo then
    panel/setup=tbro/controls=gc/logger
    plot/id=fdrp _cb view=iyx axis=frame layer=lmlf
  elseif /scan then
    res l:mcf 1K
    panel/setup=s/controls=gc/logger
    set lmlt.NX "ntbc" lmlt.NY "1"
    plot/id=tdlp _cb view=iyx axis=frame layer=lmlt
    plot/id=fdrp _cb view=iyx axis=frame layer=lmlf
    plot/id=fdlp _cbf type=line axis=trframe ymax=fscale
  elseif /fdp then
    panel/setup=f/controls=gc/logger
    set lmlt ^lmlf lmlt.TYPE "LINE"
    plot/id=fdlp _cb view=iyx axis=frame layer=lmlt
    plot/id=fdrp _cb view=iyx axis=frame layer=lmlf
  elseif /wbp then
    panel/setup=tb/controls=gc/logger
    plot/id=tdlp _cbwf type=line axis=trframe
    plot/id=fdrp _cb view=iyx axis=frame layer=lmlf
  else
    panel/setup=tb/controls=gc/logger
    plot/id=tdlp _cb view=iyx axis=frame layer=lmlt
    plot/id=fdrp _cb view=iyx axis=frame layer=lmlf
  endif

elseif /tsp then					! time series plots
  if /dual then
    panel/setup=t2/controls=gc/logger
    plot/id=tdlp _cb1{cl=4}|_cb2{cl=4} type=ltype y1=-scale y2=scale
    plot/id=tdrp1 _cb1 type=rast 
    plot/id=tdrp2 _cb2 type=rast
  else
    panel/setup=t/controls=gc/logger
    plot/id=tdlp _cb{cl=4} type=ltype y1=-scale y2=scale
    plot/id=tdrp _cb type=rast readout=+T
  endif

elseif /xyp then					! xy series plots
  panel/setup=t/controls=gc/logger
  if /wbp then
    plot/id=tdlp _cbwf type=line axis=trframe 
  else
    plot/id=tdlp _cb{cl=4} cm=mag type=point y1=0 y2=scale*1.414
  endif
  plot/id=tdrp _cb cm=rvi type=point x1=-scale x2=scale  y1=-scale y2=scale

else							! time|freq series plots
  if /tivo then
    panel/setup=tvo/controls=gc/logger
  elseif /fdp then
    panel/setup=f/controls=gc/logger
  else
    panel/setup/controls=gc/logger
  endif
  if /dual then
    plot/id=tdlp _cb1{cl=4}|_cb2{cl=4}   type=ltype y1=-scale y2=scale 
    plot/id=fdlp _cb1f|_cb2f type=line axis=trframe ymax=fscale
    plot/id=fdrp _cbxf       type=rast axis=brframe zmax=fscale readout=+T
  else
    if /wbp then
      plot/id=tdlp _cbwf type=line axis=trframe 
    elseif /nbp then
      plot/id=tdlp _cbnf type=line axis=trframe 
    elseif /fdp lt 0 then
      plot/id=tdlp _cb{cl=4}  type=ltype y1=-scale y2=scale 
    endif
    plot/id=fdlp _cbf type=line axis=trframe ymax=fscale
    plot/id=fdrp _cbf type=rast axis=brframe zmax=fscale readout=+T 
  endif
  set reg.fdlp.mimic fdrp	! tie PAN/ZOOM messages
  set reg.fdrp.mimic fdlp
  if /client gt 0 then		! set RMIF compression handlers (comp=plot)
    set reg.fdlp.rmif "RMIF"
    if /nbp or /wbp then set reg.tdlp.rmif "RMIF"
  endif
endif

! plotter naming

  if /nbp then
    if reg.tdlp rexists set reg.win.tdlp.title "NarrowBand PSD"
    if reg.fdlp rexists set reg.win.fdlp.title "WideBand PSD"
    if reg.fdlp rexists feature ,, ff {NAME=FF,TYPE=VLINE|DATA,COLOR=RED} fdlp
  elseif /wbp then
    if reg.tdlp rexists set reg.win.tdlp.title "WideBand PSD"
    if reg.tdlp1 rexists set reg.win.tdlp1.title "WideBand PSD 1"
    if reg.tdlp2 rexists set reg.win.tdlp2.title "WideBand PSD 2"
    if reg.fdlp rexists set reg.win.fdlp.title "NarrowBand PSD"
    if reg.tdlp rexists feature ,, ff {NAME=FF,TYPE=VLINE|DATA,COLOR=RED} tdlp
    if reg.tdlp1 rexists feature ,, ff1 {NAME=FF,TYPE=VLINE|DATA,COLOR=RED} tdlp1
    if reg.tdlp2 rexists feature ,, ff2 {NAME=FF,TYPE=VLINE|DATA,COLOR=RED} tdlp2
  elseif ntbc gt 1
  elseif /marker eq 2 then
    if reg.fdlp rexists feature ,, ff {NAME=FF,TYPE=SYMBOL,SYMBOL=CIRCLE,COLOR=RED} fdlp
  else
    if reg.fdlp rexists feature ,, ff {NAME=FF,TYPE=VRIDE|SYMBOL,SYMBOL=CIRCLE,COLOR=RED} fdlp
  endif

! controls panel

  gcontrol label  "FUNC"   function
  gcontrol button "MODE"   "Mode" modes "Setup" /nc=2 /toff /input
  gcontrol choice "WAVE"   "Waveform" "None,^waves" "None" /input
  gcontrol tval   "TIME"   "TC" timecode 1 -1 1  /edit=f /mon=reg.sp.time.sec
if /emt gt 0
  gcontrol lval   "EMT"    "Loading" 0 0 128 1  /gauge
  set cswitches "^cswitches/EMT"
endif
if /adlm gt 0 
  gcontrol lval   "ADLM"   "Loading" -48 -48 0 1   /vumeter 
  set cswitches "^cswitches/ADLM"
endif
if agc neqs "NONE" then
  gcontrol choice "AGC"    "AGC" "None,Gain,MGain,RfGain" agc
endif
if /play then
  gcontrol dval   "DELAY"  "Delay" 0.2 0 config.length .1 
endif
if /mtoff pexists then
  gcontrol lval   "MTOFF"  "MTOff" ^/mtoff 1 -1 1
endif
if /marker then
  gcontrol dval   "QFREQ"  "MrkFreq" 0 1 -1 1 /fmt="#0.000" /units="MHz" 
  set cswitches "^cswitches/MARKER"
endif

  gcontrol label  "ARCH"   "Archive" 0
  gcontrol file   "AFNAME" "File" ,,, raux /auxid 
if /wbp then
  gcontrol file   "WAFNAME" "WbFn" ,,, raux 
endif
if /dual then
  gcontrol choice "AUX1"   "Aux1" auxes aux1
  gcontrol choice "AUX2"   "Aux2" auxes aux2
else
  gcontrol choice "AUX0"   "Aux" auxes aux0
endif
  gcontrol tval   "ATCT"   "Top" 0 0 -1 1 /edit=t
  gcontrol tval   "ATCL"   "Len" 0 -1 -1 1 /edit=t /slider /maximum
  gcontrol lval   "AUXU"   "Disk" 0 0 100 1 /gauge /edit=f /units="% Full"
  gcontrol tval   "ATCA"   "Avail" 0 1 -1 1  /edit=f 

if sdds or iocsig eqss "RR" or nic neqs "NONE" or /nio then
  set pkttypes "ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD"
  if nic eqs "NONE" then set pkttypes "AUTO,^pkttypes,UDP,ETH"
  gcontrol label  "NET"    "Network Config"
  gcontrol choice "NPKT"   "Net Type" pkttypes "ICE"
  gcontrol lval   "VLAN"   "Net VLan" 0 0 32k-1 1
  gcontrol prompt "ADDR"   "Net Addr" "225.0.0.1"
  gcontrol lval   "SOCK"   "Net Port" 7000 0 32k-1 1
  gcontrol prompt "SID"    "Net SID " -1
endif

  invoke rfoptslist=nxm.ice.lib.DevIce.rfOptsList 
  gcontrol label  "RCVR"   "RF Config"
if xcvr nisnull then
  call makeXcvrs
  gcontrol choice "XCVR"   "RF Xcvr" xcvrs "None" /input /cs
  call setxcvr xcvr
endif
  gcontrol dval   "RFRATE" "RF Rate" 0 1 -1 1 /fmt="#0.000" /units="MHz" /edit=f
  gcontrol dval   "RFFREQ" "RF Freq" 1000 1 -1 1 /fmt="#0.000" /units="MHz"
  gcontrol lval   "RFATTN" "RF Attn" 0 0 100 1 /units="dB"
  gcontrol lval   "RFGAIN" "RF Gain" 0 -100 100 1 /units="dB"
  gcontrol choice "RFBW"   "RF BW  " rfbws 40 /units="MHz" /input
  gcontrol lval   "RFPWR"  "RF Pwr " 0 -100 100 1 /units="dBm" /edit=f
  gcontrol choice "RFOPTS" "RF Opts" rfoptslist "|" /toggle 
 if /dcsbn gt 0
  gcontrol lval   "DCSBN"   "DCS Bn " 16 4 16 1 
 endif
  set cswitches "^cswitches/RCVR"

  gcontrol label  "CFG"    "Port Config"
if cards rexists then
  gcontrol choice "CARD"   "Card  "  cards card /input
else
  gcontrol prompt "CARD"   "Card  "  card 
endif
  gcontrol choice "PORT"   "Port  "  ports config.port /input
  gcontrol choice "FORMAT" "Format"  formats "CI"
  gcontrol choice "RATE"   "Rate  "  rates 50 /units="MHz" /input
  gcontrol choice "LENGTH" "Length"  lengths 1.0 /units="sec" /input
  gcontrol choice "CLOCK"  "Clock "  clocks P
  gcontrol dval   "FBW"    "fBW   "  -1 -1 300 .010 /units="MHz"
  gcontrol choice "DEC"    "Dec   "  decs 1 /input
  gcontrol dval   "FREQ"   "Freq  "  0 -.5*gc.RATE.v gc.RATE.v 1 /fmt="#0.000" /units="MHz" /slider
  gcontrol dval   "BAUD"   "Baud  "  1 0 -1 1 /fmt="#0.000" /units="MHz"
  gcontrol lval   "GAIN"   "Gain  "  0 -100 100 1 /units="dB" /slider
  gcontrol lval   "MGAIN"  "MGain "  0 -100 100 1 /units="dB" 
if /nfgc pexists
  gcontrol lval   "NFGAIN" "NFGain" (/nfgc) -100 0 1 /units="dB" /slider
  set cswitches "^cswitches/NFGC"
endif

if /tb gt 0 or /mcs gt 0 or /scan gt 0 then
  gcontrol lval   "CHAN"   "IChn  "  0 -1 ntbc 1
  gcontrol choice "NTBC"   "NChn  "  "1,2,4,8,16,32,64,128,256,1000,1024,2000,2048,4000,4096" "^ntbc" /input
  gcontrol dval   "TBCS"   "ChnSp " -1 -1 100e6 1 /units="Hz"
endif
if /scan gt 0
  gcontrol dval   "DWELL"  "Dwell"    1 .001 10 1 /input
endif
if tbm eqs "MSP"
  gcontrol choice "REPLAY" "Replay" "Stop,One,Cont" "Cont"
endif

  gcontrol label  "DISP"   "Displays" 
  gcontrol choice "FRAME"  "Frame Size" frames 256 /input
  gcontrol choice "NFFT"   "FFT Size  " nffts 2K /input
if /wind then
  gcontrol choice "WIND"   "FFT Window" "^winds" wind /input
endif
  gcontrol choice "PSDR"   "PSD Rate  " psdrs 25 /units="Hz" /input 
  gcontrol choice "PSDA"   "Block Avg " psdas 5  /units="Frames" /input
  gcontrol choice "PSDM"   "Block Max " psdas 5  /units="Frames" /input
  gcontrol choice "DSPR"   "Disp Rate " dsprs 5  /units="Hz" /input
  gcontrol lval   "EXPA"   "Expn Avg  " 0 0 100 1 /units="Frames"
  gcontrol dval   "SCALE"  "Max Scale " 0 1 1e19 128 
  gcontrol choice "MONM"   "Monitor   " "Off,Async,Info,Full" "Async"
if /fixrange gt 0
  gcontrol lval   "RANGE"  "PSD Range " /fixrange 10 200 10
endif

  gcontrol label  "ANAL"   "Analysis" 0
  gcontrol button "APLOT"  "Function" "Function,WaveID,Speeds,Status" /nc=2 /toff
  gcontrol choice "AMODE"  "Source  " "Ram,Disk,DownLoad,ReadAfterWrite,^otherband" "Ram"
  gcontrol choice "AFFT"   "FFT Size" affts "4K" /input
  gcontrol dval   "APGR"   "Progress" 0 0 1 .1 /gauge 

  gcontrol label  "OPTS"   "Options" 0
  gcontrol prompt "FLAGS"  "Flags  " ""
  gcontrol prompt "AFLAGS" "aFlags " aflags /noedit
  gcontrol prompt "AFQUAL" "AFQual " ""
if /wbp then
  gcontrol prompt "WAFQUAL" "WAFQual" ""
endif
  gcontrol choice "ATAG"   "ArchTag" "None,Date,MJS,Datems,MJSms,RFDate" "None"
  gcontrol choice "AOVER"  "Overlay" "Ask,Erase,OverWrite,Append,LeaveAlone,Abort" "Ask"
  gcontrol choice "HDR"    "Headers" "Attached,Detached" "Det"
  gcontrol choice "APKT"   "Packets" "On,Off,ICE,ICE/DET,ICET,ICET/DET,SDDS,SDDS/DET,VRT,VRT/DET" apktdef
  gcontrol choice "WRAP"   "WrapPB"  "On,Off" "On"
  gcontrol lval   "STATS"  "Stats  " /stats 0 60 1
  gcontrol choice "COMP"   "Compression" "Off,Data,Plot" "Plot"

  gcontrol label  "SYS"    "System" 0
  gcontrol choice "ACTION" "Action" "Monitor,Process,Rec/PB,Stop,Config,Exit,ExitNow"
if /dual then
  gcontrol lval   "AUX1U"  "Disk Used-1" 0 0 100 1 /gauge /edit=n
  gcontrol lval   "AUX2U"  "Disk Used-2" 0 0 100 1 /gauge /edit=n
else
  gcontrol lval   "AUX0U"  "Disk Used-0" 0 0 100 1 /gauge /edit=n
endif
  gcontrol lval   "FULL"   "DiskFullAt " 98 0 100 1 /gauge
  gcontrol dval   "MAXFS"  "MaxFileSize" 64T 0 64T 1M /units="by"
  gcontrol lval   "CPU"    "Total CPU  " 0 0 100 1 /gauge
  gcontrol lval   "LOST"   "LostBuffers" 0 1 -1 1  /edit=f
  gcontrol lval   "CYCLE"  "CurrCycle  " 0 1 -1 1  /edit=f /mon=reg.sp.cycle
  gcontrol pipe   "PMON"   "Pipes" 

if /dbg then
  gcontrol label  "DBG"    "Debug" 0
  gcontrol button "DBGACT"  "Action" "RPM,WPM,RPB,WPB,RPC,WPC" /nc=3 /tleft
  gcontrol choice "DBGPRT"  "Port  " "IOModule1,IOModule2,Core1,Core2,HyperLink1,HyperLink2,ProcModule1,ProcModule2" /idef=1
  gcontrol lval   "DBGOFF"  "Offset" 0 0 64K 1 /hex
  gcontrol lval   "DBGVAL"  "Value " 0 1 -1 1 /hex
  gcontrol lval   "DBGRSZ"  "Size " 1 1 4 1 
endif

set d:cfl 0
if /tivo gt 0 then 			! setup tivo raster 
  calc cfl (/tivo)
  if cfl le 1 set d:cfl 60
  switch "CFL" d:cfl get cfl		! circular file length
  res cswitches "^cswitches/TIVO=^cfl"
  if /headless isfalse then 
    plot/id=tvrp type=rast axis=frame options=+BS readout=+T
    set reg.panel.toggleborders 0x2
  endif
  gcontrol label  "TIVO"  "TiVo FD Raster" 
  gcontrol button "TIVOM" "" "<<,<,RT,>,>>" "RT" /onerow 
  gcontrol tval   "TIVOS" "Bottom" 0 1 -1 1 
  gcontrol choice "TIVOL" "Window" "All,1:00,5:00,10:00,1:00:00,2:00:00" "1:00" /input
endif

if /cross then
  gcontrol label  "CROSS"  "Cross Correlation" 
  gcontrol panel  "CPLOT" "" 200 100
  plot/id=cplot _cbxf type=point cm=phase y1=-180 y2=180 axis=frame
  set gc.DISP.action close
endif

if /lponly then
  foreach id inlist "FDRP,FDRP1,FDRP2"
    if reg.^id rexists sendto "^id" "CLOSEFILE" "*"
  endfor
endif

if /checktc then erase dumptcstat dumptcdata
if /tsp or /xyp then set gc.NFFT.show 0
if fftcore le 0 then set gc.PSDM.show 0

pipe run

call picspecs
call checkafname 1
call setport
call setpbs
call setdec

if gc.MODE.v neqs "Setup" then set gc.MODE.action gc.MODE.v
if /mode pexists and parent neqs "SNAPAPP" then set gc.MODE.action "^/mode"
if /action pexists and parent neqs "SNAPAPP" then set gc.ACTION.action "^/action"

pipe off

! save off settings
if snapset rexists
 foreach item intable gc
  if item eqs "AFLAGS" or item eqs "MODE" or item eqs "ACTION" continue
  set snapset.^item gc.^{item}.value
 endfor
 table snapset SAVE "^env.home/snapset.tbl"
endif

! clean up tasks
call cleanlist
erase/warn=off snaptmp snaptmp1 snaptmp2
if logfn neqs "OFF" then report off

endmacro

procedure open
if /client gt 0 then
  set t:sets {} 
  foreach key intable gc
    set sets.^key "?"
  endfor
  message send "ICESRV" ,, "GET" ,, sets
endif
if /play lt 0 and card neqs "NONE" then set gc.WAVE.show 0
if /tivo gt 0 then set gc.CFG.v "CLOSED"
if /client isfalse then
  set this.timers 2
  set this.timer(0) 1
  set this.timer(1) 10
  sendto main "TIMER" info=1
endif
return

procedure close
!if gcalert rexists pause 1
call picstop
while reg.noop rexists
  warning "Waiting on NOOP process"
  pause 1
endwhile
return

procedure processMessage m:msg

if msg.name eqs "TIME" then return
!say "Got message ^msg.name = ^msg.data from ^msg.fid"

! translate ACTION messages from SNAPAPP here so sync messages work
if msg.name eqs "ACTION" then
  if msg.data eqss "START"
    if "ONE" subs gc.MODE.v
      call picstart "ONE"
    else
      call picstart "CONT"
    endif
    call picwait 20
    return
  endif
  if msg.data eqss "REC" and gc.AFNAME.v eqs "NONE" set msg.data "RTMEM"
  if msg.data eqss "REC" and /play istrue set msg.data "RTPLAYBACK"
  if msg.data eqss "REC" set msg.data "RTARCHIVE"
  if msg.data eqss "MON" set msg.data "RTMEM"
  if msg.data eqss "STOP" set msg.data "SETUP"
  set gc.MODE.v msg.data
  set msg.name "MODE"
endif

if msg.name eqs "CYCLE" then
  if msg.data eq 1 and "ONE" subs gc.MODE.v then 
    set regsp reg.sp
    while regsp rexists and regsp.replay neqs "STOPPED"
      pause 0.1
    endwhile
    if autoarchive then
      set gc.MODE.action "ARCHIVE"
    else
      set gc.MODE.action "SETUP"
    endif
    set onestate "FINISHED"
  endif

elseif msg.name eqs "TIMER" then 
 if msg.info eq 0		! 1 sec
  if reg.sp rexists then
    if /checktc then call dumptcdata
    if pollstr neqs "NULL" then call pollit
  endif
  if tvfn rexists and gc.TIVOM.v eqs "RT" and gc.TIME.v-gc.TIVOS.v gt 60 then
    call refreshTivoPlot
  endif
  if /server gt 0 then message send rmif ,, "ACK" ,, {TIME=^gc.TIME.v}
  if afn neqs "NULL" and /client isFalse then
    call updateArchive afn
  endif
  if nic neqs "NONE" and card neqss "NIC" return
  if  reg.sp rexists and card neqs "NONE" then
    if gc.RFPWR rexists and gc.RFPWR.show gt 0 then set gc.RFPWR.v reg.sp.RFPWR
    if /emt gt 0 then set gc.EMT.v reg.sp.EMT
    if /adlm gt 0 then set gc.ADLM.v reg.sp.ADLM
    if agc neqs "NONE" then set gc.^{agc}.v reg.sp.^agc
  endif
  if archiving neq 0 and reg.NOOP nrexists then
   call doneArchiving ^archiving
  endif

 elseif msg.info eq 1 then	! 10 sec
  report flush
  if /tivo gt 0 and /headless isfalse and tvfn nrexists then
    call refreshTivoPlot
    call updateFreqMarker
  endif
  if /gps gt 0
    ! uses gps=n value to specify which IO module the GPS is on
    picd/dmac=-(/gps) "GPS" ^card ,, gpsdat /sv=gpssv 
  endif
 endif

elseif msg.fid eqss "FDLP" or msg.fid eqss "FDRP" or msg.fid eqss "TDLP" or msg.fid eqss "TDRP" then
  ! forget marrying windows for now
  sedit msg.fid pind range 4 
  if pind neqs "" and ff^pind rexists then set ff ff^pind
  if msg.name eqs "MARK" and gc.MODE.value eqss "RT" then
    if /scan and msg.fid eqs "FDLP" then	! click select
      set gc.CHAN.action -1
    elseif ( /tb or /mcs or /scan ) and ( msg.fid eqss "FD" or /wbp isfalse ) then	! click select
      set layer reg.^{msg.fid}.layers._cb^pind
      set gc.CHAN.action layer.select
!    elseif clicktune isfalse then
!      warn "Click tune disabled by /CLICKTUNE=n"
    elseif msg.fid eqss "FD" then	! click tune
      set ffx 0
      set d:freq msg.data.x*1e-6
      if /nbp and clicktune gt 0 then set gc.FREQ.action freq
      if /wbp and clicktune eq 2 then set gc.FREQ.action gc.FREQ.v+freq
      if /wbp and clicktune eq 1 then set ffx msg.data.x
      if ff rexists and /wbp isfalse then 
        set ff.x msg.data.x
        if /marker then set ff.y msg.data.y
      endif
      call updateFreqMarker -1 ffx
    elseif msg.fid eqss "TD" then	! click tune
      set d:freq msg.data.x*1e-6
      if /wbp and clicktune gt 0 then set gc.FREQ.action freq
      call updateFreqMarker -1 
    endif
  endif

elseif msg.fid eqs "TVRP" then
  if msg.name eqs "ZOOM" then
    set gc.TIVOM.v "NONE"  ! turn off RealTime
  elseif msg.name eqs "MARK" then
    set gc.TIVOS.value msg.data.t
  endif

elseif msg.fid eqs "RMIF" then		! handle server/client messaging
  if msg.name eqs "OPEN"
    info "Got open ^msg.data from ^msg.fid"
  elseif msg.name eqs "OPENED"
    info "Got opened ^msg.data from ^msg.fid"
    pause 0.5  ! make sure plots are up
    set gc.COMP.action "PLOT"
  elseif msg.name eqs "CLOSE"
    info "Got close ^msg.data from ^msg.fid"
  elseif msg.name eqs "CLOSED"
    info "Got closed ^msg.data from ^msg.fid"
  endif

elseif msg.name eqs "GET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    if gc.^key rexists then
      set sets.^key gc.^{key}.value
    else
      set sets.^key ^key
    endif
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "RET" then		! client side
  set t:sets msg.data
  foreach key intable sets
    if key eqss "TIVO" then 
      ! TIVO messages handled locally
    else
      set gc.^{key}.value "^sets.^key"
      if key eqs "FREQ" call updateFreqMarker
      if key eqs "SCALE" call updateScale
    endif
  endfor

elseif msg.name eqs "SET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    if key eqss "TIVO" then 
      ! TIVO messages handled locally
    elseif key eqs "JOIN" or key eqs "IPCONN" then
      set reg.SP.join "^sets.^key"
    elseif key eqs "LEAVE" or key eqs "IPDISC" then
      set reg.SP.leave "^sets.^key"
    elseif key eqs "VLAN" or key eqs "IPVLAN" then
      set reg.SP.vlan "^sets.^key"
    elseif key eqs "INFO" then
      info sets.^key
    else
      set gc.^{key}.action "^sets.^key"
    endif
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "ACK" then		! client side
  set t:sets msg.data
  foreach key intable sets
    if key eqs "SYSTEM" then
      call picsystem sets.SYSTEM
    elseif key eqss "TIVO" then
      ! TIVO messages handled locally
    else
      set gc.^{key}.value "^sets.^key"
      if key eqs "FREQ" call updateFreqMarker
      if key eqs "SCALE" call updateScale
    endif
  endfor

elseif msg.name eqs "EXIT"
  pipe stop

elseif msg.name eqs "SYSTEM"
  call picsystem msg.data
  if /server gt 0 then message send rmif ,, "ACK" ,, {SYSTEM=^msg.data}

elseif msg.name eqs "WIND"
  set wind gc.WIND.v
  if reg.fft rexists set reg.fft.window wind

elseif msg.name eqs "ATCT"

elseif msg.name eqs "ATCL"
  set gc.ATCL.max msg.data
  set gc.ATCL.v 0

elseif msg.name eqs "TIVOM" then
  if msg.data eqs "RT" then
    calc tv ^gc.TIME.v
    set gc.TIVOM.v "RT"
  elseif gc.TIVOL.v eqs "ALL" then
    calc tv ^gc.TIME.v
  elseif msg.data eqs ">" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v 4 / +
  elseif msg.data eqs "<" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v 4 / -
  elseif msg.data eqs ">>" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v +
  elseif msg.data eqs "<<" then
    calc tv gc.TIVOS.v ^gc.TIVOL.v -
  endif
  set gc.TIVOS.action ^tv

elseif msg.name eqs "TIVOS" then
  call refreshTivoPlot

elseif msg.name eqs "TIVOL" then
  call refreshTivoPlot

elseif msg.name eqs "DOWNLOAD" then
  if aux.write eqs "RAM" then
    gc/temp/msg=n alert "TEMP" "Download" "DownLoad not available from Applet - try WebStart"
    return
  endif
  set dlfn msg.data.FNAME.v
  set ulfn "^{gc.AFNAME.v}.tmp(~^msg.data.START.v:+~msg.data.LENGTH.v)"
  noop/bg/gpw/tl=1m http://^remote/Files/^ulfn dlfn
  set gc.ANAL.action "OPEN"
  set gc.AMODE.v "DOWNLOAD"

elseif msg.name eqs "AGC" 
  set agc gc.AGC.v
  call setAGC

elseif msg.name eqs "APLOT" or msg.name eqs "OPLOT"
  ! handle special cases
  if msg.name eqs "OPLOT" then
    if msg.data nsubs gc.APLOT.items then
!       set gc.APLOT.items "^gc.APLOT.items,^msg.data"
       set gc.APLOT.items "Function,Datalist,^msg.data,Status"
    endif
  elseif msg.data eqs "FUNCTION"
    set tmp "TD-Line,TD-Raster,TD-Phase,FD-Line,FD-Raster,FD-Phase,Histogram,DataList,DualDiff,TimeCode,Packets"
    set tmp "^tmp,BufStats,BitStats,LSBit,Logs,SDDS-Info,SDDS-Gap,TFDOA,DMAC,DMACX,Speeds,RamStatus,TraceDump,WaveID,SaveMarker"
    gc/temp button "OPLOT"  "Analysis Functions" tmp /nc=2
    return
  endif
  if msg.data eqs "BUFSTATS"
    if /client gt 0
      gc/temp/msg=n alert "TEMP" "Analyze" "STATS plot not available in client mode"
    elseif /dual then
      call picfstats "SP"
      call picfstats "SPS"
    else
      call picfstats "SP"
    endif
  elseif msg.data eqs "LOGS"
    if logfn eqs "OFF" then
      gc/temp/msg=n alert "TEMP" "Logs" "Logging is turned OFF"
    else
      report flush
      view/bg ^{logfn}.mlog
    endif
  elseif msg.data eqs "SAVEMARKER" then
    if ff rexists then
      gc/temp prompt "SAVEMARKERAS"  "Marker Name" "FF_1"
    else
      warn "Marker FF does not exists. Insure /MARKER switch"
    endif
  elseif msg.data eqs "SPEEDS"
    pic/flags=flg get card speeds /dmac=-1
  elseif msg.data eqs "STATUS"
    pic/flags=flg STATUS card
  elseif msg.data eqs "DMAC"
    picd/flags=flg DMAC card
  elseif msg.data eqs "DMACX"
    pic/flags=flg DMACX card
  elseif msg.data eqs "DUALDIFF"
    iceutil logger pause
    icediff ramfile1 ramfile2
    iceutil logger resume
  elseif msg.data eqs "TFDOA"
    if /dual then
      icetfdoa ^ramfile1 ^ramfile2
    else
      icetfdoa "auto_nfloor" ^ramfile ,,, 0.25
    endif
  elseif msg.data eqs "TD-LINE" and /dual then
    plot/bg/id=aplot/all ramfile1|ramfile2 y1=-scale y2=scale
  else
    set analist "0"
    if /dual then set analist "1,2"
 foreach ext inlist analist
  ! prepare the data file
  if ext eqs "0" then set ext ""
  if gc.AMODE.v eqs "RAM" then
    set alfn ramfile^ext
  elseif gc.AMODE.v eqs "NARROWBANDRAM" or gc.AMODE.v eqs "WIDEBANDRAM" then
    set alfn ramfilet
  elseif gc.AMODE.v eqs "DISK" or gc.AMODE.v eqs "READAFTERWRITE" then
    if afn eqs "NULL" 
      set alfn gc.AFNAME.v
    else
      set alfn afn
    endif
    if ext neqs "" then set alfn ^{alfn}_^ext
  elseif gc.AMODE.v eqs "DOWNLOAD" then
    if dlfn nrexists then
      gc/temp alert "ANALYZE" "Analyze" "DownLoad must precede Analysis Options"
      return
    endif
    set alfn dlfn
  endif
  set snaptmp "snaptmp^ext"	! temporary file
  if gc.AMODE.v eqs "READAFTERWRITE" and msg.data nsubs "STATUS|PACKETS|TIMECODE"
    set alfn "^{alfn}(-~1:)"
  endif
  if alfn nfexists then
    gc/temp alert "ANALYZE" "Analyze" "Analyze File ^alfn does not exist"
  elseif msg.data eqs "RAMSTATUS"
    iceutil logger pause
    status alfn
    iceutil logger resume
  elseif msg.data eqs "TRACEDUMP"
    picd "TRACESETUP" ^card 0x07 /core=1
    picd "TRACEDUMP" ^card trace 4k /core=1
    plot/bg trace{form=CI}
  elseif msg.data eqs "DATALIST"
    iceutil logger pause
    calc nc 16 file(alfn).bpe 1 max /
    data/hex/h/nc=nc alfn{fs=0} 0 64
    iceutil logger resume
  elseif msg.data eqs "PACKETS"
    if file(alfn).keyword(packet) eqs "SDDS/ICE" then
      do n 0,8k,1k
        datalist/p alfn n +4
      enddo
    elseif ^{alfn}.pkt fexists then
      view/bg ^{alfn}.pkt
    else
      warn "No SDDS or ICE packets modes found"
    endif
  elseif msg.data eqs "TIMECODE"
    if file(alfn).keyword(packet) eqs "SDDS/ICE" then
      icetc extract "SDDS" alfn snaptmp /test
      view/bg snaptmp
    elseif ^{alfn}.pkt fexists then
      icetc extract "ICE" ^{alfn}.pkt snaptmp /test /delta=file(alfn).delta
      view/bg snaptmp
    else
      set tc file(alfn).time
      calc offset 1-tc.fsec file(alfn).xdelta / round
      switch "TCZONED" l:tczone get 32
      warn "No SDDS or ICE packets modes found - listing TC hack centered in ^tczone samples"
      data/hex/nc=8 alfn offset-(tczone/2) +tczone
      switch "TCZONEP" l:tczone get 2k
      calc offset offset-(tczone/2) 0 max
      if ntbc gt 1 then
        thin alfn{fs=nfs} tcchn 0 -1 ntbc
        thin tcchn{fs=0} tctmp offset offset+tczone
      else
        thin alfn tctmp offset offset+tczone
      endif
      status tctmp form=fmt xd=delta
      header tctmp xs=-tczone/2*delta
      if port eqss "T" or "LSBP" nsubs flg
        fcalc/type=l tcplot tctmp 0 *
      elseif fmt eqss "C"
        fcalc/type=l tcplot tctmp real 0x1 band scale/2 *
      else
        fcalc/type=l tcplot tctmp 0x1 band scale/2 *
      endif
      warn "Plotting TC hack centered in ^tczone samples"
      plot/bg tctmp|tcplot cm=mag y1=-scale y2=scale
    endif
  elseif msg.data eqs "SDDS-INFO"
    picd/flags=flg/port=port get card "PKTHDR" /hex /verbose
    picd/flags=flg/port=port get card "GAP" gap
    calc gap 0xFFFF band =l:gapmin gap 64k / =l:gapmax
    say "SDDS Packet Gap Min=^gapmin Max=^gapmax uS"
    picd/flags=flg/port=port get card "SEQFILL" seqfill
    picd/flags=flg/port=port get card "SEQERR" seqerr
    say "SDDS Sequence Fill=^seqfill Err=^seqerr"
    picd/flags=flg/port=port get card "DUMP" sdump
  elseif msg.data eqs "SDDS-GAP"
    call picgstats "SP"
  elseif msg.data eqs "CALCAIS"
    iceais ^{alfn}(0:1M) aistaps
    info "Ais TAPS=^aistaps"
    picd/flags=flg/port=port set card "RFAIS" aistaps
  elseif msg.data eqs "WAVEID"
    sigscan/bg alfn
  else
    call analyze msg.data alfn snaptmp
  endif 
 endfor
  endif

elseif msg.fid eqs "APLOT"
  ! ignore messages from analysis plots

elseif msg.name eqs "COMP" then
  set reg.fdlp.compression msg.data
  if /nbp or /wbp then set reg.tdlp.compression msg.data

elseif msg.name eqs "SCALE"
  call updateScale

elseif msg.name eqs "RANGE"
  call setRange

elseif /client gt 0	
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "ONLINE" then
  elseif msg.data eqs "OFFLINE" then
  elseif msg.data eqs "DOWNLOAD" then
    if dlfn nrexists set dlfn "myfile"
    if /tivo gt 0 then
      calc d:tcs reg.TVRP.t1 10 * round 10 /
      calc d:tcl reg.TVRP.y2-reg.TVRP.y1 10 * round 10 /
      calc d:fw reg.TVRP.x2-reg.TVRP.x1 round
      calc d:fc reg.TVRP.x1+(fw/2) round
    else
      set d:tcs gc.ATCT.value
      set d:tcl 10.0
      set d:fc 0
      set d:fw 1e6*gc.RATE.v/2
    endif
    gc/temp/handle=dlog dialog "DOWNLOAD" "DownLoad ARCH=^gc.AFNAME.v" 300 -5
    gc/panel=dlog tval   "START"   "TimeStart" tcs 1 -1 1
    gc/panel=dlog choice "LENGTH"  "Duration " "1,2,5,10,30,1:00,2:00,5:00,10:00" "^tcl" /units="sec" /input
    gc/panel=dlog dval   "FCENTER" "FreqCenter" fc 1 -1 1000 /units="Hz"
    gc/panel=dlog dval   "FWIDTH"  "FreqWidth " fw 1 -1 1000 /units="Hz"
    gc/panel=dlog prompt "FNAME"   "ToFile" dlfn
  else 
    ! client GUI sends all other GC messages to server
    message send "ICESRV" ,, "SET" ,, {^msg.name=^msg.data}
  endif

elseif msg.name eqs "MODE" or msg.name eqs "OTHER" then
  set afn "NULL"
  set lafn gc.AFNAME.v
  if lafn eqs "" set lafn "NULL"
  timex now curtime
  if /play isfalse and lafn nisnull then
    set l:lfreq gc.RFFREQ.v
    if gc.ATAG.v eqss "RFDATE" set lafn "^{lafn}_^{lfreq}_^curtime.tofilename"
    if gc.ATAG.v eqss "DATE" set lafn "^{lafn}_^curtime.tofilename"
    if gc.ATAG.v eqss "MJS" set lafn "^{lafn}_^l:curtime.getmjs"
    if "MS" subs gc.ATAG.v 
      calc l:msec curtime.sec 1 mod 1000 * round
      set lafn "^{lafn}_^msec"
    endif
  endif
  if msg.data eqs "OTHER" then
    gc/temp button "OTHER"  "Other Functions" "CardReset,ForceReset,Spin" /nc=1
    return
  endif
  if msg.data eqs "COMPOSE" then
    siggen/bg/offline/gcx={FORM=^gc.FORMAT.v,LEN=^gc.LENGTH.v,RATE=^gc.RATE.v} ^gc.AFNAME.v 
    return
  endif
  set l:wrp test(gc.WRAP.v,eqs,"ON")
  set l:mon test("MEM",subs,msg.data,or,"MON",subs,msg.data)
  if "ONE" subs msg.data and /pbfonly istrue then set msg.data "RTPLAY"
  if msg.data eqs "SETUP" or msg.data eqs "STOP" then
    call picstop
    set gc.MODE.v "SETUP"
    if lmode eqss "RTARCH" call doneArchiving 1
    if /autoexit then pipe stop
  elseif "RESET" subs msg.data 
    set flgs flg
    if "FORCE" subs msg.data sedit flgs flgs "APPEND" "|FORCE"
    info "Resetting card with flags: ^flgs"
    picd/flags=flgs reset ^card 
    set gc.MODE.v "SETUP"
  elseif archiving gt 0 then
    warn "Archive not complete.  Use progress widget to cancel."
    set gc.MODE.v "ARCHIVE"
  elseif archiving lt 0 then
    warn "Dearchive not complete.  Use progress widget to cancel."
    set gc.MODE.v "DEARCHIVE"
  elseif msg.data eqs "EXIT"
    if /noexitmenu and msg.quals rexists and msg.quals.actiontype eq 0 then
      warn "Exit button has been disabled - use launch window"
    else
      call picstop
      pipe stop
    endif
  elseif "ONESH" subs msg.data or msg.data eqs "WAVEFORM" then
    call picstop
    call picsetup
    switch "AUTOARCHIVE" autoarchive get test("ARCH",SUBS,msg.data) 1
    if autoarchive gt 0 set donearchmode lmode
    set gc.MODE.v "ONESHOT"
    if msg.info ge 0 call picstart "ONE"
  elseif msg.data eqs "DEARCHIVE" 
    if ramfile nrexists 
      sedit "^{gc.CARD.value}_^{gc.PORT.value}" ramfile "UPCASE"
      sedit "^{gc.CARD.value}_^{gc.PORT.value}1" ramfile1 "UPCASE"
      sedit "^{gc.CARD.value}_^{gc.PORT.value}2" ramfile2 "UPCASE"
    endif
    if /dual then
      info "Dearchiving ^gc.AFNAME.v into ^ramfile1"
      icecopy/gpw gc.AFNAME.v ramfile1{AUX=ENV.RAMAUX,DET=1,CTG=1}
      info "Dearchiving ^gc.AFNAME.v into ^ramfile2"
      icecopy/gpw gc.AFNAME.v ramfile2{AUX=ENV.RAMAUX,DET=1,CTG=1}
    else
      info "Dearchiving ^gc.AFNAME.v into ^ramfile"
      icecopy/gpw gc.AFNAME.v ramfile{AUX=ENV.RAMAUX,DET=1,CTG=1}
    endif
    call doneArchiving -1
  elseif msg.data eqs "ARCHIVE" 
    if reg.sp rexists and reg.sp.replay neqs "STOPPED" then
      gc/temp/timeout=2 alert ,,, "Must stop current acquisition/playback first."
      set gc.MODE.action "SETUP"
    elseif lafn isnull then
    elseif /dual then
      info "Archiving ^ramfile1 to ^{lafn}_1"
      icecopy/bg/gpw/verbose ramfile1 ^{lafn}_1{AUX=^AUX1,DET=^gc.HDR.item-1}
      info "Archiving ^ramfile2 to ^{lafn}_2"
      icecopy/bg/gpw/verbose ramfile2 ^{lafn}_2{AUX=^AUX2,DET=^gc.HDR.item-1}
      set l:archiving 2
    else
      info "Archiving ^ramfile to ^lafn"
      icecopy/bg/gpw/verbose ramfile lafn{AUX=^AUX0,DET=^gc.HDR.item-1}
      set l:archiving 1
    endif
  elseif "SPIN" subs msg.data then
    call picstop
    call picsetup
    call picstart "SPIN"
  elseif msg.data eqss "RTA" and lmode eqss "RTM" then	! turn on archiver
    set afn lafn
    if lafn isnull
      set ans "LEAVE"
    elseif /dual then
      call preparch "RAMFILE1" "ARCHFILE1" ^{AFN}_1 ^AUX1
      call preparch "RAMFILE2" "ARCHFILE2" ^{AFN}_2 ^AUX2
    else
      call preparch "RAMFILE" "ARCHFILE" ^{AFN} ^AUX0
    endif
    if ans eqss "LEAVE" or ans eqs "ABORT" then
      set gc.MODE.v "RTM"
    elseif /dual then
      set reg.sp.startArchiver archfile1
      set reg.sps.startArchiver archfile2
    else
      set reg.sp.startArchiver archfile
    endif
  elseif msg.data eqss "RTM" and lmode eqss "RTA" then	! turn off archiver
    if /dual then
      invoke reg.sp.stopArchiver
      invoke reg.sps.stopArchiver
    else
      invoke reg.sp.stopArchiver
    endif
  elseif "RT" subs msg.data or msg.data eqss "MON" or msg.data eqss "REC" or msg.data eqss "PLAY" then
    call picstop
    set autoarchive 0
    if ( mon eq 1 and /PBFONLY isfalse ) or /PBWONLY istrue or lafn isnull then
      set gc.MODE.v "RTM"
      set gc.AMODE.v "RAM"
    else
      set afn lafn 
      if /play then
        set gc.MODE.v "RTP"
        info "DeArchiving from ^afn"
        if /pbfonce and mon eq 0 then set l:wrp 0
      else
        if "ONE" subs msg.data then
          set gc.MODE.v "ONERT"
        else
          set gc.MODE.v "RTA"
        endif
        info "Archiving to ^afn"
      endif
      if gc.AMODE.v eqs "RAM" set gc.AMODE.v "READ"
    endif
    call picsetup
    if msg.info lt 0 
      ! prestart pass from ACTION message
    elseif "ONE" subs gc.MODE.v
      call picstart "ONE"
    else
      call picstart "CONT"
    endif
  endif
  set lmode gc.MODE.v

elseif msg.name eqs "SAVEMARKERAS" then
  set fname msg.data
  if ^fname rexists then
    set ^{fname}.X FF.X
    set ^{fname}.Y FF.Y
  elseif reg.fdlp rexists then
    feature ,, ^fname {NAME=^fname,TYPE=SYMBOL|TEXT,SYMBOL=CIRCLE,COLOR=RED,X=FF.X,Y=FF.Y} fdlp
  else
    warn "No plot for new marker name=^fname"
  endif

elseif msg.name eqs "COMPOSE"
  if msg.data eqss "CREATE" then
    noop ramfile afname
  elseif msg.data eqss "ADD" then
    fcalc afname{form=^gc.FORMAT.v} afname ramfile +
  elseif msg.data eqss "APPEND" then
    mergefile ramfile afname
  endif

elseif msg.name eqs "ANALYZE"
  say "Got an abort message"

elseif msg.name eqs "PORT"
  call setport
  call setpbs
  call picrestart 1

elseif msg.name eqs "WAVE"
  call setpbs
  call picrestart

elseif msg.name eqs "CARD"
  res rclock "Z"	! trigger reset
  call setport
  call picrestart 1

elseif msg.name eqs "FLAGS"
  set flags gc.FLAGS.v
  res rclock "Z"	! trigger reset
  call picrestart 1

elseif msg.name eqs "LENGTH"
  if /play then set gc.DELAY.max ^gc.LENGTH.value
  call picrestart

elseif msg.name eqs "PSDR" then
  if fftcore le 0
    calc l:dspr ^gc.PSDR.v ^gc.PSDA.v / 1 max
    set gc.DSPR.v ^dspr
  endif
  call picrestart 1

elseif msg.name eqs "DSPR" then
  if fftcore le 0
    calc l:psdr ^gc.DSPR.v ^gc.PSDA.v * 1 max
    set gc.PSDR.v ^psdr
  endif
  call picrestart 1

elseif msg.name eqs "PSDA" then
  if fftcore le 0
    calc l:psdr ^gc.DSPR.v ^gc.PSDA.v * 1 max
    set gc.PSDR.v ^psdr
  endif
  call picrestart 1

elseif msg.name eqs "FRAME" or msg.name eqs "NFFT" or msg.name eqs "CLOCK"  &
    or msg.name eqs "ADDR" or msg.name eqs "SID" or msg.name eqs "NPKT" &
    or msg.name eqs "SOCK" or msg.name eqs "NTBC" or msg.name eqs "TBCS"  then
  call picrestart 1

elseif msg.name eqs "FORMAT" or msg.name eqs "DEC" then 
  call setdec
  if tbm eqs "MSP" and reg.sp rexists then
    set reg.sp.replay "STOPNOW"
    set reg.sp.dec gc.DEC.v
    set gc.REPLAY.v "Stop"
    warn "Channel stopped due to decimation change"
  else
    call picrestart
  endif

elseif msg.name eqs "RATE"
  call setrate
  call setdec
  call picrestart
  if wave eqs "FILE" and ramfile "FEXISTS" then headermod ramfile xdelta=1/drate

elseif msg.name eqs "FREQ"
  set d:freq msg.data
  calc dfreq freq 1e6 *
  if reg.sp rexists set reg.sp.freq dfreq
  if reg.sps rexists set reg.sps.freq dfreq
if /nbp then
  if reg.spn rexists set reg.spn.freq dfreq
  if reg.spw rexists set reg.spw.freq dfreq
endif
  if /server then message send rmif ,, "ACK" ,, {FREQ=^freq}
  call updateFreqMarker
  if wave neqs "NONE" and wave neqs "FILE" then call picrestart

elseif msg.name eqs "BAUD"
  if wave neqs "NONE" and wave neqs "FILE" then call picrestart

elseif msg.name eqs "GAIN"
  if reg.icr rexists then
    set reg.icr.gain msg.data
    return
  endif
  set l:gain msg.data
  if reg.sp rexists set reg.sp.gain msg.data
  if reg.sps rexists set reg.sps.gain msg.data
if /nbp then
  if reg.spn rexists set reg.spn.gain msg.data
  if reg.spw rexists set reg.spw.gain msg.data
endif
  if /play and gc.WAVE.v neqs "NONE" then call picrestart

elseif msg.name eqs "MGAIN"
  if reg.sp rexists set reg.sp.mgain msg.data
  if reg.sps rexists set reg.sps.mgain msg.data
  if mtype rexists and mtype eq -13 and gc.MODE.v neqs "SETUP" then
    warn "SONET gain change currently requires RESTART to take affect"
  endif

elseif msg.name eqs "NFGAIN"
  if reg.sp rexists set reg.sp.nfgain msg.data
  if reg.sps rexists set reg.sps.nfgain msg.data

elseif msg.name eqs "DCSBN"
  if reg.sp rexists set reg.sp.DCSBN msg.data
  if reg.sps rexists set reg.sps.DCSBN msg.data

elseif msg.name eqs "REPLAY"
  set reg.sp.replay msg.data

elseif msg.name eqs "RFFREQ"
  call updateRfFreq msg.data
elseif msg.name eqs "RFBW"
  call updateRfBw ^msg.data
elseif msg.name eqs "RFGAIN"
  call updateRfGain msg.data
elseif msg.name eqs "RFATTN"
  call updateRfAttn msg.data
elseif msg.name eqs "RFOPTS"
  call updateRfOpts msg.data
elseif msg.name eqs "RFPWR"
  ! read only

elseif msg.name eqs "XCVR" then
  call setxcvr msg.data
  call setport

elseif msg.name eqs "CHAN"
  if /tb and /cross then
    calc/type=l reg.thin1.offset msg.data-1 0 max
    calc/type=l reg.thin2.offset msg.data-1 0 max
  endif
  if tbm neqs "MSP" then
    if reg.sp rexists set reg.sp.channel msg.data
    if reg.sps rexists set reg.sps.channel msg.data
    set gc.FREQ.value reg.sp.freq*1e-6
  elseif reg.sp^gc.CHAN.v rexists then
    set reg.sp reg.sp^gc.CHAN.v
    set gc.DEC.v  reg.sp.dec
    set gc.FREQ.v reg.sp.freq*1e-6
    set gc.GAIN.v reg.sp.gain
    set gc.REPLAY.v reg.sp.replay
  endif
  call updateFreqMarker

elseif msg.name eqs "STATS"
  if reg.sp  rexists set reg.sp.stats msg.data
  if reg.sps rexists set reg.sps.stats msg.data

elseif msg.name eqs "MONM"
  if reg.sp  rexists set reg.sp.monitor msg.data
  if reg.sps rexists set reg.sps.monitor msg.data

elseif msg.name eqs "EXPA"
  calc l:nexp gc.EXPA.v 1 max
  if reg.fft rexists  set reg.fft.nexp nexp
  if reg.fftn rexists set reg.fftn.nexp nexp
  if reg.fftw rexists set reg.fftw.nexp nexp
  if reg.svi rexists  set reg.svi.L:NEXP nexp

elseif msg.name eqs "AFNAME"
  call checkafname 0

elseif msg.name eqs "AUX0"
  set aux0 gc.AUX0.v
elseif msg.name eqs "AUX1"
  set aux1 gc.AUX1.v
elseif msg.name eqs "AUX2"
  set aux2 gc.AUX2.v

elseif msg.name eqs "DELAY"
  warn "This only takes effect on application restart"

elseif msg.name eqs "DBGACT"
  picd/flags=flg ^msg.data card gc.DBGOFF.v gc.DBGVAL.v /node=gc.DBGPRT.itemindex /size=gc.DBGRSZ.v

elseif msg.name eqs "ARCHIVE" then
  icearchive msg.data.func,msg.data.archive,msg.data.top,msg.data.dur,msg.data.event,msg.data.file

elseif msg.name eqs "GETLOG"
  set msg.data reg.logger.getLast

elseif msg.name eqs "GETCFG"
  set t:msg.data {FREQ=f:^gc.FREQ.v,DEC=l:^gc.DEC.v,GAIN=l:^gc.GAIN.v}

elseif msg.name eqs "SETCFG"
  set l:ii msg.info
  set t:cc ^msg.data
  foreach key intbl cc
    sendto "MAIN" "^key" cc.^key
  endfor

else
  ! the rest need no other action
  !say "Unhandled message ^msg.name"
endif
return

procedure prespecs
set l:dec  config.DEC
set d:rate config.RATE
set d:freq config.FREQ
set d:gain config.GAIN
set d:psdr config.PSDR
set l:psda config.PSDA
set s:port config.PORT
set l:nfft ^config.NFFT
set l:frame config.FRAME
set s:format config.FORMAT
set d:length config.LENGTH
set s:wave config.WAVE
sedit config.CLOCK clock "TRIM" "" "-"
calc drate rate 1e6 * dec /
sedit "MUXCLK=^clock|" flg "APPEND" aflags 
if config.flags rexists sedit flg flg "APPEND" "|" "APPEND" config.flags
iceutil "CARETS" flg flg
return

procedure picspecs
set l:dec  gc.DEC.value
set d:rate gc.RATE.value
set d:freq gc.FREQ.value
set d:gain gc.GAIN.value
set d:psdr gc.PSDR.value
set l:psda gc.PSDA.value
set d:dspr gc.DSPR.value
set s:card gc.CARD.value
set s:port gc.PORT.value
set s:monm gc.MONM.value
set l:nfft ^gc.NFFT.value
calc l:nexp gc.EXPA.v 1 max
set l:frame gc.FRAME.value
set s:format gc.FORMAT.value
set d:length gc.LENGTH.value
set s:wave gc.WAVE.value
sedit gc.CLOCK.value clock "TRIM" "" "-"
sedit card card "UPCASE"
set l:wrp test(gc.WRAP.v,eqs,"ON")
if card eqss "NIC" 
  set flg  "PKTMODE=^gc.NPKT.v"
elseif /nio then
  set flg  "MUXCLK=^clock|NIO=^gc.NPKT.v|NIOA=^gc.ADDR.v|PKTPORT=^gc.SOCK.v|SID=^gc.SID.v"
elseif iocsig eqss "RR" then
  set flg  "MUXCLK=^clock|PKTY=^gc.NPKT.v|NIOA=^gc.ADDR.v|PKTPORT=^gc.SOCK.v|SID=^gc.SID.v"
else
  set flg  "MUXCLK=^clock" 
endif
if xcvr nisnull then sedit flg flg "APPEND" "|XCVR=^xcvr"
if gc.AFLAGS.v neqs "" then sedit flg flg "APPEND" "|" "APPEND" gc.AFLAGS.v
if gc.FLAGS.v neqs "" then sedit flg flg "APPEND" "|" "APPEND" gc.FLAGS.v
if format eqs "C12b" then
  sedit flg flg "APPEND" "|PACK12"
  set s:format "CJ"
elseif format eqs "C12b16" and /play then
  sedit flg flg "APPEND" "|UP12"
  set s:format "CJ"
elseif format eqs "C12b16" then
  sedit flg flg "APPEND" "|PACK12|UP12"
  set s:format "CI"
endif
invoke bpa nxm.sys.lib.Data.getBPA(format)
iceutil "CARETS" flg flg
if rate le 0 set rate 1
if bpa lt 0 set bpa -bpa/8
if port eqss "MOD" and gc.MGAIN.show then
  set d:gain gc.MGAIN.value
endif
if /play then
  calc d:dly gc.DELAY.value ^gc.LENGTH.value-.2 min
  if dly neq gc.DELAY.value then warning "Delay limited by buffer length to ^dly sec"
elseif card neqs "NONE" and wave neqs "ZERO"
  set s:wave "NONE"
endif
if /dual then
  set aux1 gc.AUX1.v
  set aux2 gc.AUX2.v
  switch DPI1 l:dpi1 get 1
  switch DPI2 l:dpi2 get dpi1+1
  if "#" subs port then
    sedit port port1 "GSUBS" "#" "^dpi1"
    sedit port port2 "GSUBS" "#" "^dpi2"
  else
    set s:port1 ^{port}^dpi1
    set s:port2 ^{port}^dpi2
  endif
  set l:side 1
else
  set aux0 gc.AUX0.v
  set s:port1 ^{port}
  set s:port2 ^{port}
  set l:side test(port,ends,2)+1
  if "|INP=1" subs flg then set l:side 1
  if "|INP=2" subs flg then set l:side 2
endif
if /pmfft then set l:fftcore side
if sdds istrue and gc.VLAN.v gt 0 sedit "IPVLAN=100|" flg "APPEND" flg
set l:nfsx nfft
if /tsp or /xyp then
  set l:nfs frame
  set l:nfft frame
elseif /tb or /mcs then
  set l:nfs frame
elseif frame lt 0 then
  set l:nfs -frame
else
  set l:nfs nfft
endif
if "TUNER" subs port or "TBANK" subs port or "CORE" subs port then
  calc drate rate 1e6 * dec /
  if /play then
    if /irate then calc drate rate 1e6 * 
    if ratio gt 0 then calc drate drate ratio /
  else
    if format eqss "C" and "CORE" nsubs port then calc drate drate/2
    if ratio gt 0 then 
      calc drate drate ratio *
      if RESAMP nsubs flg then sedit flg flg "APPEND" "|RESAMP"    ! includes PRESAMP
    endif
  endif
  if tbm eqs "MCS" or /mcs gt 0 then sedit flg flg "APPEND" "|MCS=^ntbc"
  if "PRER2C" subs flg then calc drate drate/2
  calc l:deci dec
else
  calc drate rate 1e6 *
  calc l:deci 1
endif
calc l:skip drate nfs / psdr / round 1 max
calc l:tbskip drate nfs / psdr/psda / round 1 max
calc l:nbskip drate/dec/2 nfsx/2 / psdr / round 1 max
calc l:wbskip rate*1e6 nfsx / psdr / round 1 max
calc dbaud gc.BAUD.v 1e6 *
calc dfreq freq 1e6 *
if "X" subs format calc scale 1e19
if "L" subs format calc scale 2G
if "I" subs format calc scale 32k
if "J" subs format calc scale 32k
if "B" subs format calc scale 128
if "N" subs format calc scale 8
if "P" subs format calc scale 1
switch "FIXSCALE" scale get scale
! now evaluate carets with as many current variables as possible
if "^" subs flg then iceutil "CARETS" flg flg
return

procedure picsetup
call picspecs
trap on setuperror y
! handle reset of card before CBUFSZ queries
if nic neqs "NONE" or card eqs "NONE" then
  set l:ctype 13
else
  if /noreset le 0 and clock neqs rclock 
    info "Resetting ^card ... "
    picd/flags=flg reset ^card 
    if /rereset le 0 res rclock clock
  endif
  picd get card "TYPE" ctype
  if /ovsr ge 0 then picd/flags=flg ovsr ^card ,, ^/ovsr
endif
call setRange
set gc.SCALE.action scale
if /tb or /mcs or /scan then
  res l:pps 4m
  res l:ntbc gc.NTBC.v
  res d:tbcs gc.TBCS.v
  picd/flags=flg get card "FTTM" fttm
  set gc.CHAN.max ntbc
  if tbcs lt 0 then
    calc tbcs drate 
    if fttm ge 2 calc tbcs drate*.8
    res gc.TBCS.v tbcs
  endif
  if /scan then set l:ntbc 1
else
  res l:pps 128k
  res l:ntbc 1
  res d:tbcs -1
endif
if reg.tdlp rexists and /nbp isfalse and /wbp isfalse and /tb le 0 and /mcs le 0 and /scan le 0
  calc xend frame nfft min drate /
  set reg.tdlp.setOuterLimits("X2") xend
endif
calc l:pps nfs*bpa*2*ntbc pps max
if /atl le 0 then
  ! ptl is in bytes
  if /tsp or /xyp or /tb or /mcs then 
    calc l:atl nfs*skip
  elseif ctype eq 5 or ctype eq 6 or ctype eq 7 or ctype eq 13 then
    calc l:atl 1M/bpa nfs / round nfs * ! guess at decent archive transfer length
  elseif /dual then
    picd/port=port1/flags=flg get card "CBUFSZ" ptl
    calc l:atl ptl/(bpa*nfs) round 1 max nfs *	
  else
    picd/port=port/flags=flg get card "CBUFSZ" ptl
    calc l:atl ptl/(bpa*nfs) round 1 max nfs *	
  endif
endif
if /skiponcard then
!  res l:atl nfs*ntbc
endif
set l:ptl atl*bpa	! ptl is in bytes
if gc.APKT.value eqs "ON" then
  set apkt "DET"
elseif gc.APKT.value eqs "OFF" then
  set apkt "NOTPRESENT"
else
  set apkt gc.APKT.value
endif
if apkt eqss "SDDS" then
  set flg "^flg|UOPT"
  calc l:ptl ptl*1088/1024
endif
if /scan or /mcs or tbm eqs "MSP" or tbm eqs "MCS" then
  set pkt "ICET"
elseif /netmon pexists then
  set pkt "ICE"
else
  set pkt "NOTPRESENT"
endif
if tbm eqs "MSP" then
  set msps 1
  if port ends "2"
    sedit port port "TRIM" "" "2"
    set msps 2
  elseif port ends "1"
    sedit port port "TRIM" "" "1"
  endif
endif
switch "EXACT" exact get 0
set csw "round=ptl/multi=^ntbc"
if exact gt 0 then
  set filesize exact 
  set csw "^csw/exact"
elseif /skiponcard then
  calc filesize drate*length/skip round
elseif /ramoncard then
  calc filesize drate*length power2
  calc l:csize filesize*bpa 1k /
  sedit flg flg "APPEND" "|CSIZE=^csize"
else
  calc filesize drate*length round
endif
switch "STAG" stag get -1
if stag gt 0 then
  set csw "^csw/exact/stag=^stag"
endif
if filesAreOk eq 2 and afn eqs "NULL" and wave neqs "NULL" 
  set l:filesAreOk 0	! need new wave after archive
endif
if filesAreOk and afn eqs "NULL" then
  ! they are still good from last time
elseif wave eqs "FILE" then
  ! they are from last dearchive
elseif nic neqs "NONE" and card neqss "NIC" then
  ! there are no ram files for NICs
elseif tbm eqs "MSP" then
  do nn 1 ntbc
    calc l:ii nn-1 2 * msps + nn (/autoss) ?:
    set ramfilexn "^{card}_^{port}^ii"
    if config.mcdeci rexists then
      calc drate rate 1e6 * config.mcdeci(nn-1) /
      calc filesize drate*length round
    endif
    picd/round=ptl create ramfilexn ^format filesize drate 
    call add2list ramfilexn
  enddo
elseif /dual then
  call cleanlist
  if ramfile1 rexists erase/warn=off ramfile1 ramfile2
  switch "RAMFILE1" ramfile1 get "^{card}_^{port1}"
  switch "RAMFILE2" ramfile2 get "^{card}_^{port2}"
  call add2list ramfile1
  call add2list ramfile2
  if "RAMFILE" pexists and /play then
  elseif wave eqs "NONE"
    picd/^csw create ramfile1 ^format filesize drate
    picd/^csw create ramfile2 ^format filesize drate
  else
    info "Generating waveforms ..."
    pic/^csw create ramfile1 ^format filesize drate ^wave ^gain ^dfreq ^dbaud
    pic/^csw create ramfile2 ^format filesize drate ^wave ^gain ^dfreq ^dbaud
  endif
else
  call cleanlist
  switch "RAMFILE" ramfile get "^{card}_^{port}"
  call add2list ramfile
  if "/RAMFILE" pexists and /play then
  elseif wave eqs "NONE"
    picd/^csw create ramfile ^format filesize drate 
  else
    info "Generating waveform ..."
    pic/^csw create ramfile ^format filesize drate ^wave ^gain ^dfreq ^dbaud
  endif
endif
if /nbp then
  switch "NBPN" tport get "TUNER^side"
  res ramfilet "^{card}_^{tport}"
  switch "NBPF" nbpf get "CI"
  picd/round=nfsx*bpa create ramfilet nbpf filesize/dec/2 drate/dec/2 
  call add2list ramfilet
elseif /wbp then
  if /skiponcore then
    switch "WBPN" tport get "PM0CORE^side"
  else
    switch "WBPN" tport get "MODULE^side"
  endif
  if /skiponcard eq 0 then
    set filesizet 0.5*rate*1e6
  else
    set filesizet psdr*nfsx
  endif
  res ramfilet "^{card}_^{tport}"
  set wbpf "SI"
  picd get card "MBITS" mbits
  if mbits lt 0 then set wbpf "CI"
  switch "WBPF" wbpf get wbpf
  picd/round=nfsx*bpa create ramfilet wbpf filesizet rate*1e6 
  call add2list ramfilet
  if /dual then
    sedit tport tport2 "SUBS" "1" "2"
    res ramfilet2 "^{card}_^{tport2}"
    picd/round=nfsx*bpa create ramfilet2 wbpf filesizet rate*1e6 
    call add2list ramfilet2
  endif
elseif fftcore gt 0 then
  switch "FFTPEAKS" ntop get 0
  calc l:nfsc  nfft nfft/2 test(format,eqss,c) ?: ntop*2 +
  res cport "CORE^fftcore"
  res ramfilec "^{card}_CORE^fftcore"
  picd/round=nfsc*4 create ramfilec "SL" dspr*nfsc*length drate
  call add2list ramfilec
endif
if nic neqs "NONE" and gc.NPKT rexists then
  if gc.NPKT.v eqs "SDDS" or gc.NPKT.v eqs "VRTW" or gc.NPKT.v eqs "VRTX" then
    set drep "IEEE"
  else
    set drep "EEEI"
  endif
  if /play then
    status ramfile DATAREP=fdrep
    if fdrep neqs drep then
      noop ramfile ramfile{AUX=ENV.RAMAUX,DET=1,CTG=1,DATAREP=drep}
    endif
  else
    if /dual then
      headermod ramfile1 DATAREP=drep
      headermod ramfile2 DATAREP=drep
    else
      headermod ramfile DATAREP=drep
    endif
  endif
endif
if /dual then
  call preparch "RAMFILE1" "ARCHFILE1" ^{AFN}_1 ^AUX1
  call preparch "RAMFILE2" "ARCHFILE2" ^{AFN}_2 ^AUX2
else
  call preparch "RAMFILE" "ARCHFILE" ^{AFN} ^AUX0
endif
if ans eqss "LEAVE" then
  set gc.MODE.value "RTMEM"
elseif ans eqs "ABORT" then
  set gc.MODE.value "SETUP"
  return
endif
if afn neqs "NULL"
  set l:filesAreOk 2
else
  set l:filesAreOk 1
endif
if config.extsetup rexists then
 run config.extsetup
endif

pipe init	! move back to pipe initialization mode
trap on initerror y

if /dual then
  set flg1 flg
  set flg2 flg
  if config.flags1 rexists sedit config.flags1 flg1 "APPEND" "|" "APPEND" flg
  if config.flags2 rexists sedit config.flags2 flg2 "APPEND" "|" "APPEND" flg
  if "MTGO" subs flg then ! want to leave the MTGO on both ports
    set slv "NS"
  else
    sedit flg2 flg2 "GSUB" "TGO" "TGON" "GSUB" "SGO" "SGON"
    set slv "DEF"
  endif
  if /play then
    sinkpic/id=sp archfile1 ramfile1{fs=nfs} card deci dfreq gain /mon=_cb1{ps=pps} /archtl=atl /master=sps &
      /tl=1 /port=port1 /flags=flg1 /skip=skip /replay=0 /tc=cpu /delay=dly /wrap=wrp /monitor=monm /nchn=ntbc
    sinkpic/id=sps archfile2 ramfile2{fs=nfs} card deci dfreq gain /mon=_cb2{ps=pps} /archtl=atl /slave=slv &
      /tl=1 /port=port2 /flags=flg2 /skip=skip /replay=0 /tc=cpu /delay=dly /wrap=wrp /monitor=monm /nchn=ntbc
  else
    sourcepic/id=sp ramfile1{fs=nfs} _cb1{ps=pps} card deci dfreq gain /master=sps &
      /tl=1 /port=port1 /flags=flg1 /skip=skip /replay=0 /flush /tc=cpu /monitor=monm &
      /arch=archfile1 /archtl=atl /apacket=^apkt /packet=^pkt /nchn=ntbc /dfreq=tbcs /multi=mult
    sourcepic/id=sps ramfile2{fs=nfs} _cb2{ps=pps} card deci dfreq gain /slave=slv &
      /tl=1 /port=port2 /flags=flg2 /skip=skip /replay=0 /flush /tc=cpu /monitor=monm &
      /arch=archfile2 /archtl=atl /apacket=^apkt /packet=^pkt /nchn=ntbc /dfreq=tbcs /multi=mult
  endif
  if /tsp or /xyp then 
  elseif /tb and /cross then
    thin/id=thin1 _cb1 _cb1c 0 -1 ntbc
    thin/id=thin2 _cb2 _cb2c 0 -1 ntbc
    fft/id=fft/psd/log _cb1c _cb1f{form=s^ofb} nfft wind 0 psda _cb2c _cb2f{form=s^ofb} _cbxf{form=s^ofb}
  elseif /tb isfalse and /mcs isfalse then
    fft/id=fft/psd/log _cb1 _cb1f{form=s^ofb} nfft wind 0 psda _cb2 _cb2f{form=s^ofb} _cbxf{form=s^ofb} /cmag
  endif
  if config.core1 rexists run config.core1
  if config.core2 rexists run config.core2

elseif nic neqs "NONE" and card neqss "NIC" then
  if /play then
    sinkice/id=sp archfile ramfile{fs=nfs} _cb{ps=pps} &
      /tl=1 /skip=skip /replay=0 /tc=cpu /wrap=wrp /monitor=monm
  else
    sourceice/id=sp/native "udp:^nic:^gc.SOCK.v/^gc.ADDR.v:^gc.SOCK.v" _cb{ps=pps} format drate &
      /skip=skip /replay=0 /tc=cpu /frame=nfs /monitor=monm /arch="^archfile"
  endif
  if /tsp isfalse and /xyp isfalse then
    fft/id=fft/psd/log _cb _cbf{form=s^ofb} nfft wind 0 psda
  endif

elseif card eqs "NONE" then
  if /play then

  else
    sourcefile/id=sp ramfile{fs=nfs} _cb{ps=pps} 0 -1 skip /tl=1 /replay=0 
  endif
  if /tsp isfalse and /xyp isfalse then
    fft/id=fft/psd/log _cb _cbf{form=s^ofb} nfft wind 0 psda
  endif

else
  if /rtplay then
    if gc.MODE.v eqss "RTP" then
      noop/id=rtp/rt/wrap=wrp/tl=32k archfile _arch{ps=4m} /poll=.001
    else
      waveform/id=rtp/rt/tl=32k _arch{ps=4m} format inf wave calc(2,gain/6,**,scale,*) dfreq 0 0 1/drate /poll=.001
    endif
    sinkpic/id=sp _arch ramfile{fs=nfs} card deci dfreq gain /mon=_cb{ps=pps} /archtl=atl /poll=.001 &
      /tl=1 /port=port /flags=^flg|ncclk /skip=skip /replay=0 /flush /tc=cpu /throttle=ondemand
  elseif /play then
    sinkpic/id=sp archfile ramfile{fs=nfs} card deci dfreq gain /mon=_cb{ps=pps} /archtl=atl &
      /tl=1 /port=port /flags=flg /skip=skip /replay=0 /flush /tc=cpu /delay=dly /wrap=wrp /monitor=monm /nchn=ntbc
  elseif tbm eqs "MSP" then
    switch "MSPPS" mspps get 1m
    do nn 1 ntbc
      calc l:ii nn-1 2 * msps + nn (/autoss) ?:
      set ramfilexn "^{card}_^{port}^ii"
      set flgt flg
      if /wbp istrue or nn gt 2 then set flgt "RGO|^flgt"
      if config.mcdeci rexists then 
	set l:deci config.mcdeci(nn-1)
	calc drate rate 1e6 * deci /
	calc l:tbskip drate nfs / psdr/psda / round 1 max
      endif
      sourcepic/id=sp^nn/replay=0 ramfilexn _cb^nn{ps=mspps} card deci (nn-1)*tbcs+dfreq gain &
        /tl=frame /port=^{port}^ii /flags=^flgt /skip=tbskip /packet=^pkt 
    enddo
    set reg.sp reg.sp1
    set psw test("SWAP2",subs,flg)	! swap back for display
    picfanin/renum/skip=1/sp=reg.sp/arch="^archfile"/swap=^psw _cb{ps=256k} _cb ntbc
  else
    sourcepic/id=sp ramfile{fs=nfs} _cb{ps=pps} card deci dfreq gain &
      /tl=1 /port=port /flags=flg /skip=skip /replay=0 /flush /tc=cpu /monitor=monm &
      /arch=archfile /archtl=atl /apacket=^apkt /packet=^pkt /nchn=ntbc /dfreq=tbcs /multi=mult
  endif
  if /tsp or /xyp or /tb or /mcs then
  elseif fftcore gt 0 then			! full FFTs computed on FPGA
    calc l:mbits -8 -16 test(format,eqs,CB) ?:
    calc d:xsoff -.5*drate 0 test(format,eqss,c) ?:
    calc l:psdm drate/nfft psda / psdr / round 1 max 4K min
    calc l:fskip psdr/dspr round 1 max 
    calc d:fdelta nfft/drate psda * psdm * fskip *
    set gc.PSDM.v psdm
    switch "FFTTHRESH" d:thresh get 2.0
    if ntop gt 0
      set flgf "FFT=(NFFT=^nfft,NMAX=^psdm,NAVG=^psda,NTOP=^ntop,NWIN=8,THRESH=^thresh,FLAGS=(MAG|PKP),WIND=hann)"
    else
      set flgf "FFT=(NFFT=^nfft,NMAX=^psdm,NAVG=^psda,FLAGS=(MAG),WIND=hann)"
    endif
    sourcepic/id=spc ramfilec{fs=nfsc} _cbc{xu=3,xs=xsoff,xd=drate/nfft,yd=fdelta} card 1 0 0 /skiponhost &
      /tl=1 /port=cport /skip=fskip /replay=0 /stats=0 /flags=^flg|RGO|BLOCK=8k|IPORT=^port|^flgf|MBITS=^mbits
    calc d:scl 1/(1k)
    icecore/id=svi/core=j _cbc _cbf "FSVI" frame=nfsc nexp=nexp scale=scl flags=0x3 /ifmt=SL /ofmt=SF /tl=nfft*4
    if /pmfft then
      set l:psdsize psdr*length
      set psdfile ^{card}_PSD^{side}F
      call add2list psdfile
      sinkice/id=psdf/sink=rtfile/pt=none/maxout=psdsize/tl=1/tc=cpu _cbf psdfile{AUX=^ENV.RAMAUX}
    endif
  else
    fft/id=fft/psd/log _cb _cbf{form=s^ofb} nfft wind 0 psda
  endif
  if config.core rexists run config.core
endif

if /netmon pexists then ! output TD plot data to net stream
  sinkice/tl=nfft/tc=cpu _cb{fs=0} ^/netmon
endif

if ratio gt 0 and "CORE" subs port then
  icecore/id=icr/core=icex ,,, WBR;ICE D:RATIO=^ratio L:NTAP=32 L:GAIN=0 F:FWF=0.95 /ifmt=ci /ofmt=ci /coredev=^card:^port
endif

if /scan then
  set rfd gc.tbcs.v*1e-6
  invoke reg.sp.setScan(gc.NTBC.v,gc.rffreq.v,rfd,gc.DWELL.v)
endif

if /nbp then
  sourcepic/id=spn ramfilet{fs=nfsx} _cbn card dec dfreq gain &
    /tl=1 /port=tport /flags=RGO|^flg /skip=nbskip /replay=0 /stats=10 /autors=2 
  fft/id=fftn/psd/log _cbn _cbnf{form=s^ofb} nfsx wind 0 psda
endif

if /wbp then
  set flgt  "RGO|^flg"
  if tbm eqs "MSP" then set flgt flg
  sedit flgt flgt "PREPEND" "HXFD|BLOCK=8K|" 
  sedit flgt flgt "GSUBS" "NIO" "XNIO"
  sedit gc.WAFNAME.v aftn "APPEND" "{^gc.WAFQUAL.v}"
  if gc.WAFNAME.v eqs "" or gc.WAFNAME.v eqs "NULL" or "ARCH" nsubs gc.MODE.v then set aftn "NULL"
  if "CORE" subs tport then
    sourcepic/id=spw ramfilet{fs=nfsx} _cbw card 1 dfreq gain &
    /tl=1 /port=tport /flags=^flgt|CORE=(FRAME=^nfsx,DEC=^wbskip) /skip=1 /replay=0 /stats=10 /autors=2 /arch="^aftn" /archtl=nfsx /apacket=^apkt
  else
    sourcepic/id=spw ramfilet{fs=nfsx} _cbw card 1 dfreq gain &
    /tl=1 /port=tport /flags=^flgt /skip=wbskip /skiponcard /replay=0 /stats=10 /autors=2 /arch="^aftn" /archtl=nfsx /apacket=^apkt
  endif
  fft/id=fftw/psd/log _cbw _cbwf{form=s^ofb} nfsx wind 0 psda
  if /dual then
    sourcepic/id=spn ramfilet2{fs=nfsx} _cbn card 1 dfreq gain &
    /tl=1 /port=tport2 /flags=^flgt /skip=wbskip /skiponcard /replay=0 /stats=10 /autors=2 /arch="^aftn" /archtl=nfsx /apacket=^apkt
    fft/id=fftn/psd/log _cbn _cbnf{form=s^ofb} nfsx wind 0 psda
  endif
endif

if /tivo gt 0 then
  res nflags "FLUSH"
  if gc.AOVER.v eqs "APPEND" res nflags "^nflags|APPEND"
  noop/tl=1/id=tvn _cbf ^{gc.AFNAME.v}_psd{FLAGS=^nflags,DET=1,CFL=cfl}
endif

if /rtppsd neqs "NULL" then
  sinkdg/id=rtppsd/rtp/hostport=^/rtppsd _cbf
endif

if /dump then
  thin _cb snapdump 0 -0 100
endif

if reg.fft rexists set reg.fft.nexp nexp
if reg.fftn rexists set reg.fftn.nexp nexp
if reg.fftw rexists set reg.fftw.nexp nexp

label trappedinit
pipe run	! move into pipe run mode
label trappedsetup
trap off
if config nisnull and config.setup rexists then		! run startup commands
  foreach item inlist config.setup
    run config.^item
  endfor
endif
return

label setuperror
say "Got setup error: ^emsg.data"
goto trappedsetup
return

label initerror
say "Got init error: ^emsg.data"
pause 1
goto trappedinit
return

procedure picstart s:replay
if /server gt 0
  message send "RMIF" ,, "ACK" ,, {SCALE=^scale,MODE=^gc.MODE.v}
endif
if reg.sp nrexists then
  set gc.MODE.v "SETUP"
  return
endif
!pause 0.25 	! wait for plotters to reconnect
if sdds or nic neqs "NONE" then
  set reg.sp.ipvlan gc.VLAN.v
  set reg.sp.ipconn gc.ADDR.v
  set reg.sp.ipsock gc.SOCK.v
  if reg.sps rexists
    set reg.sps.ipvlan gc.VLAN.v
    set reg.sps.ipconn gc.ADDR.v
    set reg.sps.ipsock gc.SOCK.v
  endif
endif
if  card neqs "NONE" and rcvr neqs "NONE" and gc.RCVR.v neqs "HIDDEN" 
  if gc.RFFREQ.show then call updateRfFreq gc.RFFREQ.v
  if gc.RFBW.show   then call updateRfBw  ^gc.RFBW.v
  if gc.RFATTN.show then call updateRfAttn gc.RFATTN.v
  if gc.RFGAIN.show then call updateRfGain gc.RFGAIN.v
  if gc.RFOPTS.show then call updateRfOpts gc.RFOPTS.v
endif
if gc.MGAIN.show and gc.GAIN.show then
  if reg.sp rexists set reg.sp.MGAIN gc.MGAIN.value
  if reg.sps rexists set reg.sps.MGAIN gc.MGAIN.value
endif
if gc.NFGAIN rexists then
  if reg.sp rexists set reg.sp.nfgain gc.NFGAIN.value
endif
if agc neqs "NONE" then 
  call setAGC
endif
if /play and reg.sp rexists then
  if gc.ATCL.max gt 0 set reg.sp.archDur gc.ATCL.max
  if gc.ATCT.v   gt 0 set reg.sp.archTop gc.ATCT.v
endif
if /mtoff pexists then 
  set reg.sp.mtoff gc.MTOFF.v
endif
if gc.RFRATE.show then
  set gc.RFRATE.v reg.sp.RFBW
endif
if config nisnull and config.startup rexists then		! run startup commands
  foreach item inlist config.startup
    run config.^item
  endfor
endif
call picreplay replay
call updateFreqMarker
return

procedure picreplay s:replay
if replay eqs "ONE" and /oneshots gt 1 then
  set l:replay -(/oneshots)
endif
if reg.spn rexists set reg.spn.replay replay
if reg.spw rexists set reg.spw.replay replay
if reg.spc rexists set reg.spc.replay replay
if reg.sp  rexists set reg.sp.replay replay
if tbm eqs "MSP" then
  if replay eqs "ABORT" then
    set mreplay replay
  else
    switch "MSPREPLAY" mreplay get "^replay"
  endif
  do nn 1 ntbc
    if reg.sp^nn rexists set reg.sp^{nn}.replay mreplay
  enddo
endif
return

procedure picwait l:count
if card eqs "NONE" return
if /play then return
while reg.sp rexists and reg.sp.dmamode eq 0 and count gt 0
  pause 0.1
  set l:count count-1
endwhile
return

procedure picstop 
set spfn reg.sp.archfn
call picreplay "ABORT"
if tbm eqs "MSP" then
  if reg.picfanin rexists then reg "FINISH" picfanin 
  rem reg.sp	! this is aliased to SPT or SPX1
endif
if reg.tvn rexists reg "FINISH" "TVN"
if reg.rtp rexists reg "FINISH" "RTP"
set l:count 300 ! 30 second timeout
while count gt 0 and reg.sp rexists or reg.spn rexists or reg.spw rexists 
  pause 0.1
  set l:count count-1
  if calc(count,10,mod) eq 0 warning "Waiting for card stop or archive flush"
endwhile
if spfn neqs "NULL" call keyarchive ^spfn
if count le 0 warning "Problem stopping cards or flushing archive"
return

procedure doneArchiving l:damode
if damode lt 0 then
  if /dual then
    call add2list ramfile1
    call add2list ramfile2
    set ramfilen ramfile1
  else
    call add2list ramfile
    set ramfilen ramfile
  endif
  if port eqss "MOD" then
    calc d:rate 1 file(ramfilen).xd / round 1e-6 *
    set gc.RATE.v ^rate
    call setrate
    set gc.LENGTH.v file(ramfilen).length
  endif
  set gc.MODE.v "SETUP"
  set gc.WAVE.v "File"
  set l:filesAreOk 1
  info "Finished dearchiving"
elseif lafn isnull then
elseif damode eq 1
  call unpackarchive ^{lafn}{AUX=^AUX0}
  call keyarchive ^{lafn}{AUX=^AUX0}
elseif damode eq 2 
  call unpackarchive ^{lafn}_1{AUX=^AUX1}
  call unpackarchive ^{lafn}_2{AUX=^AUX2}
  call keyarchive ^{lafn}_1{AUX=^AUX1}
  call keyarchive ^{lafn}_2{AUX=^AUX2}
endif
set gc.AMODE.v "DISK"
if donearchmode nrexists then set donearchmode "SETUP"
if gc.MODE.v neqs donearchmode set gc.MODE.action donearchmode
remove donearchmode
set l:archiving 0
return

procedure unpackarchive s:unpafn
if /autounpack isfalse return
file rename/f unpafn temp_unpack
icecopy temp_unpack ^unpafn /unpack=12 /gpw
return

procedure keyarchive s:keyafn
if gc.APKT.v eqs "SDDS" then key keyafn put "PACKET" "SDDS/ICE" /scope=main
if /autokey isfalse return
foreach key intable config
  key keyafn add "^key" ^gc.^{key}.value
endfor
return

procedure picrestart l:nofilex
if /play isfalse or nofilex le 0 then set l:filesAreOk 0
if gc.MODE.value neqss "RT" then
  call picspecs
else
  call picstop
  call picsetup
  call picstart "CONT"
endif
if lsystab rexists call picsystem lsystab
return 

procedure setport
set port gc.PORT.value 
! check for tuner (non-Module) config widgets
set show test(port,neqss,"MODULE",and,port,neqss,"STREAM")
set gc.FREQ.show show
set gc.FBW.show show
set gc.DEC.show show
set gc.GAIN.show show
! check for module specific features
if nic neqss "NONE" or gc.CARD.v eqs "NONE" or port eqss "STREAM" then
  set gc.CLOCK.v "N"
  set gc.CLOCK.show 0
elseif /client isfalse
  set gc.CLOCK.show 1
endif
set gc.RATE.items rates
set gc.FORMAT.items formats

set iomtbl "default"
set t:tbl {KEYS=NONE,CONTROLS={}}
if nic eqs "NONE" and "IOC=" nsubs flags and /client isFalse then
 if gc.PORT.v neqs "STR" then
  picd/port=port/flags=flg/stat=stat get gc.CARD.v "NAME" iomtbl
  if stat lt 0 sedit hwalias.^gc.CARD.v iomtbl trim "IOM1=" ","
  sedit iomtbl iomtbl "LOCASE"
 endif
endif
switch "IOMTBL" iomtbl get iomtbl
fname iomfn tbl/iom iomtbl tbl ice
if iomfn fexists set t:tbl iomfn
if xcvr nisnull then
  sedit xcvr xmodel "TRIM" "" "-" "LOCASE"
  fname iomfn tbl/iom xmodel tbl ice
  if iomfn fexists then
    set t:tblx iomfn
    sedit tbl.keys tbl.keys "APPEND" tblx.keys "SUBS" ")(" "," 
    table tbl.controls MERGE tbl.controls tblx.controls
  endif
endif
if rcvr eqs "ALL" then
elseif port eqss "STREAM" or /loopback then
  set gc.RCVR.action "HIDDEN"
elseif rcvr neqs "NONE" and "RF" subs tbl.keys then
  if gc.RCVR.v eqs "HIDDEN" set gc.RCVR.action "CLOSED"
  foreach key inlist "RFRATE,RFFREQ,RFGAIN,RFATTN,RFBW,RFPWR,RFOPTS"
    if "RFEXPERT" subs flags then
      set gc.^{key}.show 1
    elseif key nsubs tbl.keys then 
      set gc.^{key}.show 0
    elseif key subs flags and rcvr eqs "AUTO"
      say "Disabling ^key graphical control as ^key is set in flags string"
      set gc.^{key}.show 0
    else
      set gc.^{key}.show 1
    endif
  endfor
elseif rcvr eqs "AUTO" 
  set gc.RCVR.action "HIDDEN"
elseif rcvr eqs "NONE" 
  set gc.RCVR.action "HIDDEN"
endif
if gc.RCVR.v eqs "HIDDEN" then
  set gc.RFFREQ.v 0
endif
if "MGAIN" subs tbl.keys then
  set gc.MGAIN.show 1
else
  set gc.MGAIN.show 0
endif
set t:tbl tbl.controls
foreach key intable tbl
  if gc.^key nrexists continue
  if key eqs "FORMAT" and port neqss "MOD" continue
  !iceutil setKeys gc.^key tbl.^key
  set t:tbl2 tbl.^key
  foreach key2 intable tbl2
    set gc.^{key}.^key2 "^tbl2.^key2"
  endfor
endfor
return

procedure setpbs
if /play and "TUNER" nsubs gc.PORT.v and "CORE" nsubs gc.PORT.v then
  set gc.FREQ.show test(gc.WAVE.v,neqs,NONE)
  set gc.GAIN.show test(gc.WAVE.v,neqs,NONE)
  set gc.BAUD.show test(gc.WAVE.getItemIndex,ge,icw+1)	! MENU is {None,^shapes}
else
  set gc.BAUD.show 0
endif
return

procedure setdec
calc l:bw gc.RATE.v*1e3/2 gc.DEC.v /
set gc.DEC.units "~ ^{bw} kHz"
invoke gc.DEC.refresh
return

procedure setrate
set gc.FREQ.min -.5*gc.RATE.v
set gc.FREQ.max gc.RATE.v
return

procedure preparch u:ramtag u:archtag cs:archname u:auxi
set afqual gc.AFQUAL.v
set ^archtag "NULL"
set ans "NULL"
if /play then set ^archtag ^ramtag
set atfn "^{archname}{AUX=^auxi}"
set atfn_toc "^{archname}_toc"
if afn eqs "NULL" return
if "udp:" subs afn or "stp:" subs afn then
 sedit afn afn sub "##|" ""
 if afqual neqs "" or cfl gt 0 then 
   set ^archtag "^{afn}{CFL=cfl,^afqual}"
 else
   set ^archtag afn
 endif
 set afn "NULL"
 if apkt eqs "DET" then
   set apkt "ICET/DET"
 elseif apkt eqs "NOTPRESENT" or apkt eqs "" then
   set apkt "ICET"
 endif
 return
endif
if /play then
  res ^archtag "^{archname}{AUX=^auxi,^afqual}"
else
  if atfn fexists or atfn_toc fexists then
    switch "OVERLAY" ans get gc.AOVER.value
    if ans eqs "ASK" then
      sedit gc.AOVER.items ans "TRIM" "Ask,"
      gc/tmp/wait menu ans "File: ^atfn exists ..." "^ans" "Leave" /tleft
    endif
  else
    set ans "NEW"
  endif
  set l:det ^gc.HDR.item-1
  res nflags ""
  if cfl gt 0 res nflags "^nflags|+FLUSH"
  if ans eqs "APPEND" res nflags "^nflags|+APPEND"
  if ans eqss "LEAVE" then
    set afn "NULL"
    set gc.MODE.value "RTMEM"
  elseif ans eqs "ABORT" then
    set afn "NULL"
    set gc.MODE.value "SETUP"
  else
    if ans eqs "ERASE" erase/verbose atfn
  endif
  if /archsf gt 0 and "APPEND" nsubs nflags then res nflags "^nflags|+APPEND"
  set ^archtag "^{archname}{AUX=^auxi,DET=^det,CFL=^cfl,FLAGS=^nflags,^afqual}"
endif
return

procedure picsystem t:systab
if systab "ISNULL" then return
set maxbytes 16T
foreach item inlist "AUX0,AUX1,AUX2"
 if gc contains "^item"
  res itemi gc.^{item}.value
  if systab contains "DISK_^itemi" and systab.DISK_^itemi "NISNULL"
    set gc.^{item}U.value systab.DISK_^{itemi}.used
    calc maxbytes systab.DISK_^{itemi}.FMBY*1e6 maxbytes min
  else
    set gc.^{item}U.value -1
  endif
 endif
endfor
if maxbytes neq 16T
  calc gc.ATCA.v maxbytes drate*bpa /
endif
if /dual then
  calc l:gc.AUXU.value gc.AUX1U.value gc.AUX2U.value max
else
  res l:gc.AUXU.value gc.AUX0U.value 
endif
if gc.MODE.value eqs "RTARCHIVE" and /play isfalse then
 if gc.AUXU.value gt gc.FULL.value
  set gc.MODE.action "SETUP"
  warning "Disk is ^{gc.AUXU.value}% full.  Stopped archive."
  gc/temp/timeout=2/handle=gcalert alert ,,, "Disk is ^{gc.AUXU.value}% full.  Stopped archive."
 endif
 if gc.MAXFS.value gt 0 and afn neqs "NULL" and /client isFalse and afn fexists and file(afn).datasize gt gc.MAXFS.value
  set gc.MODE.action "SETUP"
  warning "Max File Size of ^gc.MAXFS.value bytes reached.  Stopped archive."
  ! gc/temp/timeout=2/handle=gcalert alert ,,, "Max File Size of ^gc.MAXFS.value bytes reached.  Stopped archive."
 endif
endif
set lsystab systab
return

procedure refreshTivoPlot
if tvfn nrexists then
  set tvfn "^{gc.AFNAME.v}_psd.tmp"
  if /client gt 0 set tvfn "http://^remote/Files/^tvfn"
  message send "TVRP" ,, "OPENFILE" -1 tvfn
endif
message send "TVRP" ,, "UNZOOM" -1
if gc.TIVOM.v eqs "RT" then
  message send "TVRP" ,, "FILE" ,, "REREAD" 
  if gc.TIVOL.v eqs "ALL" then
    message send "TVRP" ,, "PANTW" 0 (0,0)
  else
    set d:tvl ^gc.TIVOL.v
    set gc.TIVOS.v gc.TIME.v
    set d:tvs gc.TIVOS.v 
    message send "TVRP" ,, "PANTW" 0 (tvs,-tvl)
  endif
else
  set d:tvl ^gc.TIVOL.v 
  set d:tvs gc.TIVOS.v 
  message send "TVRP" ,, "PANTW" 0 (tvs,-tvl)
endif
return

procedure updateFreqMarker l:upd[0] d:xoff
if ff nrexists return
if port eqss "MODULE" or /wbp then
  if upd ge 0 then set ff.x 1e6*gc.FREQ.v
endif
if tbm eqs "MSP" and gc.CHAN.v gt 0 then
  set rsp reg.sp^{gc.CHAN.v}
  set ff.dx rsp.RATE/2/rsp.DEC
else
  set ff.dx 1e6*gc.RATE.v/2/gc.DEC.v
endif
if /marker then
  calc ftmp ff.x xoff + 1e-6 *
  if /wbp then
  elseif "TUNER" subs port or "TBANK" subs port then 
    calc ftmp ftmp gc.FREQ.v +
    if "S" eqss format then calc ftmp ftmp 0.25*drate 1e-6 * -
  endif
  if reg.sp rexists then calc ftmp ftmp reg.sp.mfreq 1e-6 * +
  if /freqadj neq -1 then calc ftmp ftmp ^/freqadj 1e-6 * +
  calc gc.QFREQ.v ftmp gc.RFFREQ.v +
endif
return

procedure updateScale
set d:scale gc.SCALE.v
if reg.tdlp rexists and /nbp isfalse and /wbp isfalse and /tb le 0 and /mcs le 0 and /scan le 0 then
 set reg.tdlp.y1 -scale
 set reg.tdlp.y2 scale
endif
return

procedure updateArchive s:fn
if reg.sp rexists and reg.sp.replay eqss "CONT" then
  set gc.ATCL.max reg.sp.archDur
  set gc.ATCL.v   reg.sp.archOff
  set gc.ATCT.v   reg.sp.archTop
elseif afn fexists and /play isfalse then
  status fn timeAt(0)=gc.ATCT.v len=gc.ATCL.max
endif
if /server gt 0 then message send rmif ,, "ACK" ,, {ATCT=^gc.ATCT.v,ATCL=^gc.ATCL.v}
return

procedure updateRfFreq d:rffreq
if /freqmod gt 0 then
  calc fsamp gc.RATE.v (/freqmod) *
  calc fgran fsamp 256 /
  calc rffreq rffreq fgran / round fgran *
  set gc.RFFREQ.v rffreq
  ! calc rffreq rffreq fsamp mod
endif
if /rffreqoff ne -1 then
  calc rffreq rffreq (/rffreqoff) -
endif
if rcvr eqs "NONE" then return
if reg.sp  rexists set reg.sp.rffreq rffreq
switch "RFFREQ2" rffreq get rffreq
if reg.sps rexists set reg.sps.rffreq rffreq
return

procedure updateRfBw d:rfbw
if rcvr eqs "NONE" then return
if reg.sp  rexists set reg.sp.rfbw rfbw
if reg.sps rexists set reg.sps.rfbw rfbw
return

procedure updateRfAttn l:rfattn
if rcvr eqs "NONE" then return
if reg.sp  rexists set reg.sp.rfattn rfattn
if reg.sps rexists set reg.sps.rfattn rfattn
return

procedure updateRfGain l:rfgain
if rcvr eqs "NONE" then return
if reg.sp  rexists set reg.sp.rfgain rfgain
if reg.sps rexists set reg.sps.rfgain rfgain
return

procedure updateRfOpts s:rfopts
set l:rfopti gc.RFOPTS.ii	! need numeric version from getItemIndex()
if rcvr eqs "NONE" then return
if rfopti eq 0 then
  picd/flags=flg/port=port get card "RFOPTS" s:gc.RFOPTS.value /hex
else
  if reg.sp  rexists set reg.sp.rfopts rfopti
  if reg.sps rexists set reg.sps.rfopts rfopti
endif
return

procedure picfstats s:sid
if logfn eqs "OFF" return
pic fstats/p "^logfn" "^sid"
return

procedure picgstats s:sid
if gc.AMODE.v eqs "DISK" and "RXIPGDBG" subs flg then
  icetc extract "SDDS" alfn snaptc /gap /quiet
  view/bg snaptc
  plot/bg snaptc /layer={lt="Multi",columns=GAP} y1=0
else
  if logfn eqs "OFF" return
  pic fstats "^logfn" "^sid" /gap
  plot/bg/id=aplot/all ^{logfn}_gstat y1=0 
endif
return

procedure analyze s:atype cs:afile cs:tmpfile
info "Processing ^atype on file ^afile"
if atype eqs "HISTOGRAM"
  histogram/gpr=gc.APGR.v afile{fs=0} tmpfile -scale +scale 1
  plot/bg/id=aplot/all tmpfile 
elseif atype eqs "BITSTATS"
  iceutil MBTST afile{fs=0}
elseif atype eqs "LSBIT"
  status afile form=fmt
  if fmt eqss "C"
    fcalc/type=l/gpr=gc.APGR.v ^tmpfile afile{fs=0} real 0x1 band
  else
    fcalc/type=l/gpr=gc.APGR.v ^tmpfile afile{fs=0} 0x1 band
  endif
  plot/bg/id=aplot/all ^tmpfile y1=-.2 y2=1.2
elseif atype eqs "TD-LINE"
  plot/bg/id=aplot/all afile{fs=0} y1=-scale y2=scale
elseif atype eqs "TD-RASTER"
  plot/bg/id=aplot/all afile{fs=gc.FRAME.v z1=-scale z2=scale
elseif atype eqs "FD-LINE"
  fft/psd/log/gpr=gc.APGR.v afile{fs=0} tmpfile ^gc.AFFT.v navg=-1
  plot/bg/id=aplot tmpfile 
elseif atype eqs "FD-RASTER"
  fft/psd/log/gpr=gc.APGR.v afile{fs=0} tmpfile ^gc.AFFT.v navg=psda over=-8
  plot/bg/id=aplot/all tmpfile z2=fscale z1=fscale-frange
elseif atype eqs "TD-PHASE"
  plot/bg/id=aplot afile{fs=0} cm=phase y1=-180 y2=180 /all
endif
return

procedure addToSet t:tab
!TBD table config merge tab
foreach item intable tab
  set config.^item tab.^item
endfor
return

procedure addToSetIf t:tab
!TBD table config merge tab
foreach item intable tab
  if config.^item nrexists set config.^item tab.^item
endfor
return

procedure setRange
if /fixmax ne -1 then
  calc fscale (/fixmax)
else
  calc fscale scale log 10 *
else
endif
if reg.fdlp rexists then
  if /fixrange gt 0 then
    if /fixmax ne -1 then
      set reg.fdlp.mp.scale "MAXRANGE"
    else
      set reg.fdlp.mp.scale "AUTOMAX|MAXRANGE"
    endif
    set reg.fdlp.mp.maxrange gc.RANGE.v
    invoke reg.fdlp.mp.useRange()
  else
    set reg.fdlp.mp.scale "AUTOMIN|AUTOMAX"
  endif
endif
if reg.fdrp rexists then
  if /fixrange gt 0 then
    if /fixmax ne -1 then
      set reg.fdrp.mp.scale "MAXZRANGE"
    else
      set reg.fdrp.mp.scale "AUTOMAX|MAXZRANGE"
    endif
    set reg.fdrp.mp.maxrange gc.RANGE.v
    invoke reg.fdrp.mp.useRange()
  else
    set reg.fdrp.mp.scale "AUTOMIN|AUTOMAX"
  endif
endif
return

procedure checkafname l:init
if gc.AFNAME.v eqs "NONE" or gc.AFNAME.v eqs "NULL" then return
if "udp:" subs gc.AFNAME.v or "stp:" subs gc.AFNAME.v then return
if "/" subs gc.AFNAME.v and gc.AFNAME.v neqss "/" then
  sedit gc.AFNAME.v aux0 "TRIM" "" "/"
  sedit gc.AFNAME.v gc.AFNAME.v "TRIM" "/"
  if /dual then
    set aux1 aux0 aux2 aux0 
    set gc.AUX1.v aux1 set gc.AUX2.v aux2
  else
    set gc.AUX0.v aux0
  endif
endif
if /dual then
  set afname "^{gc.AFNAME.v}_1{AUX=^AUX1}"
else
  set afname "^{gc.AFNAME.v}{AUX=^AUX0}"
endif
if afname nfexists then
 ! do nothing
elseif /play then
  status afname xd=xdelta form=fmt
  calc d:rate 1 xdelta / round 1e-6 *
  if rate eq/t ^gc.RATE.v then
  elseif /autoconf then
    set gc.RATE.v ^rate
  elseif init le 0 and ratio lt 0
    warn "Playback file=^afname rate=^rate not equal to config=^gc.RATE.v. See /AUTOCONF."
  endif
  if fmt eqs gc.FORMAT.v then
  elseif /autoconf then
    set gc.FORMAT.v fmt
  elseif init le 0
    warn "Playback file=^afname format=^fmt not equal to config=^gc.FORMAT.v. See /AUTOCONF."
  endif
  call updateArchive afname
else ! acquire

endif
return

procedure dumptcdata
  set tc reg.SP.timecode
  set flen file(ramfile).size
  if tc.offset lt 0 return
  if file(ramfile).length lt 1.5 then warn "Ramfile should be >1.5 sec for /CHECKTC"
  calc offset tc.offset-8 flen mod
  if offset+nfft gt flen then
    thin ramfile tmptcdata offset flen
    mergefile ramfile(0:nfft+flen-offset) tmptcdata
  else
    thin ramfile tmptcdata offset +nfft
  endif
  header tmptcdata fs=nfft
  mergefile tmptcdata dumptcdata 
  file open/d/n tag tmptcstat{sr=(OFFS/SD,WSEC/SD,FSEC/SD)}
  set tag.setdata(0,"OFFS") tc.offset
  set tag.setdata(0,"WSEC") tc.wsec
  set tag.setdata(0,"FSEC") tc.fsec
  file close tag
  mergefile tmptcstat dumptcstat 
return

procedure add2list s:fname
set ramtbl.^fname "OK"
return

procedure cleanlist
if ramtbl rexists and /clean neq 0 then
  foreach item intable ramtbl 
    erase/warn=off ^item
  endfor
endif
set t:ramtbl {}
return

procedure pollit
invoke str=sp.setkey("TABLE",pollstr)
info str
return

procedure setAGC
set t:agcb {LEVEL=-12,WIDTH=2,MINGAIN=^gc.^{agc}.min,MAXGAIN=^gc.^{agc}.max,PERIOD=1}
if agc eqs "NONE" then set agcb.period 0
if reg.sp rexists set reg.sp.agc agcb
if reg.sps rexists set reg.sps.agc agcb
return

procedure makeXcvrs
set xcvrs "Clear,Bypass"
foreach id intf nxm.ice.cfg.rfinputs.txt
  sedit xcvrs xcvrs "APPEND" "," "APPEND" id
endfor 
return

procedure setxcvr s:name
  sedit name xcvr "GSUB" "  " " " "SUBS" " LO=" ":" "TRIM" "" " " "SUBS" "Clear" ""
  set gc.XCVR.v "^xcvr   "
return

