!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! SENSOR - Dual WideBand channel acquisition with tuner excision capability
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/gc=config u:card[pic1auto] cs:cflags t:config

global hwalias
invoke parent=this.M.parent.getMacro()
fname ipmice "test" "ipmice" ,, ice	! for XCVR control
if parent nisnull set parent parent.name

if config isnull then
 if parent isnull then global sensorset
 if sensorset nrexists and "^env.home/sensorset.tbl" fexists then
  ask ans "Found ~/sensorset.tbl from a previous session. Load it ? Y/[N]: "
  if ans eqss "Y" then set t:sensorset "^env.home/sensorset.tbl"
 endif
 if sensorset nrexists set t:sensorset {}
 set config sensorset
endif

switch "AFLAGS" aflags get cflags	! aflags are immutable, flags are not
if config.aflags rexists then sedit aflags aflags "APPEND" "|" "APPEND" config.aflags
if config.flags nrexists set config.flags ""

if config.PSDR rexists and config.DSPR nrexists
  calc config.DSPR config.PSDR config.PSDA /
endif

call handleTheme

sedit card cname "LOCASE"

switch "SERVER" server get 0

if /offline pexists
  switch "OFFLINE" ofn get "NULL" archive
  set sig "HHMT"
  set l:a2drev 20
  set l:dsgt -1
  set l:npm 2
else
  picd get card "ACTIVE" active
  if active lt 0 then
    say "Performing PIC initial reset or lock clear"
    picd reset card /flags=^aflags
  endif
  picd get card "FPGASIG" sig /str
  picd get card "MREV1"   a2drev
  picd get card "DSGTYPE" dsgt
  picd get card "NPM"     npm
endif
if dsgt eq 1 or dsgt eq 2
  set l:isPac 1
  set l:ntcm 4
else
  set l:isPac 0
  sedit aflags aflags "APPEND" "|PMFPGA=tq"
  set l:ntcm 16
endif
if sig eqs "HHFF" then
  set fcore1 "CORE1"
  set fcore2 "CORE2"
elseif npm eq 2 then
  set fcore1 "CORE11"
  set fcore2 "CORE21"
elseif npm eq 1 then
  set fcore1 "CORE11"
  set fcore2 "CORE12"
endif

switch "XCVR" xcvr get "Bypass"	! number tuner channels
switch "XCFB" d:xcfb get -1
switch "NTC" l:ntc get ntcm	! number tuner channels
calc l:ntbc ntc ntcm min 2 / 
set l:tuners 0
set d:xcf1 0 d:xcf2 0

switch "RFFREQ" rffreq get 0
switch "RFGAIN" rfgain get 12
switch "AAUX"   aux0 get 20
switch "ATL"    atl  get 4m

timex now time

set xfoff  0
set xfreq  1000
set xfreq1 0
set xfreq2 40000
set xattn 0
set xattn1 0
set xattn2 38
set nbgain 12
set rfagc -9
set nbagc -24

set l:nfft 4k
set l:psdr 10
set l:psda 20
set l:nexp 5
set l:pps  1M

set scale 32k
calc gscale 0
calc grange 70

set l:tdec1 8
set l:tdec2 8
set d:tfreq1 0
set d:tfreq2 0

sedit aflags aflags "APPEND" "|MUXCLK=P"
set agcdef "WB+NB"
set rfagc -9

if a2drev eq 20
  set d:srate 500
else
  set d:srate 400
endif 

set flg "^aflags|^config.flags"
if ofn nrexists then
  info "Resetting card=^card flags=^flg"
  picd reset card /flags=flg
endif

switch "XFREQ" l:xfreq get xfreq	
switch "XFOFF" l:xfoff get xfoff	
switch "RATE"  d:srate get srate	! in MHz at this point

set lmode "SETUP" runmode lmode l:specan 0 l:asel 0

sedit cname wbfile1 "APPEND" "_wb1"
sedit cname wbfile2 "APPEND" "_wb2"
sedit cname nbfile1 "APPEND" "_nb1"
sedit cname nbfile2 "APPEND" "_nb2"
sedit cname tuncfg1 "APPEND" "_tcfg1"
sedit cname tuncfg2 "APPEND" "_tcfg2"
sedit cname psdfile1 "APPEND" "_psd1"
sedit cname psdfile2 "APPEND" "_psd2"

call makeBoTs
call makeRFins

report on sensor

pipe on

if server gt 0 then icermif/id=rmif/http server _CBWF1|_CBWF2

panel/setup/controls=gc/logger/menubar
info "Sensor starting. Use Shift-Drag and Shift-Click in WideBand PSDs to set NarrowBand Tuners"

plot/id=wblp1 _cbwf1 type=line axis=tframe options=^plotopts xmin=p1x1 xmax=p1x2 ymax=gscale ymin=gscale-grange /xmult=6
plot/id=wbrp1 _cbwf1 type=rast axis=frame options=^plotopts  xmin=p1x1 xmax=p1x2 zmax=gscale zmin=gscale-grange /xmult=6
plot/id=wblp2 _cbwf2 type=line axis=tframe options=^plotopts xmin=p2x1 xmax=p2x2 ymax=gscale ymin=gscale-grange /xmult=6
plot/id=wbrp2 _cbwf2 type=rast axis=frame options=^plotopts  xmin=p2x1 xmax=p2x2 zmax=gscale zmin=gscale-grange /xmult=6

set reg.wblp1.mimic wbrp1  reg.wbrp1.mimic wblp1	! tie PAN/ZOOM messages
set reg.wblp2.mimic wbrp2  reg.wbrp2.mimic wblp2	! tie PAN/ZOOM messages

view/id=list 
plot/id=aplx axis=frame

gcontrol label	"FUNC"   "Function"
gcontrol choice	"MODE"   "Op Mode   " "Setup,Monitor,SnapWB,RecWB,RecWB-1,RecWB-2,PlyWB,Exit,Process,SnapWB/Arch,RecNB,RecNB-1,RecNB-2,PlyNB" lmode  /nc=2 /cs
gcontrol choice	"SPECAN" "SpecAn    " "Off,On,Low,Med,High,Max" "Off"
gcontrol choice	"AGCM"   "AGC Mode  " "Off,WB,NB,WB+NB" agcdef
gcontrol prompt "EVNT"   "Event Tag " "Base"
gcontrol choice	"SPOT"   "Task View " "TiVo-1,TiVo-2,BoT-1,BoT-2,Scan-1,Scan-2,Snap-0,None" "None" /cs	
gcontrol choice "AFUNC"  "Tasks" "ScanWB-1,ScanWB-2,ScanNB-1,ScanNB-2,Snap-1,Snap-2,ScanSnap,Status,BPV-1,BPV-2,SaveCfg-1,SaveCfg-2,LoadCfg-1,LoadCfg-2,Done" "Done" 
gcontrol file	"CFGFN"  "CfgFN" "sigcfg_def" "sigcfg_*.txt"

gcontrol label  "SNAP"   "SnapShot" "Hidden"
gcontrol tval	"SNAPST" "T" 0 0 -0 .1 /fmt=HH:MM:SS.S
gcontrol tval	"SNAPTD" "Duration" 1 0 60 .1 /fmt=HH:MM:SS.S
gcontrol dval	"SNAPCF" "Frequency" 0 xfreq1 xfreq2 1 /units=MHz
gcontrol dval	"SNAPBW" "BandWidth" 1 0 125 1 /units=MHz
gcontrol file	"SNAPFN" "FileName" "^{cname}_snap"
gcontrol dval   "PROG"   "Progress" 0 0 1 0.01 /gauge

gcontrol label  "CFG1"   "Module-1"
gcontrol choice "XCVR1"  "RF Dev1" rfins xcvr /nc=1 /input /cs
gcontrol lval	"XFREQ1" "RF Freq" xfreq-xfoff xfreq1 xfreq2 5 /fmt="#0" /units="MHz" 
gcontrol lval	"XATTN1" "RF Attn" xattn xattn1 xattn2 1 /units="dB"
gcontrol dval	"MFREQ1" "IF Freq" rffreq 1 -1 1 /fmt="#0.000" /units="MHz" /edit=f
gcontrol lval	"MGAIN1" "IF Gain" rfgain -33 30 1 /units="dB"
gcontrol lval	"ADLM1"  "Loading" -48 -48 0 1  /edit=f /vumeter 
gcontrol dval	"QFREQ1" "MrkFreq" 0 1 -1 1 /fmt="#0.000" /units="MHz" /edit=f
gcontrol file   "AFN1"   "Archive" "^{cname}_arch1"

gcontrol label  "CFG2"   "Module-2"
gcontrol choice "XCVR2"  "RF Dev2" rfins xcvr /nc=1 /input /cs
gcontrol lval	"XFREQ2" "RF Freq" xfreq-xfoff xfreq1 xfreq2 5 /fmt="#0" /units="MHz" 
gcontrol lval	"XATTN2" "RF Attn" xattn xattn1 xattn2 1 /units="dB"
gcontrol dval	"MFREQ2" "IF Freq" rffreq 1 -1 1 /fmt="#0.000" /units="MHz" /edit=f
gcontrol lval	"MGAIN2" "IF Gain" rfgain -33 30 1 /units="dB"
gcontrol lval	"ADLM2"  "Loading" -48 -48 0 1  /edit=f /vumeter 
gcontrol dval	"QFREQ2" "MrkFreq" 0 1 -1 1 /fmt="#0.000" /units="MHz" /edit=f
gcontrol file   "AFN2"   "Archive" "^{cname}_arch2"

gcontrol label	"DISP"   "Displays" 0
gcontrol choice	"NFFT"   "Fft Size  " "1K,2K,4K,8K,16K,32k,64K,256K,1M" ^nfft /input
gcontrol choice	"DSPR"   "Disp Rate " "5,10,25,50,100" ^psdr /units="Hz" /input
gcontrol choice	"PSDA"   "Disp Avg  " "1,5,10,20" ^psda /units="Frames" /input
gcontrol lval	"EXPA"   "Expn Avg  " nexp 0 100 1 /units="Frames"
gcontrol choice	"OVER"   "Overlap   " "Show,Hide" "Show"
gcontrol lval	"GSCALE" "Plot Max  " gscale -60 100 1 /units="dB"
gcontrol lval	"GRANGE" "Plot Range" grange 20 200 1 /units="dB"

gcontrol label	"CONF"   "Configuration" 
gcontrol choice	"NTC"    "TunerChans" "2,4,6,8,12,16,24" "^ntc"
gcontrol choice "CHNS"   "Channels  " "1,2,1&2,Auto" "Auto"
gcontrol choice	"FORMAT" "DataFormat" "CB,CJ,CI,Auto" "Auto"
gcontrol choice "RATE"   "SampleRate" "50,100,240,250,320,480,500,600,625,640,650,1000,1250" "^srate" /units="MHz" /input
gcontrol choice "CLOCK"  "Clock Src " "P,PX" "P"
gcontrol lval	"LENGTH" "Buffer Len" 1 1 -1 1 /units="sec"
gcontrol lval	"AGCL"   "IF Loading" rfagc -18 -3 1 /units="dB"
gcontrol lval	"MING"   "Min IFGain" -18 1 -1 1  /units="dB"
gcontrol lval	"MAXG"   "Max IFGain" 30 1 -1 1  /units="dB"
gcontrol lval	"AGCLN"  "NB Loading" nbagc -30 -3 1 /units="dB"
gcontrol lval	"MINGN"  "Min NBGain" -6 1 -1 1  /units="dB"
gcontrol lval	"MAXGN"  "Max NBGain" 14 1 -1 1  /units="dB"
gcontrol lval	"DEFGN"  "Def NBGain" nbgain 1 -1 1  /units="dB"
gcontrol dval	"AGCW"   "Hysteresis" 1 0 6 1   /units="dB"
gcontrol lval   "MINCV"  "Min CluVar" -20 1 -1 1  /units="dB"
gcontrol fval   "MFTHR"  "ScanThresh" 6 1 -1 1  /units="dB"
gcontrol fval   "MFMIN"  "ScanMin   " 0 1 -1 1  /units="dB"
gcontrol lval   "HOLD"   "StepHold  " 0 0 3 1  

gcontrol label	"SYS"     "System" 0
gcontrol tval   "TIME"    "T" time 1 -1 1 /edit=f 
gcontrol tval   "MAXL"    "MaxRecTime" 300 1 -1 1 
gcontrol choice "AMODE"   "ArchMode" "File,File_Date,File_MJS,File_Freq,File_F&D,File_Cnt,MultiFile,TiVoFile" "File"
gcontrol lval	"ARCHSF"  "ArchSF  " 256 0 10000 1 /units="Files"
gcontrol lval	"ARCHSFS" "ArchSFS " 1 0 64 1 /units="GBy"
gcontrol choice	"ARCHFFT" "ArchFFT " "4K,8K,16K,32K,64K,128K,256K,1M" "8K"
gcontrol lval	"ARCHCNT" "ArchCnt " 0 0 1e6 1
gcontrol prompt	"ARCHGPS" "ArchGPS " ""
gcontrol lval   "AAUX1"   "ArchAux1" aux0 0 100 1 
gcontrol lval   "AAUX2"   "ArchAux2" aux0 0 100 1 
gcontrol lval   "AUXU1"   "Aux1Used" 0 0 100 1 /gauge /edit=f /units="% Full"
gcontrol lval   "AUXU2"   "Aux2Used" 0 0 100 1 /gauge /edit=f /units="% Full"
gcontrol choice	"PKTTYP"  "PktTyp" "NONE,UDP,ICE,SDDS,VRT,AUDIO" "NONE"
gcontrol prompt	"PKTADDR" "PktAdr" "225.1.2.3:1000#" 
gcontrol prompt	"FLAGS"   "Flags " 
gcontrol prompt	"AFLAGS"  "aFlags" aflags /noedit
gcontrol pipe	"PMON"    "Pipes " 

do ii 1 2
 call setTrim ii
 feature ,, ff^ii {NAME=FF^ii,TYPE=VLINE|DATA,COLOR=#0080A0} wblp^ii
 set ff^{ii}.x gc.XFREQ^{ii}.v*1e6 ff^{ii}.dx 0
 set lafn^ii gc.AFN^{ii}.v
 sendto "MAIN" "XCVR^ii" gc.XCVR^{ii}.v
enddo

call setHold
call setNPKH
call setSPOT
if /action pexists and parent neqs "SNAPAPP" then sendto "MAIN" "ACTION" "^/action"
set l:aux1 gc.AAUX1.v
set l:aux2 gc.AAUX2.v

pipe off

call cleanram
if sensorset rexists 
 foreach item intable gc
  if item eqs "AFLAGS" or item eqs "MODE" or item eqs "ACTION" continue
  set sensorset.^item gc.^{item}.value
 endfor
 table sensorset SAVE "^env.home/sensorset.tbl"
endif

report off
endmacro

procedure cleanram l:partial
erase/warn=off wbfile1 wbfile2 nbfile1 nbfile2 psdfile1 psdfile2
if partial isfalse erase/warn=off ^{psdfile1}f ^{psdfile2}f 
files/e ^{nbfile1}-*
files/e ^{nbfile2}-*
return

procedure open
set this.timers 2
set this.timer(0) 1
set this.timer(1) 10
sendto main "TIMER" info=1
return

procedure close
return


procedure picsetup

timex now curtime
set runmode gc.MODE.v
call setNPKH
sedit gc.FLAGS.v flg "APPEND" "|MUXCLK=^gc.CLOCK.v|" "APPEND" aflags 
if ofn nrexists
  picd reset card /flags=^flg
endif

set l:nfft ^gc.NFFT.v
set l:nexp ^gc.EXPA.v
set l:psdr ^gc.DSPR.v
set l:psda ^gc.PSDA.v
set d:len ^gc.LENGTH.v
set d:srate ^gc.RATE.v*1e6
set d:trate1 srate/tdec1/2
set d:trate2 srate/tdec2/2
set d:gscale gc.GSCALE.v
set d:grange gc.GRANGE.v
set s:form gc.FORMAT.v
set l:nbgain gc.DEFGN.v

if form eqs "AUTO" set s:form "CB"
calc bpc 2 gc.RATE.v *	! assume CB for auto calcs

set chans gc.CHNS.v
if chans eqs "Auto" then
  set chans "1&2"
  if bpc gt 2000 set chans "1"
endif
if gc.FORMAT.v eqs "Auto" then
  if chans eqs "1&2" set bpc bpc*2
  if bpc*1.5 le 4000 set form "CJ"
  if bpc*2 le 4000 set form "CI"
endif
if form eqs "CB" then
  set mbits -8
else
  set mbits -16
endif
if chans eqs "1&2" then
  set l:i1 1 l:i2 2
else
  set l:i1 ^chans l:i2 ^chans
endif
set wbflgx flg
if form eqs "CJ" then
  sedit wbflgx wbflgx "APPEND" "|PACK12"
  if runmode neqss "RECWB" then
    info "Reformatting CJ to CI on XBar for follow on processing"
    sedit wbflgx wbflgx "APPEND" "|UP12"
    set form "CI"
  endif
endif
invoke bpa nxm.sys.lib.Data.getBPA(form)

set tuners test(form,eqs,"CI",and,^gc.RATE.v,le,500,and,ofn,nrexists)
set specan test(form,eqs,"CI",and,gc.SPECAN.v,neqs,"OFF")
if specan then set nexp 0

! create ramfiles for display buffers
calc wbskip srate nfft / psdr*psda / round

if runmode neqss "MON" and runmode neqss "RECNB" and runmode neqss "SNAPNB" then
  calc l:fsz srate*len 
  set l:frnd atl*bpa
else
  calc l:fsz srate*len wbskip / 
  set l:frnd nfft*bpa 
endif
if specan istrue and nfft gt 16K then
  warn "FFT size limited to 16K for FPGA full take option"
  set l:nfft 16k
endif

if runmode eqss "REC" then set gc.ARCHCNT.v gc.ARCHCNT.v+1
do ii i1 i2
  picd/round=^frnd create wbfile^ii form fsz srate
  calc l:btl trate^ii/20 power2 4k max 1m min
  picd/round=btl*4 create nbfile^ii "CI" len*trate^ii trate^ii
  if specan then picd/round=nfft*4 create psdfile^ii "SL" psdr*nfft*len srate
  call genLAFN gc.AFN^{ii}.v curtime gc.XFREQ^{ii}.v
  set lafn^ii lafn
enddo

pipe init

! Wideband 
set aflg ""
if gc.AMODE.v eqss "FILE" then
  set l:narch 0
elseif gc.AMODE.v eqs "MULTIFILE" then
  set l:narch 1
elseif gc.AMODE.v eqs "TIVOFILE" then
  set l:narch gc.ARCHSF.v
  set aflg "+APPEND"
endif
set d:archsz gc.ARCHSFS.v*1G
set l:anft ^gc.ARCHFFT.v
set s:gpsfn "^gc.ARCHGPS.v"

do ii i1 i2
  set wbswi "tl=1/replay=0/skip=wbskip/tcpp=5/stats=1/flush"
  if chans eqs "1&2" and ii eq 1 then sedit wbswi wbswi "APPEND" "/master=spw2"
  if chans eqs "1&2" and ii eq 2 then sedit wbswi wbswi "APPEND" "/slave=def"
  sedit wbflgx wbflg "APPEND" "|XCVR=^gc.XCVR^{ii}.v|MFREQ=^gc.MFREQ^{ii}.v|RFFREQ=^gc.XFREQ^{ii}.v|RFGAIN=^gc.MGAIN^{ii}.v|RFATTN=^gc.XATTN^{ii}.v"
  if runmode eqss "MON" or runmode eqss "RECNB" or runmode eqss "SNAPNB" then 
    sedit wbswi wbswi append "/skiponcard/notc"
    sedit wbflg wbflg append "|HXFD|BLOCK=8K"
  endif
  if runmode eqs "RECWB" or runmode eqs "RECWB-^ii" then
    sedit wbswi wbswi append "/arch=lafn^ii{DET=1,AUX=^aux^ii,NFFT=^anft,GPS=^gpsfn,FLAGS=^aflg}/archtl=atl/archsf=narch/archsfs=archsz"
  endif
  if ofn rexists then
    sourceice/id=spw^ii/source=file/wrap ofn _cbw^ii CI
  else
    sourcepic/id=spw^ii/port=module^ii/^wbswi/flags=wbflg wbfile^ii{fs=nfft} _cbw^ii{ps=pps} card 1 0 0
  endif
  if specan then		! FPGA full FFTs
    calc l:vadd -93 (/dboff) +
    calc d:scl 1 srate/nfft sqrt /
    calc l:nmax srate nfft / psdr*psda / round
    calc l:pavg psdr/5 1 max
    set flgf "FFT=(NFFT=^nfft,NMAX=^nmax,NAVG=^psda,FLAGS=(MAG),WIND=hann)|RGO|BLOCK=8k|MBITS=^mbits"
    sourcepic/id=spf^ii psdfile^ii{fs=nfft} _cbf^ii card 1 0 0 /tl=1 /port=^fcore^ii /replay=0 /stats=0 /flags=IPORT=module^ii|^flg|^flgf
    icecore/id=svi^ii/core=j _cbf^ii _cbwf^ii "FSVI" frame=nfft nexp=nexp scale=scl vadd=vadd flags=Mag|Log /ifmt=SL /ofmt=SF /tl=nfft*4
    icecore/id=svip^ii/core=j _cbf^ii _cbwfp^ii "FSVI" frame=nfft npkp=npkh navg=pavg scale=scl vadd=vadd flags=Mag|Log|Max /ifmt=SL /ofmt=SF /tl=nfft*4
    icecore/id=svis^ii/core=j _cbwf^ii _cbwfs^ii{fs=256} "MFPP" frame=nfft ntop=127 L:width=32 F:thresh=gc.MFTHR.v F:tmin=gc.MFMIN.v S:flags=STRIP|TAG|PEAK|SORT|DIFF|LOG /ifmt=SF /ofmt=SL /tl=nfft*4
    header _cbwf^ii xu=3 xs=-(srate/2) xd=srate/nfft yu=1 yd=1/psdr
    header _cbwfp^ii xu=3 xs=-(srate/2) xd=srate/nfft yu=1 yd=1/psdr
    header _cbwfs^ii xu=0 xs=0 xd=1 yu=1 yd=1/psdr
    if runmode eqs "PROCESS" or runmode eqs "RECWB" or runmode eqs "RECWB-^ii" then
      noop/id=nsvi^ii/tl=1/flush _cbwf^ii "^{lafn^ii}_sa"
      noop/id=nsvip^ii/tl=1/flush _cbwfs^ii "^{lafn^ii}_sap"
    endif
  else				! CPU decimated FFTs
    set reg.spw^{ii}.monitor "ASYNC"
    calc vscl 256 1 test(form,eqs,"CB") ?: nfft / 10 (/dboff)/20 ** *
    fft/id=fftw^ii/psd/log _cbw^ii _cbwf^ii nfft HANN 0 psda /nexp=nexp /scale=vscl
    header _cbwf^ii yd=1/psdr
  endif
  set l:psdsize psdr*len
  if "SNAP" subs runmode then
    noop/id=psd^ii/tl=1 _cbwf^ii "^{psdfile^ii}f"
  else
    sinkice/id=psd^ii/sink=rtfile/pt=none/maxout=psdsize/tl=1 _cbwf^ii "^{psdfile^ii}f"
  endif
  if /rtppsd^ii pexists then sinkdg/id=rtppsd^ii/rtp/hostport=^/rtppsd^ii _cbwf^ii
  if gc.XCVR^{ii}.v eqss "LNB" then set gc.XFREQ^{ii}.v reg.spw^{ii}.rffreq
enddo

! Spot narrowband monitor
set nbswi "tl=1/replay=0/skip=nbskip"
set nbflg "^flg|RGO|MBITS=-16"
if /resamp then sedit nbflg nbflg "APPEND" "|RESAMP"
do ii i1 i2
  if tuners gt 0 and runmode neqss "RECNB" and runmode neqss "SNAP" then
    calc nbskip trate^ii nfft / psdr*psda / round 1 max
    sourcepic/id=spn^ii/port=pm0tuner^ii/^nbswi/flags=^nbflg nbfile^ii{fs=nfft} _cbn^ii{ps=pps} card tdec^ii tfreq^ii nbgain
    fft/id=fftn^ii/psd/log _cbn^ii _cbnf^ii nfft HANN 0 1
  endif
  set ff^{ii}.x tfreq^ii ff^{ii}.dx trate1

! BoT narrowband Record
  if tuners le 0 continue
  if runmode neqs "RECNB" and runmode neqs "RECNB-^ii" continue
  do l:nn 1 ntbc
    set t:tab file(tuncfg^ii).dataTable(nn-1)
    if tab.ENA le 0 continue
    calc d:tfreq tab.FREQ gc.XFREQ^{ii}.v - 1e6 *
    calc l:tdec srate tab.BW*1e6 / 4 / floor 1 max 2 * 4K min
    calc d:trate srate/tdec/2
    calc l:btl trate/20 power2 4k max 1m min
    set nbfile "^{nbfile^ii}-^nn"
    picd/round=btl*4 create nbfile "CI" trate*len trate
    sedit lafn^ii lafnt "SUBS" "_tv" "" "APPEND" "_nb^nn"
    set nbswin "/tl=1/arch=^lafnt{DET=1,AUX=^aux^ii,CLEANUP=T}/archtl=btl/flush"
    set nbswik "/archkw={RFFREQ=^gc.XFREQ^{ii}.v,RFGAIN=^gc.MGAIN^{ii}.v,SOIFREQ=^tab.FREQ,SOIBW=^tab.BW}"
    say "Setup tuner ^nn on inp=^ii freq=^tab.freq bw=^tab.bw file=^lafnt"
    calc ni (nn-1)*2 ii +
    set tport "tuner^ni"
    if npm eq 2 then set tport "pm^{ii}tuner^nn"
    sourcepic/id=spn^ii-^nn/port=^tport/^nbswin/^nbswik/flags=^nbflg|inp=^ii nbfile{fs=nfft} ,, card tdec tfreq nbgain
  enddo
enddo

pipe run
return

procedure restartTuner l:ii d:tfreq d:tbw
calc l:tdec srate tbw / 4 / floor 1 max 2 * 4K min
set d:trate srate/tdec/2
set d:xfreq gc.XFREQ^{ii}.v*1e6
if tfreq lt -srate/2 or tfreq gt srate/2 then 
  if tfreq ne 0 warn "Tuner frequency offset=^tfreq out of range"
  set tfreq 0
endif
set ff^{ii}.x tfreq ff^{ii}.dx trate
set tdec^ii tdec
set tfreq^ii tfreq
if tuners le 0 
  warn "No tuners to configure in this scenario"
  return
endif
if reg.SPN^{ii} rexists then
  set reg.SPN^{ii}.replay "ABORT"
  while reg.SPN^ii rexists 
    pause 0.2
  endwhile
endif
set modt "NONE"
calc nbskip trate nfft / psdr*psda / round 1 max
if gc.SPOT.v eqss "BOT" and selidx gt 0 and tbw lt 300e3 then
  set modt file(fnt).data(selidx-1,"MOD")
  set nbskip 0
endif
picd/round=atl*4 create nbfile^ii "CI" trate*len trate
set l:nbgain gc.DEFGN.v
pipe init
sourcepic/id=spn^ii/port=pm0tuner^ii/tl=1/replay=0 nbfile^ii{fs=nfft} _cbn^ii{ps=pps} card tdec tfreq nbgain /flags=^nbflg
fft/id=fftn^ii/psd/log _cbn^ii _cbnf^ii nfft HANN -nbskip 1
sedit gc.PKTADDR.v addr "SUBS" "#" "^ii"
if gc.PKTTYP.v eqs "NONE" then
elseif modt subs "AM|FM" and gc.PKTTYP.v eqs "AUDIO" then
  icecore/id=dm^ii _cbn^ii{fs=0} _cbna^ii DMOD;IQ S:MOD=^modt INFS=trate FSYM=16e3 AGC_MAXFACTOR=1k SSR_FBWF=.25 /ifmt=ci /ofmt=si /oxd=(1/16e3)
  sinkice/id=dmrtp^ii _cbna^ii udp:^addr
else
  sinkice/id=dmrtp^ii/pt=^gc.PKTTYP.v _cbn^ii{fs=0} udp:^addr
endif
pipe run
set reg.SPN^{ii}.replay "CONTINUOUS"
return

procedure picrestart s:name
if runmode neqs "SETUP" then
  call picstop
  call picsetup
  warn "ReStarting to enable this ^name change"
  call picstart
endif
return

procedure picstart l:info
call checkXCVR
if info lt 0 return	! prestart
call setTrim 1
call setTrim 2
sendto wblp1 "OPENFILE" "_cbwf1|_cbwfp1" info=-1
sendto wbrp1 "OPENFILE" "_cbwf1" info=-1
sendto wblp2 "OPENFILE" "_cbwf2|_cbwfp2" info=-1
sendto wbrp2 "OPENFILE" "_cbwf2" info=-1
if reg.SPW1 rexists set reg.SPW1.gain gc.MGAIN1.v
if reg.SPW2 rexists set reg.SPW2.gain gc.MGAIN2.v
!if reg.fftw1 rexists then set reg.FFTW1.nexp nexp
!if reg.fftw2 rexists then set reg.FFTW2.nexp nexp
call setAGC
if "SNAP" subs runmode then
  set replay "ONESHOT"
else
  set replay "CONT"
endif
if specan then
  if reg.spf1 rexists set reg.spf1.replay replay
  if reg.spf2 rexists set reg.spf2.replay replay
  if runmode eqss "SNAP" set replay "CONT"
endif
info "Starting card=^card id=SPW1,SPW2 replay=^replay"
if "1" subs chans then
  set reg.SPW1.replay replay
  set reg.SP reg.SPW1
else
  set reg.SPW2.replay replay
  set reg.SP reg.SPW2
endif
timex now timestart
if "1&2" subs chans then
  set ids "SPN1,SPN2"
else
set ids "SPN^chans"
endif
info "Starting card=^card id=^ids replay=^replay"
foreach id inlist ids
  if reg.^{id} rexists set reg.^{id}.replay replay
endfor
return

procedure picstop l:mode
if reg.SP rexists rem reg.SP
if reg.spw1 nrexists and reg.spw2 nrexists then return
if runmode eqss "RECNB" then
 info "Stopping card=^card record NB Tuners"
 foreach id inlist "SPN1,SPN2"
  do l:nn 1 ntbc
    if reg.^{id}-^nn rexists set reg.^{id}-^{nn}.replay "FINISH"
  enddo
 endfor
endif
set ids "SPN1,SPN2,SPW1,SPW2,SPF1,SPF2"
info "Stopping card=^card id=^ids"
foreach id inlist ids
  if reg.^id rexists set reg.^{id}.replay "FINISH"
endfor
pause 0.2
foreach id inlist ids
  if reg.^id rexists then
    warn "Id=^id not finished"
  endif
endfor
set l:tuners 0
if mode ge 0 
  set runmode "SETUP"
  call cleanram 1
  rem timestart
endif
return

procedure setAGC
set t:agcwb {LEVEL=^gc.AGCL.v,WIDTH=^gc.AGCW.v,MINGAIN=^gc.MING.v,MAXGAIN=^gc.MAXG.v,PERIOD=0.5}
if "WB" nsubs gc.AGCM.v set agcwb.period 0
set t:agcnb {LEVEL=^gc.AGCLN.v,WIDTH=^gc.AGCW.v,MINGAIN=^gc.MINGN.v,MAXGAIN=^gc.MAXGN.v,PERIOD=0.5}
if "NB" nsubs gc.AGCM.v set agcnb.period 0
if reg.SPW1 rexists set reg.SPW1.agc agcwb
if reg.SPW2 rexists set reg.SPW2.agc agcwb
if reg.SPN1 rexists set reg.SPN1.agc agcnb
if reg.SPN2 rexists set reg.SPN2.agc agcnb
return

procedure updateToC l:mode
if gc.SPOT.v neqss "TIVO" return
if runmode neqss "RECWB" return
set fnt "^{lafn^asel}_toc"
set fnp "^{lafn^asel}_psd"
if asel gt 0 and fnt fexists and fnp fexists then
  sendto "LIST" "OPENFILE" fnt info=0
  sendto "APLX" "OPENFILE" fnp info=-1
else
  sendto "LIST" "OPENFILE" "" info=0
  sendto "APLX" "OPENFILE" "" info=-1
endif
return

procedure processMessage m:msg

if msg.name eqs "TIME" or msg.name eqs "NULL" then return
!if msg.name neqs "TIMER" then say "Got message n=^msg.name i=^msg.info d=^msg.data from ^msg.fid"

if msg.name eqs "TIMER" then 

 if msg.info eq 0 and gc.MODE.v neqss "SETUP" and /offline isfalse then	! 1 sec
  do ii 1 2
    if reg.spw^{ii} nrexists continue
    set gc.TIME.v reg.spw^{ii}.time.sec
    set gc.ADLM^{ii}.v reg.spw^{ii}.ADLM	! report adlm
    if "WB" subs gc.AGCM.v set gc.MGAIN^{ii}.v reg.spw^{ii}.GAIN
  enddo
  do nn 1 ntc
    set ii cfg.data(nn-1,"INP")
    set ic cfg.data(nn-1,"CHN")
    if runmode neqs "PLYNB" and reg.spn^{ii} rexists
      if "NB" subs gc.AGCM.v set cfg.data(nn-1,"GAIN") reg.spn^{ii}.chngain(^ic) 
    endif
  enddo
  timex now time
  if runmode eqss "REC" and timestart rexists and time-timestart gt gc.MAXL.v then
    info "Max record time=^gc.MAXL.v sec reached. Stopping."
    set gc.MODE.action "Setup"
  endif
  if runmode eqss "REC" and gc.AUXU1.v gt 98 then
    info "Max disk1 percentage=%^gc.AUXU1.v full. Stopping."
    set gc.MODE.action "Setup"
  endif
  if runmode eqss "REC" and gc.AUXU2.v gt 98 then
    info "Max disk2 percentage=%^gc.AUXU2.v full. Stopping."
    set gc.MODE.action "Setup"
  endif
  if runmode eqss "SNAP" then
    if specan istrue and reg.spf1.replay neqs "Stopped" return
    if specan isfalse and reg.spw1.replay neqs "Stopped" return
    call picstop -1
    call setPlots 1 0.0 1
    call setPlots 2 0.0 1
    if "ARCH" subs runmode then
      icecopy/gpw wbfile1 lafn1{DET=1,AUX=^aux1}
      icecopy/gpw wbfile2 lafn2{DET=1,AUX=^aux2}
    endif
    set runmode "DONESNAP" 
    set gc.MODE.v "SnapDone"
    timex now gc.TIME.v
  endif

 elseif msg.info eq 1 then	! 10 sec
  call updateToC
  call checkXCVR
  iceutil dstats ^aux1 disks
  set gc.AUXU1.v disks.used
  iceutil dstats ^aux2 disks
  set gc.AUXU2.v disks.used
  report flush
 endif

elseif msg.name eqs "GETLOG"
  set msg.data reg.logger.getLast

elseif msg.name eqs "EVNT"
  if runmode eqss "RECWB" then
    set reg.spw1.archiver.event gc.EVNT.v
    set reg.spw2.archiver.event gc.EVNT.v
  endif

elseif msg.name eqs "ACTION"
  if msg.data eqss "START" then
    call picstart
  elseif msg.data eqss "MON" then
    call picstop
    set gc.MODE.v "Monitor"
    call picsetup
    call picstart msg.info
  elseif msg.data eqss "REC" then
    call picstop
    set gc.MODE.v "RecWB"
    call picsetup
    call picstart msg.info
  elseif msg.data eqs "STOP" then
    call picstop
    set gc.MODE.v "Setup"
  elseif msg.data eqss "EXIT" then
    call picstop
    set gc.MODE.v "ExitNow"
    pipe stop
  endif

elseif msg.name eqs "MODE"
  if msg.data eqss "MON" or msg.data eqss "PROC" or msg.data eqss "REC" or msg.data eqss "SNAP" then
    call picstop
    call picsetup
    call picstart
  elseif msg.data eqs "SETUP" then
    call picstop
  elseif msg.data eqs "STATUS" then
    picd get card status
    set gc.MODE.v lmode
  elseif msg.data eqs "EXIT" then
    if /noexitmenu istrue and msg.quals.actiontype eq 0 then
      warn "Exit button has been disabled - use launch window"
      set gc.MODE.v lmode
    else
      call picstop
      pipe stop
    endif
  else
    warn "Option ^msg.data not available yet on this devICE"
    gc/temp/timeout=2 alert ,,, "Option ^msg.data not available yet on this devICE"
    set gc.MODE.v lmode
  endif
  set lmode "^gc.MODE.v"
  if lmode subs "SETUP,EXIT" then
    set gc.FUNC.title "Function"
  else
    set gc.FUNC.title "Op=^lmode"
  endif

elseif msg.name eqss "SPOT"
  call setSPOT

elseif msg.name eqss "AFUNC"
  if msg.data eqs "STATUS" then
    pic status ^card
  elseif msg.data eqss "SCAN" then
    sedit msg.data l:bsel "TRIM" "-"
    if msg.data eqss "ScanNB" then
      set freq gc.XFREQ^{bsel}.v+(tfreq^bsel/1e6)
      sigscan/bg/rffreq=^freq nbfile^bsel
    elseif msg.data eqss "ScanSnap" and lafns fexists then
      set freq gc.SNAPCF.v
      sigscan/bg/rffreq=^freq lafns
    elseif gc.SPOT.v eqss "TIVO" and selidx gt 0 then
      set freq gc.XFREQ^{bsel}.v
      sigscan/bg/rffreq=^freq "^{lafn^bsel}_^selidx"
    elseif gc.MODE.v neqss "RECNB" and gc.MODE.v neqss "MON" then
      set freq gc.XFREQ^{bsel}.v
      sigscan/bg/rffreq=^freq wbfile^bsel
    else
      warn "Must be in Process, SpecWB, RecWB or RecNB mode first"
      set gc.AFUNC.v "Error"
      return
    endif
  elseif msg.data eqss "SNAP-" then
    sedit msg.data l:bsel "TRIM" "-"
    timex now curtime
    set gc.SNAPST.v curtime.sec
    call genLAFN gc.SNAPFN.v curtime gc.SNAPCF.v
    set lafns lafn
    info "Starting SNAPSHOT on file=^lafn dur=^gc.SNAPTD.v at ^curtime"
    set reg.SPN^{bsel}.rffreqkwo gc.SNAPCF.v
    set reg.SPN^{bsel}.gpw gc.PROG
    invoke reg.SPN^{bsel}.startArchiver(^lafns,0,^gc.SNAPTD.v)
    set gc.SNAP.v "Open"
  elseif msg.data eqss "SAVECFG-" then
    sedit msg.data l:bsel "TRIM" "-"
    call saveBoT ^bsel gc.CFGFN.v
  elseif msg.data eqss "LOADCFG-" then
    sedit msg.data l:bsel "TRIM" "-"
    call loadBoT ^bsel gc.CFGFN.v
    if msg.quals.actiontype eq 0 then set gc.SPOT.action "BOT-^ii"
  else
    warn "Must select a BoT|TiVo|Snap view for ^msg.data function"
    set gc.AFUNC.v "Error"
    return
  endif
  set gc.AFUNC.v "Done"

elseif msg.name eqss "CFGFN" then
  info "The LoadCfg/SaveCfg functions will now use this file=^gc.CFGFN.v"

elseif msg.name eqss "COMSCAN" then
  if "-" subs msg.name then
    sedit msg.name ii "TRIM" "-" ""
    call commitBoT ii msg.data.file
  elseif gc.SPOT.v eqss "BOT" then
    sedit gc.SPOT.v ii "TRIM" "-" ""
    call commitBoT ii msg.data.file
  else
    warn "Must select BoT view to submit SCAN list"
  endif

elseif msg.name eqss "HOLD" then
  call setHold 

elseif msg.name eqs "AGCM" or msg.name eqs "AGCW" &
    or msg.name eqs "AGCL" or msg.name eqs "AGCLN" &
    or msg.name eqs "MING" or msg.name eqs "MINGN" &
    or msg.name eqs "MAXG" or msg.name eqs "MAXGN" then
  call setAGC

elseif msg.name eqs "ICONCLICKED" then
  if msg.data.pane eqs "LIST" then
  elseif msg.data.pane eqss "WBLP" then
    sedit msg.data.pane l:ii "TRIM" "WBLP" 
    if msg.data.icon starts "DUP" then 
      set l:jj 3-ii
      set gc.XFREQ^{ii}.action gc.XFREQ^{jj}.v 
    elseif msg.data.icon starts "ID" then 
      sigscan/bg lafns
    elseif msg.data.icon starts "HOLD" then
      set gc.HOLD.action gc.HOLD.v+ii
    elseif msg.data.icon starts "HELD" then
      set gc.HOLD.action gc.HOLD.v-ii
    elseif msg.data.icon starts "SCAN" and parent eqs "SNAPAPP" then
      sendto "PARENT.MAIN" "GTASK" "SCAN-^ii"
    elseif msg.data.icon starts "SCAN" then
      sendto "MAIN" "AFUNC" "SCANWB-^ii"
    elseif msg.data.icon starts "SNAP" then
      sendto "MAIN" "AFUNC" "SNAP-^ii"
    endif
  endif 

elseif msg.name eqs "EXPA" and msg.data lt 0 then
  set l:ii -msg.data
  if specan then
    set reg.svip^{ii}.npkp 0
    pause 0.2
    set reg.svip^{ii}.npkp npkh
  else
    set reg.fftw^{ii}.nexp 0
    pause 0.2
    set reg.fftw^{ii}.nexp nexp
  endif
  set gc.ADLM^{ii}.v reg.spw^{ii}.ADLM	! report adlm

elseif msg.name eqs "EXPA" and msg.data lt 0 then
  set l:ii -msg.data
  if specan then
    if calc(ii,1,BAND) then set reg.svip1.npkp 0
    if calc(ii,2,BAND) then set reg.svip2.npkp 0
    pause 0.2
    if calc(ii,1,BAND) then set reg.svip1.npkp npkh
    if calc(ii,2,BAND) then set reg.svip2.npkp npkh
  else
    if calc(ii,1,BAND) then set reg.fftw1.nexp 0
    if calc(ii,2,BAND) then set reg.fftw2.nexp 0
    pause 0.2
    if calc(ii,1,BAND) then set reg.fftw1.nexp nexp
    if calc(ii,2,BAND) then set reg.fftw2.nexp nexp
  endif
  set gc.ADLM^{ii}.v reg.spw^{ii}.ADLM	! report adlm

elseif msg.name eqs "EXPA"
  set nexp gc.EXPA.v
  if nexp gt 1 set nzexp nexp
  foreach id inlist "fftw1,fftw2,svi1,svi2"
    if reg.^id rexists then set reg.^{id}.nexp nexp
  endfor

elseif msg.name eqs "SPECAN"
  call setNPKH
  if reg.svip1 rexists then set reg.SVIP1.npkp npkh
  if reg.svip2 rexists then set reg.SVIP2.npkp npkh
  if gc.SPECAN.v neqs "Off" and specan isfalse then
    call picrestart "SPECAN"
  elseif gc.SPECAN.v eqs "Off" and specan istrue then
    call picrestart "SPECAN"
  endif

elseif msg.name eqs "MFTHR"
  if reg.svis1 rexists then set reg.SVIS1.thresh msg.data
  if reg.svis2 rexists then set reg.SVIS2.thresh msg.data
elseif msg.name eqs "MFMIN"
  if reg.svis1 rexists then set reg.SVIS1.tmin msg.data
  if reg.svis2 rexists then set reg.SVIS2.tmin msg.data

elseif msg.name eqs "NFFT" or msg.name eqs "CHNS" &
    or msg.name eqs "DSPR" or msg.name eqs "PSDA"  &
    or msg.name eqs "RATE" or msg.name eqs "FORMAT" then
  if msg.name eqs "RATE" then
    call setTrim 1
    call setTrim 2
  endif
  call picrestart msg.name

elseif msg.name eqss "MGAIN" then
  sedit msg.name l:ii "TRIM" "MGAIN" ""
  if reg.spw^{ii} rexists set reg.spw^{ii}.gain gc.MGAIN^{ii}.v

elseif msg.name eqss "MFREQ" then
  sedit msg.name l:ii "TRIM" "MFREQ" ""

elseif msg.name eqss "XCVR" then
  sedit msg.name l:ii "TRIM" "XCVR" ""
  sedit msg.data xcvr "GSUB" "  " " " "SUBS" " LO=" ":" "SUBS" " IF=" ":" "TRIM" "" " " "SUBS" "Clear" ""
  if xcvr eqss "LNB" then
    sedit msg.data d:rf1 "TRIM" "LO=" " "
    sedit msg.data d:rf2 "TRIM" "(" "-"
    if rf2 gt rf1 then sedit xcvr xcvr "APPEND" ">"
    if rf2 le rf1 then sedit xcvr xcvr "APPEND" "<"
  endif
  if ii eq 3 then
    set gc.XCVR1.v xcvr
    set gc.XCVR2.v xcvr
    call setTrim 1
    call setTrim 2
  else
    set gc.XCVR^{ii}.v xcvr
    call setTrim ii
  endif
  call picrestart msg.name

elseif msg.name eqss "XFREQ" then
  sedit msg.name l:ii "TRIM" "XFREQ" ""
  call setTrim ii
  if reg.spw^ii rexists then
    set reg.spw^{ii}.rffreq msg.data
    sendto "MAIN" "EXPA" -ii 
  endif

elseif msg.name eqss "XATTN" then
  sedit msg.name l:ii "TRIM" "XATTN" ""
  if reg.spw^ii rexists set reg.spw^{ii}.rfattn msg.data

elseif msg.name eqs "OVER" then
  call setTrim 1 1
  call setTrim 2 1

elseif msg.name eqs "TUNE" then
!  call doTune msg.data.freq 

elseif msg.name eqs "TUNER" then
  do ii 1 2
    calc d:xfreq msg.data.freq gc.XFREQ^{ii}.v*1e6 -
    if asel gt 0 and ii neq asel then continue
    if xfreq lt -srate/2 or xfreq gt srate/2 then continue
    call doTuner ii xfreq msg.data.bw
  enddo

elseif msg.name eqs "SCANUP" then
  if gc.SPOT.v eqss "BOT-^msg.info" then
    iceutil SCANUP ^msg.data fnt
    if fnt fexists sendto "LIST" "OPENFILE" fnt info=1
  endif

elseif msg.name eqs "MARK" then
  if msg.fid eqss "APLX" and gc.SPOT.v eqss "TIVO" then
    sedit gc.SPOT.v l:ii "TRIM" "-"
    calc l:selidx msg.data.y file(fnp).yd / round 1 +
    sendto "LIST" "SELECTROW" selidx
  elseif runmode eqs "DONESNAP" and msg.fid eqss "WBRP" then
    sedit msg.fid ii "TRIM" "P" "" 
    call setPlots ii msg.data.y
  elseif msg.info neq 101 then	! not SHIFT-LM click
    sedit msg.fid ii "TRIM" "P" ""
    calc gc.QFREQ^{ii}.v msg.data.x/1e6 gc.XFREQ^{ii}.v +
    if parent eqs "SNAPAPP" sendto "PARENT.MAIN" "CLICKRF" gc.QFREQ^{ii}.v info=ii
  elseif msg.fid eqss "WBLP" or msg.fid eqss "WBRP" then
    sedit msg.fid ii "TRIM" "P" "" 
    set tfreq msg.data.x
    set xfreq gc.XFREQ^{ii}.v*1e6
    set gc.SNAPCF.v (xfreq+tfreq)/1e6
    set tfreq^ii tfreq
    set ff^{ii}.x tfreq
    if tuners gt 0 then
      set reg.SPN^{ii}.freq tfreq
    endif
    if selidx gt 0 then
      set file(tuncfg^ii).data(selidx-1,"FREQ") gc.SNAPCF.v
      sendto list "FILES" "REREAD"
    endif
  endif

elseif msg.name eqs "DRAGBOX" then
  if msg.fid eqss "APLX" then
    say "Got TiVo Drag ^msg.data"
  elseif msg.info neq 101 then	! SHIFT-LM drag
    ! ignore all other drags
  elseif msg.fid eqss "WBLP" or msg.fid eqss "WBRP" then
    sedit msg.fid ii "TRIM" "P" 
    calc tfreq msg.data.xmin msg.data.xmax + 2 / 
    calc tbw msg.data.xmax-msg.data.xmin 
    if parent eqs "SNAPAPP" then
      set d:xfreq gc.XFREQ^{ii}.v*1e6
      sendto parent "DRAGBOX" {FREQ=^tfreq,BW=^tbw,XFREQ=^xfreq} info=ii
    endif
    call doTuner ii tfreq tbw
  endif

elseif msg.fid eqs "LIST" then
  !say "Got a LIST message ^msg.name = ^msg.data"
  if msg.name eqs "SELECT" then
    call doSelect msg.data
  elseif msg.name eqs "UPDATE" then
    call doUpdate msg.data
  endif

elseif msg.name eqs "GSCALE" or msg.name eqs "GRANGE" then
  set d:smax gc.GSCALE.v
  set d:smin gc.GSCALE.v-gc.GRANGE.v
  invoke reg.wblp1.setY(smax,smin)
  invoke reg.wblp2.setY(smax,smin)
  invoke reg.wbrp1.setZ(smax,smin)
  invoke reg.wbrp2.setZ(smax,smin)

elseif msg.name eqss "NTC" then
  if gc.MODE.v neqs "SETUP" then
    warn "Must be in SETUP mode to use this configuration option"
  elseif gc.NTC.v gt ntcm then
    warn "Maximum number of tuner channels in this configuration is ^ntcm"
  elseif gc.NTC.v neq ntc then
    set l:ntc ^gc.NTC.v
    set l:ntbc ntc/2
  endif

elseif msg.name eqss "CONFIG" then
  if msg.data eqs "~SHOW" then
    set reg.panel.toggleborders 0x4
  elseif msg.data eqs "REREAD" then
    sendto list "FILES" "REREAD"
  elseif msg.data eqs "SAVE" then
    gc/temp file "CFG_SAVE" "Save Config File" cfgfn "sensor_cfg_*"
  elseif gc.MODE.v neqs "SETUP" then
    warn "Must be in SETUP mode to use this configuration option"
  elseif msg.data eqs "LOAD" then
    gc/temp file "CFG_LOAD" "Load Config File" "^cfgfn" "sensor_cfg_*"
  endif

elseif msg.name eqss "RECONFIG" then
  call reconfig msg.data

elseif msg.name eqss "EXTRACT" then
  set gc.PROG.v 0
  set ii msg.info
  icearchive/bg "EXTRACT" lafn^ii ,,,,, gc.PROG /tbl=^msg.data

elseif msg.name eqss "AAUX" then
  set l:aux1 gc.AAUX1.v
  set l:aux2 gc.AAUX2.v

elseif msg.fid eqs "RMIF" then		! handle server/client messaging
  if msg.name eqs "OPEN"
    info "Got open ^msg.data from ^msg.fid"
  elseif msg.name eqs "OPENED"
    info "Got opened ^msg.data from ^msg.fid"
    pause 0.5  ! make sure plots are up
    set gc.COMP.action "PLOT"
  elseif msg.name eqs "CLOSE"
    info "Got close ^msg.data from ^msg.fid"
  elseif msg.name eqs "CLOSED"
    info "Got closed ^msg.data from ^msg.fid"
  endif

elseif msg.name eqs "GET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    if gc.^key rexists then
      set sets.^key gc.^{key}.value
    else
      set sets.^key ^key
    endif
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "RET" then		! client side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.value "^sets.^key"
  endfor

elseif msg.name eqs "SET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.action "^sets.^key"
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "ACK" then		! client side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.value "^sets.^key"
  endfor

elseif msg.name eqs "EXIT"
  pipe stop

else
  ! the rest need no other action
  !say "Unhandled message ^msg.name"
endif
return

procedure doTuner l:ii d:tfreq d:tbw
set d:xfreq gc.XFREQ^{ii}.v*1e6
set gc.SNAPCF.v (tfreq+xfreq)/1e6
set gc.SNAPBW.v tbw/1e6
set gc.SNAP.v "Closed"
if gc.SPOT.v eqss "BOT" and selidx gt 0 then
  set file(tuncfg^ii).data(selidx-1,"FREQ") gc.SNAPCF.v
  set file(tuncfg^ii).data(selidx-1,"BW") gc.SNAPBW.v
  sendto list "FILES" "REREAD"
endif
call restartTuner ii tfreq tbw
return

procedure doSelect t:tab
if asel le 0 return
if gc.SPOT.v eqss "BOT" and tab.TYPE eqs "ROW" then
  set selidx tab.ROW
  if tab.ROW gt 0 then
    set d:xfreq gc.XFREQ^{asel}.v*1e6
    calc tfreq tab.VALUE.FREQ*1e6 xfreq -
    calc tbw tab.VALUE.BW*1e6 
    call restartTuner asel tfreq tbw
  endif
endif
return

procedure doUpdate t:tab
if asel le 0 return
if gc.SPOT.v eqss "BOT" and tab.TYPE eqs "CELL" and tab.ROW gt 0 then
  if tab.NAME eqs "BW" then
    calc tbw tab.VALUE*1e6 
    call restartTuner asel tfreq^{asel} tbw
  elseif tab.NAME eqs "FREQ" then
    set d:xfreq gc.XFREQ^{asel}.v*1e6
    calc tfreq tab.VALUE*1e6 xfreq -
    set ff^{asel}.x tfreq
    set reg.SPN^{asel}.freq tfreq
  endif
endif
return

procedure setNPKH
  set l:npkh 0
  if gc.SPECAN.v eqs "LOW"  then set l:npkh 1
  if gc.SPECAN.v eqs "MED"  then set l:npkh 5
  if gc.SPECAN.v eqs "HIGH" then set l:npkh 10
  if gc.SPECAN.v eqs "MAX"  then set l:npkh -1
return

procedure setHold 
set val gc.HOLD.v
if /stepscan then
 if val eq 1 or val eq 3
  set reg.panel.panes.wblp1.setIconBar "Held,Dup2,Scan,Snap,ID"
 else
  set reg.panel.panes.wblp1.setIconBar "Hold,Dup2,Scan,Snap,ID"
 endif
 if val eq 2 or val eq 3
  set reg.panel.panes.wblp2.setIconBar "Held,Dup1,Scan,Snap,ID"
 else
  set reg.panel.panes.wblp2.setIconBar "Hold,Dup1,Scan,Snap,ID"
 endif
else
  set reg.panel.panes.wblp1.setIconBar "Scan,Snap,ID"
  set reg.panel.panes.wblp2.setIconBar "Scan,Snap,ID"
endif
return

procedure setSPOT 	! Signal Plot on Top
set l:asel 0
set l:selidx 0
sendto "LIST" "DESELECT" "" info=0
sendto "LIST" "OPENFILE" "" info=0
sendto "APLX" "OPENFILE" "" info=-1
set reg.panel.panes.list.title "^gc.SPOT.v List"
set reg.panel.panes.aplx.title "^gc.SPOT.v Plot"
if gc.SPOT.v eqs "NONE" then
  set reg.panel.borders "-Top"
  set gc.SNAP.v "Hidden"
  return
endif
set reg.panel.borders "+Top"
set gc.SNAP.v "Closed"
sedit gc.SPOT.v l:asel "TRIM" "-"
if gc.SPOT.v eqss "TIVO" then
  set fnt "^{lafn^asel}_toc"
  set fnp "^{lafn^asel}_psd"
  sendto "LIST" "OPENTEMPLATE" "nxm.ice.cfg.tivolist.tbl"
  if fnt fexists sendto "LIST" "OPENFILE" fnt info=0
  if fnp fexists sendto "APLX" "OPENFILE" fnp info=-1
elseif gc.SPOT.v eqss "BOT" then
  set fnt "^tuncfg^asel"
  set fnp "_cbnf^asel"
  sendto "LIST" "OPENTEMPLATE" "nxm.ice.cfg.senslist.tbl"
  if fnt fexists sendto "LIST" "OPENFILE" fnt info=1
  if fnp fexists sendto "APLX" "OPENFILE" fnp info=-1
elseif gc.SPOT.v eqss "SCAN" then
  set fnp "_cbwfs^asel"
  if fnp fexists sendto "APLX" "OPENFILE" fnp info=-1
elseif gc.SPOT.v eqss "SNAP" then
  set fnp "^{gc.SNAPFN.v}_psd"
  if fnp fexists sendto "APLX" "OPENFILE" fnp info=-1
endif
return

procedure checkXCVR 
return

procedure makeBoTs
call makeBoT 1
call makeBoT 2
return

procedure makeBoT l:ii
erase/all/warn=n tuncfg^ii
header/create tuncfg^ii sr=(ENA/SL,FREQ/SF,BW/SF,SNR/SF,MOD/1A,BAUD/SF,SPEC/SF,FMT/1A)
file open/d/w iwt tuncfg^ii
do nn 0 ntbc-1
  file write iwt {ENA=0,FREQ=0.0,BW=1.0,SNR=0,MOD=?,BAUD=0,SPEC=0,FMT=Auto}
enddo
file close iwt
header tuncfg^ii size=ntbc
return

procedure commitBoT l:ii cs:fname
info "Committing list=^fname to BoT-^ii"
call makeBoT ii
set d:xfreq gc.XFREQ^{ii}.v*1e6
set px1 p^{ii}x1+xfreq
set px2 p^{ii}x2+xfreq
set l:osize 0 
status fname size=isize
file open/d iwc fname
file open/d/w iwt tuncfg^ii
do nn 1 isize
  set t:tab iwc.dataTable(nn-1)
  set freq tab.FREQ*1e6
  if tab.ena le 0 or freq lt px1 or freq gt px2 continue
  file write iwt tab
  set l:osize osize+1
  if osize ge ntbc break
enddo
file close iwt
file close iwc
set gc.SPOT.action "BOT-^ii"
return

procedure saveBoT l:ii cs:fname
sedit fname fname "TRIM" "sigcfg_" "." "PREPEND" "sigcfg_" "APPEND" ".txt"
file open/t/n tf fname
file write tf "ENA\tFREQ\tBW\tSNR\tMOD\tBAUD\tSPEC\tFMT"
set size file(tuncfg^ii).size
foreach nn insize size
  set t:tab file(tuncfg^ii).dataTable(nn)
  file write tf "^tab.ENA\t^tab.FREQ\t^tab.BW\t^tab.SNR\t^tab.MOD\t^tab.BAUD\t^tab.SPEC\t^tab.FMT"
endfor
file close tf
info "BoT-^ii config saved to file=^fname"
return

procedure loadBoT l:ii cs:fname
!sedit fname fname "TRIM" "" "." "APPEND" ".txt"
convert/parse fname T2B tuncfg^ii "L|F|F|F|A8|F|F|A8" 1
header tuncfg^ii sr(1)="(ENA,)" sr(2)="(FREQ,)" sr(3)="(BW,)" sr(4)="(SNR,)" sr(5)="(MOD,)" sr(6)="(BAUD,)" sr(7)="(SPEC,)" sr(8)="(FMT,)"
info "BoT-^ii config loaded from file=^fname"
return

procedure makeRFins
set rfins "Bypass"
foreach id intf nxm.ice.cfg.rfinputs.txt
  sedit rfins rfins "APPEND" "," "APPEND" id
endfor 
return

procedure handleTheme
switch "THEME" theme get env.theme
if theme eqss "GEAR" then
  set plotopts "+contrast"
else
  set plotopts "-contrast"
endif
return

procedure setTrimX l:ii
set d:srate ^gc.RATE.v*1e6
if gc.OVER.v eqs "SHOW" then
  calc p^{ii}x1 -^gc.RATE.v/2 gc.XFREQ^{ii}.v + 1e6 *
  calc p^{ii}x2  ^gc.RATE.v/2 gc.XFREQ^{ii}.v + 1e6 *
else
  switch "TRIM"  d:trim get (-gc.RATE.v*.4,gc.RATE.v*.4)
  calc p^{ii}x1 trim(0) gc.XFREQ^{ii}.v + 1e6 *
  calc p^{ii}x2 trim(1) gc.XFREQ^{ii}.v + 1e6 *
endif
if _cbwf^ii fexists then
  header _cbwf^ii xs=gc.XFREQ^{ii}.v*1e6-(srate/2)
  sendto wblp^ii "OPENFILE" "_cbwf^ii" info=-1
  sendto wbrp^ii "OPENFILE" "_cbwf^ii" info=-1
endif
return

procedure setTrim l:ii l:tmode
set d:srate ^gc.RATE.v*1e6
set d:xoff gc.XFREQ^{ii}.v*1e6
if gc.OVER.v eqs "SHOW" then
  calc p^{ii}x1 -^gc.RATE.v/2 1e6 *
  calc p^{ii}x2  ^gc.RATE.v/2 1e6 *
else
  switch "TRIM"  d:trim get (-gc.RATE.v*.4,gc.RATE.v*.4)
  calc p^{ii}x1 trim(0) 1e6 *
  calc p^{ii}x2 trim(1) 1e6 *
endif
if reg.wblp^{ii} rexists then
  set reg.wblp^{ii}.mp.xOff xoff
  set reg.wbrp^{ii}.mp.xOff xoff
endif
if tmode gt 0 then
  sendto wblp^ii "OPENFILE" "_cbwf^ii" info=-1
  sendto wbrp^ii "OPENFILE" "_cbwf^ii" info=-1
endif
return

procedure setPlots l:ii d:yval l:init
set fna "^{psdfile^{ii}}f"
set fni "^{psdfile^{ii}}i"
calc l:iy yval file(fna).ys - file(fna).yd / round 0 max file(fna).size-1 min
noop fna(iy:iy+1) fni
header fni fs=0
if init gt 0 then
  sendto wblp^ii "OPENFILE" fni info=-1
  sendto wbrp^ii "OPENFILE" fna info=-1
else
  sendto wblp^ii "FILE" "REREAD"
endif
return

procedure reconfig t:tbl
set gc.PROG.v 0
info "Got reconfig msg: ^tbl"
set gc.PROG.v 1
return

procedure genLAFN cs:afn o:time l:freq 
  set lafn afn
  if "DATE" subs gc.AMODE.v set lafn "^{lafn}_^curtime.tofilename"
  if "MJS" subs gc.AMODE.v set lafn "^{lafn}_^l:curtime.getmjs"
  if "FREQ" subs gc.AMODE.v set lafn "^{lafn}_^{freq}"
  if "F&D" subs gc.AMODE.v set lafn "^{lafn}_^{freq}_^curtime.tofilename"
  if "CNT" subs gc.AMODE.v set lafn "^{lafn}_^gc.ARCHCNT.v"
  if "TIVO" subs gc.AMODE.v set lafn "^{lafn}_tv"
return
