startmacro u:tname s:entry
  ! make sure they've specified a file name
  if tname eqs "" then
    explain icefat
    stop
  endif

  ! make sure the file exists
  if ^tname fexists then
    ! get table from name (check validity)
    table tab load/t ^tname
    if tab isnull then
      error "Table file (^tname) format is invalid"
      stop
    endif
  else
    error "Table file (^tname) does not exist"
    stop
  endif
  
  ! default entry to all 
  if entry eqs "" then
    set entry "ALL"
  endif

  ! check switches
  switch "PLOTSON" po get "plotsoff" "plotson"
  switch "CABLELOSS" cl get 0

  ! set homepath
  home fat ice

  ! count the tests
  assert/init=g_status
  ! look for the test 'all' case
  if entry eqs all then
    foreach casename intable tab
      if CASE subs casename then 
        if ( ^{tab.snapset.enabletc} eq 0 ) AND ( ( TIME subs casename ) OR ( TRIG subs casename ) ) then 
          say "Skipping ^casename (ENABLETC==0)"
        else 
          call runTest casename
        endif
      endif
    endfor
  else 
    call runTest entry
  endif

  ASSERT/TID="ALL"/TOTAL=TESTALL/STAT=asdf

  if g_status.all.test_count eq 0 then 
    assert/text="No tests were run" 1 eq 0
  elseif g_status.all.fail_count eq 0 then
    say "Success! Passed ^g_status.all.pass_count out of ^g_status.all.test_count tests!"
  else
    say "Warning! Failed ^g_status.all.fail_count tests!"
    say "Passed ^g_status.all.pass_count out of ^g_status.all.test_count tests!"
  endif

  home restore

endmacro

procedure runTest s:case_ent
  ! read the 1st entry
  call readEntry mtbl1 tab case_ent
  ! make sure it exists
  if (mtbl1 rexists) isfalse then
    error "Entry ^entry does not exist"
    stop
  endif

  ! determine if this is a dual or single case
  if mtbl1 contains dual then 
    ! read the 2nd entry based upon the 1st entry
    call readEntry mtbl2 tab ^mtbl1.dual
    if (mtbl2 rexists) isfalse then
      error "Entry ^mtbl1.dual does not exist"
      stop
    endif
    ! look for card/module/tuner
    do anum 3 this.args.size 1
      set ckey this.args.getkey(anum)
      set carg this.args.geto(anum)
      if ckey eqs card1 then
        set mtbl1.card carg
      elseif ckey eqs port1 then
        set mtbl1.port carg
      elseif ckey eqs card2 then
        set mtbl2.card carg
      elseif ckey eqs port2 then
        set mtbl2.port carg
      elseif ( pic subs carg ) AND ( ^anum eq ^{this.args.size} ) then 
        set mtbl1.card carg
        set mtbl2.card carg
      else 
        warn "valid arguments: card1=,card2=,port1=,port2="
      endif
    enddo
    say "CARD1=^{mtbl1.card},PORT1=^{mtbl1.port},CARD2=^{mtbl2.card},PORT2=^{mtbl2.port}"
    if mtbl1.flags eqs "" then
      if 1 subs mtbl1.port then 
        set mtbl1.flags "IOM1=^{mtbl1.iom}|IOM2=NONE"
      else
        set mtbl1.flags "IOM1=NONE|IOM2=^{mtbl1.iom}"
      endif
    endif
    if mtbl2.flags eqs "" then
      if 1 subs mtbl2.port then 
        set mtbl2.flags "IOM1=^{mtbl2.iom}|IOM2=NONE"
      else
        set mtbl2.flags "IOM1=NONE|IOM2=^{mtbl2.iom}"
      endif
    endif
    %testdualmodules/^po mtbl1 mtbl2
  else 
    ! look for card/module/tuner
    do anum 3 this.args.size 1
      set ckey this.args.getkey(anum)
      set carg this.args.geto(anum)
      if (ckey eqs card) OR (pic subs carg) then
        set mtbl1.card carg
      elseif (ckey eqs port) OR (module subs carg) OR (tuner subs carg) then
        set mtbl1.port carg
      else 
        warn "valid arguments: card=,port="
      endif
    enddo
    say "CARD=^{mtbl1.card},PORT=^{mtbl1.port}"
    if mtbl1.flags eqs "" then
      if 1 subs mtbl1.port then 
        set mtbl1.flags "IOM1=^{mtbl1.iom}|IOM2=NONE"
      else
        set mtbl1.flags "IOM1=NONE|IOM2=^{mtbl1.iom}"
      endif
    endif
    %testmodule/^po mtbl1 cl
  endif

return

! returns a table with all the keys filled out
procedure readEntry s:out t:tab s:cstr
  ! make sure the entry exists
  if tab contains cstr then
    res t:ctbl ^{tab.^cstr}
  elseif tab contains "case_^{cstr}" then
    res t:ctbl ^{tab.case_^cstr}
  else 
    return 
  endif
  
  ! check for defaults (snapset)
  if tab contains snapset then
    res ^out ^tab.snapset
  else 
    table ^out CREATE {}
  endif

  ! now overwrite defaults with user defaults
  foreach key intable ctbl
    res ^{out}.^key "^{ctbl.^key}"
  endfor
return 
