
/*
   Special /dev/mem capability for raw RAM access on Linux

   Author: Jeff Schoen

*/

#include <sys/capability.h>

int main (int argc, char *argv[])
{
  int status;
  pid_t pid;
  cap_t cap;
  cap_value_t rawio = CAP_SYS_RAWIO;
  cap_value_t setpcap = CAP_SETPCAP;

  pid = getppid();
  if (argc==2) pid = atoi(argv[1]);
  printf("Setting RAWIO on pid=%d\n",pid);

  cap = cap_init();
  status = capgetp(0,cap);
  if (status!=0) printf("Could not get PID capability\n");
  status = cap_set_flag(cap,CAP_EFFECTIVE,1,&setpcap,CAP_SET);
  if (status!=0) printf("Could not set SETPCAP effective flag\n");
  status = capsetp(0,cap);
  if (status!=0) printf("Could not set SETPCAP capability\n");

  cap = cap_init();
  status = capgetp(pid,cap);
  if (status!=0) printf("Could not get PPID capability\n");
  status = cap_set_flag(cap,CAP_INHERITABLE,1,&rawio,CAP_SET);
  if (status!=0) printf("Could not set RAWIO inheritable flag\n");
  status = cap_set_flag(cap,CAP_EFFECTIVE,1,&rawio,CAP_SET);
  if (status!=0) printf("Could not set RAWIO effective flag\n");
  status = capsetp(pid,cap);
  if (status!=0) printf("Could not set RAWIO capability\n");
  return 0;
}

