#define FPQC_NUM_PRG_BITS 32 
#define PIC3_MBT3_FPQC_MAX_INRATE  100000000 
#define PIC3_MBT3_FPQC_MAX_OUTRATE 40000000 
#define FPQC_REF_FREQ           10000000 
#define MODRESET_REMOVE         0x00000001  /* This one must be in config word to remove reset/allow start */ 
#define USEFPDPTTLCLK           0x00000008  /* Use This For FPDP TTL Clk-Remove for FPDP or QC64 PECL CLK  */ 
#define USEQC64DATA             0x00000080  /* Use This For or Output                           */ 
#define ENDIAN_CONV1            0x00000200  /* Endian Convert Bit 1                             */
#define ENDIAN_CONV0            0x00000100  /* Endian Convert Bit 0                             */ 
 
int_4 pic_setup_fpqc (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{ 
  int reg=0; 
  int_u4 clkprg = 0; 
  int_u4 fpqc_cfg_bits = 0; 
  
  if ((p->type == ICEPIC3) || (p->type == ICEMBT3) || (p->type == ICEPIC4) || (p->type == ICEMBT4)) {   
    if (((dir < 0) && (rate > PIC3_MBT3_FPQC_MAX_INRATE)) || ((dir > 0) && (rate > PIC3_MBT3_FPQC_MAX_OUTRATE)) ) { 
      if (dir > 0) printf("%s%d%s\n","Output Rate Too High!!! Limit = ",PIC3_MBT3_FPQC_MAX_OUTRATE," Hz");  
      else printf("Input Rate Too High For PIC3T Or MBT3 Card\n");  
      return(-1); 
    } 
    else  { 
      if (mport == 2) {       
        if (dir > 0) clkprg = calc_synthetic_clkbits(FPQC_REF_FREQ,rate*2,0 ); /* Double Clock For Output */    
        else clkprg = calc_synthetic_clkbits(FPQC_REF_FREQ,rate,0); 
 
        fpqc_cfg_bits = clkprg | MODRESET_REMOVE | USEFPDPTTLCLK; /* Turn Off Reset USE FPDP TTL Clk*/ 
            
        /* Be sure we don't use FPDP TTL Clk for QC64 */ 
        if ((fpqc_cfg_bits & USEQC64DATA) != 0) fpqc_cfg_bits = fpqc_cfg_bits & (~USEFPDPTTLCLK); 
                    
        vprint("Setup FPQC port=%d cfgbits=%d\n",mport,fpqc_cfg_bits); 
        pic_wmodreg(p,2,0,fpqc_cfg_bits,FPQC_NUM_PRG_BITS);   /* Configuration ALWAYS VIA PORT 2 */ 
        udelay(10000);
      }  
    }   
  } 
  else { 
    printf("Only PIC3T and MBT3 cards supported with FPQC module\n"); 
    return(-1); 
  }  
  return 0; 
} 
 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define PIC_MBT3_FPDP_MAX_RATE 100000000
#define FPDP_REF_FREQ           10000000
#define FPDP_NUM_PRG_BITS 32

int_4 pic_setup_fpdp (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
  int reg=0;
  int_u4 clkprg = 0;
  int_u4 fpdp_cfg_bits = 0;

     
    if (rate > PIC_MBT3_FPDP_MAX_RATE) {
      printf("Input Rate Too High For PIC3 or MBT3 Card Type\n");  
      return(-1);
    }  
    else {
      if (dir > 0) {
        clkprg = calc_synthetic_clkbits(FPDP_REF_FREQ,rate, 0);
        vprint("FPDP Rate = %d\n",rate);
      } 
      else {
        clkprg = calc_synthetic_clkbits(FPDP_REF_FREQ,rate + 5000000,0);
        vprint("FPDP Rate = %d\n",rate + 5000000);
      }
      vprint("FPDP: Clk Program Bits = %08x\n",clkprg);                     
      fpdp_cfg_bits = clkprg | 0x00000001; /* Turn Off Reset */
    }  
  
  vprint("Setup FPDP port=%d cfgbits=%d\n",mport,fpdp_cfg_bits);
  pic_wmodreg(p,mport,0,fpdp_cfg_bits,FPDP_NUM_PRG_BITS);  
  return 0;
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define  D2PSE_NUM_PRG_BITS 32
/* #define  D2PSE_FLAG_ENABLE   1 */
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_reset_d2pse (PICSTRUCT *p, int_4 mport)
{
   pic_wmodreg(p,2,0,0x00000000,D2PSE_NUM_PRG_BITS);  /* Put Side A In Reset */
   pic_wmodreg(p,2,1,0x00000000,D2PSE_NUM_PRG_BITS);  /* Put Side B In Reset */
   return 0;
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_d2pse (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{

   int_u4 d2pse_cfg_bits = 0;
#ifdef D2PSE_FLAG_ENABLE    
    int i;
    i=findintflag("MODSLV",p->config); 
    if (i >= 0)
      d2pse_cfg_bits = (i<<1) | 0x00000008;  /* Enable Slave, & Slave Number */

    i=findintflag("MODMST",p->config); 
    if (i >= 0)
      d2pse_cfg_bits = (i<<1) | 0x00000010;  /* Enable Master, & Master Number */
#else
    d2pse_cfg_bits = (gain << 1) & 0x0000001F;
#endif 
     
   
   pic_wmodreg(p,2,0,0x00000000,D2PSE_NUM_PRG_BITS);  /* Put Side A In Reset */
   pic_wmodreg(p,2,1,0x00000000,D2PSE_NUM_PRG_BITS);  /* Put Side B In Reset */
 
   
   vprint("Setup D2PSE port=%d cfgbits=%d\n",mport,0x00000001);
   pic_wmodreg(p,2,0,d2pse_cfg_bits | 0x00000001,D2PSE_NUM_PRG_BITS);  /* Remove Side A Reset */
   pic_wmodreg(p,2,1,d2pse_cfg_bits | 0x00000001,D2PSE_NUM_PRG_BITS);  /* Remove Side B Reset */  
   return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
   /* Divsel[1..0] bits always set to [00] for Refclk = RcvClk/8        */
   /* Other Values Available If RefClk On Board Is Not RcvClk/8         */
   /* [00]   RefClk = RcvClk/8      */
   /* [01]   RefClk = RcvClk/16     */
   /* [10]   RefClk = RcvClk/10     */
   /* [11]   RefClk = RcvClk/20     */

   /* Freqsel{2..0] bits set to [010] For RcvClk = 188Mhz to 313Mhz     */
   /* Other Values Available If RcvClk Is Not 188MHz<=RcvClk<=313MHz    */
   /* [000] 750MHz<=RcvClk<=1250MHz */       
   /* [100] 375MHz<=RcvClk<=625MHz  */
   /* [010] 188MHz<=RcvClk<=313MHz  */
   /* [110] 125MHz<=RcvClk<=208MHz  */
   /* [001]  94MHz<=RcvClk<=157MHz  */
   /* [101]  63MHz<=RcvClk<=104MHz  */
   /* [011]  47MHz<=RcvClk<=78MHz   */
   /* [111]  32MHz<=RcvClk<=52MHz   */
#define CDR2D_NUM_PRG_BITS 32
#define CDR2D_SYSREGADR             1
#define CDR2D_CDRCFGREGADR          2 
#define CDR2D_BITSWALLADR           4
#define RESET_BIT          0x00000001 
#define DIVSEL0_BIT        0x00000002
#define DIVSEL1_BIT        0x00000004
#define FREQSEL0_BIT       0x00000008
#define FREQSEL1_BIT       0x00000010
#define FREQSEL2_BIT       0x00000020
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_reset_cdr2d (PICSTRUCT *p, int_4 mport)
{
  pic_wmodreg(p,mport,0,CDR2D_SYSREGADR,CDR2D_NUM_PRG_BITS);       /* Put Module In Reset                  */
  pic_wmodreg(p,mport,0,0,CDR2D_NUM_PRG_BITS);  
  return 0;
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_cdr2d (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{   
   int cdr2d_cfg_bits = DIVSEL0_BIT;                          /* Line Rate = RefClk * 16              */    
  
   pic_wmodreg(p,mport,0,CDR2D_SYSREGADR,CDR2D_NUM_PRG_BITS);       /* Put Module In Reset                  */
   pic_wmodreg(p,mport,0,0,CDR2D_NUM_PRG_BITS);  

   rate = rate * 2;                                           /* Add Man II Encoding Factor           */

   if ((rate >= 93750000) && (rate <= 156250000))             /* 50.2MHz Upper Limit For PIC4T        */
     cdr2d_cfg_bits = cdr2d_cfg_bits | 0;                     /* Set For 375MHz<=RcvClk<=625MHz       */
   else if ((rate >= 46880000) && (rate <= 78120000))         /* 8 x This Rate = 188 to 313 Line Rate */
     cdr2d_cfg_bits = cdr2d_cfg_bits | FREQSEL2_BIT;          /* Set For 188MHz<=RcvClk<=313MHz       */
   else
     {
       printf("Data Rate Not SOFTWARE Supported!\n");
       printf("Acceptable Data Rate 1 =  46.88MHz <= rate <= 50.2MHz  OR\n");
       printf("Acceptable Data Rate 2 =  23.5MHz <= rate <= 39.12MHz\n");
       return(-1);
     }    

   pic_wmodreg(p,mport,0,CDR2D_CDRCFGREGADR,CDR2D_NUM_PRG_BITS);    /* Write CDR Cfg Info To Reg            */ 
   pic_wmodreg(p,mport,0,cdr2d_cfg_bits,CDR2D_NUM_PRG_BITS);   

   pic_wmodreg(p,mport,0,CDR2D_SYSREGADR,CDR2D_NUM_PRG_BITS);       /* Remove Reset                         */ 
   pic_wmodreg(p,mport,0,RESET_BIT,CDR2D_NUM_PRG_BITS);      
       
   return(0);    
} 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define ESXDR1_NUM_PRG_BITS        32
#define ESXDR1_SYSCFG_INDEX        0x00000000
#define ESXDR1_GENCFG_INDEX        0x10000000
#define ESXDR1_SCLKCFG_INDEX       0x20000000
#define ESXDR1_PHASECFG_INDEX      0x30000000
#define ESXDR1_SWALLCFG_INDEX      0x40000000
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_esxdr1 (PICSTRUCT *p, int_4 mport,int_u4 dis_enable)
{
   /* Set System Reg = 0, Module In Reset  */
   pic_wmodreg(p,mport,0,ESXDR1_SYSCFG_INDEX,ESXDR1_NUM_PRG_BITS);
   if (dis_enable != 0)
      {
        /* If Enabling Remove Reset  */
        pic_wmodreg(p,mport,0,ESXDR1_SYSCFG_INDEX|0x01,ESXDR1_NUM_PRG_BITS);       
      }
   
   return (0);
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 esxd_wmodreg_si5326 (PICSTRUCT *p, int_4 mport,int_u4 value)
{   
   
   pic_wmodreg(p,mport,0,ESXDR1_SCLKCFG_INDEX|((value >> 8) & 0x000000FF),ESXDR1_NUM_PRG_BITS);        /* Write Addr    */   
   udelay(1000);
   pic_wmodreg(p,mport,0,ESXDR1_SCLKCFG_INDEX|(value & 0x000000FF) | 0x00004000,ESXDR1_NUM_PRG_BITS);  /* Write Data    */  
   udelay(1000);
   return 0;    
} 

int_4 pic_setup_esxdr1(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate,int_4 gain,int_4 bits)
 {
   Si5326_Reg_Obj Si5326_Reg;
   int i,ii;
   int_u4 gen_cfg_reg = 0;
   int clksrc         = 3;  /* 0-Syn Clk From On-Board Crystal  */
                            /* 1-Syn Clk From Ext Ref           */
                            /* 2-NOT USED                       */
                            /* 3-Clk From Ext Input--Default    */

  /* Set System Reg = 0, Module In Reset  */
   pic_wmodreg(p,mport,0,ESXDR1_SYSCFG_INDEX,ESXDR1_NUM_PRG_BITS);

   if (dir<=0)
     {
       esxd_wmodreg_si5326 (p,mport,0x00008880);     /* Put Si5326 In Reset    */

       if (findflag("MSBFIRST",p->config) >= 0)     
          gen_cfg_reg = gen_cfg_reg | 0x00000002;    /* Receive Data MSB First */

       pic_wmodreg(p,mport,0,ESXDR1_GENCFG_INDEX|gen_cfg_reg,ESXDR1_NUM_PRG_BITS);        /* Write General Config Reg */ 

     } 
   else
     {                   
       if ((i=findflag("MUXCLK",p->config)) >= 0)
         {
           if (p->config[i+6]!='=') ;
             else if (p->config[i+7]=='P') 
               {
                 clksrc = 0;
                 if (findflag("PREFX",p->config) >= 0)
                   {
                     clksrc = 1;                     /* Set Clock Source To PLL With Ext Ref Frequency */

                    /*
                     ii = findintflag("PREFX",p->config);   
                     if (ii <= 1)
                       printf("\nWARN: Must Specify PREFX Flag As PREFX=<freq>, Assuming %d MHz\n",A2DR11_REF_OSC/1000000); 
                     else
                      reffreq = ii;                
                    */
                   }          
               } 
            else if ((p->config[i+7]=='A') && (mport == 1));
            else if ((p->config[i+7]=='B') && (mport == 2));
            else if (p->config[i+7]=='N');          
            else 
              {
                printf("Illegal MUXCLK=%c flag - ignored\n",p->config[i+7]);
                printf("Allowable Clock Choices: MUXCLK=");
                if (mport != 2)  
                  printf("A,");
                if (mport != 1)
                  printf("B,");          
                printf("N,P,or P w/flag PREFX\n");
              } 
         }


        if (clksrc != 0)
          gen_cfg_reg = gen_cfg_reg | 0x00000001;    /* Use Ext Ref or Ext Clk  */
        if (findflag("MSBFIRST",p->config) >= 0)     
          gen_cfg_reg = gen_cfg_reg | 0x00000002;    /* Transmit Data MSB First */
        pic_wmodreg(p,mport,0,ESXDR1_GENCFG_INDEX|gen_cfg_reg,ESXDR1_NUM_PRG_BITS);        /* Write General Config Reg */ 
        udelay(1000);    

      /* Setup Clock Synthesizer */
       if (clksrc == 3)  /* Bypass to External Clock */
         {                   
           esxd_wmodreg_si5326 (p,mport,0x00008880);  /* Put Device In Reset     */
           esxd_wmodreg_si5326 (p,mport,0x00008800);  /* Remove Reset            */
           esxd_wmodreg_si5326 (p,mport,0x00000639);  /* Set LVDS,Disable Out Level  */
           esxd_wmodreg_si5326 (p,mport,0x0000157C);  /* ClkSel[1..0] Reg Active */
           esxd_wmodreg_si5326 (p,mport,0x00000345);  /* Set Clk2 Input Select   */       
           esxd_wmodreg_si5326 (p,mport,0x00000016);  /* Set Bypass Bit          */
         }
       else              /* Normal Clock selection   */
         {            
           Si5326_Reg.debuglevel = -1;
           Si5326_Reg.fref   =  10000000.0;
           Si5326_Reg.dclk1  = ((real_8) rate) * 8.0; /* Change To Bit Rate   -- This Clock Not Used   */
           Si5326_Reg.dclk2  = ((real_8) rate) * 8.0; /* Change To Bit Rate      */   
           Si5326_Reg.dwght1 = 1.0;
           Si5326_Reg.dwght2 = 1.0;   
           ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_ESXDR1);
           ii = si5326_regcfg_bwsel(&Si5326_Reg,7);                            
           ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2); /* Ext Ref Or On-Board Ref PLL  */           
           ii = si5326_regcfg_dividers(&Si5326_Reg);
           if (ii != 0)
             printf("D2ES Warning: Sample rate not possible. Using %f\n",Si5326_Reg.fclk2);
           si5326_regcfg_debug(&Si5326_Reg);
           for(i=0; i<Si5326_Reg.numreg; i++) 
             esxd_wmodreg_si5326 (p,mport,Si5326_Reg.regval[i]);
         }

            
     }
       
   return(0);
 } 
