#define STRATIX_UID_HIWORD    0x524D0000   /* Upper Word User ID String           */
#define STRATIX_1S10F484_ID   0x020010DD   /* D2PSE-Marc Y. Serializer            */
#define STRATIX_1S25F780_ID   0x020030DD   /* SonetR4 & SonetR5  Pins AG11        */
#define STRATIX_2S15F484_ID   0x020910DD   /* A2DR9,SDDSR5    Pins-G9,H9,R15,T15  */
#define STRATIX_2SGX60D_ID    0x020E20DD   /* FLZRXD-Stratix II GX                */
#define STRATIX_3SL50F484_ID  0x021080DD   /* EP3SL50F484   Device                */
#define STRATIX_4S40G2F40_ID  0x024410DD   /* EP4S40G2F40   Device                */ 
#define STRATIX_4S40G2F40_ID2 0x024010DD   /* EP4S40G2F40   Device                */
#define STRATIX_5SGXMAH2F35C2 0x029270DD   /* 5SGXMAH2F35C2 Device                */            
#define CYCLONE_EP4CGX22_ID   0x028120DD   /* EP4CGX22 JTAG IDCODE                */ 
#define ARRIA10_ID            0x02EE20DD   /* ARRIA 10 IDCODE                     */

/* A2DR9   G9 = 0, H9  = 0, R15 = 1, T15 = 0 */
/* SDDSXD  G9 = 1, H9  = 0, R15 = 1, T15 = 0 */
/* SonetR4 AG11 = 0 */
/* SonetR5 AG11 = 1 */
int_4 detect_rumel_mods (PICSTRUCT *p) 
{
  int_4 i,j,k,data[68];
  int_u1 modvalue;
  int_4 usridcode,port;
  int_4 idcode[2];

/* 
  now in icelib called before rumlib
  p->mtype[0] = IOMT_UNKNOWN;
  p->mtype[1] = IOMT_UNKNOWN;
*/
  if (!p->isY) return(0);   
  

  for (port=0;port<2;port++)
    {
      if (p->mtype[port]!=IOMT_UNKNOWN) continue;
      pic_jtag (p, port+1, JTAG_EPC2CMD_IDCODE, idcode+port, -32, 0); 
  
      if (idcode[port]==0x010020DD)
        {   
          p->mtype[port] = IOMT_DR2D;
          p->mrev[port]  = 5;    
        }
     } 

  for (i=0; i<p->miom; i++)
   {  
     if (p->mtype[i]!=IOMT_UNKNOWN) continue;
     pic_jtag (p, i+1, JTAG_CMD_IDCODE, idcode+i, -32, 0); 
     
     /* printf(" ID code = %x Port = %d\n",idcode[i],i); */    

     if (idcode[i]==-1) p->mtype[i] = IOMT_NONE;

#ifndef TGIGEXD
     if ((idcode[i]==0) && (p->mtype[i] == IOMT_UNKNOWN))
      {
       j = (i==1)? PPC_HYPB_CTL : PPC_HYPA_CTL;
       k = pic_acmd (p,ADON_RD,j>>2,0,4);
       k = k>>16; /* signature is now in byte 3 of stat */
       if (k!=0) 
       { 
         p->mtype[i] = (k&0x10)? (k&0xF) : -(k&0xF);
         p->mrev[i] = (k>>5)&0x1F;
       }
   /*    printf("Type = %d Rev = %d\n",p->mtype[i],p->mrev[i]);   */ 

       if (p->mtype[i]==IOMT_E2D || p->mtype[i]==IOMT_D2E) p->mrev[i]=5;
      } 
#endif

   }

  if ((p->mtype[0] != IOMT_UNKNOWN) && (p->mtype[1] != IOMT_UNKNOWN))
    return(0);
 
  for (port=0;port<2;port++)
   {
     if (idcode[port] ==  STRATIX_3SL50F484_ID)
       { 
        pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
        
        if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /*-See If Mod Already Programmed */ 
           {
             if ((usridcode & 0x0000FFFF) == 0)                      /* Last 16 Bits = 0 For ES2D     */ 
               {                 
                 p->mtype[port] = IOMT_ES2D;   
                 p->mrev[port]  = 1;
               }  
             else if ((usridcode & 0x0000FFFF) == 1)                 /* Last 16 Bits = 0 For D2ES     */ 
               {
                 p->mtype[port] = IOMT_D2ES;   
                 p->mrev[port]  = 1;
               }  
             else
               p->mtype[port]   = IOMT_UNKNOWN;
           }
        else
           {
             pic_jtag (p, port+1, JTAG_STXCMD_SAMPLE, data, -36*32, 0);
             modvalue  = (data[19] >>  4) & 0x08;  /* N6  Pin  615=19R7  */
             modvalue |= (data[19] >>  2) & 0x04;  /* H9  Pin  612=19R4  */
             modvalue |= (data[19] >> 30) & 0x02;  /* R15 Pin  639=19R31 */
             modvalue |= (data[19] >> 28) & 0x01;  /* T15 Pin  636=19R28 */
    
         /*    printf("Mod Value = %02x \n",modvalue);                           */
         /*    for (i=0; i<36; i++) printf("BScan %04d = %08x\n",i*32,data[i]);  */
   
             if (modvalue == 10)
               {
                 p->mtype[port] = IOMT_ES2D;   
                 p->mrev[port]  = 1;
               }
             else if (modvalue  == 8)
               {  
                 p->mtype[port] = IOMT_D2ES;   
                 p->mrev[port]  = 1;
               } 
             else
               p->mtype[port]   = IOMT_UNKNOWN;
           }
       } 
     else if (idcode[port] == ARRIA10_ID)
       {
         pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
         if(usridcode == 0x524D0001) {
           /* A2DM20 */
           p->mtype[0] = IOMT_A2D;
           p->mrev[0]  = 20;
           p->mtype[1] = IOMT_A2D;
           p->mrev[1]  = 20;
         } else if(usridcode == 0x524D0000) {
           /* Old A2DM20 */
           p->mtype[0] = IOMT_A2D;
           p->mrev[0]  = 19;
           p->mtype[1] = IOMT_A2D;
           p->mrev[1]  = 19;
         } else if(usridcode == 0x524D0002) {
           /* D2AWGM4 */
           p->mtype[0] = IOMT_D2AWG;
           p->mrev[0]  = 4;
           p->mtype[1] = IOMT_D2AWG;
           p->mrev[1]  = 4;
         } else if(usridcode == 0xFFFFFFFF) {
           pic_jtag (p, port+1, JTAG_STXCMD_SAMPLE, data, -36*32, 0);
           modvalue  = (data[2]  >> 29) & 0x01;  /* K2 Pin (93) */
           modvalue |= (data[2]  >> 23) & 0x02;  /* J3 Pin (87) */
           modvalue |= (data[18] >>  6) & 0x04;  /* G3 Pin (582) */
           modvalue |= (data[18] >>  3) & 0x08;  /* H3 Pin (579) */
           if(modvalue == 0xF) {
             /* Old A2DM20 */
             p->mtype[0] = IOMT_A2D;
             p->mrev[0]  = 19; /* We could make this 19 and get rid of om20 flag */
             p->mtype[1] = IOMT_A2D;
             p->mrev[1]  = 19;
           } else if(modvalue == 0xE) {
             /* A2DM20 */
             p->mtype[0] = IOMT_A2D;
             p->mrev[0]  = 20;
             p->mtype[1] = IOMT_A2D;
             p->mrev[1]  = 20;
           } else if(modvalue == 0xD) {
             /* D2AWGM4 */
             p->mtype[0] = IOMT_D2AWG;
             p->mrev[0]  = 4;
             p->mtype[1] = IOMT_D2AWG;
             p->mrev[1]  = 4;
           }
         }
         return(0);
       }
     else if (idcode[port] == STRATIX_1S10F484_ID)
       { 
         p->mtype[0] = IOMT_D2PSE;                                   /* Marc Y. Serializer-Special Module            */
         p->mtype[1] = IOMT_D2PSE;         
         return(0);                                                  /* Set Both Module Types-Break Out Of port Loop */
       }
     else if (idcode[port] == CYCLONE_EP4CGX22_ID)
      {        
        pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
        if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /*-See If Mod Already Programmed */ 
          {
            if ((usridcode & 0x0000FFFF) == 1)                 /* Last 16 Bits = 2 For D2AR9 */
              {  
                p->mtype[port] = IOMT_SDDSXD;
                p->mrev[port]  = 6;
              }
            else if ((usridcode & 0x0000FFFF) == 2)                 /* Last 16 Bits = 2 For D2AR9 */
              {  
                p->mtype[port] = IOMT_UFLZXD;
                p->mrev[port]  = 1;
              }
           }
        else
          {
            p->mtype[port] = IOMT_SDDSXD;
            p->mrev[port]  = 6;
          } 
      }  
     else if (idcode[port] == STRATIX_2S15F484_ID)
      {
        pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
        if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /*-See If Mod Already Programmed */ 
           {
             if ((usridcode & 0x0000FFFF) == 0)                      /* Last 16 Bits = 0 For A2DR9    */ 
               {
                 p->mtype[port] = IOMT_A2D;   
                 p->mrev[port]  = 9;                     
               }   
             else if ((usridcode & 0x0000FFFF) == 1)                 /* Last 16 Bits = 1 For SDDSXDR5 */
               {  
                 p->mtype[port] = IOMT_SDDSXD;
                 p->mrev[port]  = 5;
               }
             else if ((usridcode & 0x0000FFFF) == 2)                 /* Last 16 Bits = 2 For D2AR9 */
               {  
                 p->mtype[port] = IOMT_D2A;
                 p->mrev[port]  = 9;
               }
             else if ((usridcode & 0x0000FFFF) == 3)
               {
                 p->mtype[port] = IOMT_A2D;   
                 p->mrev[port]  = 10;  
               }
             else if ((usridcode & 0x0000FFFF) == 4)
               {
                 p->mtype[0] = p->mtype[1] = IOMT_A2D;
                 p->mrev[0]  = p->mrev[1] = 11;
               }
             else if ((usridcode & 0x0000FFFF) == 5)
               {
                 p->mtype[port] = IOMT_LB2D;   
                 p->mrev[port]  = 2;  
               }
             else if ((usridcode & 0x0000FFFF) == 6)
               {
                 p->mtype[port] = IOMT_A2D;   
                 p->mrev[port]  = 13;  
               }
             else if ((usridcode & 0x0000FFFF) == 7)
               {
                 p->mtype[port] = IOMT_D2AWG;   
                 p->mrev[port]  = 1;  
               }
             else if ((usridcode & 0x0000FFFF) == 8)
               {
                 p->mtype[port] = IOMT_D2AWG;   
                 p->mrev[port]  = 2;  
               }
             else
               p->mtype[port]   = IOMT_UNKNOWN;
             
           }
         else
           { 
             pic_jtag (p, port+1, JTAG_STXCMD_SAMPLE, data, -36*32, 0);
             modvalue  = (data[7]  >> 22) & 0x01;  /* G9  Pin  */
             modvalue |= (data[7]  >> 18) & 0x02;  /* H9  Pin  */
             modvalue |= (data[27] >> 10) & 0x04;  /* R15 Pin  */
             modvalue |= (data[26] >> 23) & 0x08;  /* T15 Pin  */

   /* 
             printf("Mod Value = %02x \n",modvalue);
             for (i=0; i<36; i++) printf("BScan %04d = %08x\n",i*32,data[i]); 
   */

             if (modvalue == 4)
               {
                 if (((data[6] >> 12) & 0x00000001) == 0) /* Check Pin A7, 0 For A2DR9, 1 For D2AR9 */
                   {
                     p->mtype[port] = IOMT_A2D;   
                     p->mrev[port]  = 9;
                   }
                 else
                    {  
                     p->mtype[port] = IOMT_D2A;
                     p->mrev[port]  = 9;
                    } 
               }
             else if (modvalue  == 7)
               {  
                 p->mtype[port] = IOMT_A2D;
                 p->mrev[port]  = 13;
               }
             else if (modvalue  == 5)
               {  
                 p->mtype[port] = IOMT_SDDSXD;
                 p->mrev[port]  = 5;
               }
             else if (modvalue  == 8)
               {  
                 p->mtype[port] = IOMT_D2AWG;                      
                 p->mrev[port]  = 1;
               }
             else if (modvalue  == 9)
               {  
                 p->mtype[port] = IOMT_D2AWG;                      
                 p->mrev[port]  = 2;
               }
             else if (modvalue  == 12)
               {  
                 p->mtype[port] = IOMT_A2D;
                 p->mrev[port]  = 10;
               }
             else if (modvalue  == 14)
               {  
                 p->mtype[0] = p->mtype[1] = IOMT_A2D;
                 p->mrev[0]  = p->mrev[1] = 11;
               }
             else if (modvalue  == 13)
               {  
                 p->mtype[port] = IOMT_LB2D;                      
                 p->mrev[port]  = 2;
               } 
 
             else 
               p->mtype[port]   = IOMT_UNKNOWN;           
          }
      }
     else if (idcode[port] == STRATIX_2SGX60D_ID)
      {
        pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
        if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /* See If Mod Already Programmed */ 
          {
            if ((usridcode & 0x0000FFFF) == 0x0001)                 /* Last 16 Bits = 0x0001 For FLZRXD */ 
              {
                p->mtype[0] = IOMT_FLZRXD;
                p->mrev[0]  = 1;
                p->mtype[1] = IOMT_FLZRXD;
                p->mrev[1]  = 1;
                return(0);                                     /* Set Both Module Types-Break Out Of port Loop */                     
              }   
            else if ((usridcode & 0x0000FFFF) == 0x0002)            /* Last 16 Bits = 0x0002 For TGSDDSXD */
              {  
                p->mtype[0] = IOMT_TGSDDSXD;
                p->mrev[0]  = 1;
                p->mtype[1] = IOMT_TGSDDSXD;
                p->mrev[1]  = 1;
                return(0);                                          /* Set Both Module Types-Break Out Of port Loop */
              }
            else
              p->mtype[port]   = IOMT_UNKNOWN;
          }  
        else
          { 
            pic_jtag (p, port+1, JTAG_STXCMD_SAMPLE, data, -36*32, 0);
            modvalue  = (data[9]  >> 24) & 0x01;   /* K14 Pin  9R25 */
            modvalue |= (data[11] >> 16) & 0x02;   /* L14 Pin 11R18 */
            modvalue |= (data[12] >> 10) & 0x04;   /* L13 Pin 12R13 */
            modvalue |= (data[12] >> 27) & 0x08;   /* T15 Pin 12R31 */
    
        /*    printf("\n\tPort = %d Mod Value = %02x \n",port+1,modvalue);       */  
        /*    for (i=0; i<36; i++) printf("BScan %04d = %08x\n",i*32,data[i]);   */
   
            if (modvalue == 1)
              {
                p->mtype[0] = IOMT_FLZRXD;
                p->mrev[0]  = 1;
                p->mtype[1] = IOMT_FLZRXD;
                p->mrev[1]  = 1;
                return(0);   
              }
            else if (modvalue  == 3)
              {  
                p->mtype[0] = IOMT_TGSDDSXD;
                p->mrev[0]  = 1;
                p->mtype[1] = IOMT_TGSDDSXD;
                p->mrev[1]  = 1;
                return(0);
              } 
          }                                                        /* Set Both Module Types-Break Out Of port Loop */            
      }  
     else if (idcode[port] == STRATIX_1S25F780_ID)
      {
        pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
        if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /*-See If Mod Already Programmed */ 
          {
            if ((usridcode & 0x0000FFFF) == 0x4C49)                 /* Last 16 Bits = 0x4C49 For SNTXDR4 */ 
              {
                 p->mtype[0] = IOMT_SNTXD;
                 p->mrev[0]  = 4;
                 p->mtype[1] = IOMT_SNTXD;
                 p->mrev[1]  = 4;
                 return(0);                                         /* Set Both Module Types-Break Out Of port Loop */                     
              }   
            else if ((usridcode & 0x0000FFFF) == 0x0001)            /* Last 16 Bits = 0x0001 For SNTXDR5            */
              {  
                p->mtype[0] = IOMT_SNTXD;
                p->mrev[0]  = 5;
                p->mtype[1] = IOMT_SNTXD;
                p->mrev[1]  = 5;
                return(0);                                          /* Set Both Module Types-Break Out Of port Loop */
              }
            else
              p->mtype[port]   = IOMT_UNKNOWN;
          }
        else
          { 
            pic_jtag (p,port+1, JTAG_STXCMD_SAMPLE, data, -68*32, 0);
            modvalue = (data[38] >> 26) & 0x01;           /*& AG11 Pin */
 /*   
            printf("Mod Value = %02x \n",modvalue);
            for (i=0; i<68; i++) printf("BScan %04d = %08x\n",i*32,data[i]); 
 */  
            if (modvalue == 0x00)
              {
                 p->mtype[0] = IOMT_SNTXD;
                 p->mrev[0]  = 4;
                 p->mtype[1] = IOMT_SNTXD;
                 p->mrev[1]  = 4;
                 return(0);                /* Set Both Module Types-Break Out Of port Loop */
              } 
            else if  (modvalue == 0x01)
              {
                p->mtype[0] = IOMT_SNTXD;
                p->mrev[0]  = 5;
                p->mtype[1] = IOMT_SNTXD;
                p->mrev[1]  = 5;
                return(0);                 /* Set Both Module Types-Break Out Of port Loop */
              } 
            else
              p->mtype[port]   = IOMT_UNKNOWN;
     
          }  
       }
     else if ((idcode[port] == STRATIX_4S40G2F40_ID) || (idcode[port] == STRATIX_4S40G2F40_ID2))
       {     
   
         pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
         if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /* See If Mod Already Programmed */ 
           {
             if ((usridcode & 0x0000FFFF) == 0x0001)
	       {	
                 p->mtype[0] = IOMT_SNTXD;
                 p->mrev[0]  = 6;
                 p->mtype[1] = IOMT_SNTXD;
                 p->mrev[1]  = 6;
                 return(0); 
	       }
	     else if ((usridcode & 0x0000FFFF) == 0x0002)            /* Last 16 Bits = 0x0002 For TGSDDS            */
               {
                 p->mtype[0] = IOMT_TGSDDSXD;
                 p->mrev[0]  = 2;
                 p->mtype[1] = IOMT_TGSDDSXD;
                 p->mrev[1]  = 2;
                 return(0);
               } 
             else if ((usridcode & 0x0000FFFF) == 0x0003)            /* Last 16 Bits = 0x0002 For TGVITA            */
               {
                 p->mtype[0] = IOMT_TGVITAXD;
                 p->mrev[0]  = 1;
                 p->mtype[1] = IOMT_TGVITAXD;
                 p->mrev[1]  = 1;
                 return(0);
               } 
           }
         else
	   {  
             pic_jtag (p,port+1, JTAG_STXCMD_SAMPLE, data, -68*32, 0);
	     modvalue  = (data[17] >> 23) & 0x01;   /* M13 Pin 17R23 */
             modvalue |= (data[17] >> 25) & 0x02;   /* N13 Pin 17R26 */
             modvalue |= (data[17] >>  9) & 0x04;   /* N15 Pin 17R11 */
             modvalue |= (data[17] >> 11) & 0x08;   /* R14 Pin 17R14 */
   
          /* printf("Mod Value = %02x \n",modvalue);                           */
          /* for (i=0; i<68; i++) printf("BScan %04d = %08x\n",i*32,data[i]);  */
      
	     if (modvalue  == 8)
               {  
                 p->mtype[0] = IOMT_SNTXD;
                 p->mrev[0]  = 6;
                 p->mtype[1] = IOMT_SNTXD;
                 p->mrev[1]  = 6;
                 return(0); 
               }
	     else if (modvalue  == 4)
	       {
                 p->mtype[0] = IOMT_TGSDDSXD;
                 p->mrev[0]  = 2;
                 p->mtype[1] = IOMT_TGSDDSXD;
                 p->mrev[1]  = 2;
                 return(0);
	       }
             else if (modvalue  == 12)
	       {
                 p->mtype[0] = IOMT_TGVITAXD;
                 p->mrev[0]  = 1;
                 p->mtype[1] = IOMT_TGVITAXD;
                 p->mrev[1]  = 1;
                 return(0);
	       }
           }
       }
    else if (idcode[port] == STRATIX_5SGXMAH2F35C2)  
       {

         if (findflag("IOMTYPEOVRD",p->config) >= 0)
           {
             if ((findflag("IOM=SNTXDR7",p->config) >= 0)  || (findflag("IOM=DXSNTR7",p->config) >= 0))    
               {
                  p->mtype[0] = IOMT_SNTXD;
                  p->mrev[0]  = 7;
                  p->mtype[1] = IOMT_SNTXD;
                  p->mrev[1]  = 7;
                  return(0);        
                }
             else if ((findflag("IOM=TGSXDR3",p->config) >= 0) || (findflag("IOM=DXTGSR3",p->config) >= 0))
                {
                  p->mtype[0] = IOMT_TGSDDSXD;
                  p->mrev[0]  = 3;
                  p->mtype[1] = IOMT_TGSDDSXD;
                  p->mrev[1]  = 3;
                  return(0);
                }
             else
               {
                 printf("Warn: IOMTYPEOVER Flag Specified But Valid Stratix V Module Type Not Specified\n");
                 printf("Warn: Using Module Type Detection Instead of Override\n");   
               } 
           }

         pic_jtag (p, port+1, JTAG_STXCMD_UIDCODE,&usridcode,-32,0);  /* Get User ID Code              */
         if ((usridcode & 0xFFFF0000) == STRATIX_UID_HIWORD)          /* See If Mod Already Programmed */ 
           {
             if ((usridcode & 0x0000FFFF) == 0x0001)
	       {	
                 p->mtype[0] = IOMT_SNTXD;
                 p->mrev[0]  = 7;
                 p->mtype[1] = IOMT_SNTXD;
                 p->mrev[1]  = 7;
                 return(0); 
	       }
	     else if ((usridcode & 0x0000FFFF) == 0x0002)            /* Last 16 Bits = 0x0002 For TGSDDS            */
               {
                 p->mtype[0] = IOMT_TGSDDSXD;
                 p->mrev[0]  = 3;
                 p->mtype[1] = IOMT_TGSDDSXD;
                 p->mrev[1]  = 3;
                 return(0);
               } 
             else if ((usridcode & 0x0000FFFF) == 0x0003)            /* Last 16 Bits = 0x0002 For TGVITA            */
               {
                 p->mtype[0] = IOMT_TGVITAXD;
                 p->mrev[0]  = 2;
                 p->mtype[1] = IOMT_TGVITAXD;
                 p->mrev[1]  = 2;
                 return(0);
               } 
           }
         else
	   {  
             pic_jtag (p,port+1, JTAG_STXCMD_SAMPLE, data, -68*32, 0);
	     modvalue  = (data[35] >> 23) & 0x01;   /* B16 Pin 35R23 */
             modvalue |= (data[31] >> 21) & 0x02;   /* B17 Pin 31R22 */
             modvalue |= (data[31] << 1)  & 0x04;   /* B20 Pin 31R1  */
             modvalue |= (data[31] >> 10) & 0x08;   /* B19 Pin 31R13 */
	     modvalue = findintflagdef("MODVALUE",p->config,modvalue);
   
          /* printf("Mod Value = %02x \n",modvalue);                           */                           
          /* for (i=0; i<68; i++) printf("BScan %04d = %08x\n",i*32,data[i]);  */
      
	     if ((modvalue == 8) || (modvalue == 9))
               {  
                 p->mtype[0] = IOMT_SNTXD;
                 p->mrev[0]  = 7;
                 p->mtype[1] = IOMT_SNTXD;
                 p->mrev[1]  = 7;
                 return(0); 
               }
	     else if ((modvalue == 4) || (modvalue == 5))
	       {
                 p->mtype[0] = IOMT_TGSDDSXD;
                 p->mrev[0]  = 3;
                 p->mtype[1] = IOMT_TGSDDSXD;
                 p->mrev[1]  = 3;
                 return(0);
	       }
             else if (modvalue == 12)
	       {
                 p->mtype[0] = IOMT_TGVITAXD;
                 p->mrev[0]  = 2;
                 p->mtype[1] = IOMT_TGVITAXD;
                 p->mrev[1]  = 2;
                 return(0);
	       }
           }
       } 
  
   }
   
  return(0);
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_module_dump (PICSTRUCT *p, int_4 mport, int_4 flag)
{
   int_4 ii,mtype,mrev,mtypeo;

   mtype  = p->mtype[mport-1];
   mrev   = p->mrev[mport-1];
   mtypeo = abs(mtype); /* output form of I or O module */

   if ((mtypeo==IOMT_DXSDDS) && p->isY)
     pic_sdds_dump (p,mport,flag);
   else if ((mtypeo==IOMT_DXSNT) && (mrev==6)  && p->isY)
     pic_sonetr6_dump(p,mport,flag);
   else if ((mtypeo==IOMT_DXSNT) && (mrev==7)  && p->isY)
     pic_sonetr7_dump(p,mport,flag);
   else if ((mtypeo==IOMT_DXTGSDDS) && (mrev>=2) && p->isY)
     pic_tgsxdr2_dump(p,mport,flag);
   else if ((mtypeo==IOMT_DXTGVITA) && (mrev==1) && p->isY)
     pic_tgvxdr1_dump(p,mport,flag);
   else if ((mtypeo==IOMT_D2AWG) && (mrev==2) && p->isY)
     pic_d2awgr2_dump(p,mport,flag);
   else
     printf("Module Side=%d Type=%d Rev=%d does not support register dump\n",mport,mtype,mrev);

   return(0);
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_setkey_module(PICSTRUCT *p, int_4 mport, int_u4 addr, int_u4 value)
{
   
  if (p->mtype[mport-1] == IOMT_D2AWG)
    {
      if (addr == 0)
        d2awg_set_clat(p,mport,value);
    }
  else
    pic_wmodreg (p, mport, addr, value, 32);
               
  return(0);

}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_getkey_module(PICSTRUCT *p, int_4 mport, int_u4 addr)
{
  int_4 value;

  if (((abs(p->mtype[mport-1])) == IOMT_DXTGSDDS) && (p->mrev[mport-1] == 3) && (addr==3) )
    value=0;  /* &BILL - Get Temp Not Avail Yet */
  else if (((abs(p->mtype[mport-1])) == IOMT_DXTGSDDS) && (p->mrev[mport-1] != 1))
    pic_rmodreg(p,mport,0x00040000,(int_u4*)&value,32);
  else if (((abs(p->mtype[mport-1])) == IOMT_DXSNT) && (p->mrev[mport-1] == 7))
    value = pic_sonetr7_getkey(p,mport,addr);
  else if (((abs(p->mtype[mport-1])) == IOMT_DXSNT) && (p->mrev[mport-1] == 6))
    value = pic_sonetr6_getkey(p,mport,addr);
  else 
   pic_rmodreg (p, mport, addr, (int_u4*)&value, 32);

  return(value);

}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 module_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr, int_u2 running)
{
  int_4 stat, mtype = p->mtype[ (mport==2)?1:0 ];
  if (mtype == IOMT_TGVITAXD)      
    stat = vita_join_leave_group (p, mport, joinleave, groupaddr, running);
  else
    stat = sdds_join_leave_group (p, mport, joinleave, groupaddr, running);
  return stat;
}
