/*****************************************************************************/
/*                                                                           */
/* part_ptfd.h                                                                */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_PTFD_H
#define _PART_PTFD_H

#include "part_common.h"

/* PTFD unique part identifier  */
enum PTFD_PART_ID {
  PTID_PTFD = FPGA_PTID_PTFDFIR 
};

/* PTFD Pin control Masks */
enum PTFD_PIN_MASK {
  PTFD_PIN_NULL = 0x00000001   /* Null function place holder */
};

/* PTFD Register ID's */
enum PTFD_RG_ID {
  PTFD_RG_SYS    = 0x00,  /* System register     */
  PTFD_RG_DEC    = 0x01,  /* Decimation register */
  PTFD_RG_TFREQW = 0x02,  /* Actual tuned frequency (whole part) */
  PTFD_RG_TFREQF = 0x03,  /* Actual tuned frequency (fractional part) */
  PTFD_RG_TUNWR  = 0x0F,  /* Tuner FPGA write register */
  PTFD_RG_TOFF   = 0x10   /* Tuner word offset */
};


/* Create register access structure */
#define PTFD_NUM_RG 272

typedef union {
  /* Register values accessed as raw array of signed 32-bit integers */
  uint32_t  rg[PTFD_NUM_RG];
  struct {
    uint32_t system;
    uint32_t dec;
    uint32_t tfreqw;
    uint32_t tfreqf;
    uint32_t dum[11];
    uint32_t tun_wraddr;
    uint32_t twave[256];
  } nm;
} PT_PTFD_REG; 

static const PT_PTFD_REG ptfd_reg_initializer = {
    {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
     0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};

/* PTFD Register Keys and Masks */
enum PTFD_RG_MASK {
  PTFD_RGM_00_EN    = ((int32_t)0x00000001),  /* Filter Enable      */
  PTFD_RGM_01_DEC   = ((int32_t)0x0000000F),  /* Filter Decimation  */
  PTFD_RGM_0F_TDATA = ((int32_t)0xFFFFFFFF)   /* Tuner Word         */
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_ptfd.c */

EXTERN_CDEFINE int32_t pt_ptfd_rgc_default(PT_PTFD_REG *R);
EXTERN_CDEFINE int32_t pt_ptfd_tune(PT_PTFD_REG *S, UDB *rate, UDB *freq);

#endif  /* _PART_PTFD_H */
