/*****************************************************************************/
/*                                                                           */
/* part_adf4350.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_PE4302_H
#define _PART_PE4302_H

#include "part_common.h"

/* PE4302 unique part identifier  */
enum PE4302_PART_ID {
  PTID_PE4302 = FPGA_PTID_PE4302 
};

/* PE4302 Register ID's */
enum PE4302_RG_ID {
  PE4302_RG_00 = 0x00   /* Attenuation */
};

/* Create register access structure */
#define PE4302_NUM_RG 1

typedef union {
  /* Register values accessed as raw array of unsigned 32-bit integers */
  int8_t rg[PE4302_NUM_RG];
  /* Register access by name */
  struct {
    int8_t attn;
  } nm;
} PT_PE4302_REG; 

static const PT_PE4302_REG pe4302_reg_initializer = {
    {0x00}
};

/* PE4302 Register Masks */
enum PE4302_RG_MASK {
  PE4302_RGM_00_ATTN = 0x3F  /* Attenuation */
};

/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_pe4302.c */

EXTERN_CDEFINE int32_t pt_pe4302_rgc_default(PT_PE4302_REG *R);
EXTERN_CDEFINE int32_t pt_pe4302_set_gain(PT_PE4302_REG *S, UDB *gain);

#endif  /* _PART_PE4302_H */
