/*****************************************************************************/
/*                                                                           */
/* part_lmx2582.h                                                             */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_LMX2582_H
#define _PART_LMX2582_H

#include "part_common.h"

/* LMX2582 unique part identifier  */
enum LMX2582_PART_ID {
  PTID_LMX2582 = FPGA_PTID_LMX2582 
};

/* LMX2582 Pin control Masks */
enum LMX2582_PIN_MASK {
  LMX2582_PIN_RESET = 0x00000001   /* Hardware reset pin */
};

enum LMX2582_PARAMS { 
 LMX2582_CONFIG_REGS  = 43
};

int_4 lmx2582_base_table[LMX2582_CONFIG_REGS][2] = {
  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
  {0x30, 0x03FD},{0x2F, 0x08C0},{0x2E, 0x04A1},{0x2D, 0xA120},
  {0x2C, 0x0007},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
  {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x001E},{0x25, 0x4000},
  {0x24, 0x0001},{0x23, 0x0219},{0x22, 0xC3F0},{0x21, 0x4210},
  /* {0x24, 0x0000},{0x23, 0x0019},{0x22, 0xC3D0},{0x21, 0x4210}, */
  {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
  {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
  {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
  {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
  {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
  {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
};

int_4 lmx2582_config_table[26][LMX2582_CONFIG_REGS][2] = {
/* Table 0 */
{   {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0032},{0x25, 0x4000},
    {0x24, 0x0011},{0x23, 0x021F},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7001},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 1 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0040},{0x25, 0x4000},
    {0x24, 0x0448},{0x23, 0x119B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7001},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 2 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0040},{0x25, 0x4000},
    {0x24, 0x0442},{0x23, 0x119B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7001},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 3 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0028},{0x25, 0x4000},
    {0x24, 0x0421},{0x23, 0x029B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7001},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 4 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0020},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x029B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7004},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 5 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0020},{0x25, 0x4000},
    {0x24, 0x0421},{0x23, 0x029B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7004},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 6 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x3FA3},{0x2D, 0x0190},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0018},{0x25, 0x4000},
    {0x24, 0x0042},{0x23, 0x119B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0BDC},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 7 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x3FA3},{0x2D, 0x0190},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0018},{0x25, 0x4000},
    {0x24, 0x0421},{0x23, 0x109B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0BDC},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 8 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x00A3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0014},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x109B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 9 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0014},{0x25, 0x4000},
    {0x24, 0x0401},{0x23, 0x101B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 10 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0AA3},{0x2D, 0x0001},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x0001},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0050},{0x25, 0x4000},
    {0x24, 0x0411},{0x23, 0x021B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x1358},
    {0x09, 0x0B02},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 11 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x04A3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x0001},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x0050},{0x25, 0x4000},
    {0x24, 0x0411},{0x23, 0x101B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x1358},
    {0x09, 0x0B02},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 12 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x04A3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x0001},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x01E0},{0x25, 0x4000},
    {0x24, 0x0411},{0x23, 0x101B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0B02},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 13  - LMXRATE = 4800, CRATE=10 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x01E0},{0x25, 0x4000},
    {0x24, 0x0011},{0x23, 0x021B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0B02},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 14 - LMXRATE = 2400, CRATE=10 */
},{ {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x00CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x01E0},{0x25, 0x4000},
    {0x24, 0x0411},{0x23, 0x021B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x018C},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0B02},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
/* Table 15 - 125MS/sec, 3000MHz DAC clock */
},{ {0x40, 0x00AF}, {0x3E, 0x0000}, {0x3D, 0x0001}, {0x3B, 0x0000},
    {0x30, 0x03FD}, {0x2F, 0x00C0}, {0x2E, 0x0FA2}, {0x2D, 0x0000},
    {0x2C, 0x0000}, {0x2B, 0x0000}, {0x2A, 0x0000}, {0x29, 0x03E8},
    {0x28, 0x0000}, {0x27, 0x8204}, {0x26, 0x012C}, {0x25, 0x5000},
    {0x24, 0x0410}, {0x23, 0x001B}, {0x22, 0xC3F0}, {0x21, 0x4210},
    {0x20, 0x4210}, {0x1F, 0x0201}, {0x1E, 0x0034}, {0x1D, 0x0084},
    {0x1C, 0x2924}, {0x19, 0x0000}, {0x18, 0x0509}, {0x17, 0x8842},
    {0x16, 0x2300}, {0x14, 0x012C}, {0x13, 0x0965}, {0x0E, 0x0423},
    {0x0D, 0x4000}, {0x0C, 0x7001}, {0x0B, 0x0028}, {0x0A, 0x10D8},
    {0x09, 0x0B02}, {0x08, 0x1084}, {0x07, 0x28B2}, {0x04, 0x1943},
    {0x02, 0x0500}, {0x01, 0x0808}, {0x00, 0x221C} 
 },
/* Table 16 - 205MS/sec, 4920MHz DAC clock */
 {  {0x40, 0x00AF}, {0x3E, 0x0000}, {0x3D, 0x0001}, {0x3B, 0x0000},
    {0x30, 0x03FD}, {0x2F, 0x08C0}, {0x2E, 0x20A2}, {0x2D, 0x0000},
    {0x2C, 0x0000}, {0x2B, 0x0000}, {0x2A, 0x0000}, {0x29, 0x03E8},
    {0x28, 0x0000}, {0x27, 0x8204}, {0x26, 0x00F6}, {0x25, 0x5000},
    {0x24, 0x0800}, {0x23, 0x0019}, {0x22, 0xC3D0}, {0x21, 0x4210},
    {0x20, 0x4210}, {0x1F, 0x0401}, {0x1E, 0x0034}, {0x1D, 0x0084},
    {0x1C, 0x2924}, {0x19, 0x0000}, {0x18, 0x0509}, {0x17, 0x8842},
    {0x16, 0x2300}, {0x14, 0x012C}, {0x13, 0x0965}, {0x0E, 0x0423},
    {0x0D, 0x4000}, {0x0C, 0x7001}, {0x0B, 0x0028}, {0x0A, 0x10D8},
    {0x09, 0x0B02}, {0x08, 0x1084}, {0x07, 0x28B2}, {0x04, 0x1943},
    {0x02, 0x0500}, {0x01, 0x0808}, {0x00, 0x221C}
 },
/* Table 17 - 120MS/sec, 2880MHz DAC clock */
 {  {0x40, 0x00AF}, {0x3E, 0x0000}, {0x3D, 0x0001}, {0x3B, 0x0000},
    {0x30, 0x03FD}, {0x2F, 0x00C0}, {0x2E, 0x20A2}, {0x2D, 0x0000},
    {0x2C, 0x0000}, {0x2B, 0x0000}, {0x2A, 0x0000}, {0x29, 0x03E8},
    {0x28, 0x0000}, {0x27, 0x8204}, {0x26, 0x0120}, {0x25, 0x5000},
    {0x24, 0x0410}, {0x23, 0x001B}, {0x22, 0xC3F0}, {0x21, 0x4210},
    {0x20, 0x4210}, {0x1F, 0x0601}, {0x1E, 0x0034}, {0x1D, 0x0084},
    {0x1C, 0x2924}, {0x19, 0x0000}, {0x18, 0x0509}, {0x17, 0x8842}, 
    {0x16, 0x2300}, {0x14, 0x012C}, {0x13, 0x0965}, {0x0E, 0x0423},
    {0x0D, 0x4000}, {0x0C, 0x7001}, {0x0B, 0x0028}, {0x0A, 0x10D8},
    {0x09, 0x0B02}, {0x08, 0x1084}, {0x07, 0x28B2}, {0x04, 0x1943},
    {0x02, 0x0500}, {0x01, 0x0808}, {0x00, 0x221C}
 },

/* Table 18 - 4800MHz DAC clock, 320MHz LMX Reference */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FD},{0x2F, 0x08DE},{0x2E, 0x08A1},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
    {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x049B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
/*
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x0FA3},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0001},{0x23, 0x021F},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x07BC},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x2218}
*/
 },

/* Table 19 - 4800MHz DAC clock, 320MHz LMX Reference, RFB Ena @ Fs/2 */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FC},{0x2F, 0x08CF},{0x2E, 0x0F23},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0801},{0x23, 0x021B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x07BC},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
 },

/* Table 20 - 4800MHz DAC clock, 320MHz LMX Reference, RFB Ena @ Fs */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FD},{0x2F, 0x08DF},{0x2E, 0x0F23},{0x2D, 0x0000},
    {0x2C, 0x0000},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x03E8},
    {0x28, 0x0000},{0x27, 0x8204},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0001},{0x23, 0x021B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0001},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x07BC},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0808},{0x00, 0x221C}
 },

/* Table 21 - 500MHz DAC clock, 320MHz LMX Reference, TEST MODE ONLY! */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    //{0x30, 0x03FC},{0x2F, 0x00DE},{0x2E, 0x1EA1},{0x2D, 0xA120},
    {0x30, 0x03FC},{0x2F, 0x00DE},{0x2E, 0x04A1},{0x2D, 0xA120},
    {0x2C, 0x0007},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
    {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x0018},{0x25, 0x4000},
    {0x24, 0x0C21},{0x23, 0x049B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0601},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
 },

/* Table 22 - 4960MHz DAC clock, 320MHz LMX Reference */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FD},{0x2F, 0x08CF},{0x2E, 0x04A1},{0x2D, 0xA120},
    {0x2C, 0x0007},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
    {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x049B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0401},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
 },

/* Table 23 - 4960MHz DAC clock, 320MHz LMX Reference, MIX PATH ENABLED */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FD},{0x2F, 0x08C0},{0x2E, 0x0421},{0x2D, 0xA120},
    {0x2C, 0x0007},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
    {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x049B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0001},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
 },

/* Table 24 - 5000MHz DAC clock, 320MHz LMX Reference! */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FD},{0x2F, 0x08CF},{0x2E, 0x08A1},{0x2D, 0x8968},
    {0x2C, 0x0009},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
    {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x001E},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x049B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0001},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
 },

/* Table 25 - 4300MHz DAC clock, 320MHz LMX Reference! */
 {  {0x40, 0x00AF},{0x3E, 0x0000},{0x3D, 0x0001},{0x3B, 0x0000},
    {0x30, 0x03FD},{0x2F, 0x08CF},{0x2E, 0x08A1},{0x2D, 0xACFC},
    {0x2C, 0x0006},{0x2B, 0x0000},{0x2A, 0x0000},{0x29, 0x4240},
    {0x28, 0x000F},{0x27, 0x8104},{0x26, 0x001A},{0x25, 0x4000},
    {0x24, 0x0021},{0x23, 0x049B},{0x22, 0xC3F0},{0x21, 0x4210},
    {0x20, 0x4210},{0x1F, 0x0001},{0x1E, 0x0034},{0x1D, 0x0084},
    {0x1C, 0x2924},{0x19, 0x0000},{0x18, 0x0509},{0x17, 0x8842},
    {0x16, 0x2300},{0x14, 0x012C},{0x13, 0x0965},{0x0E, 0x0420},
    {0x0D, 0x4000},{0x0C, 0x7002},{0x0B, 0x0018},{0x0A, 0x10D8},
    {0x09, 0x0302},{0x08, 0x1084},{0x07, 0x28B2},{0x04, 0x1943},
    {0x02, 0x0500},{0x01, 0x0809},{0x00, 0x231C}
} };


#endif  /* _PART_LMX2582_H */
