/*****************************************************************************/
/*                                                                           */
/* part_ads42b49.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_ADS42B49_H
#define _PART_ADS42B49_H

#include "part_common.h"

/* ADS42B49 unique part identifier  */
enum ADS42B49_PART_ID {
  PTID_ADS42B49 = FPGA_PTID_ADS42B49 
};

/* ADS42B49 Pin control Masks */
enum ADS42B49_PIN_MASK {
  ADS42B49_PIN_RESET = 0x00000001   /* Part reset control pin */
};

/* ADS42B49 Register ID's */
enum ADS42B49_RG_ID {
  ADS42B49_RG_00 = 0x00,  /* Reset, readout                      */
  ADS42B49_RG_01 = 0x01,  /* LVDS ctrl                           */
  ADS42B49_RG_03 = 0x03,  /* HP                                  */
  ADS42B49_RG_06 = 0x06,  /* HP                                  */
  ADS42B49_RG_25 = 0x25,  /* CH-A Gain, CH-A Test                */
  ADS42B49_RG_29 = 0x29,  /* Data format                         */
  ADS42B49_RG_2B = 0x2B,  /* CH-B Gain, CH-B Test                */
  ADS42B49_RG_3D = 0x3D,  /* Enable dc offset correction         */
  ADS42B49_RG_3F = 0x3F,  /* Custom pattern                      */
  ADS42B49_RG_40 = 0x40,  /* Custom pattern                      */
  ADS42B49_RG_41 = 0x41,  /* LVDS,CMOS                           */
  ADS42B49_RG_42 = 0x42,  /* Delay                               */
  ADS42B49_RG_44 = 0x44,  /* Enable digital                      */
  ADS42B49_RG_45 = 0x45,  /* STBY,PWRDN                          */
  ADS42B49_RG_BA = 0xBA,  /* HP                                  */
  ADS42B49_RG_BF = 0xBF,  /* CH-A Pedestal                       */
  ADS42B49_RG_C1 = 0xC1,  /* CH-B Pedestal                       */
  ADS42B49_RG_CF = 0xCF,  /* Offset correction timeconst         */
  ADS42B49_RG_D5 = 0xD5,  /* HP                                  */
  ADS42B49_RG_D9 = 0xD9,  /* HP                                  */
  ADS42B49_RG_DB = 0xDB,  /* Low speed CH-B                      */
  ADS42B49_RG_DC = 0xDC,  /* HP                                  */
  ADS42B49_RG_EF = 0xEF,  /* Enable low speed                    */
  ADS42B49_RG_F1 = 0xF1,  /* LVDS swing                          */
  ADS42B49_RG_F2 = 0xF2   /* Low speed CH-A                      */
};


/* ADS42B49 Register Keys and Masks */
enum ADS42B49_RG_MASK {
  ADS42B49_RGM_00_RESET   = 0x02, /* Reset chip to defaults */
  ADS42B49_RGM_00_READOUT = 0x01, /* Readout data           */
  ADS42B49_RGM_25_CHAGAIN = 0xF0, /* CH-A Gain              */
  ADS42B49_RGM_25_CHATEST = 0x03, /* CH-A Test output       */
  ADS42B49_RGM_2B_CHBGAIN = 0xF0, /* CH-B Gain              */
  ADS42B49_RGM_2B_CHBTEST = 0x03, /* CH-B Test output       */
  ADS42B49_RGM_44_ENABLE  = 0x01  /* Enable digital output  */
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_ads42b49.c */


#endif  /* _PART_ADS42B49_H */
