/*****************************************************************************/
/*                                                                           */
/* part_ad6688.h                                                             */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_AD6688_H
#define _PART_AD6688_H

#define AD6688_CLKDIV_SYS_CNTL_REG  0x010A
#define AD6688_CLKDIV_SYS_STAT_REG  0x010B

#define AD6688_SYS1_CNTL_REG  0x0120
#define AD6688_SYS2_CNTL_REG  0x0121
#define AD6688_SYS3_CNTL_REG  0x0122
#define AD6688_SYS4_CNTL_REG  0x0123
#define AD6688_SYS1_STAT_REG  0x0128
#define AD6688_SYS2_STAT_REG  0x0129
#define AD6688_SYS3_STAT_REG  0x012A

#define AD6688_CHIP_MODE_REG  0x0200
#define AD6688_CHIP_DEC_REG   0x0201
#define AD6688_DDCx_OFFSET    0x0020
#define AD6688_MxW_OFFSET     0x0010

#define AD6688_DDC_SYNC_REG   0x0300
#define AD6688_DDC0_CNTL_REG  0x0310
#define AD6688_DDC0_ISEL_REG  0x0311
#define AD6688_DDC0_PINC0_REG 0x0316
#define AD6688_DDC0_PINC1_REG 0x0317
#define AD6688_DDC0_PINC2_REG 0x0318
#define AD6688_DDC0_PINC3_REG 0x0319
#define AD6688_DDC0_PINC4_REG 0x031A
#define AD6688_DDC0_PINC5_REG 0x031B
#define AD6688_DDC0_POFF0_REG 0x031D
#define AD6688_DDC0_POFF1_REG 0x031E
#define AD6688_DDC0_POFF2_REG 0x031F
#define AD6688_DDC0_POFF3_REG 0x0320
#define AD6688_DDC0_POFF4_REG 0x0321
#define AD6688_DDC0_POFF5_REG 0x0322
#define AD6688_DDC0_MAW0_REG  0x0390
#define AD6688_DDC0_MAW1_REG  0x0391
#define AD6688_DDC0_MAW2_REG  0x0392
#define AD6688_DDC0_MAW3_REG  0x0393
#define AD6688_DDC0_MAW4_REG  0x0394
#define AD6688_DDC0_MAW5_REG  0x0395
#define AD6688_DDC0_MBW0_REG  0x0398
#define AD6688_DDC0_MBW1_REG  0x0399
#define AD6688_DDC0_MBW2_REG  0x039A
#define AD6688_DDC0_MBW3_REG  0x039B
#define AD6688_DDC0_MBW4_REG  0x039C
#define AD6688_DDC0_MBW5_REG  0x039D

#define AD6688_PLL_CAL_REG   0x1222
#define AD6688_PLL_START_REG 0x1228
#define AD6688_PLL_LOL_REG   0x1262

#define AD6688_SMPL_MODE_REG 0x0561
#define AD6688_PLL_CNTL_REG  0x056E
#define AD6688_JESD_CTL1_REG 0x0571
#define AD6688_JESD_CTL2_REG 0x0572
#define AD6688_JESD_CTL3_REG 0x0573
#define AD6688_JESD_CTL4_REG 0x0574
#define AD6688_SCR_L_REG     0x058B
#define AD6688_F_REG         0x058C
#define AD6688_K_REG         0x058D
#define AD6688_M_REG         0x058E
#define AD6688_CS_N_REG      0x058F
#define AD6688_SUBCLS_NP_REG 0x0590
#define AD6688_S_REG         0x0591
#define AD6688_HD_CF_REG     0x0592
#define AD6688_JESD_LPD_REG  0x05B0
#define AD6688_JESD_LA1_REG  0x05B2
#define AD6688_JESD_LA2_REG  0x05B3
#define AD6688_JESD_LA3_REG  0x05B5
#define AD6688_JESD_LA4_REG  0x05B6

#define AD6688_SMPL_INV_MASK 0x04 //Sample invert
#define AD6688_SMPL_FMT_MASK 0x03 //2's comp
#define AD6688_PLL_CNTL_MASK 0xF0 //Set Lane rate to (6.75G-13.5G)

#define AD6688_SCR_MASK    0x80   //Enable/Disable Scramble
#define AD6688_L_MASK      0x1F   //JESD204B L
#define AD6688_F_MASK      0xFF   //JESD204B F
#define AD6688_K_MASK      0x1F   //JESD204B K = 33 (JESD204 K + 1)
#define AD6688_M_MASK      0xFF   //JESD204B M = 1
#define AD6688_CS_MASK     0xC0   //JESD204B CS
#define AD6688_N_MASK      0x1F   //JESD204B N
#define AD6688_SUBCLS_MASK 0xE0   //JESD204B Subclass
#define AD6688_NP_MASK     0x1F   //JESD204B N'
#define AD6688_S_MASK      0x1F   //JESD204B S
#define AD6688_HD_MASK     0x80   //JESD204B HD
#define AD6688_CF_MASK     0x1F   //JESD204B CF

#define AD6688_CLKDIV_SYSREF_PHASE_ADJ(x) (((x) & 0x01) << 7) //Clock divider auto phase adjust enable
#define AD6688_CLKDIV_NSKEW(x) (((x) & 0x03) << 2) //Clock divider negative skew window
#define AD6688_CLKDIV_PSKEW(x) (((x) & 0x03) << 0) //Clock divider positive skew window
#define AD6688_CLKDIV_SYSREF_OFF(x) (((x) & 0x0F) << 0) //Clock divider SYSREF offset

#define AD6688_SYSREF_FLG_RST(x) (((x) & 0x01) << 6) //SYSREF +- flag reset
#define AD6688_SYSREF_TRANS_SEL(x) (((x) & 0x01) << 4) //SYSREF +- transition select
#define AD6688_SYSREF_CLK_SEL(x) (((x) & 0x01) << 3) //SYSREF +- CLK edge select
#define AD6688_SYSREF_MODE_SEL(x) (((x) & 0x03) << 1) //SYSREF +- mode select

#define AD6688_CHIP_QIGN(x) (((x) & 0x01) << 5) //Chip Q Ignore
#define AD6688_CHIP_MODE(x) (((x) & 0x0F) << 0) //Chip Application Mode
#define AD6688_CHIP_DEC(x)  (((x) & 0x0F) << 0) //Chip Decimation Ratio

#define AD6688_LANE_RATE(x) (((x) & 0x0F) << 4) //Lane Rate Setting

#define AD6688_SYNC_UMODE(x)   (((x) & 0x01) << 7) //DDC Update Mode
#define AD6688_SYNC_RST(x)     (((x) & 0x01) << 4) //DDC NCO Soft Reset
#define AD6688_SYNC_NEXT(x)    (((x) & 0x01) << 1) //DDC Update Mode
#define AD6688_SYNC_SMODE(x)   (((x) & 0x01) << 0) //DDC Sync Mode

#define AD6688_DDC_MIX_SEL(x)    (((x) & 0x01) << 7) //DDCx Mixer Select
#define AD6688_DDC_GAIN_SEL(x)   (((x) & 0x01) << 6) //DDCx Gain Select
#define AD6688_DDC_IF_MODE(x)    (((x) & 0x03) << 4) //DDCx IF Mode
#define AD6688_DDC_CMPLX_REAL(x) (((x) & 0x01) << 3) //DDCx Complex to Real Enable
#define AD6688_DDC_DEC_SEL1(x)   (((x) & 0x07) << 0) //DDCx Decimation Select 1
#define AD6688_DDC_DEC_SEL2(x)   (((x) & 0x0F) << 4) //DDCx Decimation Select 2
#define AD6688_DDC_QIN_SEL(x)    (((x) & 0x01) << 1) //DDCx Q Input Select
#define AD6688_DDC_IIN_SEL(x)    (((x) & 0x01) << 0) //DDCx I Input Select

#define AD6688_SMPL_INV(x) (((x) & 0x01) << 2) //Sample invert
#define AD6688_SMPL_FMT(x) (((x) & 0x03) << 0) //2's comp
#define AD6688_PLL_CNTL(x) (((x) & 0x0F) << 4) //Set Lane rate to (6.75G-13.5G)

#define AD6688_SCR(x)    (((x) & 0x01) << 7)   //Enable/Disable Scramble
#define AD6688_L(x)      (((x) & 0x1F) << 0)   //JESD204B L
#define AD6688_F(x)      (((x) & 0xFF) << 0)   //JESD204B F
#define AD6688_K(x)      (((x) & 0x1F) << 0)   //JESD204B K = 33 (JESD204 K + 1)
#define AD6688_M(x)      (((x) & 0xFF) << 0)   //JESD204B M = 1
#define AD6688_CS(x)     (((x) & 0x03) << 6)   //JESD204B CS
#define AD6688_N(x)      (((x) & 0x1F) << 0)   //JESD204B N
#define AD6688_SUBCLS(x) (((x) & 0x03) << 5)   //JESD204B Subclass
#define AD6688_NP(x)     (((x) & 0x1F) << 0)   //JESD204B N'
#define AD6688_S(x)      (((x) & 0x1F) << 0)   //JESD204B S
#define AD6688_HD(x)     (((x) & 0x01) << 7)   //JESD204B HD
#define AD6688_CF(x)     (((x) & 0x1F) << 0)   //JESD204B CF

#define AD6688_LAL(x)    (((x) & 0x07) << 0)   //JESD204B Lane Assign Low Lane
#define AD6688_LAH(x)    (((x) & 0x07) << 4)   //JESD204B Lane Assign High Lane

#define AD6688_JESD_SWING1(x) (((x) & 0x03) << 0) //JESD204B voltage swing
#define AD6688_JESD_SWING2(x) (((x) & 0x03) << 4) //JESD204B voltage swing
#define AD6688_JESD_EMPH(x)   (((x) & 0x07) << 4) //JESD204B pre-emphasis

#endif  /* _PART_AD9361_H */

