/****************************************************************************/
/*  UPAC multi-module interface routines                                    */
/****************************************************************************/

#define USB2CMDS "OUT,ACK,DATA0,PING,SOF,NYET,DATA2,SPLIT,IN,NAK,DATA1,PRE,SETUP,STALL,MDATA"
#define USB2_OUT	0x1
#define USB2_ACK	0x2
#define USB2_DATA0	0x3
#define USB2_PING	0x4
#define USB2_SOF	0x5
#define USB2_NYET	0x6
#define USB2_DATA2	0x7
#define USB2_SPLIT	0x8
#define USB2_IN		0x9
#define USB2_NAK	0xA
#define USB2_DATA1	0xB
#define USB2_PRE	0xC
#define USB2_SETUP	0xD
#define USB2_STALL	0xE
#define USB2_MDATA	0xF

int_4 pic_setup_upac (PICSTRUCT *p, int_4 port, int_4 dir, int_4 bits, int_4 rate, int_4 flags) {
  int_4 iadr,mode,funreg=0x41,intreg=0x00,otgreg=0x00,flag,i,ucfg[9];

  iadr = 0x00200000;
  mode = findchoiceflagdef("UPACMODE",p->config,"USB31,USB32,DP1,DP2,USB2,AUX,TGBE,PCIE,USB2LS,USB2FS,USB2HS",7)-1;
  if (mode==8)  { funreg=0x46; mode=4; intreg=1; }	/* LS */
  if (mode==9)  { funreg=0x45; mode=4; intreg=1; }	/* FS */
  if (mode==10) { funreg=0x40; mode=4; intreg=0; }	/* HS */
  intreg = findintflagdef("UPACSM",p->config,intreg);
  if (mode==4) {
    flag=0x0C00; pic_msg (p,0,PKTF_BUS_WR,iadr,&flag,4,0,-1); /* reset command fifos */
    ucfg[0]=0x84; 	/* function register write command */
    ucfg[1]=funreg; 	/* function register value */
    ucfg[2]=0x100;	/* command stop */
    ucfg[3]=0x8A; 	/* OTG register write command */
    ucfg[4]=otgreg; 	/* OTG register value */
    ucfg[5]=0x100;	/* command stop */
    ucfg[6]=0x87; 	/* interface register write command */
    ucfg[7]=intreg; 	/* interface register value */
    ucfg[8]=0x100;	/* command stop */
    for (i=0; i<9; i++) { 
      flag = (ucfg[i]<<16);
      pic_msg (p,0,PKTF_BUS_WR,iadr,&flag,4,0,-1);
      flag |= (i>=3 && i<6)? 0x8000 : 0xC000;	/* OTG=0 disable pulldowns on Host side only. Note that fifo-2 writes to controller-1 */
      pic_msg (p,0,PKTF_BUS_WR,iadr,&flag,4,0,-1); 
    }
    flag=0x0000; pic_msg (p,0,PKTF_BUS_WR,iadr,&flag,4,0,-1);
  }
  flag = (mode<<4)|mode;
  if (intreg==1) flag |= 0x2000;
  if (findintflag("THRU",p->config)==0) flag |= 0x0F00;
  if (findintflag("TRIM",p->config) >0) flag |= 0xF000;
  if (findintflag("CLIP",p->config) >0) flag |= 0x20000;
  if (findintflag("UPACTEST",p->config) >0) flag |= 0x10000;
  i = findintflagdef("TRACE",p->config,0); flag |= (i<<24);
  flag = findintflagdef("UPACFLAG",p->config,flag);
  pic_msg (p,0,PKTF_BUS_WR,iadr,&flag,4,0,-1);
  printf("UPAC mode=%d flag=%08x\n",mode,flag);

  // debug insert mode
  if (flags=99) {

  }

  return 0;
}
int_4 pic_setflag_upac (PICSTRUCT *p, int_4 flag) {
  int_4 iadr = 0x00200000;
  pic_msg (p,0,PKTF_BUS_WR,iadr,&flag,4,0,-1);
  printf("UPAC flag=%08x\n",flag);
  return 0;
}

int_4 pic_test_upac (PICSTRUCT *p, int_4 mode) {
  int ls,i,j,iadr,size=1024,osize=0,tmp[8],ltmp=0,sysreg;
  FILE *fp;
  char fname[80];
  ICEHDR hdr;
  sysreg = pic_setup_upac (p,0,-1,8,60e6,99);
  i = findintflagdef("PAUSE",p->config,3); 
  printf("Starting UPAC test len=%d flags=%s\n",i,p->config);
  pic_acmd (p, ADON_MOD, 3, 0x0001, 0);
  usleep(i*1000000);
  pic_acmd (p, ADON_MOD, 3, 0x0000, 0);
  ls = findstrflag("TFN",p->config,fname,-1);
  if (ls>0) {
    vfill(0,(int_4*)(&hdr),512);
    strncpy(hdr.version,"BLUEEEEIEEEI",12);
    hdr.type=1000; hdr.data_start=512; hdr.data_size=size*4;
    hdr.adj.r8[0]=0.0; hdr.adj.r8[1]=1.0; hdr.adj.i4[4]=1;
    strncpy(hdr.format,"SL",2);
    fp = fopen(fname,"wb");
    printf("Unloading UPAC test trace to fn=%s fp=%p\n",fname,fp);
    fwrite((char*)(&hdr),1,512,fp);
    iadr = 0x00201000;
    for (i=j=0; i<size; i++) {
      pic_msg (p,0,PKTF_BUS_RD,iadr+(i<<2),tmp,0,4,-1);
      if (tmp[0]&0x80000000) { osize+=1; ltmp=tmp[0]; }
      else osize += min(1024,tmp[0]);	// repeat count
      for (;j<osize; j++) fwrite((char*)(&ltmp),1,4,fp);
    }
    fseek(fp,0L,SEEK_SET);
    hdr.data_size=osize*4;
    fwrite((char*)(&hdr),1,512,fp);
    fclose(fp);
  }
  printf("Ending UPAC test\n");
  return 0;
}

int_4 pic_dump_upac (PICSTRUCT *p, int_4 port) {
  int i, nc=18, iport=port-1, iadr, tmp[8];
  iadr = 0x00040000 | (iport<<14);
  for (i=1; i<nc; i++) {
    pic_msg (p,0,PKTF_BUS_RD,iadr+(i<<2),tmp,0,4,-1);
    printf("OK p=%d i=%d r=%08x\n",port,i,tmp[0]);
  }
  return 0;
}
