/****************************************************************************/
/*                                                                          */
/*   iomlib_a2dm1x.h: includes for A2DM1X library interfaces                */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>   
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "icelib.h" 

#define A2DM18_ROOT_ADDR      0
#define A2DM18_TMP112_ADDR    1
#define A2DM18_PE4302_ADDR_0  2
#define A2DM18_PE4302_ADDR_1  3
#define A2DM18_PE4302_ADDR_2  4
#define A2DM18_PE4302_ADDR_3  5
#define A2DM18_ADF4350_ADDR   6
#define A2DM18_ADC12D_ADDR    7
#define A2DM18_ADCLM_ADDR_0   8
#define A2DM18_ADCLM_ADDR_1   9
#define A2DM18_PTFDFIR_ADDR_0 10
#define A2DM18_PTFDFIR_ADDR_1 11
#define A2DM18_DELAY_ADDR     12
#define A2DM18_MODULE_ADDR    13
#define A2DM18_CMD_ADDR       14

/* Define module specific state register mapping */
enum A2DM18_RG_ID {
  A2DM18_RG_SRATEW   = 0x00,  /* ADC Sample Rate (Whole MHz)             */
  A2DM18_RG_SRATEF   = 0x01,  /* ADC Sample Rate (Frac  MHz)             */
  A2DM18_RG_CHAGAIN  = 0x02,  /* CH-A Gain in dB                         */
  A2DM18_RG_CHBGAIN  = 0x03,  /* CH-B Gain in dB                         */
  A2DM18_RG_T1FREQW  = 0x04,  /* Tuner Frequency (Whole MHz)             */
  A2DM18_RG_T1FREQF  = 0x05,  /* Tuner Frequency (Frac  MHz)             */
  A2DM18_RG_T2FREQW  = 0x06,  /* Tuner Frequency (Whole MHz)             */
  A2DM18_RG_T2FREQF  = 0x07,  /* Tuner Frequency (Frac  MHz)             */
  A2DM18_RG_TDEC     = 0x08,  /* Tuner Decimation                        */
  A2DM18_RG_HDEC     = 0x09,  /* Hardware Decimation                     */
  A2DM18_RG_ADLMB1   = 0x0A,  /* ADLM Beta 1                             */
  A2DM18_RG_ADLMB2   = 0x0B,  /* ADLM Beta 2                             */
  A2DM18_RG_ADLMD    = 0x0C,  /* ADLM Decimation                         */
  A2DM18_RG_ADCTPM   = 0x0D,  /* Test Pattern from ADC                   */
  A2DM18_RG_RAMP     = 0x0E,  /* Ramp Interface Test                     */
  A2DM18_RG_FCN      = STATE_RG_FCN,  /* State elements to update / change  */
  A2DM18_RG_PIN      = STATE_RG_PIN, /* Register to hold PIN ctrls states  */
  A2DM18_RG_CRC      = STATE_RG_CRC  /* CRC over all registers             */
};


/* Define module specific register masks */
enum A2DM18_PIN_MASK {
  A2DM18_PIN_NULL    = 0x00000000,
  A2DM18_PIN_TXPD    = 0x00000001, /* TCXO Power Down */
  A2DM18_PIN_FMT     = 0x00000002, /* Format Select: 1=SI, 0=SB */
  A2DM18_PIN_DUAL    = 0x00000004, /* Use Both A/B Ports for Data (A2DPORTS=3) */
  A2DM18_PIN_VSEL    = 0x00000008, /* Channel Select */
  A2DM18_PIN_RSEL    = 0x00000010, /* Test Ramp */
  A2DM18_PIN_EXTREF  = 0x00000020, /* Use external 10MHz ref */
  A2DM18_PIN_HDEC    = 0x000000C0, /* Hardware Decimation (0,1,3) */
  A2DM18_PIN_HDECD   = 0x00000300, /* Test bit - Do not modify */
  A2DM18_PIN_PPST    = 0x00000400, /* PPS Tag Output Sample */
  A2DM18_PIN_PWIDE   = 0x00000800, /* Set to enable a2dports=5 mode */
  A2DM18_PIN_DES     = 0x00001000, /* ADC Dual Edge Sample Mode (Test - do not use) */
  A2DM18_PIN_DWIDE   = 0x00004000, /* Use 16-bit HH Protocol */
  A2DM18_PIN_BSEL    = 0x00008000, /* Byte Mode Loading Selection */
  A2DM18_PIN_LSBP    = ((int32_t)0x00002000), /* PPS Tag in LSB */
  A2DM18_PIN_PPSP    = ((int32_t)0x00004000), /* PPS for Data */
  A2DM18_PIN_ENABLE  = ((int32_t)0x80000000)  /* Enable / Disable output */ 
};


/* Define module specific register masks */
enum A2DM18_RG_MASK {
  A2DM18_RGM_CHAGAIN     = 0x000000FF, 
  A2DM18_RGM_CHBGAIN     = 0x000000FF, 
  A2DM18_RGM_TDEC        = 0x0000000F 
};


/* Define module specfic state keys for updates */
enum A2DM18_FCN_LIST {
  A2DM18_FCN_NULL        =  0x00000000,   
  A2DM18_FCN_INITIALIZE  = (0x00000001<<0),   
  A2DM18_FCN_SETUP       = (0x00000001<<1),   
  A2DM18_FCN_CHG_ENABLE  = (0x00000001<<2),   
  A2DM18_FCN_CHG_CLKREF  = (0x00000001<<4),   
  A2DM18_FCN_CHG_RFFREQA = (0x00000001<<5),   
  A2DM18_FCN_CHG_RFFREQB = (0x00000001<<6),   
  A2DM18_FCN_CHG_RFGAINA = (0x00000001<<7),   
  A2DM18_FCN_CHG_RFGAINB = (0x00000001<<8),   
  A2DM18_FCN_CHG_RFBW    = (0x00000001<<9),   
  A2DM18_FCN_CHG_SRATE   = (0x00000001<<10),   
  A2DM18_FCN_CHG_PRESEL  = (0x00000001<<11),  
  A2DM18_FCN_PINCTL      = (0x00000001<<12),   
  A2DM18_FCN_SIDEB       = (0x00000001<<13)    
};

#define A2DM1X_PORT_DSM 2

/*---------------------------------------------------------------------------*/
/* Public Function Prototypes */

EXTERN_CDEFINE int32_t mod_a2dm18_get_state(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_a2dm18_set_state(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_a2dm18_init(Module_Config_Obj *M);
