#define NIO_MSG 0
#define NIO_SET 1
#define NIO_GET 2
#define NIO_RET 3
#define NIO_ACK 4
#define NIO_MSGR 5

#define NIO_INPUT  0x01
#define NIO_OUTPUT 0x02
#define NIO_INOUT  0x04
#define NIO_OUTIN  0x08
#define NIO_RMIF   0x10
#define NIO_HTTP   0x20
#define NIO_RTAB   0x40
#define NIO_UDP    0x80
#define NIO_THREAD 0x100
#define NIO_THRSLV 0x200
#define NIO_SERVER 0x400
#define NIO_BIGBUF 0x800
  
#ifdef __cplusplus
extern "C" {
#endif

int_4 nioOpen (char *url, int_4 chans, int_4 flags);
int_4 nioSendBank (int_4 sock, int_4 chns, int_4 ncpa, void* haddr, int_4 hlen, int_4 dlen, void* vaddr, int_4 bytes, int_4 flags);
int_4 nioSend (int_4 sock, int_4 chan, void* vaddr, int_4 bytes, int_4 flags);
int_4 nioRecv (int_4 sock, int_4 chan, void* vaddr, int_4 bytes, int_4 flags);
int_4 nioMsg (int_4 sock, int_4 chan, int_4 func, char* msg, int_4 len, int_4 flags);
int_4 nioMsgRecv (int_4 sock, int_4 *func, char* msg, int_4 len, int_4 flags);
int_4 nioMsgSend (int_4 sock, int_4 func, char* msg, int_4 len, int_4 flags);
int_4 nioFile (int_4 sock, char* fname, char* aname, int_4 flags);
void* nioAlloc (int_4 bytes);
int_4 nioFree (void* vaddr);
int_4 nioClose (int_4 sock);

#ifdef __cplusplus
}
#endif

