/**
  Common defines for processing COREs

  CORE_AREA is the java native package location
  CORE_NAME is the Library Function Name
  CORE_TYPE is the Processor Type Java,CPU,GPU,VHS,MLS,ICE

  @author Jeff Schoen
  @version $Id: CoreDefs.h,v 1.1 2011/04/27 13:09:47 jgs Exp $
*/

#ifndef _CoreDefs_
#define _CoreDefs_

#include "icedefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

#define CORE_TYPE_JDK 0
#define CORE_TYPE_CPU 1
#define CORE_TYPE_PHI 2
#define CORE_TYPE_GPU 3
#define CORE_TYPE_MLS 4
#define CORE_TYPE_VHS 5
#define CORE_TYPE_ICE 6

#define CORE_TYPE_FPGA 5

#define CORE_FLOW_ARRAY 0
#define CORE_FLOW_STREAM 1
#define CORE_FLOW_BUFFER 2
#define CORE_FLOW_BUFSTR 3
#define CORE_FLOW_PACKET 4

#ifdef CORE_TYPE
#elif INNERCLASS_CPU
#define CORE_TYPE CORE_TYPE_CPU
#elif INNERCLASS_GPU
#define CORE_TYPE CORE_TYPE_GPU
#elif INNERCLASS_MLS
#define CORE_TYPE CORE_TYPE_MLS
#elif INNERCLASS_VHS
#define CORE_TYPE CORE_TYPE_VHS
#elif INNERCLASS_ICE
#define CORE_TYPE CORE_TYPE_ICE
#else
#define CORE_TYPE CORE_TYPE_JDK
#endif

#if CORE_TYPE == CORE_TYPE_JDK
#define CORE_SIG JDK
#define CORE_IS_JDK 1
#elif CORE_TYPE == CORE_TYPE_CPU
#define CORE_SIG CPU
#define CORE_IS_CPU 1
#elif CORE_TYPE == CORE_TYPE_GPU
#define CORE_SIG GPU
#define CORE_IS_GPU defined(_CUDA)
#elif CORE_TYPE == CORE_TYPE_MLS
#define CORE_SIG MLS
#define CORE_IS_MLS 1
#define CORE_IS_FPGA 1
#elif CORE_TYPE == CORE_TYPE_VHS
#define CORE_SIG VHS
#define CORE_IS_VHS 1
#define CORE_IS_FPGA 1
#elif CORE_TYPE == CORE_TYPE_ICE
#define CORE_SIG ICE
#define CORE_IS_ICE 1
#define CORE_IS_FPGA 1
#endif

#if CORE_IS_GPU
#include <cuda.h>
#include <cufft.h>
#include <driver_types.h>
#endif

#ifdef _LONG64
#define PPAD
#else
#define PPAD 
#endif

typedef struct {
  int_2 x;
} SxInt_2;

typedef struct {
  real_4 x;
} SxReal_4;

typedef struct {
  real_8 x;
} SxReal_8;

typedef struct {
  int_1 x,y;
} CxInt_1;

typedef struct {
  int_2 x,y;
} CxInt_2;

typedef struct {
  real_4 x,y;
} CxReal_4;

typedef struct {
  real_8 x,y;
} CxReal_8;

typedef struct {
  int_2 x,y,z;
} VxInt_2;

typedef struct {
  real_4 x,y,z;
} VxReal_4;

typedef struct {
  real_8 x,y,z;
} VxReal_8;

typedef struct {
  int_4 len;
  int_4 bpa;
  int_1 mode,type;
  int_1 bps,spa;
  int_1 *b;
} Value;
#define CORE_VALUE_STRUCT

/* to make sure this matches the struct in VCoreDefs.h AND fpgalib.c AND corelib.h AND Buffer above */
#include "CoreStream.h"

typedef struct {
  int_4 len,woff,roff,bpe,mask,shft;
  int_4 rok,wok,afull,aempty;
  int_1 *b;
} Queue;

typedef struct {
  int_4 OL,AL,ML;
  int_4 WA,WB;
  int_4 len;
  int_1 *b;
} Ram;

typedef struct {
  int_4 OL,OC,WA,WB;
  int_4 AL,AC,ML,MC;
  int_4 chn,len;
  int_1 *b;
} RamRWC;

typedef struct {
  int_4 N,M,L;
  real_4 *b;
  int_4 bsigx;
  int_4 bsize;
} RomF;

typedef struct {
  int_4 N,M,L;
  real_4 *b;
  int_4 bsigx;
  int_4 bsize;
} RomF2D;

typedef struct {
  int_4 N,M,L,MC;
  real_4 *b;
  int_4 bsigx;
  int_4 bsize;
} RomF2Di;

typedef struct {
  int_4 IW,N,n;
  real_4 *b;
  int_4 bsigx;
  int_4 bsize;
} TapBuf;

typedef struct {
  int_4 IW,N,n;
  CxReal_4 *b;
  int_4 bsigx;
  int_4 bsize;
} CxTapBuf;

typedef struct {
  int_4 N,n,m;
  real_4 *b;
  int_4 bsigx;
  int_4 bsize;
} StatBuf;

typedef struct {
  int_4 N,n,ro;
  real_4 *b;
  int_4 bsigx;
  int_4 bsize;
} RamBuf;

typedef struct {
  int_4 N,n,ro;
  CxReal_4 *b;
  int_4 bsigx;
  int_4 bsize;
} CxRamBuf;

typedef struct {
  int_4 AW,BW;
  int_4 cnt;
  int_4 flags;
} Dma;

typedef struct {
  int_4 AW,BW;
  int_4 cnt;
} Viterbi;

typedef char String;

#endif

#ifdef CORE_TYPE
#include "CoreLibs.h"
#endif
