c************
c   Description : PIC Measurement Primitive
c
c   Author :    JGS   1/20/99
c
c   $Revision:   1.15  $
c   $Modtime:   01/17/96 10:14:44  $
c   
c************
	program PICMEASURE
c
	implicit none
	include 'primitive.inc'
	include 'packet.inc'
	integer*4 maxpkt
	parameter (maxpkt=32)
c
	record /HEADER/ HP
	record /PACKETSTRUCT/ pkt, pkta(maxpkt), pktb(maxpkt)
c
	character*8 cnum, mode
	real*4    pause /0.025/
	integer*2 bufa(1),bufb(1)
	integer*4 iper,ipkt,idum,status,npkt,ngot,ia,ib,ja,jb
	integer*4 idcr,idca,idcb,idcn,chna,chnb,maxchn
	pointer   (pbufa,bufa),(pbufb,bufb)
	real*8    rate
c
	call M$CHECKIN
c
c validate the mode
	mode = M$UPICK(1)
c
c open input packet file
	call M$INIT (HP, M$APICK(2),'1000','SP,SB,SI,CI',0)
	call M$OPEN (HP, HCBF_INPUT)
	rate = 1.0d0 / HP.xdelta
	ipkt = 64 / HP.bpe
	iper = 0
c
c set up real time controls
	idcr = M$DWINIT('Rate ', rate, 0.0d0, 1.0d8, 1.0d1)
	chna = M$GET_SWITCH_DEF('CHNA',1)
	idca = M$LWINIT('Channel-A ', chna, 0, 24, 1)
	chnb = M$GET_SWITCH_DEF('CHNB',-1)
	idcb = M$LWINIT('Channel-B ', chnb, -1, 24, 1)
	npkt = M$GET_SWITCH_DEF('NPKT',5)
	idcn = M$LWINIT('NPackets ', npkt, 0, maxpkt, 1)
c
c signal start of processing block
	call M$SYNC()
c
c top of throttle loop
	ja = 0
	jb = 0
	maxchn = 1
	status = 0
	do while (status.ge.0 .and. .not. Mc.break)

	status = 0
	call M$HCBFUNC(HP,HCBF_AVAIL,ngot)
	if (ngot.gt.ipkt) then
	  HP.xfer_len = ipkt
	  call M$GRABX (HP,pkt,ngot)
	  if (ngot.ne.ipkt) goto 999
	  if (pkt.keys(1).ne.101) call M$ERROR('Bad packet key')
	  HP.xfer_len = pkt.elem
	  idum = M$DWGET(idcr,rate)
	  idum = M$LWGET(idca,chna)
	  idum = M$LWGET(idcb,chnb)
	  idum = M$LWGET(idcn,npkt)
	  ia = chna
	  if (chnb.ge.0) ib = chnb
	  if (chnb.lt.0 .and. ib.le.0) ib = 1
	  if (pkt.channel.gt.maxchn) maxchn = pkt.channel
	  if (pkt.elem*npkt .gt. iper) then
	    iper = pkt.elem*npkt
	    call M$MALLOC (iper*HP.bpe, pbufa)
	    call M$MALLOC (iper*HP.bpe, pbufb)
	  endif
	  if (pkt.channel.eq.ia .and. ja.ge.npkt) then
	    call M$HCBFUNC(HP,HCBF_SKIP,HP.xfer_len)
	    call dropall (hp,pkt,ipkt)
	    call measure (pkta,bufa,ja, pktb,bufb,jb, rate)
	    if (chnb.lt.0) ib = mod(ib,maxchn)+1
	    call dropall (hp,pkt,ipkt)
	    ja = 0
	    jb = 0
	  elseif (pkt.channel .eq. ia) then
	    if (ja.ge.0 .and. ja.lt.npkt) then
	      ja = ja+1
	      call M$MOVE(pkt,pkta(ja),64)
	      call M$GRABX (HP,bufa(1+(ja-1)*HP.xfer_len),ngot)
	    else
	      call M$HCBFUNC(HP,HCBF_SKIP,HP.xfer_len)
	    endif
	  elseif (pkt.channel .eq. ib) then
	    if (jb.ge.0 .and. jb.lt.npkt) then
	      jb = jb+1
	      call M$MOVE(pkt,pktb(jb),64)
	      call M$GRABX (HP,bufb(1+(jb-1)*HP.xfer_len),ngot)
	    else
	      call M$HCBFUNC(HP,HCBF_SKIP,HP.xfer_len)
	    endif
	  else
	    call M$HCBFUNC(HP,HCBF_SKIP,HP.xfer_len)
	  endif
	  status = status + 1
	endif

	if (status.eq.0) call M$PAUSE(pause)
	enddo
c
c close input/output files
  999	call M$CLOSE(HP)
c
	call M$RETURN
	end

	subroutine dropall (hp,pkt,ipkt)
	implicit none
	include 'headers.inc'
	include 'packet.inc'
	record /HEADER/ hp
	record /PACKETSTRUCT/ pkt
	integer*4 n,ipkt,ngot
	if (HP.pipe .eq. 0) return
	call M$HCBFUNC(HP,HCBF_AVAIL,n)
	do while (n.gt.ipkt)
	  HP.xfer_len = ipkt
	  call M$GRABX (HP,pkt,ngot)
	  if (pkt.keys(1).ne.101) call M$ERROR('Bad packet key')
	  HP.xfer_len = pkt.elem
	  call M$HCBFUNC(HP,HCBF_SKIP,HP.xfer_len)
	  call M$HCBFUNC(HP,HCBF_AVAIL,n)
	enddo
	return
	end


	subroutine measure (pkta,bufa,ja, pktb,bufb,jb, rate)
	implicit none
	include 'packet.inc'
	include 'parameters.inc'
	record /PACKETSTRUCT/ pkta(*), pktb(*)
	integer*2 bufa(*),bufb(*)
	integer*4 ja,jb,ia,ib,ioff,iper,iover,j,nfft,n,i
	real*8 tcaw,tcaf,tcbw,tcbf,toff,tdif,t,x
	real*8 delta,rate,deltaa,deltab
	integer*4 navg,tnano,tdnano
	parameter (nfft=16384)
	real*4 fbufa(nfft),fbufb(nfft),fbuf(nfft),fbufi(nfft)
	real*4 scale,wind(nfft)

	iper = pkta(1).elem
	print *, 'Got packet bufs ',ja,jb,pkta(1).count,pktb(1).count
	delta = 1.d0/rate

	! check timecodes
	call checktc (pkta,ja,tcaw,tcaf,delta,deltaa)
	call checktc (pktb,jb,tcbw,tcbf,delta,deltab)
	if (deltaa.le.0 .or. deltab.le.0) return

	! find overlap range
	toff = (tcbw-tcaw) 
	toff = toff + (tcbf-tcaf)
	ioff = DNINT(toff/delta)
	if (ioff.ge.0) then
	  ia = ioff
	  ib = 0
	else
	  ia = 0
	  ib = -ioff
	endif
	tdif = toff - ioff*delta
	iover = min(ja*iper-ia,jb*iper-ib)
	navg = iover/nfft
	print *, 'Got packet overlap ',ia,ib,iover
	if (iover .gt. 0) then
	  j = iover
	  ! print *, 'Got packet data ',bufa(ia+1),bufb(ib+1),bufa(ia+1)-bufb(ib+1)
	  ! print *, 'Got packet data ',bufa(ia+j),bufb(ib+j),bufa(ia+j)-bufb(ib+j)
	endif
	if (navg .gt. 0) then
	  call M$VFILL(fbufi,0.0,nfft)
	  call M$WINDOW (wind,'HANN',nfft)
	  do n = 1,navg
	    i = (n-1)*nfft+1
	    call M$RETYPE(bufa(ia+i),MP_INT,fbufa,MP_FLOAT,nfft)
	    call M$RETYPE(bufb(ib+i),MP_INT,fbufb,MP_FLOAT,nfft)
	    call M$VMUL(fbufa,wind,fbufa,nfft)
	    call M$VMUL(fbufb,wind,fbufb,nfft)
	    call M$RFFT(fbufa,nfft,3)
	    call M$RFFT(fbufb,nfft,3)
	    call M$CVMUL(fbufa,fbufb,fbuf,nfft/2,1)
	    call M$VADD(fbufi,fbuf,fbufi,nfft)
	  enddo
	  scale = 1.0/(nfft*navg)
	  call M$VSMUL(fbufi,scale,fbufi,nfft)

	  call phasefit (fbufi,nfft,x)
	  t = x * delta
	  tnano = t*1e9
	  tdnano = tdif*1e9
	  print *, 'Offets MOT (ns) = ',navg,tnano,tdnano,
     &			'   diff=',tnano+tdnano

	endif

	return
	end


	subroutine phasefit(fbuf,nfft,x)
	implicit none
	include 'types.inc'
	include 'constants.inc'
	include 'headers.inc'
	record /HEADER/ HT
	integer*4 nfft,nffti,i,imax,nfit
	parameter (nffti=131072,nfit=65536)
	complex*8 fbuf(*),fbufi(nffti)
	real*4 a0,a1,a2,scale,fit(nfit*2),fmax
	real*8 x
	call M$VFILL(fbufi,0.0,nffti*2)
	call M$VMOV(fbuf,1,fbufi,1,nfft)
	call M$CFFT(fbufi,nffti,-1)
	call M$CVMAG2(fbufi(nffti-nfit+1),fit(1),nfit)
	call M$CVMAG2(fbufi(1),fit(nfit+1),nfit)
	imax = 2
	fmax = fit(imax)
	do i = 3,nfit*2-1
	  if (fit(i).gt.fmax) then
	    imax = i
	    fmax = fit(i)
	  endif
	enddo
	a0 = sqrt(fit(imax-1))
	a1 = sqrt(fit(imax+0))
	a2 = sqrt(fit(imax+1))
	x = (a2+a0-a1-a1)
	if (abs(x).le.1e-20) x=1e-20
	x = -(a2-a0)/(2*x)
	x = (x+imax-nfit-1) * DBLE(nfft) / DBLE(nffti)
#if _JEFF
	call M$INIT (HT,'TESTFFT','2000','SF',0)
	HT.subsize = nfit*2
	HT.xstart = -nfit
	call M$OPEN (HT,HCBF_OUTPUT)
	call M$FILAD (HT,fit,1)
	call M$CLOSE (HT)
#endif	
	return
	end



	subroutine checktc (pkt,j,tcw,tcf,delta,deltacalc)
	implicit none
        include 'types.inc'
        include 'packet.inc'
        record /PACKETSTRUCT/ pkt(*)
	real*8 tcw,tcf,delta,deltacalc,sdif,tdif,tco
	character tstring*40
	integer*4 i,j

	deltacalc = delta
	if (pkt(1).tcstatus .eq. 0) then
	  tcw = 0
	  tcf = DBLE(pkt(1).count)*DBLE(pkt(1).elem)*delta
	  return
	endif

	tdif = pkt(j).tcwsec-pkt(1).tcwsec
	tdif = tdif + (pkt(j).tcfsec-pkt(1).tcfsec)
	sdif = (pkt(j).tcoff-pkt(1).tcoff) + (j-1)*pkt(1).elem
	if (tdif.gt.0 .and. sdif.gt.0) deltacalc = tdif/sdif
	if (tdif.lt.0) then
	  deltacalc = -1
	  return
	endif

        tco = pkt(1).tcoff*delta
	tcw = pkt(1).tcwsec
	tcf = pkt(1).tcfsec - tco
	i = INT(tcf)
	if (tcf.lt.0) i = i-1
	if (i.ne.0) then
	  tcw = tcw + i
	  tcf = tcf - i
	endif

	i = M$TIMES2TOD (tcw,tcf,tstring)
	i = INDEX(tstring,'.')+9
	print *, 'Time ',pkt(1).channel,' ',tstring(1:i),1.0/deltacalc
c     &		,tdif,sdif,j

	return
	end
	
