startmacro t:tbl_rx t:tbl_tx
  set frx ^tbl_rx.flags
  set ftx ^tbl_tx.flags
  set flags1 "^frx|^tbl_rx.aflags"
  set flags2 "^ftx|^tbl_tx.aflags"
  calc rate_rx ^tbl_rx.rate 1e6 *
  calc rate_tx ^tbl_tx.rate 1e6 *
  set wstr "aux=^tbl_rx.aux"
  set failure 0

  ! reset cards
  call cleanFiles
  picd/flags=force|^frx reset ^tbl_rx.card
  if ^tbl_rx.card neqs ^tbl_tx.card then 
    picd/flags=force|^ftx reset ^tbl_tx.card
  endif

  ! create input and output files
  set nels 128k
  set freq_ 2e6
  calc xdel 1 rate_tx /
  set levels 15
  calc amp_ 2 levels **
  calc freq_ 1 2 levels 1 + ** /
  wave mfile{^wstr} ^tbl_tx.format ^nels saw amp_ freq=^freq_
  headermod mfile{^wstr} xd=^xdel
  pic copy mfile filei
  pic create fileo ^tbl_rx.format nels rate_rx zero

  ! play/acquire
  picd/replay=4/stat=chan/port=^tbl_tx.port/flags=^flags2 play ^tbl_tx.card filei
  picd/replay=^tbl.replay/kick=chan/port=^tbl_rx.port/flags=^flags1 acquire ^tbl_rx.card fileo

  ! measure 
  icemeas udp lfile fileo levels

  call procResults lfile

  if /plotson or ( failure eq 1 ) then
    pipe on
      panel/setup
      plot/id=plot1 filei ymin=-40k ymax=40k /all
      plot/id=plot2 fileo ymin=-40k ymax=40k /all
      list/id=plot3 lfile
    pipe off
  endif

  call cleanFiles

endmacro

procedure cleanFiles
  erase/warn=n mfile filei fileo lfile
return

procedure procResults hi 
  status hi size=sze
  file open/d tag hi
  set maxdelt tag.getDataTable(0).maxdelta
  set errs tag.getDataTable(0).errors

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if maxdelt lt tmp.maxdelta
      set maxdelt tmp.maxdelta
    endif
    if errs lt tmp.errors
      set errors tmp.errors
    endif
  enddo

  file close tag
  assert/text="Max. Delta (Meas: ^maxdelt, Thresh: 1)" maxdelt eq 1
  assert/text="Number of Errors (Meas: ^errs, Thresh: 0)" errs eq 0 
  if ( maxdelt neq 1 ) or ( errs neq 0 ) then 
    set failure 1
  endif
return

