!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  This algorithm is used to calibrate tuner timecode by reconstructing the 
!  original input from the tuner output and using cross spectral techniques
!  to calculate delays.  These are compared to the pic_tc() results to verify
!  the theoretical equations.
!
!  This also tests the wideband timecode by comparing with the embedded value
!
!  A wideband signal (with timecode) must be applied to the input module 1 
!
!  Authors: Sid Moore, Joe Briggs, and Jeff Schoen
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/quiet fn:in1 fn:in2 d:freq[-1] d:bw[-1]

res nfft 64k
res delta file(in1).xdelta
if file(in1).format eqss "C" then
  res fbw (1/delta)*.7
  res cf 0
else
  res fbw (0.5/delta)*.7
  res cf (.25/delta)
endif
if bw eq -1 then res bw fbw
if freq eq -1 then res freq cf 
calc inter file(in2).xs file(in1).xs - delta / push round - delta *
res obw bw

fft/psd/1d in1 spec1 nfft bh92 0 -1 in2 spec2 tccross

thin tccross tccross1 freq-obw freq+obw /absc
thin tccross tccross2 freq-(obw/2) freq+(obw/2) /absc 
fcalc tphase tccross2 phasec unwrapc
polyfit tphase 1 slope err=terror
statis terror sdev=stdev
calc delay slope(1) inter -
calc f:delaysamp delay delta /
res delay
res delaysamp

if /x then
 plot/all spec1|spec2|tccross cm=10lo
 plot/all tccross1|tccross2 cm=ph
endif

endmacro
