startmacro/replay=0/tcps=2/tc=cpu s:card[pic3v6s] l:side[1]

calc rate  50e6
calc dec1  32
calc ratio1 (32/25)
calc rate1 rate/dec1/2 ratio1 *
calc dec2  16
calc ratio2 (1.2)
calc rate2 rate1/dec2/2 ratio2 *
calc l:ptl 1M
calc freq 1e6

set l:nfdm 16
set rfn "test^{side}"

if /live then
 set  flags "SIDE=^side|MUXCLK=N"
else
 set  flags "SIDE=^side|IOC=IIRR|MUXCLK=P"
endif
set nflags  "^flags|XINP=1|RESAMP|RGO"
set dflags  "^flags|RGO|LUT=FM|IPORT=PM0TUNER^side"
set taflags "^flags|RESAMP|RGO|IPORT=PM1CORE^side"
set tbflags "^flags|RESAMP|RGO|IPORT=PM2CORE^side"

picd reset card /flags=flags 

pipe on 

panel /setup /logger /controls=gc

! wideband capture
picd/round=ptl create ^{rfn}_wb si rate  rate
sourcepic/id=wb/port=module^side   ^{rfn}_wb{fs=8k} _wb card 1     /flags=flags  

! narrowband capture
picd/round=ptl create ^{rfn}_nb ci rate1 rate1
sourcepic/id=nb/port=pm0tuner^side ^{rfn}_nb{fs=8k} _nb card dec1 freq /ratio=ratio1 /flags=nflags /skip=16

! split demod captures
picd/round=ptl create ^{rfn}_fda si rate1 rate1
sourcepic/id=fda/port=pm1core^side ^{rfn}_fda{fs=8k} _fda card 1  /flags=dflags /skip=16
picd/round=ptl create ^{rfn}_fdb si rate1 rate1
sourcepic/id=fdb/port=pm2core^side ^{rfn}_fdb{fs=8k} _fdb card 1  /flags=dflags /skip=16

! post demod tuners
if /multi then
 picd/round=ptl create ^{rfn}_fdma ci rate2 rate2
 sourcepic/id=fdma/port=pm1tuner^side ^{rfn}_fdma{fs=8k} _fdma card dec2 /ratio=ratio2 /flags=taflags /multi=nfdm /autoss
 picd/round=ptl create ^{rfn}_fdmb ci rate2 rate2
 sourcepic/id=fdmb/port=pm2tuner^side ^{rfn}_fdmb{fs=8k} _fdmb card dec2 /ratio=ratio2 /flags=tbflags /multi=nfdm /autoss
else
 calc freq 10
 do l:nn side nfdm*2 2
  picd/round=ptl create ^{rfn}_fdma^nn ci rate2 rate2
  sourcepic/id=fdma^nn/port=pm1tuner^nn ^{rfn}_fdma^nn{fs=8k} _fdma^nn card dec2 freq /ratio=ratio2 /flags=taflags 
  picd/round=ptl create ^{rfn}_fdmb^nn ci rate2 rate2
  sourcepic/id=fdmb^nn/port=pm2tuner^nn ^{rfn}_fdmb^nn{fs=8k} _fdmb^nn card dec2 freq /ratio=ratio2 /flags=tbflags 
  calc freq freq+10
 enddo
endif

set scale 10e3
fft _fdma^side _psd 8k
plot/id=tdp _fdma^side{fs=3750} cm=real z1=-scale z2=scale
!plot/id=tdp _psd type=line /db

gcontrol menu "ACTION" "Action" "Cont,Stop,Check,Status,Exit" 
gcontrol lval "DEC1"   "PreDec  " dec1 16 256 2
gcontrol lval "DEC2"   "PostDec " dec2 16 256 2
gcontrol pipemon 

pipe off

endmacro

procedure processMessage msg

if msg.name eqs "ACTION"
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "STATUS" then
    pic status card
  elseif msg.data eqs "CHECK" then
    foreach item intable reg
      if reg.^item ninstanceof "nxm.ice.prim.sourcepic" continue
      set tc reg.^{item}.tc
      set delta reg.^{item}.delta
      if item eqs "WB" then
        say "SP=^item D=^delta TC=^tcd TC=^tc"
        set tc0 tc
        set delta0 delta
      else
        calc tcd tc.wsec-tc0.wsec tc.fsec-tc0.fsec + tc.offset*delta - tc0.offset*delta0 +
        say "SP=^item D=^delta TCdif=^tcd TC=^tc"
      endif
    endfor
  else
    info "Begin kick ^msg.data"
    if /multi then
      sendto/sync fdmb "SET.REPLAY" msg.data
      sendto/sync fdma "SET.REPLAY" msg.data
    else
     do l:nn side nfdm*2 2
      sendto/sync fdma^nn "SET.REPLAY" msg.data
      sendto/sync fdmb^nn "SET.REPLAY" msg.data
     enddo
    endif
    sendto/sync fda "SET.REPLAY" msg.data
    sendto/sync fdb "SET.REPLAY" msg.data
    sendto/sync nb  "SET.REPLAY" msg.data
    sendto/sync wb  "SET.REPLAY" msg.data
    info "End kick ^msg.data"
  endif
elseif msg.name eqss "DEC" 
  set l:dec1 gc.DEC1.val
  set l:dec2 gc.DEC2.val
  calc rate1 rate/dec1/2 ratio1 *
  calc rate2 rate1/dec2/2 ratio2 *
  info "Reset dec1=^dec1 dec2=^dec2"
  set reg.nb.dec dec1
  set reg.fda.rate rate1 reg.fda.replay reconnect
  set reg.fdb.rate rate1 reg.fdb.replay reconnect
  do l:nn side nfdm*2 2
    set reg.fdma^{nn}.dec dec2 reg.fdma^{nn}.rate rate1 reg.fdma^{nn}.replay reconnect
    set reg.fdmb^{nn}.dec dec2 reg.fdmb^{nn}.rate rate1 reg.fdmb^{nn}.replay reconnect
  enddo
endif
return
