!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This macro runs the %testtc macro for a number of standard cases
! It requires a 2nd card to generate the output test signals
!
startmacro s:icard[pic1iie] s:ocard[pic2ooe]

assert/init=tct

if /mode le 0 then


 picd get ocard type otype

 picd reset icard 
 picd get icard "TYPE" ctype
 picd get icard "PMTYPE" pmtype
 picd get icard "GCHIP" gchip
 picd get icard "MCHNS" chans

 res aflags ""
 res bflags ""
 res isy test(ctype eq 5 or ctype eq 6 or ctype eq 7)
 res tbank test(pmtype eq 2 or pmtype eq 3 or pmtype ge 6)
 if gchip eq 4 and pmtype gt 2 set gchip 5

 res rate 10
 say "Testing ^{rate}MHz Wideband vs Narrowband "
 if /sdds then
   if icard eqs ocard and /noreset isfalse then error "The /SDDS switch needs the /NORESET switch as well"
   icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate
   reg wait tcgen
 elseif /irb then
 else
   icetest tcgen ocard ^rate
 endif

  ! tests for all tuner implementations
  %testtc icard dec=40 form=si rate=rate /wb
  %testtc icard dec=360 form=si rate=rate
  %testtc icard dec=46 form=ci rate=rate /wbsame /wb
  %testtc icard dec=50 form=si rate=rate /ovsr=3
  %testtc icard dec=40 form=si rate=rate /aflags=POVSR /ovsr=3
  %testtc icard dec=226 form=si rate=rate

  ! tests for WB FPGA tuner on main board
 if gchip eq 4 then
  %testtc icard dec=4 form=ci rate=rate 
  %testtc icard dec=2 form=si rate=rate /wb /gain=-3
  %testtc icard dec=1 form=si rate=rate /ovsr=2 /gain=-6
  %testtc icard dec=1 form=ci rate=rate /ovsr=4 /gain=-6
  %testtc icard dec=1 form=si rate=rate /ovsr=0 /gain=-6
  %testtc icard dec=1 form=ci rate=rate /ovsr=0 /gain=-6 /rr=0.9 /aflags=PFIR=PFIR_80F
  %testtc icard dec=1 form=ci rate=rate tune=rate*.26 /ovsr=2 /gain=-6 /rr=1.76 
  %testtc icard dec=20 form=si rate=rate /aflags=PFIR=PFIR_90_127
 endif

  ! tests for WB|NB FPGA tuner 
 if gchip ge 4 then
  %testtc icard dec=20 form=sb rate=rate
  %testtc icard dec=20 form=cb rate=rate /aflags=spflip /bflags=spflip
  %testtc icard dec=20 form=cl rate=rate 
  %testtc icard dec=20 form=sb rate=rate /aflags=mbits=8 /wbform=sb
 endif
 if isy then
  %testtc icard dec=20 form=ci rate=rate /aflags=mbits=8 /wbform=sb
 endif

  ! tests for multi tuner interaction
 if chans ge 8 then
  if /side eq 2 then
    %testtc icard dec=10 form=si rate=rate /tport=tuner4 /aflags=CPC=2
    %testtc icard dec=12 form=ci rate=rate /tport=tuner6 /aflags=ITDEC|CPC=2
  else
    %testtc icard dec=10 form=si rate=rate /tport=tuner3 /aflags=CPC=2
    %testtc icard dec=12 form=ci rate=rate /tport=tuner5 /aflags=ITDEC|CPC=2
   if gchip ge 5 then
    %testtc icard dec=20 form=si rate=rate /also=3 /aflags=ITDEC|CPC=4|PFIR=pfir_80f
   else
    %testtc icard dec=20 form=si rate=rate /also=3 /aflags=ITDEC|CPC=4
   endif
   if gchip ge 4 then
    %testtc icard dec=10 form=ci rate=rate /also=1 /rr=1.1 /aflags=ITDEC|CPC=2
   endif
  endif
 endif

  ! tests for graychip 4016 functionality
 if gchip eq 2 or gchip ge 4 then
  %testtc icard dec=50 form=si rate=rate /ovsr=3 /wblast /wb
  %testtc icard dec=50 form=si rate=rate /ovsr=4 /aflags=ITDEC
  %testtc icard dec=6  form=si rate=rate /aflags=CPC=1
  %testtc icard dec=10 form=si rate=rate /aflags=CPC=2
  %testtc icard dec=50 form=ci rate=rate /rr=1 /tolr=15
  %testtc icard dec=100 form=ci rate=rate /rr=2 /tolr=50
  %testtc icard dec=40 form=ci rate=rate /rr=(8/9)
  %testtc icard dec=20 form=ci rate=rate /rr=(136/125) /tolr=80 /trestart
 endif

  ! tests for tuner banks (GC4016 or FPGA)
 if tbank then
  %testtc icard dec=64 form=si rate=rate /tport=tbank1 /aflags=FTTM=1
  %testtc icard dec=32 form=si rate=rate /tport=tbank1 /aflags=FTTM=2 /ovsr=8 /ntb=40 /itb=-8 /cfreq=1234567
  %testtc icard dec=40 form=ci rate=rate /tport=tbank1 /aflags=FTTM=2 /ovsr=8 /trestart
 endif

  ! tests for presampler feeding PM tuners 
 if isy and ( gchip eq 2 or gchip eq 5 ) then
  %testtc icard dec=24 form=si rate=rate /rr=1.1 /pre
  %testtc icard dec=16 form=si rate=rate /rr=0.3 /pre 
  %testtc icard dec=20 form=ci rate=rate /ovsr=4 /aflags=povsr /rr=0.96 /pre /wbr
  %testtc icard dec=20 form=ci rate=rate /ovsr=4 /rr=0.96 /pre /wbr
 endif

  ! tests for presampler feeding tuner banks
 if isy and tbank then
  %testtc icard dec=64 form=ci rate=rate /tport=tuner1 /ovsr=4 /rr=1.1 /pre 
  %testtc icard dec=64 form=ci rate=rate /tport=tbank1 /ovsr=4 /aflags=FTTM=2 /rr=1.1 /pre
  %testtc icard dec=20 form=ci rate=rate /tport=tbank1 /ovsr=10 /aflags=cpc=2|fttm=2|tclk=105e6|povsr /rr=1.04 /pre
  %testtc icard dec=96 form=ci rate=rate /tport=tbank1 /ovsr=2 /aflags=cpc=2|fttm=2 /rr=1.04 /pre /wblast /trestart
  %testtc icard dec=90 form=ci rate=rate /tport=tbank1 /ovsr=8 /aflags=cpc=2|fttm=2|tclk=105e6|povsr 
 endif

  ! tests for B side tuner banks
 if /side2 istrue and tbank istrue then
  %testtc icard dec=100 form=ci rate=rate /mport=module2 /tport=tuner2 /rr=2
  %testtc icard dec=256 form=ci rate=rate /mport=module1 /tport=tbank3 /aflags=FTTM=2 /rr=1.2 /pre
  %testtc icard dec=256 form=ci rate=rate /mport=module2 /tport=tbank2 /aflags=FTTM=2 /rr=1.1 /wbsame /pre
 endif

 if /sdds isfalse and otype neq 4 then
   icetest tcgen ocard 20 /NOFILL
   %testtc icard dec=16 form=si rate=20e6 /aflags=NOTCFILL
 endif

  ! tests for Embedded SDN in SDDS Stream"
 if /sdds istrue and /sdn isfalse then
  say "Testing ^{rate}MHz Embedded SDN in SDDS Stream"
  if isy then
    %testtc icard dec=10 form=si rate=rate /ovsr=4 /aflags=ITDEC /sdn
    %testtc icard dec=20 form=si rate=rate /wblast /wb /sdn
  else
  endif
 endif

  ! tests for cores feeding PM tuners - last before restart to clear THRUCORE routes
! if isy and ( gchip eq 2 or gchip eq 5 ) then
 if isy and ( gchip eq 5 ) then
  %testtc icard dec=50 form=si rate=rate /tport=pm1tuner1 /mport=pm0core1 /aflags=iport=pm0core1 /bflags=iport=module1 /wb /wblast /thrucore
  %testtc icard dec=50 form=ci rate=rate /tport=pm1tuner2 /mport=pm0core2 /aflags=iport=pm0core2 /bflags=inp=1 /wb /wblast /also=1 /ovsr=4
 endif

 if /sdds then
   registry "FINISH" "TCGEN" 
 elseif ctype eq 4 or ctype eq 10 then
   res aflags "muxclk=a"
   res bflags "muxclk=a|vhs|csize=32"
   picd reset icard /flags=^bflags
 else
   ! no special flags needed
 endif

 if /nohs istrue stop

 res rate 50
 say "Testing ^{rate}MHz Wideband vs Narrowband "
 if /sdds then
   icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate
   reg wait tcgen
 elseif /irb then
 else
   pic test/tcgen ocard ^rate
 endif

 if isy or /sdds isfalse
   %testtc icard dec=32  form=si rate=rate /aflags=^aflags /bflags=^bflags
   %testtc icard dec=400 form=si rate=rate /aflags=^aflags /bflags=^bflags
 endif

 ! special tests for chunked sdds packets into throttled tuner banks, etc.
 if /sdds then
  if /sdn isfalse then
   if isy then %testtc icard dec=16  form=ci rate=rate /aflags=spflip|^aflags /bflags=spflip|^bflags
   registry "FINISH" "TCGEN" 
   res rate 25
   say "Testing ^{rate}MHz SDDS Byte Data "
   calc l:blk test(ctype gt 5) 6 *
   icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=sb /aflags=pktblk=^blk|tclk=105e6
   reg wait tcgen
   %testtc icard dec=16 form=si rate=rate 
   %testtc icard dec=40 form=ci rate=rate 
   if isy and tbank then 
     %testtc icard dec=45 form=ci rate=rate /ovsr=4 /aflags=spflip|tclk=105e6 /bflags=spflip /rr=.975 /pre
     %testtc icard dec=48 form=ci rate=rate /ovsr=4 /aflags=spflip|tclk=105e6 /bflags=spflip /rr=1.04 /pre /wbsame
     registry "FINISH" "TCGEN" 
     res rate 12.5
     say "Testing ^{rate}MHz SDDS Word Data "
     icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=si /aflags=pktblk=^blk|tclk=105e6
     %testtc icard dec=24 form=ci rate=rate /ovsr=8 /tport=tbank1 /aflags=spflip|cpc=2|fttm=2|tclk=105e6 /bflags=spflip /rr=1.04 /pre /ntb=40 /itb=-8 /cfreq=1234567 /dfreq=25000
     registry "FINISH" "TCGEN" 
     res rate 10.0
     say "Testing ^{rate}MHz SDDS Word Data "
     icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=si /aflags=pktblk=^blk|tclk=105e6
     %testtc icard dec=20 form=ci rate=rate /ovsr=10 /tport=tbank1 /aflags=spflip|cpc=2|fttm=2|tclk=105e6|povsr /bflags=spflip /rr=1.04 /pre
     registry "FINISH" "TCGEN" 
     res rate 6.25
     say "Testing ^{rate}MHz SDDS Word Data " ! cant pktblk at 6.25MHz on SDDSR6
     icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=si /aflags=pktblk=3|tclk=105e6
     %testtc icard dec=12 form=ci rate=rate /ovsr=16 /tport=tbank1 /aflags=spflip|cpc=2|fttm=2|tclk=105e6 /bflags=spflip /rr=.96 /pre /wbr
     registry "FINISH" "TCGEN" 
     res rate 50
     say "Testing ^{rate}MHz SDDS Word Data " ! cant pktblk at 100Mby on PIC5
     icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=si /aflags=xpktblk=^blk|tclk=105e6
     %testtc icard dec=96 form=ci rate=rate /ovsr=2 /tport=tbank1 /aflags=spflip|cpc=2|fttm=2|tclk=105e6 /bflags=spflip /rr=1.04 /pre
   endif
   registry "FINISH" "TCGEN" 
   res rate 25
   say "Testing ^{rate}MHz SDDS Nibble Data "
   icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=sn
   reg wait tcgen
   %testtc icard dec=16  form=si rate=rate /aflags=^aflags /bflags=^bflags
   %testtc icard dec=40  form=ci rate=rate /aflags=^aflags /bflags=^bflags
  endif
   registry "FINISH" "TCGEN" 
 else
   res rate 100
   say "Testing ^{rate}MHz Wideband vs Narrowband "
   pic test/tcgen ocard rate
   %testtc icard dec=100 form=si rate=rate /aflags=^aflags /bflags=^bflags
   %testtc icard dec=16  form=ci rate=rate /aflags=^aflags|CPC=1 /bflags=^bflags
 endif

endif

if /mode eq 1 then
 pic test/tcgen ocard 10
 say "Multituner Narrowband Rate=10MHz dec=80"
 %testtuners/mux/meas/tcx/tc=sdn0/tctolr=10e-9/nox/aflags=itdecx/wbpx=2 &
  icard ,,, 80 -1 10e6 10e6/5
endif

! causes Java OutOfMem error
if /mode eq 2 then
 pic test/tcgen ocard 50
 say "Multituner Narrowband Rate=50MHz dec=100 ITDEC"
 %testtuners/mux/meas/tcx/tc=sdn0/tctolr=10e-9/nox/aflags=itdec/wbpx=2 &
  icard ,,, 100 -1 50e6 50e6/5
endif

if /mode eq 3 then
 pic test/tcgen ocard 1
 say "Multituner Narrowband Rate=1MHz dec=16 ITDEC"
 %testtuners/mux/meas/tcx/tc=sdn0/tctolr=10e-9/nox/aflags=itdec/wbpx=2 &
  icard ,,, 16 -1 1e6 1e6/5
endif

if /mode eq 9 then
 res rate 12.5
 say "Testing ^{rate}MHz SDDS Word Data "
 icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=si /aflags=pktblk=6|tclk=105e6|tpoe=7
 do nn 1 20 
   %testtc icard dec=24 form=ci rate=rate /tport=tuner1 /ovsr=8 /wblast /seqchkx
 enddo
 registry "FINISH" "TCGEN"
endif

if /mode eq 10 then
 res rate 25
 say "Testing ^{rate}MHz SDDS Word Data "
 icetest/bg/id=tcgen tcgen/sdds/live ocard ^rate /form=si
 %testtc icard dec=16*8 form=ci rate=rate /tport=tbank1 /wb /aflags=fttm=2 /ovsr=2
 registry "FINISH" "TCGEN"
endif

label done
assert/total=testall/ltext=90/text="TestAllTC"
info "Passed ^tct.test.pass_count of ^tct.test.test_count tests"

endmacro

