startmacro/quiet s:device[PIC1] &
  s:clksrc[D] l:nfft[2k] l:ndec[256] l:ntun[-1] l:samplerate[10e6] d:freq[620e3]

res flags "MUXCLK=^clksrc|^/aflags"
picd/flags=^flags reset ^device 
if ntun lt 0 picd/flags=^flags get ^device "CHNS" ntun

calc psdr 10
calc buflen 0.5
calc l:ntun ntun 8 min
calc nyquist samplerate/2
calc osamplerate samplerate/ndec/2
calc pdec samplerate nfft*psdr / round 1 max
calc qdec osamplerate nfft*psdr / round 1 max
switch "GAIN" gain get 0

res plotmin -50
res plotmax  50
res pass 0

if /mcpc then
  set l:ntun 10
endif

! create test output files
calc fsize buflen*samplerate nfft*2 max 64k max round
pic create testoutA SI fsize samplerate
pic create testoutB SI fsize samplerate
calc fsize buflen*osamplerate nfft*2 max 64k max round
do nn 1 ntun
  pic create testout^nn CI fsize osamplerate
enddo

! ufilt case
if "UFILT" subs flags then
  firwind tmpfir{form=si} lowpass bh92 63 .15 .2 .5 /sym /scale=32k
  do nn 1 ntun
    picd/port=tuner^nn loadfc ^device tmpfir
  enddo
endif

if /mform then
  header testout3 form=SI xd=0.5/osamplerate
  header testout4 form=SI xd=0.5/osamplerate
endif

pipe/panel/controls=gc on 

  sourcepic/id=SPA/port=Module1/flags=^flags/skip=pdec/tl=1/host=y &
		testoutA{fs=nfft} _cbA ^device 1 freq
  if /tsp then
    plot/id=PPA/msgid=main/wname="Module-A" _cbA type=rast 
  else
    fft/id=FFA/mag/log _cbA{fs=0} _cbfA nfft HANN 0
    plot/id=PPA/msgid=main/wname="Module-A" _cbfA type=line 
  endif

if /nob isfalse
  sourcepic/id=SPB/port=Module2/flags=^flags/skip=pdec/tl=1/host=y &
		testoutB{fs=nfft} _cbB ^device 1 freq
  if /tsp then
    plot/id=PPB/msgid=main/wname="Module-B" _cbB type=rast 
  else
    fft/id=FFB/mag/log _cbB{fs=0} _cbfB nfft HANN 0
    plot/id=PPB/msgid=main/wname="Module-B" _cbfB type=line 
  endif
endif

 do nn 1 ntun
  sourcepic/id=SP^nn/port=tuner^nn/flags=^flags/skip=qdec/tl=1 &
		testout^nn{fs=nfft} _cb^nn ^device ndec freq gain
  fft/id=FF^nn/mag/log _cb^nn{fs=0} _cbf^nn nfft HANN 0
  plot/id=PP^nn/msgid=main/wname="Tuner-^nn" _cbf^nn type=line 
  if /mcpc istrue and nn eq 8 set flags "^flags|CPC=2"
 enddo

pipe run

gcontrol label  "MACRO" "Macro" 
gcontrol button "MAIN"  ,, "Run,Stop,Exit" 
gcontrol choice "PLOT"  "Plot #" "A,B,1,2,3,4,5,6,7,8" 1
gcontrol label  "PORT"  "ICE Port" 
gcontrol dvalue "FREQ"  "TFreq " 0 0 nyquist nyquist*1e-5
gcontrol lvalue "GAIN"  "TGain " 0 -100 100 1 
gcontrol lvalue "DEC"   "TDec  " 0 1 8192 2 
gcontrol button "MODE"  ,, "Cont,One,StopN" 
gcontrol menu   "TEST"  ,"Tests", "StartWB,StopWB,StartNB,StopNB,OneDec,NewDec,OldDec,MultiDec,ReConnect,Restart,LeaveJoin" /nc=2
gcontrol tval   "TIME"   "TC"     0 1 -1 1  /edit=f

call setupSP

set this.timers 2
set this.timer(0) 1
pipe wait
pipe off

picd reset ^device 

! remove test output files
erase testoutA testoutB
do nn 1 ntun
  erase testout^nn 
enddo

endmacro


procedure processMessage 
if msg.name eqs "TIMER" then
  set gc.TIME.v reg.spa.time.sec
  if /testljloop then call leavejoin
elseif msg.name eqs "MARK" then
  sedit msg.fid nn trim "PP"
  set gc.PLOT.value nn
  call setupSP
elseif msg.name eqs "PLOT" then
  call setupSP
elseif msg.name eqs "FREQ" then
  set SP.freq msg.data
elseif msg.name eqs "DEC" then
  set SP.dec msg.data
elseif msg.name eqs "GAIN" then
  set SP.gain msg.data
elseif msg.name eqs "MODE" then
  set SP.replay msg.data
elseif msg.name eqs "MAIN" then
  if msg.data eqs "EXIT" then
    stop
  elseif msg.data eqs "RUN" then
  elseif msg.data eqs "STOP" then
  endif
elseif msg.name eqs "TEST" then
  if msg.data eqs "STARTWB"
    if reg.spA rexists set reg.spA.replay cont
    if reg.spB rexists set reg.spB.replay cont
  elseif msg.data eqs "STOPWB"
    if reg.spA rexists set reg.spA.replay stop
    if reg.spB rexists set reg.spB.replay stop
  elseif msg.data eqs "STARTNB"
    do nn 1 ntun
      set reg.sp^{nn}.replay cont
    enddo
  elseif msg.data eqs "STOPNB"
    do nn 1 ntun
      set reg.sp^{nn}.replay stop
    enddo
  elseif msg.data eqs "ONEDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec ndec
    enddo
  elseif msg.data eqs "NEWDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec 320
    enddo
  elseif msg.data eqs "OLDDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec 256
    enddo
  elseif msg.data eqs "MULTIDEC"
    do nn 1 ntun
      set reg.sp^{nn}.dec nn*20+ndec
      pause 0.1
    enddo
  elseif msg.data eqs "RECONNECT"
    set sp.replay "STOPNOW"
    set sp.replay "RECONNECT"
    set sp.replay "CONT"
  elseif msg.data eqs "RESTART"
    do nn 1 ntun
      set reg.sp^{nn}.replay "STOPNOW"
      set reg.sp^{nn}.replay "RECONNECT"
      pause .2
    enddo
    do nn ntun 1 -1
      set reg.sp^{nn}.replay "RESTART"
    enddo
  elseif msg.data eqs "LEAVEJOIN"
    call leavejoin
  endif
  pause 0.25
  call setupSP
endif
return

procedure leavejoin
set reg.spA.replay "STOPNOW"
set reg.sp1.replay "STOPNOW"
while reg.spA.replay neqs "STOPPED" or reg.sp1.replay neqs "STOPPED"
  pause 0.1
endwhile
say "Leave join pass=^pass"
if pass eq 0
  picd/port=module1 leave ^device "224.1.2.11"
  picd/port=module1 join ^device "224.1.2.12"
else
  picd/port=module1 leave ^device "224.1.2.12"
  picd/port=module1 join ^device "224.1.2.11"
endif
set reg.spA.replay "CONTINUOUS"
set reg.sp1.replay "CONTINUOUS"
res l:pass 1-pass
return

procedure setupSP
set nn gc.PLOT.value
set sp reg.sp^nn
set gc.FREQ.value sp.freq
set gc.DEC.value  sp.dec
set gc.GAIN.value sp.gain
set gc.MODE.value sp.replay
return
