startmacro t:tbl_rx t:tbl_tx
  call cleanFiles
  set failure 0
  
  set flagsr "^tbl_rx.flags|^tbl_rx.aflags"
  set flagst "^tbl_tx.flags|^tbl_tx.aflags"
  calc rate ^tbl_rx.rate 1e6 *

  ! reset the card and clean out playground
  pic/batch clean 
  picd/flags=force|^flagsr reset ^tbl_rx.card
  if ^tbl_rx.card neqs ^tbl_tx.card then
    picd/flags=force|^flagst reset ^tbl_tx.card
  endif

  ! copy then headermod to the correct rate
  noop/tl=12m ^tbl_tx.file filei{aux=^tbl_tx.picaux,det=1}
  calc xdel 1 rate /
  headermod filei xd=xdel

  ! create the output file
  pic create fileo ^tbl_rx.format ^tbl_rx.fsize ^rate zero

  ! play & receive the file 
  picd/replay=-1/bg/port=^tbl_rx.port/flags=^flagsr acquire ^tbl_rx.card fileo
  picd/replay=-1/port=^tbl_tx.port/flags=^flagst play ^tbl_tx.card filei

  ! make measurement
  icemeasure/tl=1m sonet lfile filei fileo 0 ^tbl_rx.frame ^tbl_rx.numframes off

  if off lt 0 then 
    assert/text="Bit Error Rate (Meas: 100, Thresh: ^tbl_rx.ber)" 100 le 0
    set off 0
    set failure 1
    set mind 0
  else
    call procResults lfile ^tbl_rx.ber mind
  endif

  if /plotson or ( failure eq 1 ) then
    say "max at index: ^mind!"
    ! show them the frame with the most errors
    calc nels ^tbl_rx.frame 1 *
    calc seek ^mind ^tbl_rx.frame *
    thin filei tmpi off+seek +^nels
    thin fileo tmpo seek +^nels
    headermod tmpi xs=0
    headermod tmpo xs=0
    pipe on 
      panel/setup
      plot/id=plot1 tmpi /all
      plot/id=plot2 tmpo /all
      plot/id=plot3 tmpi|tmpo /all
      list/id=plot4 lfile
    pipe off
  endif

  call cleanFiles

endmacro

procedure cleanFiles
  erase/warn=n filei fileo lfile tmpi tmpo rfrx
return

procedure procResults hi f:vber u:inde
 status hi size=sze
  file open/d tag hi
  set errs 0
  set proc 0
  set maxe 0
  set ^inde 0

  do ind 0 sze-1 1
    res tmp tag.getDataTable(ind)
    calc errs errs tmp.errors +
    calc proc proc tmp.proc +
    if tmp.errors gt maxe then 
      set ^inde ^ind
      set maxe tmp.errors
    endif
  enddo

  file close tag
  calc/nform=".0000" ber errs proc / 100 *
  ! test thresholds here
  assert/text="BER (Samples: ^proc, BER: ^ber, Thresh: ^vber)" ber lt vber
  if ber ge vber then 
    set failure 1
  endif
return

