startmacro t:tbl
  set flagsrx "^tbl.flags|^tbl.aflagsrx"
  set flagstx "^tbl.flags|^tbl.aflagstx"
  calc rate ^tbl.rate 1e6 *
  set wstr "aux=^tbl.aux"
  set failure 0

  ! reset cards
  picd/flags=force|^flagstx reset ^tbl.card
  call cleanFiles

  ! create input and output files
  calc xdel 1 rate /
  calc amp_ 2 ^tbl.levels **
  calc freq_ 1 2 ^tbl.levels 1 + ** /
  wave mfile{^wstr} ^tbl.format ^tbl.nels saw amp_ freq=^freq_
  headermod mfile{^wstr} xd=^xdel

  pic copy mfile filei
  pic create fileo ^tbl.format ^tbl.nels rate zero

  ! play/acquire
  picd/replay=4/stat=chan/port=^tbl.porttx/flags=^flagstx play ^tbl.card filei
  picd/replay=^tbl.replay/kick=chan/port=^tbl.portrx/flags=^flagsrx acquire ^tbl.card fileo

  ! measure 
  icemeas udp lfile fileo ^tbl.levels

  call procResults lfile ^tbl.cond

  if /plotson or ( failure eq 1 ) then
    pipe on
      panel/setup
      plot/id=plot1 filei ymin=-40k ymax=40k /all
      plot/id=plot2 fileo ymin=-40k ymax=40k /all
      list/id=plot3 lfile
    pipe off
  endif

  call cleanFiles

endmacro

procedure cleanFiles
  erase/warn=n mfile filei fileo lfile
return

procedure procResults hi cond
  status hi size=sze
  file open/d tag hi
  set maxdelt tag.getDataTable(0).maxdelta
  set errs tag.getDataTable(0).errors

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if maxdelt lt tmp.maxdelta
      set maxdelt tmp.maxdelta
    endif
    if errs lt tmp.errors
      set errors tmp.errors
    endif
  enddo

  file close tag
  assert/test=^cond/text="Max. Delta (Meas: ^maxdelt, Thresh: 1)" maxdelt eq 1
  assert/test=^cond/text="Number of Errors (Meas: ^errs, Thresh: 0)" errs eq 0 
  set bool ( maxdelt neq 1 ) or ( errs neq 0 )
  if ( maxdelt neq 1 ) or ( errs neq 0 ) then 
    if ( cond eqs pass ) then 
      set failure 1
    endif
  elseif ( cond eqs fail ) then 
     set failure 1
  endif
return

