/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See WBR.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME WBR
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 2
#define AW 16
#define BW 32*NP
#define CW 6

enum { WBR_ONP = 1 };
enum { WBR_OTAP = 6 };
enum { WBR_RTAP = 1 << WBR_OTAP };
enum { WBR_OFILT = 5 };
enum { WBR_FILT = 1 << WBR_OFILT };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  real_4 fwf;
  real_8 p;
  real_8 dp;
  real_8 dpinc;
  int_2 ntap;
  int_2 nrpt;
  real_4 fscl;
  real_4 lfp;
  real_4 mfp;
  real_4 dpi;
  real_4* dpia;
  int_1 updn;
  int_1 bypass;
  int_1 gain;
  CxTapBuf* vd;
  RomF2Di* rft;
  CxReal_4** vi;
  CxReal_4** vs;
  CxReal_4** vo;
} WBR;

#include "cores/CoreProtos.h"

/** CORE Code */

void* WBR_alloc (char *config) {
  WBR* plan = WBR_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 WBR_upload (WBR* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,22);
  HW_loadFlt  (planp,plan->fwf);
  HW_loadDbl  (planp,plan->p);
  HW_loadDbl  (planp,plan->dp);
  HW_loadDbl  (planp,plan->dpinc);
  HW_loadInt  (planp,plan->ntap);
  HW_loadInt  (planp,plan->nrpt);
  HW_loadFlt  (planp,plan->fscl);
  HW_loadFlt  (planp,plan->lfp);
  HW_loadFlt  (planp,plan->mfp);
  HW_loadFlt  (planp,plan->dpi);
  HW_loadBuf  (planp,plan->dpia,'f',1);
  HW_loadInt  (planp,plan->updn);
  HW_loadInt  (planp,plan->bypass);
  HW_loadInt  (planp,plan->gain);
  HW_loadInt  (planp,0);
  HW_loadObj  (planp,RomF2Di_upload(plan->rft,planp));
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_push (planp,HW_OPEN);
  return 22;
}

void WBR_setRatio (WBR* plan, real_8 ratio) {
  plan->dp = 1.0 / ratio;
  plan->ntap = WBR_RTAP - 2 * d2i (ceil (NP * plan->dp));
  plan->updn = (ratio > 1);
  plan->bypass = (plan->dp == 1);
  plan->dpinc = plan->updn ? plan->dp : ratio;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,5);HW_loadDbl(plan,plan->dpinc);  HW_push(plan,HW_UPD); }
}

void WBR_setGain (WBR* plan, real_8 dgain) {
  real_8 scale = pow (2.0, dgain / 6);
  plan->fscl = d2f (scale);
  if (plan->gain == dgain) return;
  plan->gain = (int_1) (dgain);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,16);HW_loadInt1(plan,plan->gain); HW_loadAddr(plan,9);HW_loadFlt(plan,plan->fscl);  HW_push(plan,HW_UPD); }
}

void WBR_genFilt (WBR* plan) {
  int_4 i, j, k, nt = plan->nrpt * plan->ntap;
  int_4 joff = WBR_RTAP - plan->ntap;
  real_8 fw = plan->updn ? plan->fwf : plan->fwf / plan->dp;
  real_4* ctap = zallocBuf(sizeof(real_4)*(nt * 2));
  firkais_generate (1, fw / plan->nrpt, 0.0, 0.05 / plan->nrpt, 90.0, ctap, nt, 0);
  for (i = j = 0; j < plan->ntap; j ++) for (k = 0; k < plan->nrpt; k ++, i += 2) RomF2Di_set (plan->rft, k, j + joff, ctap[i] * plan->nrpt);
}

int_4 WBR_init (WBR* plan) {
  plan->fwf = 0.9F;
  plan->dp = 1;
  plan->fscl = 1;
  plan->ntap = WBR_RTAP;
  plan->nrpt = WBR_FILT;
  return 0;
}

int_4 WBR_set (WBR* plan, String* key, Value* value) {
  if (isMatch (key, "D:RATIO")) WBR_setRatio (plan, Value_toD (value));
  else if (isMatch (key, "L:NTAP")) plan->ntap = Value_toL (value);
  else if (isMatch (key, "F:FWF")) plan->fwf = Value_toF (value);
  else if (isMatch (key, "D:GAIN")) WBR_setGain (plan, Value_toD (value));
  else return Core_set (plan, key, value);
  return 0;
}

int_4 WBR_get (WBR* plan, String* key, Value* value) {
  if (isMatch (key, "L:GAIN")) Value_fromL (value, plan->gain);
  else if (isMatch (key, "L:NTAP")) Value_fromL (value, plan->ntap);
  else if (isMatch (key, "D:RATIO")) Value_fromD (value, 1.0 / plan->dp);
  else if (isMatch (key, "D:XDIO")) Value_fromD (value, plan->dp);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 WBR_open (WBR* plan) {
  int_4 i;
  plan->rft = RomF2Di_new (WBR_OFILT, WBR_OTAP, WBR_RTAP);
  plan->vd = CxTapBuf_new (WBR_OTAP, 1, WBR_RTAP, -1);
  plan->vi = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vi[i] = CxReal_4_new ();
  plan->vo = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vo[i] = CxReal_4_new ();
  plan->vs = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vs[i] = CxReal_4_new ();
  if (plan->ntap > WBR_RTAP) {
    printf ("Number taps=%d limited to max taps=%d for this build\n", plan->ntap, WBR_RTAP);
    plan->ntap = WBR_RTAP;
  }
  WBR_genFilt (plan);
  plan->dpi = d2f (plan->dp);
  plan->p = 0;
  plan->lfp = 0;
  plan->mfp = 1 - plan->lfp;
  plan->dpia = zallocBuf(sizeof(real_4)*(NP));
  for (i = 0; i < NP; i ++) plan->dpia[i] = plan->dpi * i;
  plan->dpi = d2f (plan->dp * 0.999);
  printf ("WBR dp=%f ntap=%d nrpt=%d spc=%d byp=%d\n", plan->dp, plan->ntap, plan->nrpt, NP, plan->bypass ? 1 : 0);
  WBR_upload (plan,plan);
  return 0;
}

int_4 WBR_process (WBR* plan, Stream* si, Stream* so) {
  CxReal_4 fi_,*fi=&fi_;
  int_1 doin, doout;
  real_4 pp, nfp;
  int_2 i, j, k;
  CxReal_4 tf_,*tf=&tf_;
  while (si->rok && so->wok) {
    nfp = d2f (plan->p);
    if (plan->updn) {
      doin = nfp < plan->lfp;
      doout = 1;
      pp = nfp;
    }
    else {
      doin = 1;
      doout = (nfp <= plan->lfp);
      pp = plan->mfp * plan->dpi;
    }
    plan->lfp = nfp;
    plan->mfp = 1.0F - nfp;
    plan->p = frac (plan->p + plan->dpinc);
    if (doin) {
      Stream_rdCIFA (si, plan->vi, NP);
      for (k = 0; k < NP; k ++) {
        mulfc (plan->fscl, plan->vi[k], plan->vs[k]);
      }
      CxTapBuf_loadA (plan->vd, plan->vs, NP);
    }
    if (doout) {
      for (j = 0; j < NP; j ++) {
        real_4 rp;
        rp = mulfp2 (pp, WBR_ONP) + plan->dpia[j];
        CxReal_4 fr_,*fr=&fr_;
        fr->x = 0;
        fr->y = 0;
        for (i = 0; i < WBR_RTAP; i ++) {
          real_4 ft, ftx;
          CxReal_4 fdi_,*fdi=&fdi_, fdix_,*fdix=&fdix_, fdiy_,*fdiy=&fdiy_;
          ftx = RomF2Di_getrN (plan->rft, rp, i);
          ft = ftx;
          CxTapBuf_get (plan->vd, i, fdix);
          fdi = fdix;
          fr->x += ft * fdi->x;
          fr->y += ft * fdi->y;
        }
        plan->vo[j] = fr;
      }
      Stream_wrCFIA (so, plan->vo, NP);
    }
  }
  return 0;
}

int_4 WBR_close (WBR* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 WBR_poll (WBR* plan) { return 0; }

int_4 WBR_free (WBR* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

WBR* WBR_subCore (HALO* halo, int_4 scid) {
  WBR* plan = WBR_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  WBR_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
