/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See PKT2DAT.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME PKT2DAT
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 4
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 2

static char* PKT2DAT_pktList = "Auto,None,Eth,UDP,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
enum { PKT2DAT_PT_AUTO = -1 };
enum { PKT2DAT_PT_NONE = 0 };
enum { PKT2DAT_PT_ETH = 1 };
enum { PKT2DAT_PT_UDP = 2 };
enum { PKT2DAT_PT_ICE = 3 };
enum { PKT2DAT_PT_SDDS = 4 };
enum { PKT2DAT_PT_VRT = 5 };
enum { PKT2DAT_PT_VRTL = 6 };
enum { PKT2DAT_PT_VRTW = 7 };
enum { PKT2DAT_PT_VRTX = 8 };
enum { PKT2DAT_PT_VRTD = 9 };
static char* PKT2DAT_flgList = "Asis,Gate,Clip,AllEth,AnyMC,AnySID,AnyIP,Other,Pack,Test";
enum { PKT2DAT_RW = 15 };
enum { PKT2DAT_NC = 4 };
enum { PKT2DAT_IP = 0x0008 };
enum { PKT2DAT_ARP = 0x0608 };
enum { PKT2DAT_ICMP = 1 };
enum { PKT2DAT_IGMP = 2 };
enum { PKT2DAT_TCP = 6 };
enum { PKT2DAT_UDP = 17 };
enum { PKT2DAT_SOP = 0xD555 };
enum { PKT2DAT_OUID = 0x104D77 };
enum { PKT2DAT_DIFI = 0x6A621E };
enum { PKT2DAT_GATE = 0x1CEF0000 };
enum { PKT2DAT_IGMP_BA = 0xe0000001 };
enum { PKT2DAT_RES_IPKT = 1 };
enum { PKT2DAT_RES_OPKT = 2 };
enum { PKT2DAT_RES_ARP = 3 };
enum { PKT2DAT_RES_ICMP = 4 };
enum { PKT2DAT_RES_IGMP = 5 };
enum { PKT2DAT_RES_OTHER = 6 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_1 pkty;
  int_u4 myip;
  int_u4 mcip;
  int_u2 mcid;
  int_u2 flags;
  int_u1 osel;
  int_u2 ipkt;
  int_u4 opkt;
  int_u1 ic;
  int_u1 nc;
  int_u4* mcips;
  int_u2* mcids;
  int_u1* osels;
  int_u4 counts;
  int_u1 nseq;
  int_4 ouid;
  int_4 debug;
  Dma* dma;
} PKT2DAT;

#include "cores/CoreProtos.h"

/** CORE Code */

void* PKT2DAT_alloc (char *config) {
  PKT2DAT* plan = PKT2DAT_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 PKT2DAT_upload (PKT2DAT* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,18);
  HW_loadInt  (planp,plan->pkty);
  HW_loadInt  (planp,plan->myip);
  HW_loadInt  (planp,plan->mcip);
  HW_loadInt  (planp,plan->mcid);
  HW_loadInt  (planp,plan->flags);
  HW_loadInt  (planp,plan->osel);
  HW_loadInt  (planp,plan->ipkt);
  HW_loadInt  (planp,plan->opkt);
  HW_loadInt  (planp,plan->ic);
  HW_loadInt  (planp,plan->nc);
  HW_loadBuf  (planp,plan->mcips,'i',1);
  HW_loadBuf  (planp,plan->mcids,'s',1);
  HW_loadBuf  (planp,plan->osels,'b',1);
  HW_loadInt  (planp,plan->counts);
  HW_loadInt  (planp,plan->nseq);
  HW_loadInt  (planp,plan->ouid);
  HW_loadInt  (planp,plan->debug);
  HW_loadInt  (planp,0);
  HW_push (planp,HW_OPEN);
  return 18;
}

int_4 PKT2DAT_init (PKT2DAT* plan) {
  plan->ic = 0;
  plan->nc = 0;
  plan->pkty = PKT2DAT_PT_AUTO;
  plan->ouid = 0;
  return 0;
}

int_4 PKT2DAT_set (PKT2DAT* plan, String* key, Value* value) {
  if (isMatch (key, "S:PT")) plan->pkty = Value_toItem (value, PKT2DAT_pktList);
  else if (isMatch (key, "L:PKTY")) plan->pkty = Value_toL (value);
  else if (isMatch (key, "L:MYIP")) plan->myip = Value_toL (value);
  else if (isMatch (key, "L:CHAN")) plan->ic = Value_toL (value);
  else if (isMatch (key, "L:MCIP")) plan->mcip = Value_toL (value);
  else if (isMatch (key, "L:MCID")) plan->mcid = Value_toL (value) & 0xFFFF;
  else if (isMatch (key, "L:OSEL")) plan->osel = Value_toL (value);
  else if (isMatch (key, "L:OUID")) plan->ouid = Value_toL (value);
  else if (isMatch (key, "S:FLAGS")) plan->flags = Value_toMask (value, PKT2DAT_flgList);
  else if (isMatch (key, "L:FLAGS")) plan->flags = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 PKT2DAT_get (PKT2DAT* plan, String* key, Value* value) {
  if (isMatch (key, "L:PKTY")) Value_fromL (value, plan->pkty);
  else if (isMatch (key, "L:MYIP")) Value_fromL (value, plan->myip);
  else if (isMatch (key, "L:MCIP")) Value_fromL (value, plan->mcip);
  else if (isMatch (key, "L:MCID")) Value_fromL (value, plan->mcid);
  else if (isMatch (key, "L:FLAGS")) Value_fromL (value, plan->flags);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 PKT2DAT_open (PKT2DAT* plan) {
  int_4 i;
  plan->dma = Dma_new (PKT2DAT_RW, BW);
  plan->mcips = zallocBuf(sizeof(int_u4)*(PKT2DAT_NC));
  plan->mcids = zallocBuf(sizeof(int_u2)*(PKT2DAT_NC));
  plan->osels = zallocBuf(sizeof(int_u1)*(PKT2DAT_NC));
  for (i = 0; i < PKT2DAT_NC; i ++) {
    plan->mcips[i] = 0xFFFFFFFF;
    plan->mcids[i] = 0xFFFF;
    plan->osels[i] = 0;
  }
  plan->mcips[plan->ic] = plan->mcip;
  plan->mcids[plan->ic] = plan->mcid;
  plan->osels[plan->ic] = plan->osel;
  if (plan->pkty == PKT2DAT_PT_UDP) plan->flags |= 0x01;
  if (plan->pkty == PKT2DAT_PT_ETH) plan->flags |= 0x08;
  if (plan->mcip == 0xFFFFFFFF) plan->flags |= 0x10;
  if (plan->mcid == 0xFFFF) plan->flags |= 0x20;
  if (plan->ouid < 0) plan->flags |= 0x400;
  if (plan->ouid <= 0) plan->ouid = (plan->pkty == PKT2DAT_PT_VRTD) ? PKT2DAT_DIFI : PKT2DAT_OUID;
  plan->ipkt = 0;
  plan->opkt = 0;
  plan->nseq = 0;
  plan->counts = 0;
  if(plan->halo.vbpr&1)printf ("PKT2DAT pkt=%d flg=%04x\n", plan->pkty, plan->flags);
  PKT2DAT_upload (plan,plan);
  return 0;
}

int_4 PKT2DAT_process (PKT2DAT* plan, Buffer* bi, Stream* sip, Stream* so, Stream* sop) {
  int_u2 length, reslen, pktlen, udplen, ulen, dlen;
  int_u4 src, dest, bx, by, bz, bq, bs;
  int_u1 ihdr, ioff, seq, dmaflg;
  int_u1 restyp, ooff, bps, tlen;
  int_u2 sid;
  int_1 asis, gate, doclip, anyMC, anySID, anyOUID, anyIP, othpkt, pack, isMe, isMC, isBA, isSID, isOUID, hasOUID, hasSID;
  int_1 isARP, isIP, isICMP, isIGMP, isUDP, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTx, isVRTd, isVRTc, isVCTX, isKeep, isBE, isNB;
  int_1 alludp, alleth, okICE, okSDDS, okVRT, noOut, tena, xrst;
  asis = getBit(plan->flags, 0);
  gate = getBit(plan->flags, 1);
  doclip = getBit(plan->flags, 2);
  alleth = getBit(plan->flags, 3) || (plan->pkty == PKT2DAT_PT_ETH);
  anyMC = getBit(plan->flags, 4);
  anySID = getBit(plan->flags, 5);
  anyIP = getBit(plan->flags, 6);
  othpkt = getBit(plan->flags, 7);
  pack = getBit(plan->flags, 8);
  tena = getBit(plan->flags, 9);
  tlen = getBits(plan->flags, 15, 12);
  xrst = 0;
  noOut = (plan->pkty == PKT2DAT_PT_NONE) && ! getBit(plan->flags, 1);
  alludp = (plan->pkty == PKT2DAT_PT_UDP);
  okICE = (plan->pkty == PKT2DAT_PT_AUTO) || (plan->pkty == PKT2DAT_PT_ICE);
  okSDDS = (plan->pkty == PKT2DAT_PT_AUTO) || (plan->pkty == PKT2DAT_PT_SDDS);
  okVRT = (plan->pkty == PKT2DAT_PT_AUTO) || (plan->pkty >= PKT2DAT_PT_VRT);
  if (gate && ! sip->rok && so->wok && ! noOut) {
    Stream_wrL (so, PKT2DAT_GATE);
  }
  while (sip->rok) {
    dmaflg = 0;
    pktlen = 0;
    reslen = 0;
    restyp = 0;
    ihdr = 0;
    ioff = 0;
    length = 0;
    seq = plan->nseq;
    plan->ipkt ++;
    plan->counts=setBits(plan->counts, 11, 0, plan->ipkt);
    bs = Stream_rdL (sip);
    by = Buffer_getL (bi, 0);
    bx = Buffer_getL (bi, 12);
    isARP = (getBits(bx, 31, 16) == PKT2DAT_ARP);
    isIP = (getBits(bx, 31, 16) == PKT2DAT_IP);
    bx = Buffer_getL (bi, 24);
    isUDP = isIP && (getBits(bx, 15, 8) == PKT2DAT_UDP);
    isICMP = isIP && (getBits(bx, 15, 8) == PKT2DAT_ICMP);
    isIGMP = isIP && (getBits(bx, 15, 8) == PKT2DAT_IGMP);
    isVCTX = 0;
    bx = Buffer_getL (bi, 32);
    dest = bswap4 (bx);
    isMe = (dest == plan->myip);
    isMC = (dest == plan->mcip);
    isBA = (dest == PKT2DAT_IGMP_BA);
    if (getBits(bs, 17, 16) != 0x1 || getBits(by, 15, 0) != PKT2DAT_SOP) {
      xrst = 1;
      plan->counts=setBit(plan->counts, 31, 1);
      plan->counts=setBits(plan->counts, 30, 28, getBits(plan->counts, 30, 28) + 1);
      return 1;
    }
    if (isUDP && (anyMC || isMC) && ! alleth) {
      bx = Buffer_getL (bi, 40);
      udplen = bswap2 (getBits(bx, 15, 0));
      ooff = 8;
      ihdr = 44;
      isKeep = 1;
      bx = Buffer_getL (bi, ihdr);
      by = Buffer_getL (bi, ihdr + 4);
      bz = Buffer_getL (bi, ihdr + 8);
      bq = Buffer_getL (bi, ihdr + 12);
      anyOUID = getBit(plan->flags, 10) || ! getBit(bx, 3);
      hasOUID = getBit(bx, 3);
      hasSID = (getBits(bx, 6, 5) > 1) ? 1 : getBit(bx, 4);
      sid = bswap2 (hasSID ? getBits(by, 31, 16) : getBits(bz, 15, 0));
      isSID = (sid == plan->mcid);
      isOUID = (plan->ouid == bswap4 (hasSID ? bz : by));
      isVRTi = (getBits(bx, 7, 0) == 0x1C);
      isVRTj = (getBits(bx, 7, 0) == 0x08);
      isVRTx = (getBits(bx, 7, 0) == 0x14) && (plan->pkty == PKT2DAT_PT_VRTX);
      isVRTd = (getBits(bx, 7, 0) == 0x18);
      isVRTc = (getBits(bx, 7, 0) == 0x49) || (getBits(bx, 7, 0) == 0x41);
      isICE = okICE && (bx == 0x00676665);
      isSDDS = okSDDS && (udplen == 1088);
      isVRT = okVRT && (isVRTi || isVRTj || isVRTx || isVRTd) && (isSID || anySID) && (isOUID || anyOUID);
      isVCTX = okVRT && isVRTc && (isSID || anySID) && (isOUID || anyOUID);
      if (alludp) {
        ioff = 0;
      }
      else if (isICE) {
        ioff = 64;
        seq = getBits(by, 7, 0);
        sid = getBits(bq, 31, 16);
      }
      else if (isSDDS) {
        ioff = 56;
        seq = getBits(bx, 31, 24);
        isNB = getBits(bx, 13, 8) > 8;
        bq = Buffer_getL (bi, ihdr + 52);
        sid = getBits(bq, 31, 16);
        dmaflg=setBit(dmaflg, 0, isNB);
      }
      else if (isVRT) {
        if ((getBit(bx, 2)) && ! asis) {
          ooff = 12;
        }
        seq = getBits(bx, 11, 8);
        plan->nseq = plan->nseq & 0xF;
        ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28;
        isBE = isVRTi ? getBit(bq, 22) : isVRTj ? getBit(bz, 22) : 1;
        bps = isVRTi ? getBits(bq, 27, 24) : isVRTj ? getBits(bz, 27, 24) : 15;
        dmaflg=setBit(dmaflg, 0, (bps == 15) && isBE);
        dmaflg=setBit(dmaflg, 1, (bps > 7) && isBE);
        dmaflg=setBit(dmaflg, 2, (bps == 11) && isBE);
        if (tena) {
          bx = Buffer_getL (bi, ihdr + 16);
          isKeep = (getBits(bx, 31, 28) < tlen);
        }
      }
      else {
        isKeep = isVCTX ? asis : 0;
      }
      if (asis) {
        ioff = 0;
        dmaflg = 0;
      }
      ulen = udplen - ioff - ooff;
      isSID = (sid == plan->mcid);
      if (isKeep && (isSID || anySID)) {
        length = ulen;
      }
    }
    else if (isICMP && (isMe | anyIP)) {
      restyp = PKT2DAT_RES_ICMP;
      plan->counts=setBits(plan->counts, 19, 16, getBits(plan->counts, 19, 16) + 1);
      alleth |= ! gate;
    }
    else if (isIGMP && (isMe | anyIP | isMC | isBA)) {
      restyp = PKT2DAT_RES_IGMP;
      plan->counts=setBits(plan->counts, 23, 20, getBits(plan->counts, 23, 20) + 1);
    }
    else if (isARP) {
      bx = Buffer_getL (bi, 40);
      dest = bswap4 (bx);
      isMe = (dest == plan->myip);
      if (isMe) {
        restyp = PKT2DAT_RES_ARP;
        plan->counts=setBits(plan->counts, 27, 24, getBits(plan->counts, 27, 24) + 1);
        alleth |= ! gate;
      }
    }
    else if (othpkt && ! isUDP) {
      restyp = PKT2DAT_RES_OTHER;
      plan->counts=setBits(plan->counts, 30, 28, getBits(plan->counts, 30, 28) + 1);
    }
    if (alleth) {
      while (! sip->rok) {
      }
      pktlen = Stream_rdL (sip);
      pktlen &= 0xFFFF;
      length = pktlen;
      if (gate) {
        Stream_wrL (so, PKT2DAT_GATE | pktlen);
      }
    }
    if (length > 0 && ! noOut) {
      if (plan->nc > 0) {
        plan->osel = plan->osels[plan->ic];
      }
      Stream_setC (so, plan->osel);
      Dma_setFlags (plan->dma, dmaflg);
      Dma_b2s (plan->dma, bi, ihdr + ioff, so, 0, length);
      plan->opkt ++;
      if (isUDP && ! isVCTX) {
        if (seq != plan->nseq) {
          plan->counts=setBits(plan->counts, 15, 12, getBits(plan->counts, 15, 12) + 1);
        }
        plan->nseq = seq + 1;
      }
      Dma_sync (plan->dma);
    }
    if (! alleth) {
      while (! sip->rok) {
      }
      pktlen = Stream_rdL (sip);
      pktlen &= 0xFFFF;
    }
    if (restyp > 0 && sop->wok) {
      Dma_setFlags (plan->dma, 0);
      reslen = pktlen;
      bs=setBits(bs, 31, 20, 0x1CE);
      bs=setBits(bs, 19, 16, restyp);
      bs=setBits(bs, 15, 0, reslen);
      Stream_wrL (sop, bs);
      bs = bswap4 (plan->myip);
      Stream_wrL (sop, bs);
      Dma_b2s (plan->dma, bi, 0, sop, 0, reslen);
      printf ("Got restyp=%d reslen=%d\n", restyp, reslen);
      Dma_sync (plan->dma);
    }
    Buffer_rnxt (bi, pktlen);
  }
  plan->opkt = plan->opkt;
  plan->counts = plan->counts;
  return 0;
}

int_4 PKT2DAT_close (PKT2DAT* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 PKT2DAT_poll (PKT2DAT* plan) { return 0; }

int_4 PKT2DAT_free (PKT2DAT* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

PKT2DAT* PKT2DAT_subCore (HALO* halo, int_4 scid) {
  PKT2DAT* plan = PKT2DAT_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  PKT2DAT_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
