/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See Modems.jv for documentation.
*/
#include "Modefs.c"
#ifndef _Modems_
#include "cores/CoreDefs.h"


static int_1 mapTCM[] = { 0x0 , 0x2 , 0x3 , 0x1 , 0x4 , 0x6 , 0x7 , 0x5 };

/** Define CORE Plan Handles */
typedef struct {
  int_4 alg;
  int_4 upp;
  real_8 ratio;
  int_4 MO;
  int_4 MP;
  int_4 OLUT;
  int_4 NLUT;
  int_u1 ilen;
  int_u1 olen;
  int_u1 ibit;
  int_u1 slen;
  int_u1 obit;
  int_u1 serr;
  int_u1 ipunc;
  int_u1 jpunc;
  int_u1 mpunc;
  int_u2 mask;
  int_u2 shft;
  int_u1 rluts;
  int_u1 vluts;
  int_u1* rlut;
  int_u1* pflgs;
  int_u1 vflg;
  int_u1 sdb;
  int_u8 ivec;
  int_u2 ovec;
  int_1 iby3;
  int_1 oby2;
  int_1 frm1;
  int_1 frm2;
  int_u1 uv;
  Viterbi* vit;
} Modems_IFEC;

int_4 Modems_IFEC_upload (Modems_IFEC* plan, void *planp) {
  HW_loadHdr (planp,30);
  HW_loadInt  (planp,plan->MO);
  HW_loadInt  (planp,plan->MP);
  HW_loadInt  (planp,plan->OLUT);
  HW_loadInt  (planp,plan->NLUT);
  HW_loadInt  (planp,plan->ilen);
  HW_loadInt  (planp,plan->olen);
  HW_loadInt  (planp,plan->ibit);
  HW_loadInt  (planp,plan->slen);
  HW_loadInt  (planp,plan->obit);
  HW_loadInt  (planp,plan->serr);
  HW_loadInt  (planp,plan->ipunc);
  HW_loadInt  (planp,plan->jpunc);
  HW_loadInt  (planp,plan->mpunc);
  HW_loadInt  (planp,plan->mask);
  HW_loadInt  (planp,plan->shft);
  HW_loadInt  (planp,plan->rluts);
  HW_loadInt  (planp,plan->vluts);
  HW_loadBuf  (planp,plan->rlut,'b',1);
  HW_loadBuf  (planp,plan->pflgs,'b',1);
  HW_loadInt  (planp,plan->vflg);
  HW_loadInt  (planp,plan->sdb);
  HW_loadInt8 (planp,plan->ivec);
  HW_loadInt  (planp,plan->ovec);
  HW_loadInt  (planp,plan->iby3);
  HW_loadInt  (planp,plan->oby2);
  HW_loadInt  (planp,plan->frm1);
  HW_loadInt  (planp,plan->frm2);
  HW_loadInt  (planp,plan->uv);
  HW_loadInt  (planp,0);
  return 30;
}

int_4 Modems_getModID (String* s) {
  int_4 id = findListItem (Modefs_modList, s, -2);
  if (id < 0) printf ("Unknown MOD type=%s\n", s);
  return id;
}

int_4 Modems_getFecID (String* s) {
  int_4 id = findListItem (Modefs_fecList, s, -2);
  if (id < 0) printf ("Unknown FEC type=%s\n", s);
  return id;
}

int_4 Modems_getMapID (String* s) {
  int_4 id = findListItem (Modefs_mapList, s, -2);
  if (id < 0) printf ("Unknown MAP type=%s\n", s);
  return id;
}

int_4 Modems_getBitsPerSym (int_4 mod) {
  int_4 bps;
  switch (mod) {
    case Modefs_MT_1024QAM : bps = 10;
    break;
    case Modefs_MT_512QAM : bps = 9;
    break;
    case Modefs_MT_256APSK : case Modefs_MT_256CQAM : case Modefs_MT_256QAM : bps = 8;
    break;
    case Modefs_MT_128APSK : case Modefs_MT_128CQAM : case Modefs_MT_128QAM : bps = 7;
    break;
    case Modefs_MT_64APSK : case Modefs_MT_64CQAM : case Modefs_MT_64QAM : bps = 6;
    break;
    case Modefs_MT_32APSK : case Modefs_MT_32QAM : bps = 5;
    break;
    case Modefs_MT_16APSK : case Modefs_MT_16PSK : case Modefs_MT_16CQAM : case Modefs_MT_16QAM : bps = 4;
    break;
    case Modefs_MT_8PSK : bps = 3;
    break;
    case Modefs_MT_8QAM : bps = 3;
    break;
    case Modefs_MT_FSK : case Modefs_MT_BPSK : bps = 1;
    break;
    default : bps = 2;
  }
  return bps;
}

int_4 Modems_getGridSF (int_4 mod) {
  int_4 bps = Modems_getBitsPerSym (mod);
  real_8 gsf = sqrt (pow (2.0, i2d (bps)));
  return d2i (round (gsf / 2));
}

real_4 Modems_getMinSNR (int_4 mod) {
  real_4 snr;
  switch (mod) {
    case Modefs_MT_1024QAM : snr = 40;
    break;
    case Modefs_MT_512QAM : snr = 36;
    break;
    case Modefs_MT_256APSK : case Modefs_MT_256CQAM : case Modefs_MT_256QAM : snr = 30;
    break;
    case Modefs_MT_128APSK : case Modefs_MT_128CQAM : case Modefs_MT_128QAM : snr = 20;
    break;
    case Modefs_MT_64APSK : case Modefs_MT_64CQAM : case Modefs_MT_64QAM : snr = 15;
    break;
    case Modefs_MT_32APSK : case Modefs_MT_32QAM : snr = 12;
    break;
    case Modefs_MT_16APSK : case Modefs_MT_16CQAM : case Modefs_MT_16QAM : snr = 9;
    break;
    case Modefs_MT_8PSK : snr = 9;
    break;
    case Modefs_MT_8QAM : snr = 9;
    break;
    case Modefs_MT_BPSK : snr = 6;
    break;
    default : snr = 6;
  }
  return snr;
}

real_4 Modems_getMinCV (int_4 mod) {
  real_4 cv;
  switch (mod) {
    case Modefs_MT_FSK : cv = -9;
    break;
    case Modefs_MT_4FSK : cv = -12;
    break;
    case Modefs_MT_8PSK : cv = -10;
    break;
    case Modefs_MT_AM : cv = -9;
    break;
    case Modefs_MT_FM : cv = -9;
    break;
    case Modefs_MT_OQPSK : cv = -6;
    break;
    case Modefs_MT_QPSK : cv = -9;
    break;
    default : cv = -20;
  }
  return cv;
}

real_4 Modems_getCFact (int_4 mod) {
  real_4 cf;
  switch (mod) {
    case Modefs_MT_256CQAM : cf = 0.001F;
    break;
    case Modefs_MT_128QAM : cf = 0.002F;
    break;
    case Modefs_MT_64APSK : cf = 0.05F;
    break;
    case Modefs_MT_32QAM : cf = 0.001F;
    break;
    case Modefs_MT_BPSK : cf = 0.10F;
    break;
    default : cf = 0.01F;
  }
  return cf;
}

int_4 Modems_bitRev (int_4 ord, int_4 im) {
  int_4 i, om = 0;
  for (i = 0; i < ord; i ++) if (((im >> i) & 1) != 0) om |= (1 << (ord - 1 - i));
  return om;
}

int_4 Modems_getMap (int_4 map, int_4 ord, int_4 i) {
  int_4 n = (1 << ord), nh = n / 2, o = i;
  if (map == Modefs_MAP_BRGCIB && i >= nh) i = n - 1 - i + nh;
  if (map >= Modefs_MAP_BRGC) o = i ^ (i >> 1);
  if (map == Modefs_MAP_BRGCNT) o = mapTCM[i];
  if (map == Modefs_MAP_BRGCBE) o = Modems_bitRev (ord, o);
  return o;
}

int_4 Modems_getMapXY (int_4 map, int_4 ord, int_4 i, int_4 j, int_4 k) {
  int_4 o, hord = ord / 2, n = (1 << hord), im, jm;
  if (map == Modefs_MAP_BRGCIX || map == Modefs_MAP_BRGCIXY) i = n - 1 - i;
  if (map == Modefs_MAP_BRGCIY || map == Modefs_MAP_BRGCIXY) j = n - 1 - j;
  im = (map >= Modefs_MAP_BRGC) ? i ^ (i >> 1) : i;
  jm = (map >= Modefs_MAP_BRGC) ? j ^ (j >> 1) : j;
  o = (im << hord) | jm;
  if ((ord & 1) != 0) o = k;
  if (map == Modefs_MAP_BRGCBE) o = Modems_bitRev (ord, o);
  return o;
}

void Modems_fixCQ (int_4 nr, real_4 rs, int_4 i, int_4 j, int_4 im, real_4* xa, real_4* ya) {
  int_4 k;
  real_4 r, rr;
  real_4 xr = xa[im], yr = ya[im];
  r = sqrtf (xr * xr + yr * yr);
  i = (i < nr) ? nr - 1 - i : i - nr;
  j = (j < nr) ? nr - 1 - j : j - nr;
  k = imax (i, j);
  rr = (k == 0) ? 0.8F : rs * (k + 0.5F) / r;
  xa[im] = xr * rr;
  ya[im] = yr * rr;
}

int_4 Modems_getSymbolMap (int_4 mod, int_4 map, real_8 amp, real_8 midx, int_4 nper, real_4* x, real_4* y) {
  real_4 scl = (real_4) amp;
  int_4 i, j, k = 0, im, jm, km, hlut = 0, olut = 0;
  real_8 p;
  if (map < 0) map = Modefs_MAP_BRGC;
  if (mod == Modefs_MT_NONE) olut = 0;
  else if (mod == Modefs_MT_CW) {
    olut = 10;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < 1024; i ++) {
      p = (i + 0.5) / 1024;
      x[i] = r1 * coscf (p);
      y[i] = r1 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_FSK) {
    olut = 1;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < nper * 2; i ++) {
      p = (0.5 * midx * i) / nper;
      j = 0 + (i << 4);
      x[j] = r1 * coscf (p);
      y[j] = r1 * sincf (p);
    }
    for (i = 0; i < nper * 2; i ++) {
      p = (-0.5 * midx * i) / nper;
      j = 1 + (i << 4);
      x[j] = r1 * coscf (p);
      y[j] = r1 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_4FSK) {
    olut = 2;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < nper * 2; i ++) {
      p = (0.5 * midx * i) / nper;
      j = 0 + (i << 4);
      x[j] = r1 * coscf (p);
      y[j] = r1 * sincf (p);
    }
    for (i = 0; i < nper * 2; i ++) {
      p = (-0.5 * midx * i) / nper;
      j = 1 + (i << 4);
      x[j] = r1 * coscf (p);
      y[j] = r1 * sincf (p);
    }
    for (i = 0; i < nper * 2; i ++) {
      p = (1.5 * midx * i) / nper;
      j = 2 + (i << 4);
      x[j] = r1 * coscf (p);
      y[j] = r1 * sincf (p);
    }
    for (i = 0; i < nper * 2; i ++) {
      p = (-1.5 * midx * i) / nper;
      j = 3 + (i << 4);
      x[j] = r1 * coscf (p);
      y[j] = r1 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_BPSK) {
    olut = 1;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < 2; i ++) {
      p = (i + 0.25) / 2;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
  }
  else if (mod >= Modefs_MT_QPSK && mod <= Modefs_MT_1P4DQPSK) {
    olut = 2;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < 4; i ++) {
      p = (i + 0.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_8PSK) {
    olut = 3;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < 8; i ++) {
      p = (i + 0.5) / 8;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_16PSK) {
    olut = 4;
    real_4 r1 = scl * (1.414F / 2);
    for (i = 0; i < 16; i ++) {
      p = (i + 0.5) / 16;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_16APSK) {
    olut = 4;
    real_4 r2 = scl * (1.5F / 2), r1 = r2 * (1.0F / 2.57F);
    for (i = 0; i < 4; i ++) {
      p = (i + 0.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
    for (i = 4; i < 16; i ++) {
      p = (i - 3.5) / 12;
      im = Modems_getMap (map, olut, i);
      x[im] = r2 * coscf (p);
      y[im] = r2 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_32APSK) {
    olut = 5;
    real_4 r3 = scl * (2.5F / 3), r2 = r3 * (2.53F / 4.30F), r1 = r3 * (1.0F / 4.30F);
    for (i = 0; i < 4; i ++) {
      p = (i + 0.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
    for (i = 4; i < 16; i ++) {
      p = (i - 3.5) / 12;
      im = Modems_getMap (map, olut, i);
      x[im] = r2 * coscf (p);
      y[im] = r2 * sincf (p);
    }
    for (i = 16; i < 32; i ++) {
      p = (i - 15.) / 16;
      im = Modems_getMap (map, olut, i);
      x[im] = r3 * coscf (p);
      y[im] = r3 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_64APSK) {
    olut = 6;
    real_4 r4 = scl * (3.5F / 4), r3 = r4 * (4.0F / 5.3F), r2 = r4 * (2.53F / 5.30F), r1 = r4 * (1.0F / 5.30F);
    for (i = 0; i < 4; i ++) {
      p = (i + 0.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
    for (i = 4; i < 16; i ++) {
      p = (i - 3.5) / 12;
      im = Modems_getMap (map, olut, i);
      x[im] = r2 * coscf (p);
      y[im] = r2 * sincf (p);
    }
    for (i = 16; i < 36; i ++) {
      p = (i - 15.5) / 20;
      im = Modems_getMap (map, olut, i);
      x[im] = r3 * coscf (p);
      y[im] = r3 * sincf (p);
    }
    for (i = 36; i < 64; i ++) {
      p = (i - 35.5) / 28;
      im = Modems_getMap (map, olut, i);
      x[im] = r4 * coscf (p);
      y[im] = r4 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_128APSK) {
    olut = 7;
    real_4 r5 = scl * (4.5F / 5), r4 = scl * (3.5F / 5), r3 = scl * (2.5F / 5), r2 = scl * (1.5F / 5), r1 = r5 * (0.7F / 5);
    for (i = 0; i < 4; i ++) {
      p = (i + 0.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
    for (i = 4; i < 16; i ++) {
      p = (i - 3.5) / 12;
      im = Modems_getMap (map, olut, i);
      x[im] = r2 * coscf (p);
      y[im] = r2 * sincf (p);
    }
    for (i = 16; i < 36; i ++) {
      p = (i - 15.5) / 20;
      im = Modems_getMap (map, olut, i);
      x[im] = r3 * coscf (p);
      y[im] = r3 * sincf (p);
    }
    for (i = 36; i < 64; i ++) {
      p = (i - 35.5) / 28;
      im = Modems_getMap (map, olut, i);
      x[im] = r4 * coscf (p);
      y[im] = r4 * sincf (p);
    }
    for (i = 64; i < 128; i ++) {
      p = (i - 63.5) / 64;
      im = Modems_getMap (map, olut, i);
      x[im] = r5 * coscf (p);
      y[im] = r5 * sincf (p);
    }
  }
  else if (mod == Modefs_MT_8QAM) {
    olut = 3;
    real_4 r2 = scl * (1.848F / 2.5F), r1 = (0.768F / 2.5F);
    for (i = 0; i < 4; i ++) {
      p = (i + 0.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r1 * coscf (p);
      y[im] = r1 * sincf (p);
    }
    for (i = 4; i < 8; i ++) {
      p = (i - 3.5) / 4;
      im = Modems_getMap (map, olut, i);
      x[im] = r2 * coscf (p);
      y[im] = r2 * sincf (p);
    }
  }
  else {
    int_4 clut = 0;
    switch (mod) {
      case Modefs_MT_16QAM : olut = 4;
      hlut = 4;
      break;
      case Modefs_MT_16CQAM : olut = 4;
      hlut = 4;
      clut = 2;
      break;
      case Modefs_MT_32QAM : olut = 5;
      hlut = 6;
      break;
      case Modefs_MT_64QAM : olut = 6;
      hlut = 8;
      break;
      case Modefs_MT_64CQAM : olut = 6;
      hlut = 8;
      clut = 4;
      break;
      case Modefs_MT_128QAM : olut = 7;
      hlut = 12;
      break;
      case Modefs_MT_256QAM : olut = 8;
      hlut = 16;
      break;
      case Modefs_MT_256CQAM : olut = 8;
      hlut = 16;
      clut = 8;
      break;
      case Modefs_MT_512QAM : olut = 9;
      hlut = 24;
      break;
      case Modefs_MT_1024QAM : olut = 10;
      hlut = 32;
      break;
    }
    real_4 ampd = 2 * scl / hlut, amp0 = - scl + ampd / 2;
    for (i = 0; i < hlut; i ++) {
      for (j = 0; j < hlut; j ++) {
        if (mod == Modefs_MT_32QAM && (i < 1 || i > 4) && (j < 1 || j > 4)) continue;
        if (mod == Modefs_MT_128QAM && (i < 2 || i > 9) && (j < 2 || j > 9)) continue;
        if (mod == Modefs_MT_512QAM && (i < 4 || i > 19) && (j < 4 || j > 19)) continue;
        im = Modems_getMapXY (map, olut, i, j, k);
        x[im] = amp0 + i * ampd;
        y[im] = amp0 + j * ampd;
        if (clut > 0) Modems_fixCQ (clut, ampd, i, j, im, x, y);
        k ++;
      }
    }
  }
  return 1 << olut;
}

int_4 Modems_getRings (int_4 mod, int_4 nsym, real_4* sx, real_4* sy, real_4* rb) {
  int_4 i, j, k, nr = 0;
  for (i = 0; i < nsym; i ++) {
    real_4 r = sqrtf (sx[i] * sx[i] + sy[i] * sy[i]);
    for (j = 0; j < nr; j ++) {
      if (fabsf (r - rb[j]) < 0.001) break;
    }
    if (j == nr) {
      for (k = nr; k > 0; k --) {
        if (r > rb[k-1]) break;
        rb[k] = rb[k-1];
      }
      rb[k] = r;
      nr ++;
    }
  }
  if (mod == Modefs_MT_256CQAM) for (nr = 0; nr < 5; nr ++) rb[nr] = rb[nr+3];
  return nr;
}

real_4 Modems_getAMDes (int_4 mod, int_4 nsym, real_4* sx, real_4* sy) {
  int_4 i;
  real_4 avg, total;
  total = 0.0F;
  for (i = 0; i < nsym; i ++) {
    total += (sx[i] * sx[i] + sy[i] * sy[i]);
  }
  avg = sqrtf (total / nsym) * 0.9F;
  return avg;
}

int_4 Modems_diff (int_4 order, int_4 e) {
  int_4 i, i0, i1 = 0, ix, d = 0;
  for (i = 0; i < order; i ++) {
    i0 = i1;
    i1 = (e >> i) & 1;
    ix = i0 ^ i1;
    d |= (ix << i);
  }
  return d;
}

int_4 Modems_genLUT (int_4 order, int_4 poly0, int_4 poly1, int_1 denc, int_4 iper, int_4 oper, int_4 plen, int_4 ppat, int_u2* lut, int_u1* pflg) {
  int_4 MO = 9;
  int_4 i, j, k, k0, k1, pp, p0, p1, p2, p3, p4, par, len, mask, mpunc;
  int_1 tcm = (ppat == 7);
  len = (order == 0) ? 1 << iper : 1 << order;
  mask = (order == 1) ? 0 : len - 1;
  mpunc = plen - 1;
  if (mpunc < 0) mpunc = 0;
  if (lut != null) for (i = 0; i < len; i ++) {
    k = denc ? Modems_diff (order, i) : i;
    k0 = ones (k & poly0, order) & 0x1;
    k1 = ones (k & poly1, order) & 0x1;
    p0 = (i % 2 == 1) ? (1 << oper) - 1 : 0;
    p1 = 0x100 | k0;
    p2 = 0x100 | k1;
    p3 = (k1 << 1) | k0;
    p4 = (k0 << 1) | k1;
    if (tcm) for (j = 0; j < 8; j ++) {
      k = (k0 != 0) ? (j & 0x5) : (j & 0x3);
      par = ones (k, 3) & 0x1;
      lut[(j<<MO)|i] = (par << 2) | (k0 << 1) | k1;
    }
    else for (j = 0; j < plen; j ++) {
      pp = (ppat >> (4 * j)) & 0xF;
      lut[(j<<MO)|i] = (int_2) ((order == 0) ? i & mask : (pp == 0) ? p0 : (pp == 1) ? p1 : (pp == 2) ? p2 : (pp == 3) ? p3 : (pp == 4) ? p4 : p0);
    }
  }
  if (pflg != null) for (j = 0; j < plen; j ++) {
    pp = (ppat >> (4 * j)) & 0xF;
    if (pp == 2) pflg[j] = 0x9;
    else if (pp == 1) pflg[j] = 0xA;
    else pflg[j] = 0x0;
  }
  return (mpunc << 28) | (mask << 16) | (oper << 8) | iper;
}

int_4 Modems_getFECLUT (int_4 alg, int_4 upp, int_u2* lut, int_u1* pflg) {
  int_4 io = 0, order, npunc;
  int_1 up = (upp != 0);
  switch (alg) {
    case Modefs_FEC_NONE : io = Modems_genLUT (0, 0x000, 0x000, 0, 1, 1, 1, up ? upp : 0x00000000, lut, pflg);
    break;
    case Modefs_FEC_REP1 : io = Modems_genLUT (1, 0x001, 0x000, 0, 1, 1, 1, up ? upp : 0x00000000, lut, pflg);
    break;
    case Modefs_FEC_REP2 : io = Modems_genLUT (1, 0x001, 0x000, 0, 1, 2, 1, up ? upp : 0x00000000, lut, pflg);
    break;
    case Modefs_FEC_REP3 : io = Modems_genLUT (1, 0x001, 0x000, 0, 1, 3, 1, up ? upp : 0x00000000, lut, pflg);
    break;
    case Modefs_FEC_V27 : case Modefs_FEC_V27P12 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 1, up ? upp : 0x00000003, lut, pflg);
    break;
    case Modefs_FEC_V27P23 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 2, up ? upp : 0x00000013, lut, pflg);
    break;
    case Modefs_FEC_V27P34 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 3, up ? upp : 0x00000213, lut, pflg);
    break;
    case Modefs_FEC_V27P45 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 4, up ? upp : 0x00001113, lut, pflg);
    break;
    case Modefs_FEC_V27P56 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 5, up ? upp : 0x00021213, lut, pflg);
    break;
    case Modefs_FEC_V27P67 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 6, up ? upp : 0x00212113, lut, pflg);
    break;
    case Modefs_FEC_V27P78 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 1, 2, 7, up ? upp : 0x02121113, lut, pflg);
    break;
    case Modefs_FEC_V29 : case Modefs_FEC_V29P12 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 1, up ? upp : 0x00000003, lut, pflg);
    break;
    case Modefs_FEC_V29P23 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 2, up ? upp : 0x00000013, lut, pflg);
    break;
    case Modefs_FEC_V29P34 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 3, up ? upp : 0x00000113, lut, pflg);
    break;
    case Modefs_FEC_V29P45 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 4, up ? upp : 0x00001213, lut, pflg);
    break;
    case Modefs_FEC_V29P56 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 5, up ? upp : 0x00021123, lut, pflg);
    break;
    case Modefs_FEC_V29P67 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 6, up ? upp : 0x00211213, lut, pflg);
    break;
    case Modefs_FEC_V29P78 : io = Modems_genLUT (9, Modefs_V29PA, Modefs_V29PB, 0, 1, 2, 7, up ? upp : 0x01121213, lut, pflg);
    break;
    case Modefs_FEC_TCM : case Modefs_FEC_TCM23 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 0, 2, 3, 1, up ? upp : 0x00000007, lut, pflg);
    break;
    case Modefs_FEC_DTCM23 : io = Modems_genLUT (7, Modefs_V27PA, Modefs_V27PB, 1, 2, 3, 1, up ? upp : 0x00000007, lut, pflg);
    break;
    default : io = Modems_genLUT (0, 0x000, 0x000, 0, 1, 1, 1, up ? upp : 0x00000000, lut, pflg);
    printf ("Unhandled FEC algorithm index=%d \n", alg);
  }
  return io;
}

int_4 Modems_getFrameSize (int_4 modt, int_4 fect, int_4 word, int_4 len) {
  int_4 fs, fsb, isb;
  int_4 bps = Modems_getBitsPerSym (modt);
  int_4 iom = Modems_getFECLUT (fect, 0, null, null);
  int_4 iper = (iom >> 0) & 0xFF;
  int_4 oper = (iom >> 8) & 0xFF;
  int_4 mask = (iom >> 16) & 0xFFF;
  int_4 punc = (iom >> 28) & 0xF;
  punc += 1;
  int_4 iperp = iper * punc;
  int_4 operp = oper + (punc - 1) * (oper - 1);
  for (fs = len; fs > 30; fs --) {
    fsb = fs * bps;
    if ((fsb % operp) != 0) continue;
    isb = (fsb / operp) * iperp;
    if ((isb % word) != 0) continue;
    break;
  }
  if (fs != len) printf ("RFP Frame: ask=%d use=%d\n", len, fs);
  if (fs < 32) printf ("Problem finding frame size for bps=%d word=%d feci=%d feco=%d punc=%d\n", bps, word, iper, oper, punc);
  return (oper << 28) | (iper << 24) | (punc << 20) | (bps << 16) | fs;
}

int_4 Modems_getFrameFor (String* mod, String* fec, int_4 word, int_4 len) {
  return Modems_getFrameSize (Modems_getModID (mod), Modems_getFecID (fec), word, len);
}

int_4 Modems_getFrameAWG (int_4 fsm) {
  int_4 fs = (fsm >> 0) & 0xFFFF;
  return fs;
}

real_8 Modems_getFECratio (int_4 fect) {
  int_4 iom = Modems_getFECLUT (fect, 0, null, null);
  int_4 iper = (iom >> 0) & 0xFF;
  int_4 oper = (iom >> 8) & 0xFF;
  int_4 mask = (iom >> 16) & 0xFFF;
  int_4 punc = (iom >> 28) & 0xF;
  punc += 1;
  int_4 iperp = iper * punc;
  int_4 operp = oper + (punc - 1) * (oper - 1);
  return i2d (operp * iper) / iperp;
}

int_4 Modems_getFrameFEC (int_4 fsm) {
  int_4 fs = (fsm >> 0) & 0xFFFF;
  int_4 bps = (fsm >> 16) & 0xF;
  int_4 punc = (fsm >> 20) & 0xF;
  int_4 iper = (fsm >> 24) & 0xF;
  int_4 oper = (fsm >> 28) & 0xF;
  int_4 iperp = iper * punc;
  int_4 operp = oper + (punc - 1) * (oper - 1);
  return fs * bps / operp * iperp / iper;
}

Modems_IFEC* Modems_IFEC_new (int_4 OFEC) {
  Modems_IFEC* plan=zalloc(sizeof(Modems_IFEC));
  plan->MO = OFEC;
  plan->MP = plan->MO + 3;
  plan->OLUT = plan->MP + 2;
  plan->NLUT = (1 << plan->OLUT);
  plan->pflgs = zallocBuf(sizeof(int_u1)*(8));
  plan->rlut = zallocBuf(sizeof(int_u1)*(plan->NLUT));
  plan->vit = Viterbi_new ();
  return plan;
}

void Modems_IFEC_formLUT (Modems_IFEC* plan) {
  int_4 i, iom, bi, bo, ni, iuv, ferrs, score0, score1, score2, score3, shift;
  int_4 p, q, r, u, v;
  int_u2* elut = zallocBuf(sizeof(int_u2)*(plan->NLUT));
  iom = Modems_getFECLUT (plan->alg, plan->upp, elut, plan->pflgs);
  plan->olen = (iom >> 0) & 0xFF;
  plan->ilen = (iom >> 8) & 0xFF;
  plan->mask = (iom >> 16) & 0xFFF;
  plan->mpunc = (iom >> 28) & 0xF;
  if (! getBit(plan->vflg, 7)) {
    plan->rlut = zallocBuf(sizeof(int_u1)*(8));
    return;
  }
  ni = (plan->ilen >= 3) ? 8 : (plan->ilen == 2) ? 4 : 2;
  for (shift = 0; shift < (1 << plan->MO); shift ++) {
    for (bi = 0; bi < ni; bi ++) {
      score0 = (bi ^ elut[((shift<<1)&plan->mask)|0]) & 3;
      score1 = (bi ^ elut[((shift<<1)&plan->mask)|1]) & 3;
      ferrs = 0;
      if (plan->alg >= Modefs_FEC_TCM) {
        r = (score1 < score0) ? 1 : 0;
        if (score0 != 0 && score1 != 0) ferrs ++;
        q = ((bi & 2) != 0) ? 1 : 0;
        p = ((bi & 4) != 0) ? 1 : 0;
        for (iuv = 0; iuv < 4; iuv ++) {
          u = ((iuv & 1) != 0) ? 1 : 0;
          v = ((iuv & 2) != 0) ? 1 : 0;
          bo = (r << 1) | ((q != 0) ? p ^ v : p ^ u);
          plan->rlut[(iuv<<plan->MP)|(bi<<plan->MO)|shift] = (ferrs << 3) | (q << 2) | bo;
        }
      }
      else {
        bo = (score1 < score0) ? 1 : 0;
        if (score0 != 0 && score1 != 0) ferrs ++;
        if (score0 == 0) plan->rlut[(1<<plan->MP)|(((bi>>1)&1)<<plan->MO)|shift] = bo;
        if (score1 == 0) plan->rlut[(1<<plan->MP)|(((bi>>1)&1)<<plan->MO)|shift] = bo;
        if (score0 == 0) plan->rlut[(2<<plan->MP)|(((bi>>0)&1)<<plan->MO)|shift] = bo;
        if (score1 == 0) plan->rlut[(2<<plan->MP)|(((bi>>0)&1)<<plan->MO)|shift] = bo;
        plan->rlut[(0<<plan->MP)|(bi<<plan->MO)|shift] = (ferrs << 3) | bo;
      }
    }
  }
}

void Modems_IFEC_open (Modems_IFEC* plan, int_4 palg, int_4 pupp, int_4 flags) {
  plan->alg = palg;
  plan->upp = pupp;
  plan->vflg = flags;
  Modems_IFEC_formLUT (plan);
  plan->iby3 = (plan->ilen == 3);
  plan->oby2 = (plan->olen == 2);
  plan->ibit = 0;
  plan->obit = 0;
  plan->serr = 0;
  plan->sdb = getBit(plan->vflg, 1) ? 4 : getBit(plan->vflg, 0) ? 3 : 1;
  plan->slen = plan->ilen * plan->sdb;
}

real_8 Modems_IFEC_getRatio (Modems_IFEC* plan) {
  return Modems_getFECratio (plan->alg);
}

void Modems_IFEC_processReframe (Modems_IFEC* plan) {
  if (getBit(plan->vflg, 5)) {
    plan->frm1 = (plan->ibit == plan->sdb);
    plan->frm2 = ! plan->frm1;
  }
  if (plan->frm2) {
    plan->shft = 0;
  }
}

void Modems_IFEC_processRepunc (Modems_IFEC* plan) {
  plan->ipunc = (plan->ipunc >= plan->mpunc) ? 0 : plan->ipunc + 1;
  plan->jpunc = (plan->jpunc >= plan->mpunc) ? 0 : plan->jpunc + 1;
  if (plan->jpunc == 0 && ! getBit(plan->vflg, 2)) {
    plan->ibit ++;
  }
}

int_u4 Modems_IFEC_process (Modems_IFEC* plan, int_u4 hsym, int_u1 hbits) {
  int_u2 ilut;
  int_u1 pflg;
  int_u1 bihd;
  int_u2 bisd;
  int_u1 iinc, hlen, sluts, xluts;
  int_u1 fhd, ferr, flen, ump;
  int_u2 shift;
  int_1 init, valid, restr, s3, s4, tcm, uv35, ufad, ufrm, uvit, ufec;
  s3 = getBit(plan->vflg, 0);
  s4 = getBit(plan->vflg, 1);
  tcm = getBit(plan->vflg, 2);
  uv35 = getBit(plan->vflg, 3);
  ufad = getBit(plan->vflg, 4);
  ufrm = getBit(plan->vflg, 5);
  uvit = getBit(plan->vflg, 6);
  ufec = getBit(plan->vflg, 7);
  plan->ivec = (hsym << plan->ibit) | getBits(plan->ivec, 7, 0);
  plan->ibit += hbits;
  plan->obit = 0;
  init = 1;
  while (plan->ibit >= plan->slen) {
    pflg = plan->pflgs[plan->ipunc];
    ump = tcm ? plan->uv : getBits(pflg, 1, 0);
    iinc = plan->iby3 ? (s4 ? 12 : s3 ? 9 : 3) : getBit(pflg, 3) ? (s4 ? 4 : s3 ? 3 : 1) : (s4 ? 8 : s3 ? 6 : 2);
    plan->ipunc = (plan->ipunc >= plan->mpunc) ? 0 : plan->ipunc + 1;
    bihd = plan->iby3 ? getBits(plan->ivec, 2, 0) : ! getBit(pflg, 3) ? getBits(plan->ivec, 1, 0) : getBits(plan->ivec, 0, 0);
    if (uvit) {
      plan->vluts = Viterbi_process (plan->vit, getBits(plan->ivec, 11, 0), pflg, plan->vflg);
    }
    else {
      restr = ufad && getBit(plan->rluts, 3);
      shift = restr ? 0 : (plan->frm2 ? 0 : tcm ? getBits(plan->rluts, 1, 1) : getBits(plan->rluts, 0, 0)) | (plan->shft << 1);
      ilut = (ump << plan->MP) | (bihd << plan->MO) | (shift & plan->mask);
      plan->rluts = plan->rlut[ilut];
      plan->shft = plan->frm1 ? 0 : shift;
      plan->uv = getBit(plan->rluts, 2) ? (plan->uv & 1) | (getBits(plan->rluts, 0, 0) << 1) : (plan->uv & 2) | (getBits(plan->rluts, 0, 0));
    }
    xluts = uvit ? plan->vluts : plan->rluts;
    valid = uvit ? getBit(plan->vluts, 2) : 1;
    fhd = valid ? getBits(xluts, 1, 0) : 0;
    ferr = valid ? getBits(xluts, 3, 3) : 0;
    flen = valid ? plan->olen : 0;
    plan->serr = init ? ferr : plan->serr + ferr;
    plan->ovec = init ? fhd : plan->ovec | (fhd << plan->obit);
    plan->obit = init ? flen : plan->obit + flen;
    plan->ivec = plan->ivec >> iinc;
    plan->ibit -= iinc;
    init = 0;
    plan->frm2 = plan->frm1;
    plan->frm1 = 0;
  }
  return (plan->serr << 24) | (plan->obit << 16) | plan->ovec;
}
#define _Modems_
#endif
