/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See MFPP.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
public class MFPP extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, BW = 32, OHIT = 8, MHIT = (1 << OHIT), OTOP = 8, MTOP = (1 << OTOP), OWIN = 6, MWIN = (1 << OWIN), OFFT = 14, MFFT = (1 << OFFT), PIPE = 1;
public static class CORE extends Core {
  public final static String flgList = "Bypass,Strip,Tag,Log,Peak,Sort,Diff,HiThresh";
  public final static int F_BYPASS = 0, F_STRIP = 1, F_TAG = 2, F_LOG = 3, F_PEAK = 4, F_SORT = 5, F_DIFF = 6, F_HITHRESH = 7;
  float thresh;
  int frame;
  float vthresh;
  int mframe;
  int nwin;
  int ntop;
  float tmin;
  int flags;
  int itop;
  int count;
  boolean cntovr;
  boolean isUp;
  int iup;
  float vtot;
  float vhit;
  float vnf;
  StatBuf sbuf;
  int[] hiti;
  float[] hitv;
  int edgeL, edgeR;
  public int addToSort (int itop, float vtot, int vind) {
    int ii;
    boolean rep0, rep1;
    for (ii = itop; ii >= 0; ii --) {
      rep0 = (ii == itop) || (vtot > hitv[ii]);
      rep1 = (ii > 0) && (vtot > hitv[ii-1]);
      if (rep1) {
        hiti[ii] = hiti[ii-1];
        hitv[ii] = hitv[ii-1];
      }
      else if (rep0) {
        hiti[ii] = vind;
        hitv[ii] = vtot;
      }
    }
    if (itop < ntop) itop ++;
    return itop;
  }
  public int init () {
    thresh = 2.0F;
    frame = 256;
    ntop = 64;
    tmin = 0;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "L:FRAME")) frame = value.toL ();
    else if (isMatch (key, "L:WIDTH")) nwin = value.toL ();
    else if (isMatch (key, "L:NTOP")) ntop = value.toL ();
    else if (isMatch (key, "F:THRESH")) thresh = value.toF ();
    else if (isMatch (key, "F:TMIN")) tmin = value.toF ();
    else if (isMatch (key, "S:FLAGS")) flags = value.toMask (flgList);
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:FRAME")) value.fromL (frame);
    else if (isMatch (key, "L:WIDTH")) value.fromL (nwin);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    if (nwin > MWIN) {
      System.out.printf ("Sliding window width=%d limited to max=%d\n", nwin, MWIN);
      nwin = MWIN;
    }
    if (ntop > MTOP) {
      System.out.printf ("Number peaks=%d limited to max=%d\n", ntop, MTOP);
      ntop = MTOP;
    }
    sbuf = new StatBuf (OWIN);
    sbuf.setLength (nwin);
    hiti = new int[MHIT];
    hitv = new float[MHIT];
    cntovr = false;
    if (ntop == 0) flags |= F_BYPASS;
    vthresh = 1.0F / thresh;
    count = 0;
    mframe = frame - 1;
    itop = 0;
    if((this.halo.vbpr&1)!=0)System.out.printf ("MFPP frame=%d ntop=%d flags=%x\n", frame, ntop, flags);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    float v, vi, vmin, vmax, vmid, vchk, vthr, vd, vdx;
    boolean cntok, hitu, hitd, hitm, topl, topn;
    boolean bypass, strip, tag, log, peak, sort, diff, hsnr;
    int ve, vc, vcx;
    int edgeM;
    int ibin;
    bypass = getBit(flags, 0);
    strip = getBit(flags, 1);
    tag = getBit(flags, 2);
    log = getBit(flags, 3);
    peak = getBit(flags, 4);
    sort = getBit(flags, 5);
    diff = getBit(flags, 6);
    hsnr = getBit(flags, 7);
    while (si.rok && so.wok && ! cntovr) {
      cntok = (count >= nwin) && (edgeR == 0);
      cntovr = (count >= mframe);
      ibin = count - (nwin >> 1);
      count = (bypass || count >= mframe) ? 0 : count + 1;
      vi = si.rdF ();
      if (! strip) {
        so.wrL (fp2i (vi));
      }
      sbuf.load (vi);
      vmid = sbuf.getMid ();
      vmin = sbuf.getMinM (peak ? 0 : - 1);
      vmax = sbuf.getMaxM (1);
      v = diff ? vmid - vmin : vmid - vnf;
      vthr = mulff (vmid, vthresh);
      vchk = log ? vmid - thresh : vthr;
      hitu = cntok && vchk > vmin;
      hitd = cntovr || vmid < vhit;
      hitm = hsnr && ((vmax - vmid) > thresh);
      if (isUp && hitd) {
        edgeR = sbuf.getMinI (1);
        edgeM = imin (edgeL, edgeR);
        ve = ((ibin + edgeM) << 16) | (iup - edgeM);
        if (vtot < tmin) {
        }
        else if (sort) {
          itop = addToSort (itop, vtot, ve);
        }
        else if (itop < ntop) {
          hiti[itop] = ve;
          hitv[itop] = vtot;
          itop ++;
        }
        isUp = false;
        vtot = 0;
      }
      else if (isUp ? hitm : hitu) {
        iup = ibin;
        vtot = v;
        vhit = vmid;
        if (! isUp) {
          vnf = vmin;
        }
        edgeL = sbuf.getMinI (-1);
        isUp = true;
      }
      else if (isUp) {
        if (! peak) {
          vtot += v;
        }
        else if (v > vtot) {
          vtot = v;
        }
      }
      else if (edgeR > 0) {
        edgeR --;
      }
    }
    while (so.wok && cntovr) {
      cntovr = (count < ntop);
      topl = (count < itop);
      topn = (count == ntop);
      vc = hiti[count];
      vd = hitv[count];
      count = (count >= ntop) ? 0 : count + 1;
      if (! topn || tag) {
        vcx = topn ? itop : topl ? vc : 0;
        vdx = topn ? vtot : topl ? vd : 0;
        so.wrL (vcx);
        so.wrL (fp2i (vdx));
        vtot = vtot + vd;
      }
      if (topn) {
        itop = 0;
      }
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
