/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See LRS.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME LRS
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW NP*32
#define CW 6



/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 gain;
  real_4 fscl;
  int_4 lrsx;
  int_4 lrsy;
  CxReal_4** vi;
  CxReal_4** vo;
  int_1 neg;
} LRS;

#include "cores/CoreProtos.h"

/** CORE Code */

void* LRS_alloc (char *config) {
  LRS* plan = LRS_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 LRS_upload (LRS* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,7);
  HW_loadInt  (planp,plan->gain);
  HW_loadFlt  (planp,plan->fscl);
  HW_loadInt  (planp,plan->lrsx);
  HW_loadInt  (planp,plan->lrsy);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,plan->neg);
  HW_push (planp,HW_OPEN);
  return 7;
}

int_4 LRS_set (LRS* plan, String* key, Value* value) {
  if (isMatch (key, "L:GAIN")) plan->gain = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 LRS_get (LRS* plan, String* key, Value* value) {
  if (isMatch (key, "L:GAIN")) Value_fromL (value, plan->gain);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 LRS_fLRS (LRS* plan, int_4 lrs) {
  return (lrs << 1) | (getBits(lrs, 0, 0) ^ getBits(lrs, 1, 1) ^ getBits(lrs, 5, 5) ^ getBits(lrs, 25, 25));
}

int_4 LRS_init (LRS* plan) {
  plan->gain = -70;
  plan->lrsx = ~ 123456;
  plan->lrsy = ~ 654321;
  plan->neg = 0;
  return 0;
}

int_4 LRS_open (LRS* plan) {
  int_4 i;
  plan->fscl = d2f (pow (2.0, plan->gain / 6.0));
  plan->vi = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vi[i] = CxReal_4_new ();
  plan->vo = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vo[i] = CxReal_4_new ();
  LRS_upload (plan,plan);
  return 0;
}

int_4 LRS_process (LRS* plan, Stream* si, Stream* so) {
  int_4 lrsx2, lrsy2;
  int_2 i;
  while (si->rok && so->wok) {
    Stream_rdCIFA (si, plan->vi, NP);
    lrsx2 = iLRS (plan->lrsx);
    lrsy2 = iLRS (plan->lrsy);
    for (i = 0; i < NP; i ++) {
      CxReal_4 cn_,*cn=&cn_, cm_,*cm=&cm_;
      cn->x = L2F ((i > 0) ? ~ lrsx2 : plan->neg ? ~ plan->lrsx : plan->lrsx);
      cn->y = L2F ((i > 0) ? ~ lrsy2 : plan->neg ? ~ plan->lrsy : plan->lrsy);
      cm->x = cn->x * plan->fscl;
      cm->y = cn->y * plan->fscl;
      addcc (plan->vi[i], cm, plan->vo[i]);
    }
    plan->lrsx = (NP < 2) ? lrsx2 : iLRS (lrsx2);
    plan->lrsy = (NP < 2) ? lrsy2 : iLRS (lrsy2);
    plan->neg = (NP < 2) ? ! plan->neg : 0;
    Stream_wrCFIA (so, plan->vo, NP);
  }
  return 0;
}

int_4 LRS_close (LRS* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 LRS_poll (LRS* plan) { return 0; }

int_4 LRS_free (LRS* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

LRS* LRS_subCore (HALO* halo, int_4 scid) {
  LRS* plan = LRS_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  LRS_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
