/**
  Implements generic HardwareOnlyCore functions 

  @author Jeff Schoen
  @version $Id: HOC.c,v 1.3 2021/9/22 jgs Exp $
*/

/* Define Signatures */
#define CORE_NAME HOC
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 0
#define CORE_IS_HOC 1

/* CORE defines */
#include "CoreDefs.h"

/* CORE Plan handle */
typedef struct {
  HALO halo;
} HOC;

/* CORE Code */
#include "CoreProtos.h"

void* HOC_alloc (char *config) {
  HOC *plan = HOC_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}

int_4 HOC_init (HOC *plan) {
  plan->halo.dec = 1;
  return 0;
}

int_4 HOC_set (HOC *plan, String *key, Value *value) {
  int_4 i;
       if (isMatch(key,"L:DEC")) { plan->halo.dec  = Value_toL(value); HW_write(COREG_DEC,plan->halo.dec-1); }
  else if (isMatch(key,"L:GAIN")) { plan->halo.gain = Value_toL(value); HW_write(COREG_GAIN,plan->halo.gain); }
  else if (isMatch(key,"L:RATE")) { plan->halo.rate = Value_toL(value); HW_write(COREG_RATE,plan->halo.rate); }
  else if (isMatch(key,"D:RATIO")) { plan->halo.ratio = R2L(Value_toD(value)); HW_write(COREG_RATIO,plan->halo.ratio); }
  else if (isMatch(key,"L:FRAME")) { plan->halo.frame = Value_toL(value); HW_write(COREG_FRAME,plan->halo.frame); }
  else if (isMatch(key,"D:FREQ")) { plan->halo.freq = R2L(Value_toD(value)); HW_write(COREG_FREQ,plan->halo.freq); }
  else if (isMatch(key,"L:FLAG")) { plan->halo.flag = Value_toL(value); HW_write(COREG_FLAG,plan->halo.flag); }
  else if ((i=isMatchIndexed(key,"L:USER"))>=0) { plan->halo.user[i] = Value_toL(value); HW_write(64+i*4,plan->halo.user[i]); }
  else return Core_set (plan, key, value);
  return 0;
}

int_4 HOC_get (HOC *plan, String *key, Value *value) {
  int_4 i;
       if (isMatch(key,"L:DEC")) Value_fromL(value,plan->halo.dec);
  else if (isMatch(key,"L:GAIN")) Value_fromL(value, plan->halo.gain);
  else if (isMatch(key,"L:RATE")) Value_fromL(value,plan->halo.rate);
  else if (isMatch(key,"D:RATIO")) Value_fromD(value,(plan->halo.ratio==0)? 1.0 : L2R(plan->halo.ratio));
  else if (isMatch(key,"L:FRAME")) Value_fromL(value,plan->halo.frame);
  else if (isMatch(key,"D:FREQ")) Value_fromD(value,L2R(plan->halo.freq));
  else if (isMatch(key,"L:FLAG")) Value_fromL(value,plan->halo.flag);
  else if ((i=isMatchIndexed(key,"L:USER"))>=0) Value_fromL(value,HW_read(64+i*4));
  else return Core_get (plan, key, value);
  return 0;
}

int_4 HOC_open (HOC *plan) {
  int_4 sys = getFmts(FMTS)|CORE_DEC;
  HW_write(COREG_SYS,sys);
  HW_write(COREG_SYS,sys|CORE_ENA); 
  return 0;
}

int_4 HOC_close (HOC *plan) {
  return 0;
}

int_4 HOC_free (HOC *plan) {
  HW_free(plan);
  free(plan);
  return 0;
}

#include "CoreHandles.h"
