/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DDC.jv for documentation.
*/

import CORE_types::*;
package DDC_types;
import CORE_types::*;
endpackage
import DDC_types::*;

module DDC_core #(PORT=1, IBW=32,OBW=32, IFLG=0,OFLG=0, IOCLKS=1, IKR=4,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=STREAM, BUFCFG=BCIO, SELFPACE=0, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=NP*32, SIBW=32*NP, SOBW=32, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FRAW, OFMT=FRAW, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=SIBW, XOBW=SOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam NSUB=PORT/100, SUB=PORT%100;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (NSUB>0)? s_clks[2] : s_sys[0];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[21:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(22,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"DDC",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic si_ren,so_wen,si_rok_,so_wok_; logic[5:0] si_bits,so_bits; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel; logic[XIBW-1:0] si_rbus; logic[XIBWP-1:0] si_rsel; logic[7:0] so_swaps;
  wire c_rdy = (SELFPACE!=0) || (si_rok_ && so_wok_); wire si_rok = si_rok_ && c_ok; wire so_wok = so_wok_ && c_ok;
  generate if (NSUB>0 && SUB!=1) begin
    assign si_rbus=i_bus, si_rsel=i_sel, i_rdy=si_ren, si_rok_=i_ena;
  end else begin
    logic i_val; always @(posedge i_clk) i_val <= i_ena;
    fifoNxM #(IBW+IBWP,XIBW+XIBWP,IKR/2,3,IFLG^BPAR,BPAR) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, si_rok_,si_ren,{si_rsel,si_rbus});
    if (NSUB>0 && SUB==1) assign s_ack = si_rok_;
  end endgenerate
  generate if (NSUB>0 && SUB!=NSUB) begin
    assign o_bus=so_wbus, o_sel=so_wsel, o_rdy=so_wen, so_wok_=o_ena;
  end else begin
    fifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR/2,4,BPAR,OFLG^BPAR) f_o (s_clk,o_frst, so_wok_,so_wen,{so_wsel,so_wbus}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});
    if (NSUB>0 && SUB==NSUB) assign s_ack = so_wok_;
  end endgenerate

  logic c_start,c_prep,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_prep <= 0; else if (c_done) c_prep <= 0;
    if (frst) c_start <= 0; else c_start <= s_ena && (c_rdy||c_prep) && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=64, OCIC=5, ODEC=10, OTAP=8, RTAP=256, PTAP=8, OAGC=12, FPS=(RTAP/8)-1, MAXCR=250000000;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_p=256,CV_dp=264,CV_fscl=272,CV_ntap=276,CV_cdec=280,CV_ndec=284,CV_ups=288,CV_mdec=292,CV_idec=296,
    CV_oagc=300,CV_pass=304,CV_maxpass=308,CV_count=312,CV_maxcount=316,CV_blkSum=320,CV_AMDes=324,CV_cntovr=328,CV_cic=332,
    CV_vd=336,CV_rft=340;

  dptx p;
  dptx dp;
  fptx fscl;
  intx ntap;
  intx cdec;
  intx ndec;
  intx ups;
  intx mdec;
  intx idec;
  int8 oagc;
  intx pass;
  intx maxpass;
  intx count;
  intx maxcount;
  fptx blkSum;
  fptx AMDes;
  boolean cntovr;
  logic cic_process_ena; CxFptx cic_fi; CxFptx cic_fo; logic cic_process_ret; 
  Filters_CxCIC #( OCIC , ODEC ) cic (clks,rst,s_set[19],s_sub,s_val,cic_process_ena,cic_fi,cic_fo,cic_process_ret);
  logic[4-1:0] vd_stride; logic vd_split; logic vd_load; CxFptx vd_wbus; logic vd_ren[PTAP]; logic[OTAP-1:0] vd_radr[PTAP]; CxFptx vd_rbus[PTAP]; 
  CxTapBuf #( OTAP , 1 , PTAP , 0 ) vd (clks,rst,vd_stride,vd_split,vd_load,vd_wbus,vd_ren,vd_radr,vd_rbus);
  logic rft_ren; logic[OTAP-1:0] rft_rM[PTAP]; fptx rft_rbus[PTAP]; 
  RomF #( OTAP , PTAP ) rft (clks,rst,s_set[21],s_sub,s_val,rft_ren,rft_rM,rft_rbus);

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[64];  wire c_en[64];  wire c_xn[64];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( StreamI si , StreamO so ) {
  CxFptx_stk sc, cn, cm, cc, fo, fos, fc;                    // CxFptx_stk sc , cn , cm , cc , fo , fos , fc ;
  fptx fp, msq, mag, blkAvg, blkAvgInv;                      // fptx fp , msq , mag , blkAvg , blkAvgInv ;
  boolean cgo, fout, okOut;                                  // boolean cgo , fout , okOut ;
  uint6 ia;                                                  // uint6 ia ;
  setLine #(1,0,0) f_6 (c_ln[6],"If",cntovr,F);              // if ( cntovr ) {
  setLine #(6,0,1) f_7 (c_ln[7],"setVar",T,F);               // pass = ( pass >= 0x1000 ) ? 0x1000 : pass + 1 ;
  setLine #(6,1,0) f_8 (c_ln[8],"If",pass <= oagc,F);        // if ( pass <= oagc ) {
  setLine #(8,0,1) f_9 (c_ln[9],"setVar",T,F);               // blkAvg = divfp2 ( blkSum , OAGC ) ;
  setLine #(8,1,1) f_10 (c_ln[10],"setVar",T,F);             // blkAvgInv = invf ( blkAvg ) ;
  setLine #(8,2,1) f_11 (c_ln[11],"setVar",T,F);             // fscl = fscl * AMDes * blkAvgInv ;
  setLine #(8,0,1) f_12 (c_ln[12],"setVar",T,F);             // blkSum = 0 ;
  setLine #(8,3,0) f_13 (c_ln[13],"endIf",c_xn[8],F);        // }
  setLine #(13,0,1) f_14 (c_ln[14],"setVar",T,F);            // count = 0 ;
  setLine #(13,0,1) f_15 (c_ln[15],"setVar",T,F);            // cntovr = F ;
  setLine #(13,1,0) f_16 (c_ln[16],"endIf",c_xn[6],F);       // }
  setLine #(16,0,1) f_17 (c_ln[17],"setVar",T,F);            // okOut = ( pass >= oagc ) ;
  setLine #(16,1,0) f_18 (c_ln[18],"While",si_rok && so_wok && ! cntovr,c_xn[61]); // while ( si.rok && so.wok && ! cntovr ) {
  setLine #(18,0,0) f_19 (c_ln[19],"If",ups == 2 && count[0],F); // if ( ups == 2 && count [ 0 ] ) {
  setLine #(19,0,1) f_20 (c_ln[20],"setVar",T,F);            // cn.x = 0 ;
  setLine #(19,0,1) f_21 (c_ln[21],"setVar",T,F);            // cn.y = 0 ;
  setLine #(19,0,0) f_22 (c_ln[22],"endIfE",c_xn[19],F);     // }
  setLine #(18,0,0) f_23 (c_ln[23],"ElseIf",T,c_xn[19]);     // else {
  setLine #(23,0,3) f_24 (c_ln[24],"StreamI_rdCIF",T,F);     // si.rdCIF ( cn ) ;
  setLine #(23,0,0) f_25 (c_ln[25],"endIf",c_xn[23],F|c_en[22]); // }
  setLine #(18,0,1) f_26 (c_ln[26],"setVar",T,F);            // fp = d2f ( p ) ;
  setLine #(18,0,1) f_27 (c_ln[27],"setVar",T,F);            // p = frac ( p + dp ) ;
  setLine #(18,1,2) f_28 (c_ln[28],"doTask",T,F);            // sc = sincoscf ( fp ) ;
  setLine #(18,3,2) f_29 (c_ln[29],"doTask",T,F);            // cm = mulccx ( cn , sc ) ;
  setLine #(18,5,5) f_30 (c_ln[30],"CxCIC_process",T,F);     // cgo = cic.process ( cm , cc ) ;
  setLine #(18,10,0) f_31 (c_ln[31],"If",cgo,F);             // if ( cgo ) {
  setLine #(31,0,0) f_32 (c_ln[32],"CxTapBuf_load",T,F);     // vd.load ( cc ) ;
  setLine #(31,0,1) f_33 (c_ln[33],"setVar",T,F);            // fout = ( idec == 0 ) ;
  setLine #(31,0,1) f_34 (c_ln[34],"setVar",T,F);            // idec = ( idec == 0 ) ? mdec : idec - 1 ;
  setLine #(31,1,0) f_35 (c_ln[35],"If",fout,F);             // if ( fout ) {
  setLine #(35,1,8) f_36 (c_ln[36],"Accum",T,F);             // fo.x = 0 ;
  setLine #(35,1,8) f_37 (c_ln[37],"Accum",T,F);             // fo.y = 0 ;
  setLine #(35,0,0) f_38 (c_ln[38],"GenForP",ia+PTAP < ntap,F); // for ( ia = 0 ; ia < ntap ; ia ++ ) {
  setLine #(38,0,1) f_41 (c_ln[41],"RomF_get",T,F);          // ft = rft.get ( ia ) ;
  setLine #(38,0,1) f_42 (c_ln[42],"CxTapBuf_get",T,F);      // vd.get ( ia , fdi ) ;
  setLine #(38,1,1) f_43 (c_ln[43],"setAcc",c_en[36],F);     // fo.x += ft * fdi.x ;
  setLine #(38,1,1) f_44 (c_ln[44],"setAcc",c_en[37],F);     // fo.y += ft * fdi.y ;
  setLine #(38,0,0) f_45 (c_ln[45],"endGenForP",c_xn[38],F); // }
  setLine #(35,9,1) f_46 (c_ln[46],"setVar",T,F);            // fos = mulcf ( fo , fscl ) ;
  setLine #(35,0,0) f_47 (c_ln[47],"If",okOut,F);            // if ( okOut ) {
  setLine #(47,10,1) f_48 (c_ln[48],"StreamO_wrCFI",T,F);    // so.wrCFI ( fos ) ;
  setLine #(47,0,0) f_49 (c_ln[49],"endIf",c_xn[47],F);      // }
  setLine #(35,0,0) f_50 (c_ln[50],"If",pass < oagc,F);      // if ( pass < oagc ) {
  setLine #(50,10,1) f_51 (c_ln[51],"setVar",T,F);           // fc.x = fos.x * fos.x ;
  setLine #(50,10,1) f_52 (c_ln[52],"setVar",T,F);           // fc.y = fos.y * fos.y ;
  setLine #(50,11,1) f_53 (c_ln[53],"setVar",T,F);           // msq = fc.x + fc.y ;
  setLine #(50,12,1) f_54 (c_ln[54],"setVar",T,F);           // mag = sqrtfx ( msq ) ;
  setLine #(50,13,1) f_55 (c_ln[55],"setVar",T,F);           // blkSum = blkSum + mag ;
  setLine #(50,0,0) f_56 (c_ln[56],"endIf",c_xn[50],F);      // }
  setLine #(35,0,1) f_57 (c_ln[57],"setVar",T,F);            // count = count + 1 ;
  setLine #(35,0,1) f_58 (c_ln[58],"setVar",T,F);            // cntovr = ( count >= maxcount ) ;
  setLine #(35,0,0) f_59 (c_ln[59],"endIf",c_xn[35],F);      // }
  setLine #(31,0,0) f_60 (c_ln[60],"endIf",c_xn[31],F);      // }
  setLine #(18,25,0) f_61 (c_ln[61],"endWhile",c_xn[18],F);  // }
  setLine #(61,0,0) f_62 (c_ln[62],"return",c_stat,F);       // return 0 ;
  setLine #(62,0,0) f_63 (c_ln[63],"endMethod",T,F);         // }
  sincoscf_task fn28 (clks,rst,c_en[28],c_xn[28], fp,sc);
  mulccx_task fn29 (clks,rst,c_en[29],c_xn[29], cn,sc,cm);

  assign vd_load = c_en[32], vd_wbus = cc;
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    if (MC==0) begin so_wen <= F; si_ren <= F; end
    cic_process_ena <= F; if (rst) cic_fi <= 0; 
    if (s_set[1]) p <= lswap(s_val);
    if (s_set[3]) dp <= lswap(s_val);
    if (s_set[4]) fscl <= s_val;
    if (s_set[5]) ntap <= s_val;
    if (s_set[6]) cdec <= s_val;
    if (s_set[7]) ndec <= s_val;
    if (s_set[8]) ups <= s_val;
    if (s_set[9]) mdec <= s_val;
    if (s_set[10]) idec <= s_val;
    if (s_set[11]) oagc <= s_val;
    if (s_set[12]) pass <= s_val;
    if (s_set[13]) maxpass <= s_val;
    if (s_set[14]) count <= s_val;
    if (s_set[15]) maxcount <= s_val;
    if (s_set[16]) blkSum <= s_val;
    if (s_set[17]) AMDes <= s_val;
    if (s_set[18]) cntovr <= s_val;
    if (c_xn[7]) begin pass <= (pass >= 16'h1000) ? 16'h1000 : pass + 1; end
    if (c_xn[9]) begin blkAvg <= divfp2 (blkSum, OAGC); end
    if (c_xn[10]) begin blkAvgInv <= invf (blkAvg); end
    if (c_xn[11]) begin fscl <= mulff (fscl, AMDes) * blkAvgInv; end
    if (c_xn[12]) begin blkSum <= 0; end
    if (c_xn[14]) begin count <= 0; end
    if (c_xn[15]) begin cntovr <= F; end
    if (c_xn[17]) begin okOut <= (pass >= oagc); end
    if (c_xn[20]) begin cn.x <= 0; end
    if (c_xn[21]) begin cn.y <= 0; end
    if (c_en[24]) begin si_ren <= T; end 
    if (c_xn[24]) begin cn <= CI2CF (si_rbus); end
    if (c_xn[26]) begin fp <= d2f (p); end
    if (c_xn[27]) begin p <= frac (p + dp); end
    if (c_xn[28]) begin /* sc <= sincoscf (fp); */ end
    if (c_xn[29]) begin /* cm <= mulccx (cn, sc); */ end
    if (c_en[30]) begin cic_process_ena <= T; cic_fi <= cm; end 
    if (c_xn[30]) begin cc <= cic_fo; cgo <= cic_process_ret; end
    if (c_xn[33]) begin fout <= (idec == 0); end
    if (c_xn[34]) begin idec <= (idec == 0) ? mdec : idec - 1; end
    if (c_xn[38] || rst) begin ia <= 0; end else if (c_en[38]) begin ia <= ia + PTAP; end
    if (c_xn[46]) begin fos <= mulcf (fo, fscl); end
    if (c_xn[48]) begin so_wen <= T; so_wbus <= CF2CI (fos); end
    if (c_xn[51]) begin fc.x <= mulff (fos.x, fos.x); end
    if (c_xn[52]) begin fc.y <= mulff (fos.y, fos.y); end
    if (c_xn[53]) begin msq <= fc.x + fc.y; end
    if (c_xn[54]) begin mag <= sqrtfx (msq); end
    if (c_xn[55]) begin blkSum <= blkSum + mag; end
    if (c_xn[57]) begin count <= count + 1; end
    if (c_xn[58]) begin cntovr <= (count >= maxcount); end
    if (c_xn[62]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off SELRANGE */
  generate
  genvar I1,I2,I3,I4;
  fptx fo_x_a[PTAP]; sumf # (PTAP, 4) fn36 (clk, rst, c_en[43], c_xn[43], fo_x_a, fo.x);
  fptx fo_y_a[PTAP]; sumf # (PTAP, 4) fn37 (clk, rst, c_en[44], c_xn[44], fo_y_a, fo.y);
  for (I1 = 0; I1 < PTAP; I1 = I1 + 1) begin : b38
    fptx ft;
    CxFptx_stk fdi;
    assign rft_ren = c_en[41], rft_rM[I1] = I1 + ia, ft = rft_rbus[I1];
    assign vd_stride = 1, vd_ren[I1] = c_en[42], vd_radr[I1] = I1 + ia;
    always @(posedge clk) if (c_xn[42]) begin fdi <= vd_rbus[I1]; end
    always @(posedge clk) if (c_xn[43]) begin fo_x_a[I1] <= mulff (ft, fdi.x); end
    always @(posedge clk) if (c_xn[44]) begin fo_y_a[I1] <= mulff (ft, fdi.y); end
  end
  endgenerate
  /* verilator lint_on SELRANGE */

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[64*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 31,1,0,0, 21,6,0,0, 31,6,1,0, 21,8,0,0, 21,8,1,0, 21,8,2,0, 21,8,0,0, 32,8,3,0, 21,13,0,0, 21,13,0,0, 32,13,1,0, 21,16,0,0, 41,16,1,1, 33,18,0,0, 21,19,0,0, 21,19,0,0, 35,19,0,0, 34,18,0,0, 10,23,0,2, 32,23,0,0, 21,18,0,0, 21,18,0,0, 10,18,1,1, 10,18,3,1, 10,18,5,4, 31,18,10,0, 10,31,0,0, 21,31,0,0, 21,31,0,0, 31,31,1,0, 10,35,1,7, 10,35,1,7, 62,35,0,0, 0,0,0,0, 0,0,0,0, 10,38,0,0, 10,38,0,0, 23,38,1,0, 23,38,1,0, 10,38,0,0, 21,35,9,0, 31,35,0,0, 10,47,10,0, 32,47,0,0, 31,35,0,0, 21,50,10,0, 21,50,10,0, 21,50,11,0, 21,50,12,0, 21,50,13,0, 32,50,0,0, 21,35,0,0, 21,35,0,0, 32,35,0,0, 32,31,0,0, 42,18,25,0, 14,61,0,0, 15,62,0,0};
  sequencer #(64,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

