/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See CFIR.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME CFIR
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 2
#define AW 16
#define BW 32*NP
#define CW 6

enum { CFIR_ONP = 1 };
enum { CFIR_RTAP = 32 };
enum { CFIR_NCTAP = 22 };
enum { CFIR_NCTAPX = CFIR_NCTAP + NP };
enum { CFIR_CSCL = 16 };

static real_8 EQFILT_6DB[] = { 0.0013318773 , -0.0 , -0.002600332 , 6.3422725E-5 , 0.0048201275 , -1.2684545E-4 , -0.008562068 , 3.1711368E-4 , 0.014714073 , -6.3422736E-4 , -0.024481175 , 0.0012050319 , 0.039639205 , -0.0022197957 , -0.06393011 , 0.0042493227 , 0.10585253 , -0.008752337 , -0.19686416 , 0.02295903 , 0.6135515 , -0.16718231 , 0.648878 , 0.12361091 , -0.20047925 , -0.005898314 , 0.106994145 , -5.073818E-4 , -0.06437407 , 0.0013953 , 0.039829474 , -0.0012684547 , -0.024544597 , 9.5134095E-4 , 0.0147774955 , -6.9765E-4 , -0.0086254915 , 4.4395908E-4 , 0.0048201275 , -2.536909E-4 , -0.002600332 , 1.2684545E-4 , 0.0013318773 , -6.3422725E-5 };
static real_8 EQFILT_12DB[] = { 0.0013437333 , -3.7325924E-5 , -0.0025754888 , 1.1197778E-4 , 0.0048150443 , -2.2395556E-4 , -0.008584962 , 4.8523702E-4 , 0.014706414 , -9.331481E-4 , -0.02444848 , 0.0017543184 , 0.039602805 , -0.0032846814 , -0.06382733 , 0.006308081 , 0.10570701 , -0.013176052 , -0.19644634 , 0.035496954 , 0.6100549 , -0.27303913 , 0.6520839 , 0.22746417 , -0.20077613 , -0.015378281 , 0.10705075 , 0.0021275778 , -0.06434989 , 3.7325924E-4 , 0.039864086 , -8.584963E-4 , -0.024523133 , 8.2117034E-4 , 0.014781066 , -5.972148E-4 , -0.008584962 , 4.1058517E-4 , 0.0048150443 , -2.6128147E-4 , -0.0025754888 , 1.493037E-4 , 0.0013437333 , -7.465185E-5 };
static real_8 EQFILT_15DB[] = { 0.0013215624 , -5.7459238E-5 , -0.0025856656 , 1.436481E-4 , 0.004826576 , -2.872962E-4 , -0.008590156 , 5.745924E-4 , 0.014709565 , -0.0010917255 , -0.024420176 , 0.0020685326 , 0.039618142 , -0.0038784987 , -0.063808486 , 0.0074409717 , 0.10563881 , -0.015600183 , -0.1962233 , 0.042376187 , 0.60820603 , -0.33125252 , 0.6539436 , 0.2845956 , -0.20093496 , -0.020570407 , 0.10710402 , 0.0035912024 , -0.064383075 , -1.436481E-4 , 0.03984798 , -6.607812E-4 , -0.024535095 , 7.1824045E-4 , 0.014767024 , -5.745924E-4 , -0.008590156 , 4.0221465E-4 , 0.004826576 , -2.5856658E-4 , -0.0025856656 , 1.436481E-4 , 0.0013215624 , -8.618886E-5 };

/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 eq;
  int_4 ntap;
  int_4 nrpt;
  int_4 gain;
  real_8 fwf;
  int_1 bypass;
  CxReal_4** vi;
  CxReal_4** vo;
  real_4* cftx;
  real_4* cfty;
  CxReal_4** cdt;
  real_4 cscl;
} CFIR;

#include "cores/CoreProtos.h"

/** CORE Code */

void* CFIR_alloc (char *config) {
  CFIR* plan = CFIR_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 CFIR_upload (CFIR* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,7);
  HW_loadInt  (planp,plan->bypass);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadBuf  (planp,plan->cftx,'f',1);
  HW_loadBuf  (planp,plan->cfty,'f',1);
  HW_loadInt  (planp,0);
  HW_loadFlt  (planp,plan->cscl);
  HW_push (planp,HW_OPEN);
  return 7;
}

void CFIR_setEq (CFIR* plan, int_4 deq) {
  int_4 i, aeq, nt = 0;
  aeq = (deq < 0) ? - deq : deq;
  if (plan->cftx == null) {
    plan->eq = deq;
    return;
  }
  real_8* filt = null;
  for (i = 0; i < CFIR_NCTAP; i ++) {
    plan->cftx[i] = 0;
    plan->cfty[i] = 0;
  }
  if (aeq == 0) {
    nt = 1;
    plan->cftx[0] = CFIR_CSCL;
  }
  else if (aeq == 6) {
    nt = 22;
    filt = EQFILT_6DB;
  }
  else if (aeq == 12) {
    nt = 22;
    filt = EQFILT_12DB;
  }
  else if (aeq == 15) {
    nt = 22;
    filt = EQFILT_15DB;
  }
  else {
    printf ("Unsupported EQ rollOff=%d dB\n", plan->eq);
    return;
  }
  if (nt > 1 && filt != null) {
    for (i = 0; i < nt; i ++) {
      plan->cftx[i] = d2f (CFIR_CSCL * filt[i+i+0]);
      plan->cfty[i] = d2f (CFIR_CSCL * filt[i+i+1]);
    };
    if (deq < 0) for (i = 0; i < nt; i ++) plan->cfty[i] = - plan->cfty[i];
  }
  plan->eq = deq;
}

int_4 CFIR_init (CFIR* plan) {
  plan->ntap = CFIR_RTAP;
  plan->bypass = 0;
  plan->fwf = 1;
  plan->cscl = 1.0F / CFIR_CSCL;
  return 0;
}

int_4 CFIR_set (CFIR* plan, String* key, Value* value) {
  if (isMatch (key, "L:GAIN")) plan->gain = Value_toL (value);
  else if (isMatch (key, "L:EQ")) CFIR_setEq (plan, Value_toL (value));
  else if (isMatch (key, "L:NTAP")) plan->ntap = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 CFIR_get (CFIR* plan, String* key, Value* value) {
  if (isMatch (key, "L:GAIN")) Value_fromL (value, plan->gain);
  else if (isMatch (key, "L:NTAP")) Value_fromL (value, plan->ntap);
  else return Core_get (plan, key, value);
  return 0;
}

void CFIR_genFilt (CFIR* plan) {
  int_4 i, j, k, nt = plan->nrpt * plan->ntap;
  int_4 joff = CFIR_RTAP - plan->ntap;
  real_8 fw = plan->fwf;
  real_4* ctap = zallocBuf(sizeof(real_4)*(nt * 2));
  firkais_generate (1, fw / plan->nrpt, 0.0, 0.05 / plan->nrpt, 80.0, ctap, nt, 0);
}

int_4 CFIR_open (CFIR* plan) {
  int_4 i;
  plan->cftx = zallocBuf(sizeof(real_4)*(CFIR_NCTAP));
  plan->cfty = zallocBuf(sizeof(real_4)*(CFIR_NCTAP));
  plan->cdt = zallocBuf(sizeof(CxReal_4*)*(CFIR_NCTAPX));
  for (i = 0; i < CFIR_NCTAPX; i ++) plan->cdt[i] = CxReal_4_new ();
  plan->vi = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vi[i] = CxReal_4_new ();
  plan->vo = zallocBuf(sizeof(CxReal_4*)*(NP));
  for (i = 0; i < NP; i ++) plan->vo[i] = CxReal_4_new ();
  CFIR_setEq (plan, plan->eq);
  printf ("CFIR ntap=%d NP=%d eq=%d byp=%d\n", plan->ntap, NP, plan->eq, plan->bypass ? 1 : 0);
  CFIR_upload (plan,plan);
  return 0;
}

int_4 CFIR_process (CFIR* plan, Stream* si, Stream* so) {
  int_1 doin, doout;
  int_2 i, j, k;
  while (si->rok && so->wok) {
    Stream_rdCIFA (si, plan->vi, NP);
    for (k = CFIR_NCTAP - 1; k >= 0; k --) {
      dupcc ((k < NP) ? plan->vi[NP-1-k] : plan->cdt[k-NP], plan->cdt[k]);
    }
    for (j = 0; j < NP; j ++) {
      CxReal_4 csum_,*csum=&csum_;
      csum->x = 0;
      csum->y = 0;
      for (i = 0; i < CFIR_NCTAP; i ++) {
        CxReal_4 ctap_,*ctap=&ctap_, cdat_,*cdat=&cdat_, cmx_,*cmx=&cmx_, cmy_,*cmy=&cmy_;
        ctap->x = plan->cftx[i];
        ctap->y = plan->cfty[i];
        cdat = plan->cdt[NP-1-j+i];
        cmx->x = ctap->x * cdat->x;
        cmx->y = ctap->y * cdat->y;
        cmy->x = ctap->x * cdat->y;
        cmy->y = ctap->y * cdat->x;
        csum->x += cmx->x - cmx->y;
        csum->y += cmy->x + cmy->y;
      }
      mulcf (csum, plan->cscl, plan->vo[j]);
    }
    Stream_wrCFIA (so, plan->vo, NP);
  }
  return 0;
}

int_4 CFIR_close (CFIR* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 CFIR_poll (CFIR* plan) { return 0; }

int_4 CFIR_free (CFIR* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

CFIR* CFIR_subCore (HALO* halo, int_4 scid) {
  CFIR* plan = CFIR_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  CFIR_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
