/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See AU2C.jv for documentation.
*/

/** Define Signatures */
#define CORE_NAME AU2C
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 2
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 64
#define CW 6

enum { AU2C_RW = 12 };
enum { AU2C_NHDR = 64 };
enum { AU2C_NPKT = 2432 };
enum { AU2C_NPKTI = 2432 };
enum { AU2C_NCFG = 64 };
enum { AU2C_NOVR = 4000 };
enum { AU2C_NRAM = 4096 };
enum { AU2C_MRAM = ( AU2C_NRAM - 1 ) };
enum { AU2C_NCRP = 270 };
enum { AU2C_NCRV = 260 };
enum { AU2C_NROW = 9 };
enum { AU2C_NVRC = ( 87 * 9 ) };
enum { AU2C_NOUT = 2340 };
enum { AU2C_NTOT = ( AU2C_NHDR + AU2C_NPKT ) };
enum { AU2C_NTOTI = ( AU2C_NHDR + AU2C_NPKTI ) };
enum { AU2C_SFIL = ( AU2C_NHDR + AU2C_NOUT - 4 ) };
enum { AU2C_SOVH = ( AU2C_NHDR + AU2C_NOUT + 12 ) };
enum { AU2C_MAXDMAI = 272 };
enum { AU2C_MAXDMAO = 264 };

static int_u2 NCRPS[] = { AU2C_NCRP * 1 , AU2C_NCRP * 4 , AU2C_NCRP * 16 , AU2C_NCRP * 64 };
static int_u2 NCRVS[] = { AU2C_NCRV * 1 , AU2C_NCRV * 4 , AU2C_NCRV * 16 , AU2C_NCRV * 64 };
static int_u4 DMINS[] = { 10 * 1 * 12 , 10 * 4 * 3 , 10 * 16 * 1 , 10 * 64 * 1 };

/** Define CORE Plan Handles */
typedef struct {
  int_u1 smd;
  int_u1 cnt;
  int_u2 ptr;
  int_u1 irow;
  int_u1 orow;
  int_u2 ilen;
  int_u2 olen;
  int_u4 iram;
  int_u4 oram;
} AU2C_ChannelState;

int_4 AU2C_ChannelState_upload (AU2C_ChannelState* plan, void *planp) {
  HW_loadHdr (planp,9);
  HW_loadInt  (planp,plan->smd);
  HW_loadInt  (planp,plan->cnt);
  HW_loadInt  (planp,plan->ptr);
  HW_loadInt  (planp,plan->irow);
  HW_loadInt  (planp,plan->orow);
  HW_loadInt  (planp,plan->ilen);
  HW_loadInt  (planp,plan->olen);
  HW_loadInt  (planp,plan->iram);
  HW_loadInt  (planp,plan->oram);
  return 9;
}
AU2C_ChannelState* AU2C_ChannelState_new() { 
  return (AU2C_ChannelState*)zalloc(sizeof(AU2C_ChannelState)); 
}
typedef struct {
  HALO halo;
  int_4 func;
  int_4 dec;
  int_4 chn;
  int_4 imd;
  int_1 pkt;
  int_1 tag;
  int_1 ntag;
  int_1 mtag;
  int_4 nfpp;
  int_4 itag;
  int_4 ncfg;
  int_4 itl;
  int_4 otl;
  int_4 ofs;
  int_4 dfs;
  int_4 ipkt;
  int_4 opkt;
  int_u2 novh;
  AU2C_ChannelState** csa;
  RamRWC* ram;
  RamRWC* rov;
  RamRWC* rop;
  Dma* dmar;
  Dma* dmaw;
} AU2C;

#include "cores/CoreProtos.h"

/** CORE Code */

void* AU2C_alloc (char *config) {
  AU2C* plan = AU2C_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 AU2C_upload (AU2C* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,6);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_push (planp,HW_OPEN);
  return 6;
}

int_4 AU2C_init (AU2C* plan) {
  plan->itl = AU2C_NTOTI;
  plan->otl = AU2C_NTOT * 2;
  plan->ofs = AU2C_NTOT;
  plan->dec = 1;
  return 0;
}

void AU2C_setFunction (AU2C* plan, Value* value) {
}

void AU2C_setConfigFile (AU2C* plan, Value* value) {
}

int_4 AU2C_set (AU2C* plan, String* key, Value* value) {
  if (isMatch (key, "S:FUNCTION")) AU2C_setFunction (plan, value);
  else if (isMatch (key, "L:CONFIG")) AU2C_setConfigFile (plan, value);
  else if (isMatch (key, "L:CHN")) plan->chn = Value_toL (value);
  else if (isMatch (key, "L:FLAGS")) plan->halo.flag = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 AU2C_get (AU2C* plan, String* key, Value* value) {
  if (isMatch (key, "L:NCFG")) Value_fromL (value, plan->ncfg);
  else if (isMatch (key, "L:ITL")) Value_fromL (value, plan->itl);
  else if (isMatch (key, "L:OTL")) Value_fromL (value, plan->otl);
  else if (isMatch (key, "L:OFS")) Value_fromL (value, plan->ofs);
  else if (isMatch (key, "L:DEC")) Value_fromL (value, plan->dec);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 AU2C_open (AU2C* plan) {
  int_4 i;
  plan->csa = zallocBuf(sizeof(AU2C_ChannelState*)*(AU2C_NCFG));
  for (i = 0; i < AU2C_NCFG; i ++) plan->csa[i] = AU2C_ChannelState_new ();
  plan->ram = RamRWC_new (AU2C_RW, BW, BW, CW);
  plan->rov = RamRWC_new (4, BW, 8, CW);
  plan->rop = RamRWC_new (AU2C_RW, BW, BW, 1);
  plan->dmar = Dma_new (AU2C_RW, BW);
  plan->dmaw = Dma_new (AU2C_RW, BW);
  AU2C_upload (plan,plan);
  return 0;
}

int_4 AU2C_process (AU2C* plan, Buffer* bi, Buffer* bo) {
  int_4 flag;
  int_8 bx, bx1;
  int_1 bb, br;
  int_u1 omc;
  int_u1 nds;
  int_u1 omd, typ, smd, pmode, noc;
  int_u1 chn, seq, cnt;
  int_u1 chx, ndx, ndy;
  int_u2 bpct;
  int_u2 ncol;
  int_u2 ptr, xptr, nptr;
  int_u2 i, iadr, jadr, oadr;
  int_u2 iper, oper, iend, oend;
  int_u4 iram, oram, dram, tram, dmin;
  int_u1 xpebc, xpobc;
  int_u1 irow, orow;
  int_u2 ilen, olen;
  int_u2 inpr, onpr;
  int_1 iok, ook, restart, doin, doout, doovh, byp;
  AU2C_ChannelState* cs;
  nptr = 0;
  i = 0;
  flag = plan->halo.flag;
  bx = Buffer_getX (bi, i);
  plan->ipkt = getBits(bx, 63, 32);
  bx=setBits(bx, 63, 32, plan->opkt);
  Buffer_setX (bo, i, bx);
  i += 8;
  bx = Buffer_getX (bi, i);
  Buffer_setX (bo, i, bx);
  bx1 = bx;
  i += 8;
  chx = getBits(bx, 39, 32);
  chn = getBits(bx, 53, 48);
  omd = getBits(bx, 59, 56);
  typ = getBits(bx, 63, 60);
  omc = omd - 1;
  byp = (typ == 0) || (typ == 2) || (getBits(flag, 4, 4) != 0);
  doovh = (plan->novh >= AU2C_NOUT);
  while (i < AU2C_NHDR) {
    bx = Buffer_getX (bi, i);
    Buffer_setX (bo, i, bx);
    i += 8;
  }
  doin = 1;
  doout = 0;
  if (byp) {
    while (i < AU2C_NTOT) {
      bx = Buffer_getX (bi, i);
      Buffer_setX (bo, i, bx);
      i += 8;
    }
    doout = 1;
  }
  else if (doovh) {
    bx1=setBits(bx1, 63, 32, 0x90000000);
    Buffer_setX (bo, 8, bx1);
    Dma_r2b (plan->dmaw, plan->rop, 0, bo, AU2C_NHDR, AU2C_NPKT);
    plan->novh = 0;
    doin = 0;
    doout = 1;
  }
  else if (typ == 1) {
  }
  else {
    RamRWC_setC (plan->ram, chn);
    RamRWC_setC (plan->rov, chn);
    nds = omc << 1;
    ndx = 1 << nds;
    ndy = ndx - 1;
    seq = chx & ndy;
    bpct = 3 << nds;
    cs = plan->csa[chn];
    oram=cs->oram; iram=cs->iram; olen=cs->olen; ilen=cs->ilen; orow=cs->orow; irow=cs->irow; ptr=cs->ptr; cnt=cs->cnt; smd=cs->smd;
    Dma_addReader (plan->dmar, bi);
    Dma_addReader (plan->dmaw, plan->ram);
    inpr = NCRPS[omc];
    onpr = NCRVS[omc];
    dmin = DMINS[omc] + AU2C_MAXDMAO;
    dram = iram - oram;
    doout = dram > dmin && dram < AU2C_NRAM;
    iper = 192;
    iadr = AU2C_NHDR;
    iend = AU2C_NHDR + AU2C_NPKT;
    if (seq == 0) {
      irow = 0;
      ilen = 0;
    }
    if (seq == 57 && omc == 3) {
      iadr += iper;
    }
    if (seq == ndy) {
      iend -= (2 << nds);
    }
    oadr = AU2C_NHDR;
    oend = AU2C_NHDR + AU2C_NOUT;
    bx = 0;
    i = AU2C_SFIL;
    while (i < AU2C_NTOT) {
      Buffer_setX (bo, i, bx);
      i += 8;
    }
    do {
      iok = iadr < iend;
      if (ilen > 0 && iok) {
        iper = iend - iadr;
        if (ilen < iper) {
          iper = ilen;
        }
        if (iper > AU2C_MAXDMAI) {
          iper = AU2C_MAXDMAI;
        }
        if(plan->halo.vbpr&1)printf ("DMAi chn=%d row=%d adr=%x ram=%x xfer=%d smd=%d\n", chn, irow, iadr, iram, iper, smd);
        if (smd > 1) {
          Dma_sync (plan->dmar);
          Dma_b2r (plan->dmar, bi, iadr, plan->ram, iram, iper);
          iram = (iram + iper);
        }
        iadr += iper;
        ilen -= iper;
      }
      iok = iadr < iend;
      oper = oend - oadr;
      if (olen > 0 && oper > 0 && doout) {
        if (olen < oper) {
          oper = olen;
        }
        if (oper > AU2C_MAXDMAO) {
          oper = AU2C_MAXDMAO;
        }
        if(plan->halo.vbpr&1)printf ("DMAo chn=%d row=%d adr=%x ram=%x olen=%d xfer=%d\n", chn, orow, oadr, oram, olen, oper);
        Dma_sync (plan->dmaw);
        Dma_r2b (plan->dmaw, plan->ram, oram, bo, oadr, oper);
        oram = (oram + oper);
        oadr += oper;
        olen -= oper;
      }
      if (ilen == 0 && iok) {
        noc = 9;
        if (irow == 3) {
          restart = 0;
          jadr = iadr + bpct;
          bb = Buffer_getB (bi, iadr);
          nptr=setBits(nptr, 9, 8, bb);
          pmode = getBits(bb, 7, 4);
          bb = Buffer_getB (bi, jadr);
          nptr=setBits(nptr, 7, 0, bb);
          xptr = nptr ^ ptr;
          xpebc = getBits(xptr, 0, 0) + getBits(xptr, 2, 2) + getBits(xptr, 4, 4) + getBits(xptr, 6, 6) + getBits(xptr, 8, 8);
          xpobc = getBits(xptr, 1, 1) + getBits(xptr, 3, 3) + getBits(xptr, 5, 5) + getBits(xptr, 7, 7) + getBits(xptr, 9, 9);
          if (xptr == 0) {
            if (smd < 5) {
              smd ++;
            }
            restart = (smd == 2);
          }
          else if (pmode == 9) {
            if (smd > 2) {
              smd = 2;
            }
            ptr = nptr;
            restart = 1;
          }
          else if (smd < 2) {
            ptr = nptr;
          }
          else if (xpobc > 2) {
            noc = 12;
            ptr ++;
            if (ptr == AU2C_NVRC) {
              ptr = 0;
            }
          }
          else if (xpebc > 2) {
            noc = 6;
            if (ptr == 0) {
              ptr = AU2C_NVRC - 1;
            }
            else {
              ptr --;
            }
          }
          else if (smd > 0) {
            smd --;
            if (smd == 2) {
              smd = 0;
            }
            if (smd == 0) {
              restart = 1;
            }
          }
          tram = ptr * bpct;
          if(plan->halo.vbpr&1)printf ("pMode=%x nPtr=%x Ptr=%x chn=%d typ=%d smd=%d iadr=%x\n", pmode, nptr, ptr, chn, typ, smd, iadr);
          if (restart) {
            doout = 0;
            iram = 0;
            oram = tram;
            orow = 0;
            cnt = 0;
            olen = 0;
          }
        }
        ncol = AU2C_NCRP - noc;
        iadr = iadr + (noc << nds);
        irow = irow + 1;
        ilen = ncol << nds;
      }
      ook = oadr < oend && doout;
      if (olen == 0 && ook) {
        br = RamRWC_rdB (plan->ram, oram);
        oram += ndx;
        olen = onpr;
        orow = orow + 1;
        RamRWC_wrB (plan->rov, orow, br);
      }
    } while (iok || ook);
    if (doout) {
      Dma_sync (plan->dmaw);
      bx1=setBits(bx1, 47, 32, cnt);
      Buffer_setX (bo, 8, bx1);
      cnt = (cnt + 1) & ndy;
      if (cnt == 0) {
        RamRWC_wrB (plan->rov, 0, chn);
        Dma_r2b (plan->dmaw, plan->rov, 1, bo, AU2C_SOVH, 9);
        Dma_sync (plan->dmaw);
        Dma_r2r (plan->dmaw, plan->rov, 0, plan->rop, plan->novh, 10);
        plan->novh += 10;
        orow = 0;
      }
    }
    cs->oram=oram; cs->iram=iram; cs->olen=olen; cs->ilen=ilen; cs->orow=orow; cs->irow=irow; cs->ptr=ptr; cs->cnt=cnt; cs->smd=smd;
    plan->csa[chn] = cs;
  }
  Dma_sync (plan->dmar);
  if (doin) {
    Buffer_rnxt (bi, AU2C_NTOTI);
  }
  Dma_sync (plan->dmaw);
  if (doout) {
    Buffer_wnxt (bo, AU2C_NTOT);
    plan->opkt ++;
  }
  return 0;
}

int_4 AU2C_close (AU2C* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 AU2C_poll (AU2C* plan) { return 0; }

int_4 AU2C_free (AU2C* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

AU2C* AU2C_subCore (HALO* halo, int_4 scid) {
  AU2C* plan = AU2C_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  AU2C_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
