module xfft_16k (
  aclk,
  aresetn,
  s_axis_config_tdata,
  s_axis_config_tvalid,
  s_axis_config_tready,
  s_axis_data_tdata,
  s_axis_data_tvalid,
  s_axis_data_tready,
  s_axis_data_tlast,
  m_axis_data_tdata,
  m_axis_data_tuser,
  m_axis_data_tvalid,
  m_axis_data_tready,
  m_axis_data_tlast,
  event_frame_started,
  event_tlast_unexpected,
  event_tlast_missing,
  event_status_channel_halt,
  event_data_in_channel_halt,
  event_data_out_channel_halt
);

  input aclk;
  input aresetn;
  input [23 : 0] s_axis_config_tdata;
  input s_axis_config_tvalid;
  output s_axis_config_tready;
  input [63 : 0] s_axis_data_tdata;
  input s_axis_data_tvalid;
  output s_axis_data_tready;
  input s_axis_data_tlast;
  output [63 : 0] m_axis_data_tdata;
  output [15 : 0] m_axis_data_tuser;
  output m_axis_data_tvalid;
  input m_axis_data_tready;
  output m_axis_data_tlast;
  output event_frame_started;
  output event_tlast_unexpected;
  output event_tlast_missing;
  output event_status_channel_halt;
  output event_data_in_channel_halt;
  output event_data_out_channel_halt;

// synthesis translate_off

  XFFT_16K inst (
        .aclk(aclk),
        .aresetn(aresetn),
        .s_axis_config_tdata(s_axis_config_tdata), // Bus [23 : 0]
        .s_axis_config_tvalid(s_axis_config_tvalid),
        .s_axis_config_tready(s_axis_config_tready),
        .s_axis_data_tdata(s_axis_data_tdata), // Bus [63 : 0]
        .s_axis_data_tvalid(s_axis_data_tvalid),
        .s_axis_data_tready(s_axis_data_tready),
        .s_axis_data_tlast(s_axis_data_tlast),
        .m_axis_data_tdata(m_axis_data_tdata), // Bus [63 : 0]
        .m_axis_data_tuser(m_axis_data_tuser), // Bus [15 : 0]
        .m_axis_data_tvalid(m_axis_data_tvalid),
        .m_axis_data_tready(m_axis_data_tready),
        .m_axis_data_tlast(m_axis_data_tlast),
        .event_frame_started(event_frame_started),
        .event_tlast_unexpected(event_tlast_unexpected),
        .event_tlast_missing(event_tlast_missing),
        .event_status_channel_halt(event_status_channel_halt),
        .event_data_in_channel_halt(event_data_in_channel_halt),
        .event_data_out_channel_halt(event_data_out_channel_halt));

// synthesis translate_on

// XST black box declaration
// box_type "black_box"
// synthesis attribute box_type of xfft_16k is "black_box"

endmodule
