/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE-V6M Main Controller

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/1/2010

*/
`define IO_CPP
`define PE_CPP
`define CARD_CPP
`define HSV HSV_CPP
`include "vdefs.h"
`include "mdefs.h"

module top (
  cclkp,cclkn,
  vipc,vinc, vip,vin, vopc,vonc, vop,von,
  mckp, mckn, mcke, mcs, mwe, mcas, mras,
  mdm, mba, ma, mdqs, mdq,
  sig, tp
  );

  // parameters
  parameter IBW=64;
  parameter MBW=128;

  // clocks  
  input  cclkp,cclkn;

  // hyper-transport
  input  vipc,vinc;
  input  [7:0] vip,vin;
  output vopc,vonc;
  output [7:0] vop,von;

  // memory interface
  inout mckp;
  output mckn,mcke,mcs,mwe,mcas,mras;
  output [2:0] mba;
  output [12:0] ma;
  output [1:0] mdm;
  inout  [7:0] mdqs;
  inout  [63:0] mdq;

  // test port
  inout [7:0] tp;
  input sig;

// Global clocks
wire L=0, H=1;
wire gclkt,gclks,gclkx,gclkvi,gclkvo,gclkf;
wire [3:0] gclkvis,gclkvos;
wire [10:0] gclkms;

// JTAG control bus
wire clk,cs,rd,wr;
wire [7:0] page,addr,data,datat,datap;

// Hyper-transport lines
wire [2:0] hrios,hrdys;
wire [3:0] hold,hihold,hohold;

// PPC system control bus
wire srw, srds,swrs, srdx,swrx, srdf,swrf;
wire [31:0] sdbus, srdbus, swrbus, srdbusm,srdbusn;
wire [31:0] swrbusp,srdbusd, srdbush,srdbust, srdbusca,srdbuscb, srdbusta,srdbustb;
wire [31:0] saddr,sads,sadf;
wire [7:0] sack;
wire [7:0] csel = saddr[31:24];

// PPC local bus
wire busyp,okp;
wire [31:0] addrp;
wire [1:0] sizep;
wire [31:0] reqp;

// BRAM control bus
wire bclk = gclkx;
wire brd, bwr;
wire [15:0] baddr;
wire [31:0] brdbus, bwrbus;

// System dma bus
wire ioclk = gclkx;
wire irdym,ienam, ienap,ienah, ienaca,ienacb, ienaha,ienahb,ienahc, ienata,ienatb;
wire ordym,oenam, oenap,oenah, oenaca,oenacb, oenaha,oenahb,oenahc, oenata,oenatb;
wire [IBW-1:0] ibusm, ibusp,ibush, ibusca,ibuscb, ibusha,ibushb, ibusta,ibustb;
wire [IBW-1:0] obusm, obusp,obush, obusca,obuscb, obusha,obushb, obusta,obustb;
wire [7:0] iselca,iselcb,oselca,oselcb,iselta,iseltb,iselha,iselhb,oselha,oselhb;
wire [11:0] oselta,oseltb;
wire [15:0] istat,ostat,iselhc;
wire [23:0] qrdym,qselm;
wire [7:0] mcena,mcenb;
wire [31:0] route;
wire [3:0] hpchn;
wire hprst;

// DRAM interface
wire [35:0] acmd;
wire mclk,ago,apd,afull,modt;

// System resets / clock speeds
wire rdmac,rxt,rscs,rprc,rmem,rtun,rio,rmod,oppms;
wire hypm = hpchn[0]; // hyper calibration mode
wire [7:0] speed;
wire [2:0] trsp,trsv;

// Control address page resolution
wire pagez = (page==0);
wire pagep = (pagez && !addr[7]);
wire paget = (pagez && addr[7]);

// Test output signals
wire[7:0] testm,testhi,testho,testp,testd,testr,testx,testca,testcb,testta,testtb,testsc;

// JTAG interface for read/write of control words
bscanif bsif (clk,cs,rd,wr,page,addr,data,paget?datat:datap);

// Mux the system read busses
muxTxN #(32) srd (sdbus, srdbusd,  csel[`DMAC]);
muxTxN #(32) srm (sdbus, srdbusm,  csel[`HP]);
muxTxN #(32) srh (sdbus, srdbush,  csel[`HA]);
muxTxN #(32) srt (sdbus, srdbusn,  csel[`HB]);
muxTxN #(32) sr1 (sdbus, srdbusca, csel[`CA]);
muxTxN #(32) sr2 (sdbus, srdbuscb, csel[`CB]);
muxTxN #(32) sr3 (sdbus, srdbusta, csel[`TA]);
muxTxN #(32) sr4 (sdbus, srdbustb, csel[`TB]);
assign swrbus = swrbusp;
assign srdbus = sdbus;

// System clocks for hyper-transport, memory, tuners and PPC
wire crst = (rd && page==`C0F);
wire swrc = csel[`DMAC] && saddr[14] && swrs;
sysclocks sc (
  cclkp,cclkn,vipc,vinc,vopc,vonc,mclk,clk,
  crst,addr, swrc,swrbus, srdbusm,srdbusn, rdmac,
  rscs,rprc,rmem,rtun,rio,rmod, speed,trsp,
  gclkc,gclkt,gclks,gclkx,gclkms,gclkvi,gclkvis,gclkvo,gclkvos,gclkf, testsc);

// Controller logic
processor #(IBW) ppc (
  clk,rd,wr,page,addr,data,datap, pagep,                        // JTAG IF
  bclk,baddr, brd,brdbus, bwr,bwrbus, H,                        // BRAM IF
  gclkx,rprc, srw,saddr, srdx,srdbus, swrx,swrbusp, sack,       // System Control
  gclks,srds,swrs,sads, gclkf,srdf,swrf,sadf,                   // Alternate SC rates
  ioclk, istat[`PROC],ienap,ibusp, ostat[`PROC],oenap,obusp,    // Data Bus
  addrp,sizep,busyp,okp,reqp, testp);                           // Memory access

// Input/output bus muxes and DMA sequencer
dmacontroller #(IBW) dmac (
  bclk,baddr, brd,brdbus, bwr,bwrbus,                   // BRAM IF
  gclkx,csel[`DMAC],saddr, srdx,srdbusd,swrx,swrbus,    // System IF
  gclkx,ago,apd,acmd,afull,qrdym,qselm,                 // Memory control
  irdym,ienam,ibusm,ordym,oenam,obusm,                  // Memory bus
  ioclk,rio,rdmac,rxt, istat,ostat,route,               // Block status
  ienap,ibusp,oenap,obusp, addrp,sizep,busyp,okp,       // PPC local bus
  ienah,ibush,oenah,obush, hpchn,hprst,                 // Host/TunerC bus
  ienaha,ibusha,iselha,oenaha,obusha,oselha,            // Hyper IF
  ienahb,ibushb,iselhb,oenahb,obushb,oselhb,            // Hyper IF
  ienaca,ibusca,iselca,oenaca,obusca,oselca,            // Core bus
  ienacb,ibuscb,iselcb,oenacb,obuscb,oselcb,            // Core bus
  ienata,ibusta,iselta,oenata,obusta,oselta,            // Tuner IF
  ienatb,ibustb,iseltb,oenatb,obustb,oseltb,            // Tuner IF
  oenahc,hrios,hrdys,hold,hihold,hohold, testd);

// SDRAM controller
sddrXram #(MBW,IBW,4) mb (
  gclkms,rmem, ago,apd,acmd,afull,qrdym,qselm,
  ioclk, irdym,ienam,ibusm, ordym,oenam,obusm,
  mckp,mckn,mcke,mwe,mcas,mras,mdm,mcs,mba,ma,mdqs,mdq,modt,
  mclk,trsp, testr);

// Hyper-transport input port 
hypin #(IBW) hi (
  gclkvi,gclkvis, vip,vin, 
  ioclk,rio, ostat[`HA],oenaha,oselha,obusha, ostat[`HB],oenahb,oselhb,obushb,  ostat[`HC],oenahc,
  hypm,calib, hrios,hrdys,hold, testhi);

// Core 1 engine
`ENGINE1 #(1,IBW) core1 (gclkf,rmod, csel[`CA],saddr, swrf,swrbus, srdf,srdbusca, sack[`CA],
  ioclk, istat[`CA],ienaca,iselca,ibusca, ostat[`CA],oenaca,oselca,obusca, testca);

// Core 2 engine
`ENGINE2 #(2,IBW) core2 (gclkf,rmod, csel[`CB],saddr, swrf,swrbus, srdf,srdbuscb, sack[`CB],
  ioclk, istat[`CB],ienacb,iselcb,ibuscb, ostat[`CB],oenacb,oselcb,obuscb, testcb);

// Core 3 / MultiCore 1 engine
`ENGINE3 #(3,IBW) mcore1 (gclkf,rmod, csel[`TA],saddr, swrf,swrbus, srdf,srdbusta, sack[`TA],
  ioclk, istat[`TA],ienata,iselta,ibusta, ostat[`TA],oenata,oselta,obusta, testta);

// Core 4 / MultiCore 2 engine
`ENGINE4 #(4,IBW) mcore2 (gclkf,rmod, csel[`TB],saddr, swrf,swrbus, srdf,srdbustb, sack[`TB],
  ioclk, istat[`TB],ienatb,iseltb,ibustb, ostat[`TB],oenatb,oseltb,obustb, testtb);

// Hyper-transport output port
hypout #(IBW) ho (
  gclkvo,gclkvos, vop,von, hihold,hohold,
  ioclk,rio, istat[`HA],ienaha,iselha,ibusha, istat[`HB],ienahb,iselhb,ibushb, istat[`HA1],istat[`HB1],iselhc,
  speed, hihold,hohold, testho);

// Test Port Output
wire tsync;
testport #(0,0) tport (
  clk,L, rd,wr,paget,addr,data,datat, tp,tsync,oppms,sig,
  testr,testd,testhi,testho, testca,testcb,testta,testtb);

// RealTime test vector
wire rdya,rdyb;
fifoNxM #(32,32) tfif (gclkx,crst,rdya,ago,acmd,  gclks,crst,rdyb,srds&csel[`HB],srdbust);

endmodule

