/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE Register Defines

  Definitions for Controller Registers

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`ifndef _REGDEFS
`define _REGDEFS

`define REG_RAM        0            // FIFO in/out register
`define REG_PCSR       1            // PCI control/status register
`define REG_MCSR       2            // master control/status register
`define REG_PLAT       3            // PCI Latency Timer
`define REG_PBAR       4            // PCI Base Address register
`define REG_IOC        5            // IOC port register
`define REG_MDAR       6            // master DMA address register
`define REG_MDTC       7            // master DMA transfer count

`define MAP_FIFO       8'h10        // 0x40 PCI
`define MAP_PCSR       8'h01        // 0x04
`define MAP_MCSR       8'h12        // 0x48
`define MAP_PLAT       8'h03        // 0x0C
`define MAP_PBAR       8'h04        // 0x10
`define MAP_PXCR       8'h13        // 0x4C
`define MAP_PXSR       8'h14        // 0x50
`define MAP_IOC        8'h15        // 0x54
`define MAP_MDAR       8'h16        // 0x58
`define MAP_MDTC       8'h17        // 0x5C

`define MAP_MBX1       8'h18        // 0x60
`define MAP_MBX2       8'h19        // 0x64
`define MAP_MBX3       8'h1A        // 0x68
`define MAP_MBX4       8'h1B        // 0x6C
`define MAP_MBX5       8'h1C        // 0x70
`define MAP_MBX6       8'h1D        // 0x74
`define MAP_MBX7       8'h1E        // 0x78
`define MAP_MBX8       8'h1F        // 0x7C


// Master Control/Status Register bits
`define MCSR_RPRC              0    // reset Processor
`define MCSR_RIOC              1    // reset IO controller
`define MCSR_RFIFO             2    // reset FIFO           - write 1 reset
`define MCSR_RMBXF             3    // reset MBX flags      - write 1 reset
`define MCSR_MENA              4    // Enable PCI master read/write
`define MCSR_MDIR              5    // Master direction 0=P2S 1=S2P
`define MCSR_WIDE              6    // PCI 64 bit enable
`define MCSR_TEST              7    // Run Self Test Counter

`define MCSR_BIGE0             8    // FIFO byte swap
`define MCSR_BIGE1             9    // FIFO short swap
`define MCSR_BIGE2             10   // FIFO int swap
`define MCSR_LIOC              11   // load IO controller
`define MCSR_FLG0              12   // Modifier flag - bit 0
`define MCSR_FLG1              13   // Modifier flag - bit 1
`define MCSR_CLK66             14   // 66 MHz PCI bus
`define MCSR_BUS64             15   // 64 bit PCI bus

`define MCSR_MBX1F             16   // Input mailbox #1 full        - write 1 clear
`define MCSR_MBX2F             17   // Input mailbox #2 full
`define MCSR_MBX3F             18   // Input mailbox #3 full
`define MCSR_MBX4F             19   // Input mailbox #4 full
`define MCSR_MBX5F             20   // Input mailbox #5 full
`define MCSR_MBX6F             21   // Input mailbox #6 full
`define MCSR_MBX7F             22   // Input mailbox #7 full
`define MCSR_MBX8F             23   // Input mailbox #8 full

`define MCSR_OFIFO_FULL        24   // P2S Fifo full        - readonly
`define MCSR_OFIFO_AFULL       25   // P2S Fifo almost full
`define MCSR_OFIFO_HALF        26   // P2S Fifo half full
`define MCSR_OFIFO_EMPTY       27   // P2S Fifo empty
`define MCSR_IFIFO_FULL        28   // S2P Fifo full        - readonly
`define MCSR_IFIFO_AFULL       29   // S2P Fifo almost full
`define MCSR_IFIFO_HALF        30   // S2P Fifo half full
`define MCSR_IFIFO_EMPTY       31   // S2P Fifo empty

`define MCSR_DAC               11   // Dual Address Cycle flag

`endif
