/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Xilinx RocketIO 3GIO Controller

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003


*/
`define RIO_DBW 128

module riocontroller (
  bsclk,bscs,bsrd,bswr,bspage,bsaddr,bsdata,bsdatao, // Boundary Scan Interface
  sclk,srst, scs,saddr, swr,swrbus, srd,srdbus,
  pxclkx, pxrxp,pxrxn, pxtxp,pxtxn, pxctl,
  rclk, clk1,rst1,rbus1,tbus1, clk2,rst2,rbus2,tbus2,
  test);			

  parameter PORTS=8;
  parameter IOTYPE1=0;
  parameter IOTYPE2=0;
  parameter IBW=64;

  localparam MPORTS=16;
  localparam DBW=`RIO_DBW;
  localparam DBWP=4+1+1+DBW;	// hold+rdy+valid+bus

  // BSCAN ports
  input bsclk,bscs,bsrd,bswr;
  input [7:0] bspage,bsaddr,bsdata;
  output [7:0] bsdatao;

  // system bus
  input sclk,srst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;
        
  // MGT ports
  input [3:0] pxclkx;
  input [PORTS-1:0] pxrxp,pxrxn;
  output [PORTS-1:0] pxtxp,pxtxn;
  inout [MPORTS-1:0] pxctl;

  // IO port busses
  input rclk;
  output [1:0] clk1,clk2;
  output reg rst1,rst2;
  output [DBWP-1:0] rbus1,rbus2;
  input  [DBWP-1:0] tbus1,tbus2;

  // test port
  output [7:0] test;

  // global signals 
  wire F=0, T=1;

  wire pxclk  = pxclkx[0];
  wire pxclkp = pxclkx[2];
  wire pxclkn = pxclkx[3];

  // boundary scan to DRP monitor
  wire drp_clk = sclk;
  wire drp_en;
  wire [15:0] drp_di,drp_addr;
  wire [PORTS-1:0] drp_wex,drp_rdyx;
  wire [PORTS*16-1:0] drp_dox;
  wire [PORTS*17-1:0] dmon_dox;
  bs2drp #(PORTS) (bsclk,bscs,bsrd,bswr,bspage,bsaddr,bsdata,bsdatao, 
		   drp_clk,drp_en,drp_wex,drp_addr,drp_di,drp_rdyx,drp_dox,dmon_dox);

  wire [3:0] rdy1,rdy2;
  wire [7:0] test1,test2;

  reg  [7:0]  icet_route;
  reg  [31:0] icetsys1,icetsys2;
  wire [31:0] status1,status2,rxaux1,rxaux2;
  wire [31:0] dbgsys = 32'h12345678;

  // system register address resolution - with pipeline
  wire [15:0] sb; swrbank #(0,16) swb (sclk,scs,swr,saddr,sb);
  
  // system registers - written to by pic_cport() host control software
  always @(posedge sclk) begin
    if (srst) icetsys1   <= 0; else if (sb[0]) icetsys1   <= swrbus;
    if (srst) icetsys2   <= 0; else if (sb[1]) icetsys2   <= swrbus;
    if (srst) icet_route <= 0; else if (sb[3]) icet_route <= swrbus[7:0];
    rst1 <= (status1[31:24] != 8'hFF);
    rst2 <= (status2[31:24] != 8'hFF);
  end

  reg [3:0] rx1cnt,rx2cnt; reg [127:0] rxdbg1,rxdbg2;

  // this next mux concatenates all inputs from right-to-left in second argument
  muxMxNp #(16,32) (srdbus,{rxdbg2,rxdbg1, rxaux2,rxaux1,dbgsys,24'hDEAD03,icet_route, status2,status1,icetsys2,icetsys1}, saddr[5:2],sclk);

  wire [DBW:0] rbus11,rbus21;
  icepm_rio #(4,DBW) bnk1 (sclk,icetsys1, clk1[0],clk1[1], rdy1, tbus1[DBW],tbus1[DBW-1:0], rbus11[DBW],rbus11[DBW-1:0],
		drp_clk,F,drp_en,drp_addr,drp_wex[3:0],drp_di,drp_rdyx[3:0],drp_dox[16*4-1:16*0],dmon_dox[17*4-1:17*0],
		pxclk, pxtxp[3:0],pxtxn[3:0], pxrxp[3:0],pxrxn[3:0], test1,status1,rxaux1);
`ifndef ICE_PM
  icepm_rio #(4,DBW) bnk2 (sclk,icetsys2, clk2[0],clk2[1], rdy2, tbus2[DBW],tbus2[DBW-1:0], rbus21[DBW],rbus21[DBW-1:0],
		drp_clk,F,drp_en,drp_addr,drp_wex[7:4],drp_di,drp_rdyx[7:4],drp_dox[16*8-1:16*4],dmon_dox[17*8-1:17*4],
		pxclk, pxtxp[7:4],pxtxn[7:4], pxrxp[7:4],pxrxn[7:4], test2,status2,rxaux2);
`endif
  reg [DBWP-1:0] rbus1,rbus2;
  always @(posedge clk1[1]) rbus1 <= {rxaux1[3:0],rdy1[0],rbus11[DBW:0]};
  always @(posedge clk2[1]) rbus2 <= {rxaux2[3:0],rdy2[0],rbus21[DBW:0]};
  always @(posedge clk1[1]) begin rx1cnt <= rx1cnt+1; if (rx1cnt==0) rxdbg1 <= rbus1; end
  always @(posedge clk2[1]) begin rx2cnt <= rx2cnt+1; if (rx2cnt==0) rxdbg2 <= rbus2; end

//  assign test = {rdy2,rdy1,clk2,clk1,tbus2[32],tbus1[32],rbus2[32],rbus1[32]};
//  assign test = {test1,tbus1[DBW],rbus1[DBW],clk1,srst};
  assign test = test1;

endmodule

module icepm_rio (sclk,sys, txclk,rxclk, rdy, txval,txdata, rxval,rxdata,
    drpclk,drprst,drpen,drpaddr,drpwe,drpdi,drprdy,drpdo,dmondo,
    gthrefclk, gthtxp,gthtxn, gthrxp,gthrxn, testout,status,data
  );
   
  parameter NC = 4;
  parameter BW = 32*NC;
  parameter INV = 0;
  parameter LOOPBACK = 0;

  localparam CW = 32;
  localparam LCW = NC*CW;

  input sclk;
  input [31:0] sys;

  output txclk,rxclk;
  output [NC-1:0] rdy;

  input txval;
  input [BW-1:0] txdata;

  output rxval;
  output [BW-1:0] rxdata;

  input drpclk;
  input drprst;
  input drpen;
`ifdef VIRTEX8P
  input [9:0] drpaddr;
`else
  input [8:0] drpaddr;
`endif
  input [15:0] drpdi;
  input [NC-1:0] drpwe;
  output [NC-1:0] drprdy;
  output [(NC*16)-1:0] drpdo;
  output [(NC*17)-1:0] dmondo;

  input gthrefclk;
  output [NC-1:0] gthtxp,gthtxn;
  input  [NC-1:0] gthrxp,gthrxn;

  output [7:0] testout;
  output [31:0] status;
  output [31:0] data;

  function [3:0] parity (input [31:0] idat);
    parity = {	idat[3]^idat[7]^idat[11]^idat[15]^idat[19]^idat[23]^idat[27]^idat[31],
		idat[2]^idat[6]^idat[10]^idat[14]^idat[18]^idat[22]^idat[26]^idat[30],
		idat[1]^idat[5]^idat[9] ^idat[13]^idat[17]^idat[21]^idat[25]^idat[29],
		idat[0]^idat[4]^idat[8] ^idat[12]^idat[16]^idat[20]^idat[24]^idat[28] };
  endfunction

  wire [NC-1:0] txclks,rxclks;
  BUFG_GT txbufg (.I(txclks[0]),.O(txclk));
  BUFG_GT rxbufg (.I(rxclks[0]),.O(rxclk));

  wire cxrst;  ff #(1,2) resyncc  (cxrst, sys[0],sclk);
  wire txrst;  ff #(1,2) resynct  (txrst, sys[1],txclk);
  wire rxrst;  ff #(1,2) resyncr  (rxrst, sys[2],rxclk);
  wire pxrst;  ff #(1,2) resyncp  (pxrst, sys[3],rxclk);
  wire txrstb; ff #(1,2) resynctb (txrstb,sys[4],txclk);
  wire rxrstb; ff #(1,2) resyncrb (rxrstb,sys[5],rxclk);
  wire rxrstd; ff #(1,2) resyncrd (rxrstd,sys[6],rxclk);
  wire txrsts; ff #(1,2) resyncs  (txrsts,sys[7],txclk);

  // prep resets and clocks
  reg [7:0] txcnt; always @(posedge txclk or posedge cxrst) if (cxrst) txcnt <= 0; else txcnt <= txcnt+1;
  reg [7:0] rxcnt; always @(posedge rxclk or posedge cxrst) if (cxrst) rxcnt <= 0; else rxcnt <= rxcnt+1;
  reg txact; always @(posedge txclk or posedge cxrst) if (cxrst) txact <= 0; else txact <= txact || txcnt[7];
  reg rxact; always @(posedge rxclk or posedge cxrst) if (cxrst) rxact <= 0; else rxact <= rxact || rxcnt[7];
  wire gtwiz_buffbypass_tx_done_out,gtwiz_buffbypass_tx_error_out;
  wire gtwiz_buffbypass_rx_done_out,gtwiz_buffbypass_rx_error_out;
  wire refclk,gtwiz_reset_rx_cdr_stable_out,gtwiz_reset_tx_done_out,gtwiz_reset_rx_done_out;
  wire [NC-1:0] gtpowergood_int,rxpmaresetdone_out,txpmaresetdone_out,txprgdivresetdone_out;
  wire gtwiz_userclk_tx_active = txact;
  wire gtwiz_userclk_rx_active = rxact;
  wire gtwiz_buffbypass_tx_reset_in = txrstb;
  wire gtwiz_buffbypass_rx_reset_in = rxrstb;

  // training sequence 
  //  7
  //  0 txstr1  0xEE11EE11  
  //  1      2             rxscren
  //  2 txscren
  //
  reg txstr1,txstr2;
  reg txscren,rxscren;
  wire [31:0] txscramvec,rxscramvec;
  scrambler32dp #(2) scr (txclk,!txscren,txscramvec, rxclk,!rxscren,rxscramvec);

  // prep output streams
  reg tval,tvalh;
  wire [BW-1:0] txdatb;
  reg [BW-1:0] txdatc;
  reg [7:0] tcnt,tcnth;
  reg [4:0] tcyc;
  wire tcycle = !tcyc[4];
  wire theader = txval && (txdata[7:0]==8'hA5) && !tcycle;
  wire tstart = theader && (txdata[19:16]==4'h4);
  always @(posedge txclk) begin
    txstr1 <= txrsts && !txscren && !txstr1 && !txstr2;
    txstr2 <= txstr1;
    txdatc <= {NC{txscramvec}} ^ txdatb;
    tval   <= tstart;
    tvalh  <= theader;
    if (tstart)   tcyc <= 0; else if (tcycle) tcyc <= tcyc+1;
    if (!txscren) tcnt <= 0; else if (tval) tcnt <= tcnt+1;
    if (txrst) txscren <= 0; else txscren <= txstr2 || txscren;
    if (!txscren) tcnth <= 0; else if (tvalh) tcnth <= tcnth+1;
  end

  // align input streams
  reg rxgood,rval,rvalh,rxparen;
  wire [BW-1:0] rxdatc;
  reg [BW-1:0] rxdata;
  reg [7:0] rxseq,rcnt,rerr,rcnth;
  reg [4:0] rcyc;
  reg [3:0] rerrs;
  reg [NC-1:0] rxslide,rxaligned;
  wire rcycle = !rcyc[4];
  wire rheader = rxval && (rxdata[7:0]==8'hA5) && !rcycle;
  wire rstart = rheader && (rxdata[19:16]==4'h4);
  always @(posedge rxclk) begin
    rxdata <= {NC{~rxscramvec}} ^ rxdatc;	// polarity in PMs is always inverted;
    rxseq <= rxseq+1;
    rxgood <= rxaligned=={NC{1'b1}};
    rval  <= rstart; 
    rvalh <= rheader; 
    if (rstart)   rcyc <= 0; else if (rcycle) rcyc <= rcyc+1;
    if (!rxscren) rcnt <= 0; else if (rval)   rcnt <= rcnt+1;
    if (!rxparen) rerr <= 0; else if (rerrs!=0) rerr <= rerr+1;
    if (rxrst) rxscren <= 0; else if (rxgood) rxscren <= rxscren || (rxdata[31:0]==32'hEE11EE11);
    if (rxrst) rxparen <= 0; else rxparen <= rxparen || (rxscren && rheader);
    if (!rxscren) rcnth <= 0; else if (rvalh)   rcnth <= rcnth+1;
  end

  genvar i;
  generate
  for (i=0; i<NC; i=i+1) begin
    reg [2:0] cnt; reg rok;
    wire [31:0] rdati = rxdata[31+i*32:i*32];
    wire [31:0] tdati = txdata[31+i*32:i*32];
    wire [31:0] tdatj = txstr1? 32'hEE11EE11 : tdati;
    reg [7:0] rxslid;
    reg [3:0] tpar,rpar;
    wire [3:0] tpar_ = parity (tdati);
    wire [3:0] rpar_ = parity (rdati);
    always @(posedge rxclk) begin
      rok <= (rdati==32'hEE11FF00);
      if (rxrstb|(!rxseq[7])) cnt <= 0; else if (rok) cnt <= cnt+1; // need 4 since last rxslide or 32 clocks
      if (rxrstb) rxaligned[i] <= 0; else rxaligned[i] <= rxaligned[i] || (cnt[2] && pxrst);
      rxslide[i] <= pxrst && !rxaligned[i] && (rxseq[7:1]==1);
      if (rxrstb) rxslid  <= 0; else if (rxslide[i]) rxslid = rxslid+1;
      rpar <= rheader ? rpar_ ^ rdati[23:20] : rpar ^ rpar_;	// TX parity based on parity field=0
      rerrs[i] <= rxparen && rheader && (rdati[23:20] != rpar);
    end
    assign data[3+i*4:i*4] = rxslid;
    always @(posedge txclk) begin
      tpar <= theader ? tpar_ : tpar ^ tpar_;
    end		// insert current parity in header field
    assign txdatb[31+i*32:i*32] = { tdatj[31:24], theader?tpar:tdatj[23:20], tdatj[19:0] };
  end
  endgenerate

  assign rxval = rxgood;
  assign rdy = {NC{rxgood}};

  // call the coregen for all 4 channels
  gtrio gtinst (
    .gthrxn_in                               (gthrxn)
   ,.gthrxp_in                               (gthrxp)
   ,.gthtxn_out                              (gthtxn)
   ,.gthtxp_out                              (gthtxp)
   ,.gtwiz_userclk_tx_active_in              (gtwiz_userclk_tx_active)
   ,.gtwiz_userclk_rx_active_in              (gtwiz_userclk_rx_active)
   ,.gtwiz_buffbypass_tx_reset_in            (gtwiz_buffbypass_tx_reset_in)
   ,.gtwiz_buffbypass_tx_start_user_in       (1'b0)
   ,.gtwiz_buffbypass_tx_done_out            (gtwiz_buffbypass_tx_done_out)
   ,.gtwiz_buffbypass_tx_error_out           (gtwiz_buffbypass_tx_error_out)
   ,.gtwiz_buffbypass_rx_reset_in            (gtwiz_buffbypass_rx_reset_in)
   ,.gtwiz_buffbypass_rx_start_user_in       (1'b0)
   ,.gtwiz_buffbypass_rx_done_out            (gtwiz_buffbypass_rx_done_out)
   ,.gtwiz_buffbypass_rx_error_out           (gtwiz_buffbypass_rx_error_out)
   ,.rxslide_in                              (rxslide)
   ,.gtwiz_reset_clk_freerun_in              (sclk)
   ,.gtwiz_reset_all_in                      (cxrst)
   ,.gtwiz_reset_tx_pll_and_datapath_in      (txrst)
   ,.gtwiz_reset_tx_datapath_in              (1'b0)
   ,.gtwiz_reset_rx_pll_and_datapath_in      (rxrst)
   ,.gtwiz_reset_rx_datapath_in              (rxrstd)
   ,.gtwiz_reset_rx_cdr_stable_out           (gtwiz_reset_rx_cdr_stable_out)
   ,.gtwiz_reset_tx_done_out                 (gtwiz_reset_tx_done_out)
   ,.gtwiz_reset_rx_done_out                 (gtwiz_reset_rx_done_out)
   ,.gtwiz_userdata_tx_in                    (txdatc)
   ,.gtwiz_userdata_rx_out                   (rxdatc)
   ,.dmonitorclk_in                          ({NC{drpclk}})
   ,.dmonitorout_out                         (dmondo)
   ,.drpclk_in                               ({NC{drpclk}})
   ,.drpaddr_in                              ({NC{drpaddr}})
   ,.drpdi_in                                ({NC{drpdi}})
   ,.drpen_in                                ({NC{drpen}})
   ,.drpwe_in                                (drpwe)
   ,.drpdo_out                               (drpdo)
   ,.drprdy_out                              (drprdy)
   ,.gtrefclk00_in                           (gthrefclk)
   ,.qpll0outrefclk_out                      (refclk)
   ,.rxusrclk_in                             ({NC{rxclk}})
   ,.rxusrclk2_in                            ({NC{rxclk}})
   ,.txusrclk_in                             ({NC{txclk}})
   ,.txusrclk2_in                            ({NC{txclk}})
   ,.gtpowergood_out                         (gtpowergood_int)
   ,.rxoutclk_out                            (rxclks)
   ,.rxpmaresetdone_out                      (rxpmaresetdone_out)
   ,.txoutclk_out                            (txclks)
   ,.txpmaresetdone_out                      (txpmaresetdone_out)
   ,.txprgdivresetdone_out                   (txprgdivresetdone_out)
  );

  wire [3:0] txstat = {gtwiz_buffbypass_tx_reset_in,gtwiz_buffbypass_tx_done_out,gtwiz_reset_tx_done_out,gtwiz_userclk_tx_active};
  wire [3:0] rxstat = {gtwiz_buffbypass_rx_reset_in,gtwiz_buffbypass_rx_done_out,gtwiz_reset_rx_done_out,gtwiz_userclk_rx_active};
  wire [3:0] cxstat = {(rxstat==7),(txstat==7),rxscren,txscren};
  reg ttt; always @(posedge txclk) ttt <= !ttt;
  reg rrr; always @(posedge rxclk) rrr <= !rrr;
  assign testout = {sys[3:0], rrr,rxrst,ttt,txrst};
  assign status = {rxaligned,cxstat, rerr, rcnt, tcnt};
  assign data[31:16] = {rcnth,tcnth};

endmodule
