/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE-K8M Main Controller

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  6/29/2012

*/
`define IO_CPP
`define PE_CPP
`define CARD_CPP
`define HSV HSV_CPP
`include "vdefs.h"
`include "mdefs.h"

module top (

  cclkp,cclkn,					// 2
  dclkp,dclkn,					// 2

  pclkp,pclkn,					// 2 MGT
  qclkp,qclkn,					// 2 MGT
  rclkp,rclkn,					// 2 MGT
  sclkp,sclkn,					// 2 MGT

  pxrxp,pxrxn, pxtxp,pxtxn, pxrst,
  pyrxp,pyrxn, pytxp,pytxn,

  mckp,mckn,mcke,mwe,mcas,mras,ma,mba,mdm,mdq,mdqsp,mdqsn,
  mcs,mrst,modt,mact,

  led_grn,led_red,
  fram_scl,fram_sda,
  tsense,
  cfg,						// 4
`ifdef JTAG_PUPS
  xvtck,xvtms,xvtdi,xvtdo,
`endif
  tp						// 8

);

  // parameters
`ifdef DMA_PKT_4X
  parameter IBW=256;		// I/O bus width
`else
  parameter IBW=128;		// I/O bus width
`endif
  parameter PXLW=`PX_LW;	// PCI Express Lane Width
  parameter PYLW=`PY_LW;	// Alternate 3GIO ports
  parameter MBL=8;		// Memory chip byte lanes
  parameter RBW=128;
`ifdef SYS_CLKF2_MASK
  localparam FM=`SYS_CLKF2_MASK;
  localparam F1=(FM>>0)&1, F2=(FM>>1)&1, F3=(FM>>2)&1, F4=(FM>>3)&1;
`else
  localparam F1=0, F2=0, F3=0, F4=0;
`endif

  // programmable clocks
  input cclkp,cclkn; 
  input dclkp,dclkn; 

  // GTE clocks  
  input pclkp,pclkn;
  input qclkp,qclkn;
  input rclkp,rclkn;
  input sclkp,sclkn;

  // MGT interfaces
  input pxrst;
  input  [PXLW-1:0] pxrxp, pxrxn;
  output [PXLW-1:0] pxtxp, pxtxn;
  input  [PYLW-1:0] pyrxp, pyrxn;
  output [PYLW-1:0] pytxp, pytxn;

  // memory interface
  inout  mckp,mckn;
  output mcke,mwe,mcas,mras;
  output [13:0] ma;
  output [2:0] mba;
  inout  [MBL-1:0] mdm;
  inout  [8*MBL-1:0] mdq;
  inout  [MBL-1:0] mdqsp,mdqsn;
  output mcs,mrst,modt,mact;

  // external interfaces
  output led_red,led_grn;
  inout fram_scl,fram_sda;
  input [3:0] cfg;
  input tsense;

  // jtag driver
`ifdef JTAG_PUPS
  input xvtck,xvtms,xvtdi,xvtdo;
`else
  wire xvtck,xvtms,xvtdi,xvtdo;
`endif

  // test port
  inout [7:0] tp;

// Global signals
wire L=0, H=1;

// Global clocks
wire gclkt,gclkr,gclkw,gclks,gclkx,gclky,gclkv;
wire [3:0] lclktp,lclktq,lclktr,lclkts;
wire [2:0] gclkf;
wire [39:0] gclkms;
wire cclk,pclk; 	// unused
wire [7:0] pxctl,pyctl;	// unused

// Activity detect
reg led1,led2;

// PPC system control bus
wire srw, srd,swr, srds,swrs, srdx,swrx, srdf[1:0],swrf[1:0];
wire [31:0] saddr,sads,sadf[1:0],swrbus,srdbus,swrbuss,swrbusf[1:0];
wire [31:0] srdbusp, srdbusr, srdbusd, srdbusc, srdbusj,srdbusn;
wire [31:0] srdbusha,srdbushb, srdbusca,srdbuscb, srdbusta,srdbustb;
wire [7:0] sack;
wire [7:0] csel = saddr[31:24];
wire [7:0] csels = sads[31:24];
wire [7:0] cself[1:0]; assign cself[0]=sadf[0][31:24]; assign cself[1]=sadf[1][31:24];

// PPC local bus
wire busyp,okp;
wire [31:0] addrp;
wire [1:0] sizep;
wire [31:0] reqp;

// BRAM control bus - also JVM clock
wire bclk = gclky;
wire brd,bwr;
wire [15:0] baddr;
wire [31:0] brdbus, bwrbus;

// System dma bus
wire ioclk = gclkx;
wire ienam, ienanv,ienad,ienan, ienap,ienah, ienaca,ienacb, ienaha,ienahb,ienahc, ienata,ienatb;
wire oenam, oenanv,oenad,oenan, oenap,oenah, oenaca,oenacb, oenaha,oenahb,oenahc, oenata,oenatb;
wire [IBW-1:0] ibusm, ibusnv,ibusn, ibusp,ibush, ibusca,ibuscb, ibusha,ibushb, ibusta,ibustb;
wire [IBW-1:0] obusm, obusnv,obusn, obusp,obush, obusca,obuscb, obusha,obushb, obusta,obustb;
wire [7:0]  iseln,oseln,iselh,oselh,iselca,iselcb,oselca,oselcb,iselha,iselhb,oselha,oselhb,iselta,iseltb;
wire [15:0] iselnv,oselnv,iselhc;
wire [11:0] oselta,oseltb;
wire [15:0] istat,ostat;
wire [31:0] route;
wire [23:0] qrdym,qselm;
wire [5:0] hpchn;
wire [3:0] istatn;
wire hprst;
wire hypm = hpchn[0]; // hyper calibration mode

// Hypertransport lines
wire [2:0] hrios,hrdys;
wire [3:0] hold,hihold,hohold;
wire [31:0] calib;

// DRAM interface
wire [35:0] acmd;
wire mclk,ago,apd,afull,irdym,ordym;
wire [2:0] trsp;

// System resets
wire rpci,rprc,rioc,rdmac,rxt;
wire rscs,rhyp,rmem,rio,rsts,rstf[1:0],rmod,boot,opps,oppts,oppms,oppus;

// RIO  signals
wire rrst1,rrst2;
wire [1:0] rclk1,rclk2;
wire rclk1o=rclk1[0],rclk1i=rclk1[1];
wire [RBW+6-1:0] ribus1,ribus2, robus1,robus2;

// Test output signals
wire [7:0] testsc,testx,testp,testd,testca,testcb,testj,testpm,temp;
wire [7:0] testhi,testho,testta,testtb,testrio,testnv,testnio,testr;
reg [7:0] speed; always @(posedge gclks) speed <= {testtb[7:4],testta[7:4]};

// Configuration signals
wire spi_clk,spi_fcs,cfg_clk;
wire [3:0] spi_dat;
wire [3:0] spi_i; assign spi_dat[1] = spi_i[1];
wire [3:0] spi_o = {spi_dat[3],spi_dat[2],H,spi_dat[0]};
wire [3:0] spi_dts = 2;
STARTUPE3 se3 (.USRCCLKO(spi_clk), .FCSBO(spi_fcs), .FCSBTS(L), .DO(spi_o), .DI(spi_i), .DTS(spi_dts), .USRCCLKTS(L), .CFGMCLK(cfg_clk) );
wire icapwr = selic && swrs;
ICAPE3 ice3 (.CLK(gclks),.CSIB(!icapwr),.I(swrbuss),.RDWRB(sads[0]));

// JTAG control bus
wire clk,cs,rd,wr,rdp,wrs; 
wire [1:0] rds; assign {rdp,rd}=rds;
wire [7:0] page,addr,data,datat,datap,datar,datan,datanv,datao,dataq, dataru,datarl,dataqu,dataql;
bscanif bsif (clk,cs,rds,wrs,page,addr,data,datao, spi_clk,spi_fcs,spi_dat);
assign wr=wrs;

// Control address page resolution
wire pagez = (page==0);
wire pagep = (pagez && !addr[7]);	// Processor
wire paget = (pagez &&  addr[7]);	// TestPort
wire pages = (page==3);			// Temp Sensor
wire pager = (page[7:6]==2);		// RIO
`ifdef DMA_NIO
wire pageq = (page[7:6]==3);		// NIO
wire pagen = (page==5);			// NIO JVM
wire [1:0] nioena;
`else
wire pageq = L;
wire pagen = L;
`endif
`ifdef DMA_NVM
wire pagenv = (page==6);		// NVME JVM
`else
wire pagenv = L;
`endif
wire   nsel  = page[4];
assign datar = nsel? dataru : datarl;
assign dataq = nsel? dataqu : dataql;
assign datao = pageq? dataq : pager? datar : pages? temp : paget? datat : pagen? datan : pagenv? datanv : datap;

// extra address selectors
wire csel0 = (csels==0);                // no select
wire [3:0] cselx = sads[23:20];
wire seljt = (csel0 && (cselx==8));     // JTAG
wire selic = (csel0 && (cselx==7));     // ICAP
wire selsm = (csel0 && (cselx==6));     // SysMon
wire selnx = (csel0 && (cselx==5));     // NetIO
wire selau = (csel0 && (cselx==4));     // Auxiliary
wire seltr = (csel0 && (cselx==3));     // Tracer
wire selrr = (csel0 && (cselx==2));     // RocketIO
wire selsc = (csel0 && (cselx==1));     // Sysclock

// Mux the system bus read ports
muxTxN #(32) srd (srdbus, srdbusd,  csel[`DMAC]);
muxTxN #(32) srp (srdbus, srdbusp,  csel[`HP]);
muxTxN #(32) sr3 (srdbus, srdbusha, csel[`HA]);
muxTxN #(32) sr4 (srdbus, srdbushb, csel[`HB]);
muxTxN #(32) sr5 (srdbus, srdbusca, csel[`CA]);
muxTxN #(32) sr6 (srdbus, srdbuscb, csel[`CB]);
muxTxN #(32) sr7 (srdbus, srdbusta, csel[`TA]);
muxTxN #(32) sr8 (srdbus, srdbustb, csel[`TB]);
muxTxN #(32) srn (srdbus, srdbusn,  selnx);
muxTxN #(32) srr (srdbus, srdbusr,  selrr);
muxTxN #(32) srj (srdbus, srdbusj,  seljt);
muxTxN #(32) srm (srdbus, srdbusc,  selsc);

// Generate system clocks/resets for hyper-transport, memory, cores and PPC
wire crst = (rd && page==`C0F);
wire swrc = csels[`DMAC] && saddr[14] && swrs;
wire rset = csels[`DMAC] && saddr[13] && swrs;
wire pset = csels[`DMAC] && saddr[12] && swrs;

sysclocks sc (
  cclkp,cclkn,dclkp,dclkn,pclkp,pclkn,qclkp,qclkn,rclkp,rclkn,sclkp,sclkn, cclk,mclk,trsp,
  crst,addr, swrc,swrbus,srdbusc, rprc,rdmac,pset,rset,
  rscs,rhyp,rmem,rio,rsts,rmod,boot,
  gclks,gclkx,gclky,gclkms,gclkf,gclkv,
  lclktp,lclktq,lclktr,lclkts,pclk, testsc);

// Handle activity detect
reg activity;
reg [9:0] acnt1,acnt2;
div_to_ppsx (gclks,opps,oppts,oppms,oppus);
always @(posedge gclks) begin
  activity <= rd || wr || oenaha || oenahb || ienaha || ienahb;
  if (oppms) acnt1 <= acnt1+1;
  if (activity) acnt2 <= 100; else if (oppms&&led2) acnt2 <= acnt2-1;
  led1 <= acnt1[9];
  led2 <= acnt2>0;
end
assign led_grn=!led1;
assign led_red=!led2;

// Command bus
wire ciena,cirdy,sirdy; wire [35:0] cibus; 
wire coena,cordy,sordy; wire [35:0] cobus; 
wire cmdsel = csel[`HA] && saddr[17] &&  saddr[4];
wire cmdsta = csel[`HA] && saddr[17] && !saddr[4] && saddr[3];
wire [31:0] cistats,cidata,costats; 
assign srdbusha = saddr[3]? cistats : cidata;
reg cmdrst; always @(posedge gclkx) if (swrx&cmdsta) cmdrst <= swrbus[0];
cmdfifo #(0) cif (cmdrst,cistats, rclk1i,cirdy,ciena,cibus, gclkx,sirdy,srdx&&cmdsel,cidata);
cmdfifo #(0) cof (cmdrst,costats, gclkx,sordy,swrx&&cmdsel,swrbus, rclk1o,cordy,coena,cobus);
assign srdbushb = 32'h12345678;

// JVM Controller logic 
processor #(IBW,0) ppc (
  clk,rd,wr,page,addr,data,datap, pagep,			// JTAG IF
  bclk,baddr, brd,brdbus, bwr,bwrbus, H,srd,swr,		// BRAM IF
  gclkx,rprc, srw,saddr, srdx,srdbus, swrx,swrbus, sack,	// System Control Bus
  ioclk, istat[`PROC],ienap,ibusp, ostat[`PROC],oenap,obusp,	// Data Bus
  addrp,sizep,busyp,okp,reqp, testp);

// Sysbus clock domain expander
busexpander sbx (
  gclky,    rprc, saddr,srd,swr,swrbus,
  gclks,    rmod, sads,srds,swrs,swrbuss, 
  gclkf[0], rstf[0], sadf[0],srdf[0],swrf[0],swrbusf[0],
  gclkf[1], rstf[1], sadf[1],srdf[1],swrf[1],swrbusf[1]);

// Input/output bus muxes and DMA sequencer
dmacontroller #(IBW) dmac (
  bclk,baddr, brd,brdbus, bwr,bwrbus,			// BRAM IF
  gclkx,csel[`DMAC],saddr, srdx,srdbusd,swrx,swrbus,	// System IF
  ioclk,ago,apd,acmd,afull,qrdym,qselm,			// Memory control
  irdym,ienam,ibusm,ordym,oenam,obusm,			// Memory bus
  ioclk,rio,rdmac,rxt, istat,ostat,route,		// Block status
  ienap,ibusp,oenap,obusp, addrp,sizep,busyp,okp,	// PPC local bus
  ienah,ibush,oenah,obush, hpchn,hprst,			// Host Port
  ienaha,ibusha,iselha,oenaha,obusha,oselha,		// I/O Module 1 
  ienahb,ibushb,iselhb,oenahb,obushb,oselhb,		// I/O Module 2 
  ienaca,ibusca,iselca,oenaca,obusca,oselca,		// Core 1
  ienacb,ibuscb,iselcb,oenacb,obuscb,oselcb,		// Core 2
  ienata,ibusta,iselta,oenata,obusta,oselta,		// Processor Module 1
  ienatb,ibustb,iseltb,oenatb,obustb,oseltb,		// Processor Module 2
`ifdef DMA_NIO
  ienan,ibusn,iseln,oenan,obusn,oseln, istatn,nioena,	// Network IO port
`endif
`ifdef DMA_NVM
  ienanv,ibusnv,iselnv,oenanv,obusnv,oselnv, iselhc,	// NVME IO port
`endif
  oenahc,hrios,hrdys,hold,hihold,hohold, testd);

// SDRAM controller 
`ifndef NOMEM
sddrXram #(IBW,8,MBL) mb (
  gclkms, rmem, ago,apd,acmd,afull,qrdym,qselm,
  ioclk, irdym,ienam,ibusm, ordym,oenam,obusm,
  mckp,mckn,mcke,mwe,mcas,mras,ma,mba,mdm,mdq,mdqsp,mdqsn,mcs,mrst,modt,mact,
  mclk,trsp, testr);
`endif

// Rocket IO X-bar interface
riocontroller #(PYLW,3,3) riop (
  clk, pager,rdp,wr,page,addr,data,datarl,  // JTAG debug port
  gclks,rprc, selrr,sads, swrs,swrbuss, srds,srdbusr,
  lclktr, pyrxp[3:0],pyrxn[3:0],pytxp[3:0],pytxn[3:0], pyctl,
  gclkv, rclk1,rrst1,ribus1,robus1, rclk2,rrst2,ribus2,robus2,
  testrio);

// Hyper-transport input port 
hypin #(IBW,8) hi (rclk1i,rrst1,ribus1[RBW],ribus1[RBW-1:0], ciena,cibus,
  ioclk,rio, ostat[`HA],oenaha,oselha,obusha, ostat[`HB],oenahb,oselhb,obushb, ostat[`HC],oenahc,
  hypm,calib, hrios,hrdys,hold, testhi);

`ifdef MC_FEEDBACK
mcengine #(1,IBW) core1 (gclkf[F1],rstf[F1], cself[F1][`CA],sadf[F1], swrf[F1],swrbusf[F1], srdf[F1],srdbusca, sack[`CA],
  ioclk, istat[`CA],ienaca,iselca,ibusca, ostat[`CA],oenaca,oselca,obusca, ostat[`TA],oenata,oselta,obusta, testca);

mcengine #(2,IBW) core2 (gclkf[F2],rstf[F2], cself[F2][`CB],sadf[F2], swrf[F2],swrbusf[F2], srdf[F2],srdbuscb, sack[`CB],
  ioclk, istat[`CB],ienacb,iselcb,ibuscb, ostat[`CB],oenacb,oselcb,obuscb, ostat[`TB],oenatb,oseltb,obustb, testcb);

`else
// Core 1 engine
`ENGINE1 #(1,IBW,IBW) core1 (gclkf[F1],rstf[F1], cself[F1][`CA],sadf[F1], swrf[F1],swrbusf[F1], srdf[F1],srdbusca, sack[`CA],
  ioclk, istat[`CA],ienaca,iselca,ibusca, ostat[`CA],oenaca,oselca,obusca, testca);
`ENGINE1DP

// Core 2 engine
`ENGINE2 #(2,IBW,IBW) core2 (gclkf[F2],rstf[F2], cself[F2][`CB],sadf[F2], swrf[F2],swrbusf[F2], srdf[F2],srdbuscb, sack[`CB],
  ioclk, istat[`CB],ienacb,iselcb,ibuscb, ostat[`CB],oenacb,oselcb,obuscb, testcb);
`ENGINE2DP

// Core 3 / MultiCore 1 engine
`ENGINE3 #(3,IBW,IBW) mcore1 (gclkf[F3],rstf[F3], cself[F3][`TA],sadf[F3], swrf[F3],swrbusf[F3], srdf[F3],srdbusta, sack[`TA],
  ioclk, istat[`TA],ienata,iselta,ibusta, ostat[`TA],oenata,oselta,obusta, testta);
`ENGINE3DP

// Core 4 / MultiCore 2 engine
`ENGINE4 #(4,IBW,IBW) mcore2 (gclkf[F4],rstf[F4], cself[F4][`TB],sadf[F4], swrf[F4],swrbusf[F4], srdf[F4],srdbustb, sack[`TB],
  ioclk, istat[`TB],ienatb,iseltb,ibustb, ostat[`TB],oenatb,oseltb,obustb, testtb);
`ENGINE4DP
`endif

// Hyper-transport output port
hypout #(IBW,8) ho (rclk1o,rrst1,ribus1[RBW+1],robus1[RBW],robus1[RBW-1:0], cordy,coena,cobus,
  ioclk,rio, istat[`HA],ienaha,iselha,ibusha, istat[`HB],ienahb,iselhb,ibushb, istat[`HA1],istat[`HB1], iselhc,
  speed, hihold,hohold, testho);

wire riox = rprc;
// Network IO interface
`ifdef DMA_NIO
niocontroller #(4,IBW) niop (
  clk, pageq,rdp,wr,page,addr,data,dataqu,	// JTAG debug port
  gclks,rprc, selnx,sads, swrs,swrbuss, srds,srdbusn,
  clk, rd,wr,page,addr,data,datan, pagen,	// JVM control IF
  lclktr, pxrxp[7:4],pxrxn[7:4], pxtxp[7:4],pxtxn[7:4], pxctl,
  ioclk,riox,nioena, istat[`NIO],ienan,iseln,ibusn, ostat[`NIO],oenan,oseln,obusn,     // Network IO port
  testnio);
  assign istatn = testnio;
`endif

// NVMe interface
`ifdef DMA_NVM
nvmcontroller #(4,IBW) nvmp (
  clk, pager,rdp,wr,page,addr,data,dataru,	// JTAG debug port
  clk, pagenv,rd,wr,page,addr,data,datanv, 	// JVM control IF
  rclk1i,cmdrst,ciena,cibus,
  lclktp, pyrxp[7:4],pyrxn[7:4], pytxp[7:4],pytxn[7:4], 
  ioclk,rio, istat[`NV],ienanv,iselnv,ibusnv, ostat[`NV],oenanv,oselnv,obusnv, 
  gclks,opps,oppts, testnv);
`endif

// Test Port Output
wire tsync;
testport #(1,0) tport (
  clk,L, rd,wr,paget,addr,data,datat, tp,tsync,oppms,cfg,
  testrio,testnio,testhi,testho, testca,testcb,testta,testtb);

// Temp Sensor
max6577 ts (gclks,oppms,tsense,temp);

endmodule
