`include "mdefs.h"
`include "../lib/ramdefs.h"
`ifdef verilator
`define Z1 1
`define Z2 1
`endif
`ifdef JVM_NOMULT
`define Z1 1
`endif
`ifdef VIRTEX6
`define Z2 1
`endif
`ifdef VIRTEX7
`define Z2 1
`endif
`ifdef VIRTEX8
`define Z2 1
`endif
`ifdef Z2
`define Z3 4
`else
`define Z3 2
`endif
module
jvmengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
32
;
parameter
OBW
=
IBW
;
localparam
SBW
=
32
;
localparam
IBB
=
IBW
/
8
;
localparam
MBW
=
32
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
SBW
-
1
:
0
]
saddr
;
input
[
SBW
-
1
:
0
]
swrbus
;
output
[
SBW
-
1
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z4
=
0
,
z5
=
1
,
z6
=
0
,
z7
=
1
;
assign
sack
=
z5
;
wire
[
31
:
0
]
z8
;
statusblk
#
(
"JVM"
,
0
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
z8
);
wire
[
1
:
0
]
z9
;
swrbank
#
(
0
,
2
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z9
);
wire
z10
=
z9
[
0
];
wire
z11
=
z9
[
1
];
reg
[
31
:
0
]
z12
;
reg
[
11
:
0
]
z13
;
reg
z14
;
always
@(
posedge
sclk
)
begin
if
(
z10
)
z12
<=
swrbus
;
z14
<=
scs
&&
swr
&&
saddr
[
12
];
z13
<=
swrbus
[
11
:
0
];
end
wire
z15
=
z12
[
0
];
wire
z16
=
z12
[
1
];
wire
z17
=
z12
[
8
];
wire
[
31
:
0
]
z18
,
z19
;
wire
[
MBW
-
1
:
0
]
z20
,
z21
;
wire
[
2
:
0
]
z22
;
wire
z23
,
z24
;
wire
[
31
:
0
]
z25
,
z26
,
z27
;
wire
z28
,
z29
,
z30
;
wire
[
31
:
0
]
z31
;
wire
[
1
:
0
]
z32
;
wire
z33
,
z34
;
wire
z35
=
ioclk
;
wire
z36
=
ioclk
;
wire
z37
=
ioclk
;
reg
z38
,
z39
,
z40
,
z41
;
reg
[
7
:
0
]
z42
,
z43
,
z44
,
z45
;
reg
[
10
:
2
]
z46
;
reg
[
IBW
-
1
:
0
]
z47
;
wire
[
IBW
-
1
:
0
]
z48
;
wire
[
7
:
0
]
z49
=
(
z32
==
3
)?
64
:
(
z32
==
2
)?
32
:
(
z32
==
1
)?
16
:
4
;
wire
z50
=
z40
||
z41
;
wire
z51
=
z40
||
z39
;
always
@(
posedge
ioclk
)
begin
if
(!
z51
)
z46
<=
z31
[
10
:
2
];
else
z46
<=
z46
+
1
;
if
(!
z50
)
z42
<=
z49
;
else
z42
<=
z42
-
IBB
;
if
(
z50
)
z45
<=
0
;
else
z45
<=
{
z45
[
6
:
0
],
z34
};
if
(
z50
)
z44
<=
0
;
else
z44
<=
{
z44
[
6
:
0
],
z33
};
z40
<=
z40
?
(
z42
>
IBB
)
:
z44
[
3
];
z41
<=
z41
?
(
z42
>
IBB
)
:
z45
[
3
];
z38
<=
z40
;
z39
<=
z41
;
z43
<=
z42
;
if
(
z38
)
$write
(
"Iena addr=%x data=%x sz=%d %d\n"
,
z46
,
z47
,
z32
,
z43
);
if
(
z39
)
$write
(
"Oena addr=%x data=%x sz=%d %d\n"
,
z46
,
z48
,
z32
,
z43
);
if
(
z16
)
z47
<=
64'h0000000100000000
;
else
if
(
z38
)
z47
<=
z47
+
64'h0000000200000002
;
end
dpram
#
(
4
,
32
,
32
)
dram
(
sclk
,
z5
,
saddr
[
11
:
2
],
z14
,
swrbus
,
srdbus
,
z37
,
z5
,
z18
[
11
:
2
],
z22
[
0
],
z20
,
z21
);
jvm
j1
(
z35
,
z16
,
z15
,
z11
,
z13
,
z36
,
z28
,
z25
,
z29
,
z26
,
z30
,
z27
,
z37
,
z18
,
z22
,
z20
,
z23
,
z21
,
z19
,
ioclk
,
z31
,
z32
,
z33
,
z40
,
z47
,
z34
,
z41
,
z48
,
test
);
assign
z27
=
32'hF0F01234
;
endmodule
module
jvm
(
clk
,
srst
,
start
,
load
,
cdata
,
sclk
,
srw
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
z37
,
z18
,
z22
,
z20
,
z23
,
z21
,
z19
,
ioclk
,
z31
,
z32
,
z33
,
iena
,
ibus
,
z34
,
oena
,
obus
,
test
);
parameter
IBW
=
64
;
parameter
NCR
=
0
;
parameter
NIOR
=
1
;
parameter
FLAGS
=
0
;
localparam
NKB
=(
NCR
>
0
)?
NCR
:
(`Z3
==
0
)?
2
:
`Z3
;
localparam
CAW
=(
NKB
==
32
)?
15
:
(
NKB
==
16
)?
14
:
(
NKB
==
8
)?
13
:
(
NKB
==
4
)?
12
:
11
;
localparam
DAW
=
CAW
-
2
;
localparam
SAW
=
9
;
localparam
DBW
=
32
;
localparam
MBW
=
32
;
localparam
IWW
=
IBW
/
32
;
input
clk
,
srst
,
start
,
load
;
input
[
11
:
0
]
cdata
;
input
sclk
;
output
reg
srw
,
swr
,
srd
;
output
reg
[
31
:
0
]
swrbus
,
saddr
;
input
[
31
:
0
]
srdbus
;
input
z37
;
output
reg
z23
;
output
reg
[
2
:
0
]
z22
;
output
reg
[
31
:
0
]
z18
;
output
reg
[
MBW
-
1
:
0
]
z20
;
input
[
MBW
-
1
:
0
]
z21
;
input
[
MBW
-
1
:
0
]
z19
;
input
ioclk
,
iena
,
oena
;
output
z33
,
z34
;
input
[
IBW
-
1
:
0
]
ibus
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
31
:
0
]
z31
;
output
[
1
:
0
]
z32
;
`ifdef TRACE_JVM
output
[
32
:
0
]
test
;
`else
output
[
7
:
0
]
test
;
`endif
wire
z4
=
0
,
z5
=
1
,
z6
=
0
,
z7
=
1
;
reg
z11
,
z52
;
always
@(
posedge
clk
)
begin
z11
<=
load
&&
!
cdata
[
9
]
&&
!
cdata
[
11
];
z52
<=
load
&&
cdata
[
9
]
&&
!
cdata
[
11
];
end
wire
z53
;
delayp
#
(
4
)
xdp
(
clk
,
load
,
z53
);
wire
z54
;
bootreset
#
(
32
)
startup
(
clk
,
z54
);
reg
[
CAW
-
1
:
0
]
z55
;
reg
[
DAW
-
1
:
0
]
z56
;
reg
signed
[
SAW
-
1
:
0
]
z57
;
reg
signed
[
SAW
-
1
:
0
]
z58
;
wire
signed
[
DBW
-
1
:
0
]
z59
,
z60
;
wire
signed
[
DBW
-
1
:
0
]
z61
,
z62
,
z63
,
z64
;
wire
signed
[
DBW
-
1
:
0
]
z65
,
z66
,
z67
,
z68
;
wire
z69
,
z70
;
wire
[
7
:
0
]
z71
;
wire
[
35
:
0
]
z72
;
wire
[
9
:
0
]
z73
=
{
z69
,
z70
,
z71
};
wire
[
3
:
0
]
z74
=
z67
[
31
:
28
];
wire
[
1
:
0
]
z75
=
z67
[
15
:
14
];
wire
[
6
:
0
]
z76
=
(
z75
==
3
)?
32
:
(
z75
==
2
)?
12
:
(
z75
==
1
)?
4
:
1
;
wire
[
DAW
-
1
:
0
]
z77
=
z67
[
DAW
-
1
+
16
:
16
];
wire
[
CAW
-
1
:
0
]
z78
=
z67
[
CAW
-
1
:
0
];
reg
z79
,
z80
,
z81
,
z82
,
z83
,
z84
,
z85
,
z86
,
z87
,
z88
,
z89
,
z90
;
reg
z91
,
z92
,
z93
,
z94
,
z95
;
reg
[
3
:
0
]
z96
,
z97
;
reg
signed
[
1
:
0
]
z98
;
reg
signed
[
3
:
0
]
z99
;
wire
signed
[
3
:
0
]
z100
=
z72
[
15
:
12
];
wire
z101
=
z72
[
1
];
wire
z102
=
z72
[
2
];
wire
z103
=
z72
[
4
];
wire
z104
=
z72
[
5
];
wire
z105
=
z72
[
21
];
always
@(
posedge
clk
)
begin
z79
<=
z72
[
0
];
z80
<=
z72
[
1
];
z81
<=
z72
[
2
];
z85
<=
z72
[
3
];
z82
<=
z72
[
4
];
z83
<=
z72
[
4
]|
z89
;
z84
<=
z72
[
5
];
z87
<=
z72
[
6
];
z95
<=
z72
[
7
];
z99
<=
z72
[
11
:
8
];
z98
<=
z72
[
17
:
16
];
z91
<=
z72
[
18
];
z92
<=
z72
[
19
];
z93
<=
z72
[
20
];
z94
<=
z72
[
22
];
z86
<=
z72
[
23
];
z96
<=
z72
[
27
:
24
];
z97
<=
z72
[
31
:
28
];
end
wire
z106
=
(
z59
==
0
);
wire
z107
=
(
z59
[
31
]);
wire
z108
=
(!
z106
&&
!
z107
);
wire
z109
=
(
z60
==
z59
);
wire
z110
=
(
z60
<
z59
);
wire
z111
=
(!
z109
&&
!
z110
);
wire
z112
;
mux8xN
cmux
(
z112
,
z5
,
z4
,
z109
,
z106
,
z110
,
z107
,
z111
,
z108
,
z97
[
2
:
0
]);
reg
z113
;
always
@(
posedge
clk
)
z113
<=
(
z97
[
3
]^
z112
);
wire
z114
=
z79
&&
(
z86
||
z113
);
reg
z115
,
z116
,
z16
,
z117
,
z118
,
z119
,
z120
,
z121
,
z122
;
reg
[
3
:
0
]
z123
;
reg
[
7
:
0
]
z124
,
z125
,
z126
;
wire
[
7
:
0
]
z127
;
wire
z128
;
wire
[
8
:
0
]
z129
=
(!
z118
||
z121
||
z122
)?
0
:
z69
?
{
z4
,
8'hfd
}
:
z102
?
{
z5
,
z124
}
:
z70
?
{
z4
,
z71
}
:
0
;
wire
[
CAW
-
1
:
0
]
z130
;
wire
[
CAW
-
1
:
0
]
z131
=
{
z71
,
z124
};
wire
[
CAW
-
1
:
0
]
z132
=
z55
+
1
;
wire
[
CAW
-
1
:
0
]
z133
=
z114
?
z131
:
z83
?
z78
:
z104
?
z130
:
z132
;
wire
[
DAW
-
1
:
0
]
z134
;
wire
[
SAW
-
1
:
0
]
z135
,
z136
;
wire
z137
,
z138
;
wire
z139
=
z118
?
!(
z85
||
z137
)
:
z5
;
wire
z140
=
z118
?
!(
z85
||
z137
||
z69
||
z121
)
:
z53
;
always
@(
posedge
clk
)
begin
z16
<=
z54
||
srst
;
z117
<=
z54
||
srst
||
(
z52
&&
(
z55
[
10
:
0
]==
11'h7FE
));
if
(
z16
)
z118
<=
start
;
if
(
z16
)
z115
<=
0
;
else
if
(
z118
)
z115
<=
z70
;
if
(
z16
)
z116
<=
0
;
else
if
(
z118
)
z116
<=
z70
&&
!
z69
;
if
(
z16
)
z120
<=
0
;
else
if
(
z118
)
z120
<=
z115
;
if
(
z117
)
z55
<=~
0
;
else
if
(
z140
)
z55
<=
z133
;
if
(
z16
)
z124
<=
0
;
else
if
(
z139
)
z124
<=
z71
;
if
(
z16
)
z125
<=
0
;
else
if
(
z139
)
z125
<=
z124
;
if
(
z16
)
z126
<=
0
;
else
if
(
z115
)
z126
<=
z71
;
if
(
z16
)
z58
<=
0
;
else
if
(
z104
)
z58
<=
z57
;
else
if
(
z82
)
z58
<=
z58
+
z76
;
else
if
(
z118
)
z58
<=
z58
+
z98
;
if
(
z16
)
z57
<=
0
;
else
if
(
z104
)
z57
<=
z136
;
else
if
(
z82
)
z57
<=
z58
-
z74
;
if
(
z16
)
z56
<=
0
;
else
if
(
z104
)
z56
<=
z134
;
else
if
(
z82
)
z56
<=
z77
;
if
(
z16
)
z123
<=~
0
;
else
if
(
z104
)
z123
<=
z123
-
1
;
else
if
(
z103
)
z123
<=
z123
+
1
;
z121
<=
z69
;
z122
<=
z121
;
end
reg
[
7
:
0
]
z141
;
wire
[
7
:
0
]
z142
=
z59
[
7
:
0
]-
z124
;
always
@(
posedge
clk
)
begin
if
(
z87
)
z141
<=
(
z142
>
z71
)?
8'h00
:
z142
;
z88
<=
z87
;
z89
<=
z88
;
z90
<=
z89
;
end
wire
signed
[
3
:
0
]
z143
=
$signed
(
z97
);
wire
signed
[
7
:
0
]
z144
=
$signed
(
z124
);
wire
signed
[
7
:
0
]
z145
=
$signed
(
z71
);
wire
signed
[
7
:
0
]
z146
=
$signed
(
z126
);
wire
signed
[
15
:
0
]
z147
=
$signed
({
z71
,
z124
});
cram16xNs
#
(
CAW
)
rpque
(
z130
,
z132
,
z123
,
clk
,
z82
);
cram16xNs
#
(
DAW
)
rcque
(
z134
,
z56
,
z123
,
clk
,
z82
);
cram16xNs
#
(
SAW
)
rfque
(
z136
,
z57
,
z123
,
clk
,
z82
);
wire
z148
=
!
z99
[
3
];
wire
z149
=
!
z100
[
3
];
wire
z150
=
(
z99
==
7
);
wire
z151
=
(
z100
==
7
);
reg
z152
;
always
@(
posedge
clk
)
z152
<=
z151
&&
z102
;
wire
signed
[
7
:
0
]
z153
=
{{
4
{
z99
[
3
]}},
z99
[
3
:
0
]};
wire
signed
[
7
:
0
]
z154
=
{{
4
{
z100
[
3
]}},
z100
[
3
:
0
]};
wire
signed
[
7
:
0
]
z155
=
z150
?
z126
:
z153
;
wire
signed
[
7
:
0
]
z156
=
z152
?
z124
:
z151
?
z71
:
z154
;
wire
[
7
:
0
]
z157
=
z89
?
z141
:
z116
?
z71
:
z126
;
wire
signed
[
SAW
-
1
:
0
]
z158
=
z148
?
z57
:
z58
;
wire
signed
[
SAW
-
1
:
0
]
z159
=
z149
?
z57
:
z58
+
z98
;
wire
[
CAW
-
1
:
2
]
z160
=
z89
?
{
z71
,
z124
[
7
:
2
]}
:
z56
;
wire
[
SAW
-
1
:
0
]
z161
=
z158
+
z155
;
wire
[
SAW
-
1
:
0
]
z162
=
z159
+
z156
;
wire
[
CAW
-
1
:
2
]
z163
=
z160
+
z157
;
generate
if
(
NKB
>`Z3
)
begin
:
ncrN
spram
#
(
NKB
/
4
,
2
)
comm
(
clk
,
z139
,
z133
,
z11
,
{
cdata
[
10
],
cdata
[
8
]},{
z69
,
z70
});
dpram
#
(
NKB
,
8
,
32
,`COMCLK
)
z13
(
clk
,
z139
,
z133
,
z11
,
cdata
[
7
:
0
],
z71
,
clk
,
z5
,
z163
,
z94
,
z63
,
z67
);
end
if
(
NKB
<=`Z3
)
begin
:
ncr1
assign
z69
=
z4
;
dpram
#
(
NKB
,
9
,
36
,`BPAR
|`COMCLK
)
z13
(
clk
,
z139
,
z133
,
z11
,
cdata
,{
z70
,
z71
},
clk
,
z5
,
z163
,
z94
,
z63
,
z67
);
end
endgenerate
sprom
#
(
2
,
32
,
"jvmlut"
)
cbit
(
clk
,
z5
,
z129
,
z72
);
dpram
#
(
2
,
32
,
32
,`COMCLK
)
stack
(
clk
,
z5
,
z161
,
z93
,
z61
,
z65
,
clk
,
z5
,
z162
,
z105
,
z62
,
z66
);
reg
z164
,
z165
;
always
@(
posedge
clk
)
begin
z164
<=
z115
&&
(
z124
>=
8'h3b
)
&&
(
z124
<=
8'h4e
)
&&
(
z71
==
z124
-
33
);
z165
<=
z164
;
end
wire
signed
[
15
:
0
]
z166
=
z66
;
wire
signed
[
15
:
0
]
z167
=
z166
+
z145
;
wire
[
31
:
16
]
z168
=
z66
[
31
:
16
];
wire
z169
=
(
z91
&&
!
z164
&&
!
z165
)
||
z138
;
wire
z170
=
(
z92
&&
!
z164
&&
!
z165
);
assign
z61
=
z59
;
assign
z62
=
{
z168
,
z167
};
assign
z63
=
z59
;
wire
signed
[
7
:
0
]
z171
=
z86
?
z143
:
z146
;
wire
signed
[
DBW
-
1
:
0
]
z172
=
z171
;
wire
signed
[
DBW
-
1
:
0
]
z173
=
z147
;
wire
signed
[
DBW
-
1
:
0
]
z174
=
z86
?
z143
:
z125
[
0
]?
z147
:
z146
;
wire
signed
[
DBW
-
1
:
0
]
z175
=
z60
>>
z59
[
4
:
0
];
wire
signed
[
DBW
-
1
:
0
]
z176
=
z60
<<
z59
[
4
:
0
];
wire
[
DBW
-
1
:
0
]
z177
=
0
;
wire
[
DBW
-
1
:
0
]
z178
=
z60
&
z59
;
wire
[
DBW
-
1
:
0
]
z179
=
z60
|
z59
;
wire
[
DBW
-
1
:
0
]
z180
=
z60
^
z59
;
wire
signed
[
DBW
-
1
:
0
]
z181
=
-
z59
;
wire
signed
[
DBW
-
1
:
0
]
z182
=
z60
-
z59
;
wire
signed
[
DBW
-
1
:
0
]
z183
=
z60
+
z59
;
wire
signed
[
DBW
-
1
:
0
]
z184
=
z60
*
z59
;
`ifdef Z1
wire
[
DBW
-
1
:
0
]
z185
,
z186
,
z187
,
z188
;
mux4xN
#
(
DBW
)
mstk0
(
z185
,
z65
,
z66
,
z67
,
z68
,
z96
[
1
:
0
]);
mux4xN
#
(
DBW
)
mstk1
(
z186
,
z60
,
z174
,
z175
,
z176
,
z96
[
1
:
0
]);
mux4xN
#
(
DBW
)
mstk2
(
z187
,
z177
,
z178
,
z179
,
z180
,
z96
[
1
:
0
]);
`ifdef JVM_NOMULT
mux4xN
#
(
DBW
)
mstk3
(
z188
,
z181
,
z182
,
z183
,
32'b0
,
z96
[
1
:
0
]);
`else
mux4xN
#
(
DBW
)
mstk3
(
z188
,
z181
,
z182
,
z183
,
z184
,
z96
[
1
:
0
]);
`endif
mux4xNpe
#
(
DBW
)
mstka
(
z59
,
z185
,
z186
,
z187
,
z188
,
z96
[
3
:
2
],
clk
,
z169
);
mux2xNpe
#
(
DBW
)
mstkb
(
z60
,
z66
,
z59
,
z95
,
clk
,
z170
);
`else
wire
[
DBW
-
1
:
0
]
z189
;
jvmdsp
jdsp
(
clk
,
z169
,
z96
,
z59
,
z60
,
z189
,
z59
);
wire
[
DBW
-
1
:
0
]
z185
,
z186
;
mux4xN
#
(
DBW
)
mstk0
(
z185
,
z65
,
z66
,
z67
,
z68
,
z96
[
1
:
0
]);
mux4xN
#
(
DBW
)
mstk1
(
z186
,
z60
,
z174
,
z175
,
z176
,
z96
[
1
:
0
]);
mux2xNpe
#
(
DBW
)
mstka
(
z189
,
z185
,
z186
,
z96
[
2
],
clk
,
z169
);
mux2xNpe
#
(
DBW
)
mstkb
(
z60
,
z66
,
z59
,
z95
,
clk
,
z170
);
`endif
wire
[
7
:
0
]
z190
=
z126
;
wire
z191
=
z80
&&
(
z190
[
0
]);
wire
z192
=
z80
&&
(
z190
[
1
]);
wire
z193
=
z80
&&
(
z190
[
2
]);
wire
z194
=
z80
&&
(
z190
[
3
]);
wire
z195
=
z80
&&
(
z190
[
4
]);
wire
z196
=
z80
&&
(
z190
[
5
]);
wire
z197
=
z80
&&
(
z190
[
6
]);
wire
z198
=
z80
&&
(
z190
[
7
]);
wire
[
MBW
-
1
:
0
]
z47
,
z48
;
reg
[
1
:
0
]
z32
;
reg
[
7
:
0
]
z199
;
reg
z200
,
z201
,
z33
,
z34
,
z202
,
z203
,
z204
,
z205
,
z206
;
wire
z207
=
z23
||
(
z22
!=
0
)
||
(
z203
&!
z202
);
wire
[
DBW
-
1
:
0
]
z208
=
z191
?
z60
:
z59
;
wire
z209
=
z196
?
z5
:
z18
[
23
:
22
]==
0
;
wire
z210
=
z196
?
z4
:
z18
[
23
:
22
]==
1
;
wire
z211
=
z196
?
z208
[
23
]
:
z18
[
23
:
22
]==
2
;
always
@(
posedge
clk
)
begin
if
(!
z118
)
srd
<=
0
;
else
srd
<=
z194
;
if
(!
z118
)
z206
<=
0
;
else
z206
<=
z193
;
if
(!
z118
)
swr
<=
0
;
else
swr
<=
z206
;
if
(!
z118
)
z22
<=
0
;
else
z22
<=
{
z197
&&
z211
,
(
z197
&
z210
),
(
z197
&
z209
)
||
(
z204
&
z202
)
};
if
(!
z118
)
z23
<=
0
;
else
z23
<=
(
z198
&&
!
z196
)
||
z138
;
if
(!
z118
)
z200
<=
0
;
else
z200
<=
z195
||
(
z200
&&
!
z205
);
if
(!
z118
)
z201
<=
0
;
else
z201
<=
z195
||
(
z201
&&
!(
z33
|
z34
));
if
(
z192
)
srw
<=
1
;
else
if
(
swr
|
srd
)
srw
<=
0
;
if
(
z192
)
saddr
<=
z59
;
if
(
z193
)
swrbus
<=
z59
;
if
(
z196
)
z18
[
DBW
-
1
:
16
]
<=
z208
[
DBW
-
1
:
16
];
if
(
z196
)
z18
[
15
:
2
]
<=
z208
[
15
:
2
]+
z71
;
else
if
(
z207
)
z18
[
15
:
2
]
<=
z18
[
15
:
2
]+
1
;
if
(
z196
)
z18
[
1
:
0
]
<=
z208
[
1
:
0
];
z20
<=
z200
?
z47
:
z59
;
if
(
z195
)
z202
<=
z59
[
16
];
if
(
z195
)
z32
<=
z59
[
5
]?
2
:
z59
[
4
]?
1
:
z59
[
2
]?
0
:
3
;
if
(
z195
)
z199
<=
z59
[
9
:
2
];
end
reg
z212
;
always
@(
posedge
clk
)
z212
<=
z18
[
22
];
reg
z213
;
always
@(
posedge
clk
)
z213
<=
z18
[
23
];
wire
[
1
:
0
]
z214
=
{(
z101
&&
z71
[
3
])
||
z213
,
(
z101
&&
z71
[
3
])
||
(
z212
&&
!
z213
)};
mux4xNp
#
(
DBW
)
mstkx
(
z68
,
z21
,
z48
,
z19
,
srdbus
,
z214
,
clk
);
srlMxN
#
(
4
,
1
,
1
)
rmeml
(
sclk
,
z5
,
4'h1
,
(
z198
&
z196
),
z138
);
reg
z215
,
z216
,
z38
,
z217
,
z218
,
z219
;
reg
[
7
:
0
]
z220
,
z221
;
reg
[
7
:
0
]
z222
;
wire
z223
=
(
z222
==
1
);
always
@(
posedge
sclk
)
begin
z215
<=
z195
;
z216
<=
iena
;
z203
<=
(
z202
?
z216
:
z215
)
||
(
z203
&&
!
z223
);
z204
<=
z203
;
z217
<=
z203
&&
!
z202
;
if
(
z215
)
z222
<=
z199
;
else
if
(
z203
)
z222
<=
z222
-
1
;
if
(!
z200
)
z220
<=
0
;
else
if
(
z202
?
z203
:
z217
)
z220
<=
z220
+
1
;
z218
<=
!
z200
||
z215
||
(
z222
>
4
);
if
(!
z118
)
z205
<=
0
;
else
z205
<=
(
z203
&&
z223
);
end
always
@(
posedge
ioclk
)
begin
z38
<=
iena
;
z219
<=
z201
;
if
(!
z118
)
z33
<=
0
;
else
z33
<=
(
z219
&&
z202
)
||
(
z33
&&
!
iena
);
if
(!
z118
)
z34
<=
0
;
else
z34
<=
(
z219
&&
!
z202
&&
!
z218
)
||
(
z34
&&
!
oena
);
if
(!(
oena
||
z38
))
z221
<=
0
;
else
z221
<=
z221
+
1
;
end
assign
z48
=
z21
;
generate
if
(
NIOR
==
0
)
begin
:
iorN
assign
z47
=
0
;
assign
obus
=
0
;
end
if
(
NIOR
>
0
)
begin
:
iorN
dpram
#
(
NIOR
,
MBW
,
IBW
)
ioram
(
sclk
,
z5
,
z220
,
z217
,
z48
,
z47
,
ioclk
,
z5
,
z221
,
z38
,
ibus
,
obus
);
end
endgenerate
assign
z31
=
saddr
;
assign
z137
=
z195
||
z200
;
wire
z17
=
z4
;
wire
z224
=
z118
&&
!
z16
&&
z17
;
reg
[
31
:
0
]
z225
;
always
@(
posedge
clk
)
begin
z225
<=
z72
;
if
(
z224
)
$write
(
"pc=%x:%x bc=%x:%x:%x inst=%x:%x cptr=%x fptr=%x sptr=%x stk %x:%x:%x ra %x:%x:%x rb %x:%x:%x rc %x:%x:%x  %x %x\n"
,
z55
,
z133
,
z73
,
z124
,
z125
,
z120
,
z225
,
z56
,
z57
,
z58
,
z123
,
z59
,
z60
,
z93
,
z161
,
z65
,
z105
,
z162
,
z66
,
z94
,
z163
,
z67
,
z139
,
z140
);
end
`ifdef TRACE_JVM
assign
test
[
32
]=
clk
;
assign
test
[
31
:
0
]={
z71
[
7
:
0
],
z133
[
7
:
0
],
cdata
[
7
:
0
],
z70
,
z82
,
z11
,
z139
};
`else
assign
test
=
z127
;
`endif
endmodule
