`ifndef FFT_ORDER
`define FFT_ORDER 12
`endif
`include "../lib/ramdefs.h"
module
fftengine
(
sclk
,
rst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
OBW
=
IBW
;
localparam
DBW
=
16
;
localparam
XBW
=
18
;
localparam
CBW
=
16
;
localparam
FBW
=
32
;
localparam
BBW
=
32
;
localparam
MA
=`FFT_ORDER
;
localparam
MD
=
16
;
localparam
CBX
=(
MA
>
12
)?
16
:
CBW
;
localparam
NDP
=(
MA
>
12
)?
32
:
0
;
input
sclk
;
input
rst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
assign
osel
=
0
;
wire
z3
,
z4
,
z5
,
z6
,
z7
,
z8
,
z9
,
z10
,
z11
,
z12
,
z13
;
wire
[
2
*
DBW
-
1
:
0
]
z14
;
wire
[
2
*
XBW
-
1
:
0
]
z15
;
wire
[
2
*
FBW
-
1
:
0
]
z16
;
wire
[
BBW
-
1
:
0
]
z17
,
z18
,
z19
,
z20
,
z21
;
reg
z22
,
z23
,
z24
,
z25
;
reg
[
MA
-
1
:
0
]
z26
,
z27
;
reg
[
MD
-
1
:
0
]
z28
,
z29
,
z30
;
reg
[
31
:
0
]
z31
,
z32
;
reg
[
7
:
0
]
z33
,
z34
;
reg
[
15
:
0
]
z35
;
statusblk
#
(
"FFT"
,
MA
,
MD
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
wire
[
11
:
0
]
z36
;
swrbank
#
(
0
,
12
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z36
);
wire
z37
=
z36
[
0
],
z38
=
z36
[
1
],
z39
=
z36
[
2
],
z40
=
z36
[
5
],
z41
=
z36
[
7
],
z42
=
z36
[
8
],
z43
=
z36
[
9
],
z44
=
z36
[
10
],
z45
=
z36
[
11
];
always
@(
posedge
sclk
)
begin
z25
<=
rst
||
!
z31
[
0
];
if
(
z37
)
z31
<=
swrbus
;
if
(
z40
)
z26
<=
swrbus
[
MA
-
1
:
0
];
if
(
z40
)
z33
<=
swrbus
[
23
:
16
];
if
(
z43
)
z27
<=
swrbus
[
MA
-
1
:
0
];
if
(
z39
)
z35
<=
swrbus
[
15
:
0
];
if
(
z41
)
z32
<=
swrbus
;
if
(
z38
)
z34
<=
swrbus
[
23
:
16
];
if
(
z38
)
z28
<=
swrbus
[
MD
-
1
:
0
];
if
(
z44
)
z29
<=
swrbus
[
MD
-
1
:
0
];
if
(
z45
)
z30
<=
swrbus
[
MD
-
1
:
0
];
end
wire
[
3
:
0
]
z46
=
z31
[
11
:
8
];
wire
[
3
:
0
]
z47
=
z31
[
15
:
12
];
wire
z48
=
z32
[
0
];
wire
z49
=
z32
[
1
];
wire
z50
=
z32
[
2
];
wire
z51
=
z32
[
3
];
wire
z52
=
z32
[
4
];
wire
z53
=
z32
[
5
];
wire
z54
=
z32
[
6
];
wire
z55
=
z32
[
7
];
wire
[
3
:
0
]
z56
=
z32
[
11
:
8
];
wire
[
3
:
0
]
z57
=
z32
[
15
:
12
];
reg
z58
;
reg
[
15
:
0
]
z59
;
wire
z60
=
z59
[
z56
];
wire
z61
=
z25
||
z59
[
z57
];
always
@(
posedge
ioclk
)
begin
if
(
z61
)
z59
<=
1
;
else
if
(
iena
)
z59
<=
z59
+
1
;
if
(
z25
)
z58
<=
0
;
else
z58
<=
(
z57
!=
0
)
&&
(
z58
?
!
z61
:
z60
);
z24
<=
iena
&&
!
z58
;
end
always
@(
posedge
sclk
)
begin
z22
<=
z3
&&
z4
;
z23
<=
z22
;
end
fifoNxMfmt
#
(
IBW
,
2
*
DBW
,
NDP
)
fi
(
ioclk
,
z25
,
z46
,
istat
,
z24
,
ibus
,
sclk
,
z25
,
4'h8
,
z3
,
z22
,
z14
);
`ifdef FFT_FPPF
fppfilter
#
(
2
,
MA
,
DBW
,
CBX
,
XBW
)
win
(
sclk
,
z25
,
{
2
{
z53
}},
z26
,
z42
,
swrbus
,
z23
,
z14
,
z7
,
z15
);
`else
cwindow
#
(
MA
,
DBW
,
CBX
,
XBW
)
win
(
sclk
,
z25
,
z26
,
z42
,
swrbus
,
z23
,
z14
,
z7
,
z15
);
`endif
cfft
#
(
MA
,
XBW
,
CBW
,
FBW
)
fft
(
sclk
,
z25
,
z48
,
z33
,
z27
,
z35
,
z4
,
z7
,
z15
,
z5
,
z8
,
z16
,
test
);
magnitude
#
(
FBW
,
BBW
)
bmag
(
sclk
,
z25
,
z8
,
z16
,
z10
,
z18
);
blockavg
#
(
MA
,
MD
,
BBW
,
BBW
)
bavg
(
sclk
,
z25
,
z27
,
z28
,
z34
,
z10
,
z18
,
z11
,
z19
);
blockmax
#
(
MA
,
MD
,
BBW
,
BBW
)
bmax
(
sclk
,
z25
,
z27
,
z29
,
z11
,
z19
,
z12
,
z20
);
`ifdef FFT_PEAK
wire
z62
=
scs
&&
saddr
[
16
];
wire
z63
,
z64
,
z65
,
z66
,
z67
,
z68
,
z69
;
reg
z70
,
z71
;
always
@(
posedge
sclk
)
begin
z71
<=
z65
&&
z6
;
z70
<=
z71
;
end
assign
z13
=
z70
;
MFPP_core
#
(
1
,
BBW
,
BBW
)
bpkp
(
sclk
,!
z55
,
z62
,
saddr
,
swr
,
swrbus
,
srd
,
z67
,
z68
,
sclk
,
z63
,
z12
,
z64
,
z20
,
z65
,
z71
,
z66
,
z21
,
z69
);
assign
z9
=
z55
?
z13
:
z12
;
assign
z17
=
z55
?
z21
:
z20
;
assign
z5
=
z55
?
z6
&
z63
:
z6
;
`else
assign
z9
=
z12
;
assign
z17
=
z20
;
assign
z5
=
z6
;
`endif
fifoNxMfmti
#
(
IBW
,
2
*
BBW
)
fo
(
ioclk
,
z25
,
z47
,
ostat
,
oena
,
obus
,
sclk
,
z25
,
4'hC
,
z6
,
z50
?
z9
:
z8
,
z50
?{
z17
,
z17
}:
z16
);
endmodule
module
cwindow
(
clk
,
rst
,
size
,
sload
,
sbus
,
vin
,
din
,
vout
,
dout
);
parameter
MA
=
10
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
PBW
=
IBW
+
CBW
-
1
;
parameter
NKB
=(
2
**
MA
)*
2
/
1024
;
input
clk
,
rst
;
input
[
MA
-
1
:
0
]
size
;
input
sload
;
input
[
31
:
0
]
sbus
;
input
vin
;
input
[
2
*
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
2
*
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
reg
[
MA
-
1
:
0
]
z72
;
wire
signed
[
CBW
-
1
:
0
]
z73
;
reg
signed
[
CBW
-
1
:
0
]
z74
;
sdpram
#
(
NKB
,
CBW
,
CBW
)
cram
(
clk
,
z2
,
sbus
[
MA
-
1
:
0
],
sload
,
sbus
[
32
-
1
:
32
-
CBW
],
clk
,
z2
,
z72
,
z73
);
reg
z75
,
z76
,
z77
;
reg
signed
[
IBW
-
1
:
0
]
z78
,
z79
;
reg
signed
[
IBW
-
1
:
0
]
z80
,
z81
;
reg
signed
[
PBW
-
1
:
0
]
z82
,
z83
;
wire
z84
=
rst
||
((
z72
==
size
)
&&
vin
);
always
@(
posedge
clk
)
begin
if
(
z84
)
z72
<=
0
;
else
if
(
vin
)
z72
<=
z72
+
1
;
z78
<=
din
[
IBW
-
1
:
0
];
z79
<=
din
[
2
*
IBW
-
1
:
IBW
];
z74
<=
z73
;
z80
<=
z78
;
z81
<=
z79
;
z82
<=
z80
*
z74
;
z83
<=
z81
*
z74
;
z75
<=
vin
;
z76
<=
z75
;
z77
<=
z76
;
end
assign
vout
=
z77
;
assign
dout
=
{
z83
[
PBW
-
1
:
PBW
-
OBW
],
z82
[
PBW
-
1
:
PBW
-
OBW
]};
endmodule
module
magnitude
(
clk
,
rst
,
vin
,
din
,
vout
,
dout
);
parameter
IBW
=
16
;
parameter
OBW
=
16
;
parameter
QBW
=
36
;
input
clk
,
rst
;
input
vin
;
input
[
2
*
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
reg
z85
;
reg
[
IBW
-
1
:
0
]
z78
,
z79
;
reg
[
IBW
-
1
:
0
]
z86
,
z87
,
z88
,
z89
,
z90
;
wire
z91
=
(
z78
>
z79
);
always
@(
posedge
clk
)
begin
z78
<=
(
din
[
IBW
-
1
])?
~
din
[
IBW
-
1
:
0
]
:
din
[
IBW
-
1
:
0
];
z79
<=
(
din
[
2
*
IBW
-
1
])?
~
din
[
2
*
IBW
-
1
:
IBW
]
:
din
[
2
*
IBW
-
1
:
IBW
];
z86
<=
z91
?
z78
:
z79
;
z87
<=
z91
?
z79
:
z78
;
z88
<=
z87
;
z85
<=
z86
>
(
z87
[
IBW
-
1
:
1
]
+
z87
[
IBW
-
1
:
2
]);
z89
<=
z86
+
z87
[
IBW
-
1
:
2
];
z90
<=
z85
?
z89
+
z88
[
IBW
-
1
:
3
]
:
z89
;
end
wire
[
IBW
-
2
:
0
]
z92
=
z90
[
IBW
-
1
]?
~
0
:
z90
[
IBW
-
2
:
0
];
delaypipe
#
(
4
)
srl1
(
clk
,
vin
,
vout
);
assign
dout
=
z92
;
endmodule
module
blockavg
(
clk
,
rst
,
size
,
z28
,
z34
,
vin
,
din
,
vout
,
dout
);
parameter
MA
=
10
;
parameter
MD
=
8
;
parameter
IBW
=
16
;
parameter
OBW
=
16
;
parameter
QBW
=
36
;
parameter
NR
=
2
**(
(
MA
<=
10
)?
0
:
MA
-
10
);
parameter
NKB
=(
2
**
MA
)*
4
/
1024
;
input
clk
,
rst
;
input
[
MA
-
1
:
0
]
size
;
input
[
MD
-
1
:
0
]
z28
;
input
[
3
:
0
]
z34
;
input
vin
;
input
[
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
reg
[
MA
-
1
:
0
]
z72
;
reg
[
MD
-
1
:
0
]
z93
;
reg
[
QBW
-
1
:
0
]
z79
,
z94
,
z95
;
wire
[
QBW
-
1
:
0
]
z96
;
reg
z97
;
wire
z98
;
delaypipe
#
(
2
)
srl1
(
clk
,
vin
,
z98
);
wire
[
MA
-
1
:
0
]
z99
;
delaypipe
#
(
2
,
1
,
MA
)
srl2
(
clk
,
z72
,
z99
);
sdpram
#
(
NKB
,
QBW
,
QBW
)
cram
(
clk
,
z2
,
z99
,
z98
,
z94
,
clk
,
z2
,
z72
,
z96
);
wire
z84
=
rst
||
((
z72
==
size
)
&&
vin
);
wire
z100
=
rst
||
((
z93
==
z28
)
&&
z84
);
always
@(
posedge
clk
)
begin
if
(
z84
)
z72
<=
0
;
else
if
(
vin
)
z72
<=
z72
+
1
;
if
(
z100
)
z93
<=
0
;
else
if
(
z84
)
z93
<=
z93
+
1
;
z97
<=
(
z93
==
0
);
z79
<=
din
;
z94
<=
z97
?
z79
:
z79
+
z96
;
z95
<=
z94
>>
z34
;
end
delaypipe
#
(
3
)
srl3
(
clk
,
vin
&&
(
z93
==
z28
),
vout
);
assign
dout
=
z95
;
endmodule
module
blockmax
(
clk
,
rst
,
size
,
z28
,
vin
,
din
,
vout
,
dout
);
parameter
MA
=
10
;
parameter
MD
=
8
;
parameter
IBW
=
16
;
parameter
OBW
=
16
;
parameter
QBW
=
36
;
parameter
NKB
=(
2
**
MA
)*
4
/
1024
;
input
clk
,
rst
;
input
[
MA
-
1
:
0
]
size
;
input
[
MD
-
1
:
0
]
z28
;
input
vin
;
input
[
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
reg
[
MA
-
1
:
0
]
z72
;
reg
[
MD
-
1
:
0
]
z93
;
reg
[
QBW
-
1
:
0
]
z79
,
z94
;
wire
[
QBW
-
1
:
0
]
z96
;
reg
z97
;
wire
z98
;
delaypipe
#
(
2
)
srl1
(
clk
,
vin
,
z98
);
wire
[
MA
-
1
:
0
]
z99
;
delaypipe
#
(
2
,
1
,
MA
)
srl2
(
clk
,
z72
,
z99
);
sdpram
#
(
NKB
,
QBW
,
QBW
)
cram
(
clk
,
z2
,
z99
,
z98
,
z94
,
clk
,
z2
,
z72
,
z96
);
wire
z84
=
rst
||
((
z72
==
size
)
&&
vin
);
wire
z100
=
rst
||
((
z93
==
z28
)
&&
z84
);
always
@(
posedge
clk
)
begin
if
(
z84
)
z72
<=
0
;
else
if
(
vin
)
z72
<=
z72
+
1
;
if
(
z100
)
z93
<=
0
;
else
if
(
z84
)
z93
<=
z93
+
1
;
z97
<=
(
z93
==
0
);
z79
<=
din
;
z94
<=
(
z97
||
z79
>
z96
)?
z79
:
z96
;
end
delaypipe
#
(
2
)
srl3
(
clk
,
vin
&&
(
z93
==
z28
),
vout
);
assign
dout
=
z94
;
endmodule
module
cfft
(
clk
,
rst
,
z48
,
z33
,
size
,
shift
,
virdy
,
vinc
,
din
,
vordy
,
vout
,
dout
,
test
);
parameter
MA
=
12
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
IBW
;
parameter
NIC
=
1
;
parameter
NPC
=
1
;
localparam
SBW
=
IBW
+
CBW
+
9
;
localparam
XBW
=
32
;
localparam
ZBW
=
XBW
-
IBW
;
localparam
MB
=(
NIC
==
2
)?
MA
+
1
:
MA
;
localparam
KDR
=(
2
**
MB
)*
4
/
1024
;
input
clk
,
rst
,
z48
;
input
[
7
:
0
]
z33
;
input
[
MA
-
1
:
0
]
size
;
input
[
15
:
0
]
shift
;
output
virdy
;
input
[
1
:
0
]
vinc
;
input
[
NPC
*
2
*
IBW
-
1
:
0
]
din
;
input
vordy
;
output
reg
vout
;
output
reg
[
NPC
*
2
*
OBW
-
1
:
0
]
dout
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
wire
z101
,
z102
;
wire
z103
=
vinc
[
0
];
wire
z104
=
vinc
[
1
];
wire
z105
=
(
NIC
>
1
)?
vinc
[
1
]
:
(
NPC
>
1
)?
!
vinc
[
1
]
:
z1
;
wire
[
NPC
*
2
*
IBW
-
1
:
0
]
z106
,
z107
,
z108
;
wire
z109
;
generate
if
(
NIC
>
1
)
begin
:
ixchn
reg
[
MA
:
0
]
z110
,
z111
;
reg
z112
,
z113
,
z114
;
wire
z115
=
((
z110
=={
size
,
z2
})
&&
z103
)
||
rst
;
wire
z116
=
((
z111
==
size
)
&&
z103
)
||
rst
;
always
@(
posedge
clk
)
begin
if
(
z115
)
z110
<=
0
;
else
if
(
z103
)
z110
<=
z110
+
1
;
if
(
z116
)
z111
<=
0
;
else
if
(
z103
)
z111
<=
z111
+
1
;
if
(
rst
)
z112
<=
z1
;
else
if
(
z116
)
z112
<=
z2
;
if
(
rst
)
z113
<=
z2
;
else
if
(
z116
)
z113
<=
!
z113
;
z114
<=
z112
&&
z103
;
end
sdpram
#
(
KDR
,
2
*
IBW
,
2
*
IBW
,`WFIRST
,`WFIRST
)
qram
(
clk
,
z2
,
z110
,
z103
,
din
,
clk
,
z2
,
{
z111
,
z113
},
z107
);
assign
z102
=
z114
;
end
if
(
NPC
>
1
)
begin
:
pxchn
reg
[
MA
:
0
]
z110
,
z111
;
reg
z112
,
z113
,
z114
,
z117
;
wire
z115
=
((
z110
==
size
[
MA
-
1
:
1
])
&&
z103
)
||
rst
;
wire
z116
=
((
z111
==
size
)
&&
z114
)
||
rst
;
always
@(
posedge
clk
)
begin
if
(
z115
)
z110
<=
0
;
else
if
(
z103
)
z110
<=
z110
+
1
;
if
(
rst
)
z112
<=
z1
;
else
if
(
z115
)
z112
<=
z2
;
if
(
rst
)
z113
<=
z1
;
else
if
(
z115
)
z113
<=
!
z113
;
if
(
z116
)
z111
<=
0
;
else
if
(
z114
)
z111
<=
z111
+
1
;
z114
<=
z112
&&
z103
;
z117
<=
z114
;
end
wire
z118
;
wire
[
MA
:
0
]
z119
;
wire
[
4
*
IBW
-
1
:
0
]
z120
;
delaypipe
#
(
4
,
1
,
4
*
IBW
+
MA
+
1
+
1
)
dlp
(
clk
,{
z103
&&!
z113
,
z110
,
din
},{
z118
,
z119
,
z120
});
sdpram
#
(
KDR
/
2
,
4
*
IBW
,
2
*
IBW
)
qram1
(
clk
,
z2
,
z119
,
z118
,
z120
,
clk
,
z2
,
z111
,
z107
[
2
*
IBW
-
1
:
0
*
IBW
]);
sdpram
#
(
KDR
/
2
,
4
*
IBW
,
2
*
IBW
)
qram2
(
clk
,
z2
,
z110
,
z103
&&
z113
,
din
,
clk
,
z2
,
z111
,
z107
[
4
*
IBW
-
1
:
2
*
IBW
]);
assign
z102
=
z117
;
end
endgenerate
reg
z121
,
z122
;
reg
[
4
:
0
]
z123
;
assign
z101
=
z105
?
z102
:
z103
;
assign
z106
=
z105
?
z107
:
din
;
`ifdef verilator
wire
z124
=
z121
||
((
z123
!=
0
)
&&
(
z123
!=
5'h1F
)
&&
virdy
);
`else
wire
z124
=
((
z123
!=
5'h1F
)
&&
virdy
);
`endif
always
@(
posedge
clk
)
begin
if
(
rst
)
z123
<=
5'h1F
;
else
if
(
z101
&!
z124
)
z123
<=
z123
+
1
;
else
if
(
z124
&!
z101
)
z123
<=
z123
-
1
;
z121
<=
z124
&&
!
z121
;
z122
<=
vordy
;
end
srlMxN
#
(
5
,
NPC
*
2
*
IBW
)
ique
(
clk
,
z101
,
z123
,
z106
,
z108
);
wire
z125
;
wire
[
NPC
*
2
*
OBW
-
1
:
0
]
z126
;
`ifdef verilator
reg
z127
,
z128
,
z129
;
reg
[
MA
+
7
:
0
]
z130
;
reg
[
MA
-
1
:
0
]
z131
;
reg
[
MA
:
0
]
z132
;
wire
[
MA
-
1
:
0
]
z133
=
1
<<(
MA
-
z33
);
wire
[
MA
-
1
:
0
]
z134
=
(
1
<<
z33
)-
1
;
wire
[
7
:
0
]
z135
=
z130
[
MA
+
7
:
MA
];
wire
[
MA
:
0
]
z136
=
{
z130
[
MA
],
z134
&
z131
[
MA
-
1
:
0
]};
always
@(
posedge
clk
)
begin
z127
<=
z124
;
z129
<=
z127
&&
(
z135
>
z33
||
z128
)
&&
(
z136
[
MA
-
1
:
0
]<=
size
);
if
(
rst
)
z130
<=
0
;
else
if
(
z127
)
z130
<=
z130
+
z133
;
if
(
rst
)
z131
<=
0
;
else
if
(
z127
)
z131
<=
z131
+
1
;
if
(
rst
)
z128
<=
0
;
else
z128
<=
z129
||
z128
;
end
wire
[
MA
:
0
]
z137
;
delaypipe
#
(
4
,
1
,
MA
+
1
)
srla
(
clk
,
z136
,
z137
);
wire
[
MA
-
1
:
0
]
z138
;
bitrev
#
(
MA
)
bri
(
z136
,
z138
);
wire
z139
;
delaypipe
#
(
4
)
srlc
(
clk
,
z127
,
z139
);
assign
z125
=
z129
;
assign
virdy
=
z122
;
genvar
n
,
i
,
j
,
k
;
generate
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
chx
localparam
k
=
n
*
2
;
wire
[
MA
:
0
]
z140
[
MA
:
0
];
wire
[
2
*
XBW
-
1
:
0
]
z141
[
MA
:
0
];
reg
signed
[
XBW
-
1
:
0
]
z142
,
z143
;
always
@(
posedge
clk
)
begin
z142
<=
z108
[(
1
+
k
)*
IBW
-
1
:(
0
+
k
)*
IBW
]<<
ZBW
;
z143
<=
z108
[(
2
+
k
)*
IBW
-
1
:(
1
+
k
)*
IBW
]<<
ZBW
;
end
xpram
#
(
MA
+
1
,
2
*
XBW
)
rami
(
clk
,
z127
,
z130
,{
z143
,
z142
},
z140
[
0
],
z141
[
0
]);
for
(
i
=
0
;
i
<
MA
;
i
=
i
+
1
)
begin
:
stage
wire
[
MA
:
0
]
z144
=
(
i
+
1
==
z33
)?
{!
z136
[
MA
],
z138
}
:
z140
[
i
+
1
];
butterfly
#
(
i
,
MA
,
XBW
,
CBW
)
bfly
(
clk
,
z33
,
z48
,
z135
,
z127
,
z136
,
z140
[
i
],
z141
[
i
],
z139
,
z137
,
z144
,
z141
[
i
+
1
]);
end
wire
signed
[
XBW
-
1
:
0
]
z145
=
z141
[
z33
][
1
*
XBW
-
1
:
0
*
XBW
];
wire
signed
[
XBW
-
1
:
0
]
z146
=
z141
[
z33
][
2
*
XBW
-
1
:
1
*
XBW
];
wire
signed
[
XBW
-
1
:
0
]
z147
=
z145
<<
shift
;
wire
signed
[
XBW
-
1
:
0
]
z148
=
z146
<<
shift
;
assign
z126
[(
1
+
k
)*
OBW
-
1
:(
0
+
k
)*
OBW
]
=
z147
[
XBW
-
1
:
XBW
-
OBW
];
assign
z126
[(
2
+
k
)*
OBW
-
1
:(
1
+
k
)*
OBW
]
=
z148
[
XBW
-
1
:
XBW
-
OBW
];
end
endgenerate
`else
wire
[
23
:
0
]
z149
=
{
shift
,!
z48
,
z33
};
genvar
n
,
i
,
j
,
k
;
generate
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
chx
localparam
k
=
n
*
2
;
wire
[
MA
-
1
:
0
]
z150
;
wire
signed
[
XBW
-
1
:
0
]
z151
,
z152
,
z153
,
z154
;
assign
z151
=
{
z108
[(
1
+
k
)*
IBW
-
1
:(
0
+
k
)*
IBW
],{
ZBW
{
z1
}}};
assign
z152
=
{
z108
[(
2
+
k
)*
IBW
-
1
:(
1
+
k
)*
IBW
],{
ZBW
{
z1
}}};
wire
z155
,
z156
,
z157
,
z158
,
z159
;
wire
z160
,
z161
,
z162
,
z163
,
z164
,
z165
;
if
(
MA
<=
8
)
begin
:
mxsz256
xfft_256
fft_core
(
clk
,!
rst
,
z149
,
z157
,
z157
,
{
z152
,
z151
},
z124
,
z156
,
z158
,
{
z154
,
z153
},
z150
,
z155
,
z122
,
z159
,
z160
,
z161
,
z162
,
z163
,
z164
,
z165
);
end
if
(
MA
>
8
&&
MA
<=
10
)
begin
:
mxsz1k
xfft_1k
fft_core
(
clk
,!
rst
,
z149
,
z157
,
z157
,
{
z152
,
z151
},
z124
,
z156
,
z158
,
{
z154
,
z153
},
z150
,
z155
,
z122
,
z159
,
z160
,
z161
,
z162
,
z163
,
z164
,
z165
);
end
if
(
MA
>
10
&&
MA
<=
12
)
begin
:
mxsz4k
xfft_4k
fft_core
(
clk
,!
rst
,
z149
,
z157
,
z157
,
{
z152
,
z151
},
z124
,
z156
,
z158
,
{
z154
,
z153
},
z150
,
z155
,
z122
,
z159
,
z160
,
z161
,
z162
,
z163
,
z164
,
z165
);
end
if
(
MA
>
12
&&
MA
<=
14
)
begin
:
mxsz16k
xfft_16k
fft_core
(
clk
,!
rst
,
z149
,
z157
,
z157
,
{
z152
,
z151
},
z124
,
z156
,
z158
,
{
z154
,
z153
},
z150
,
z155
,
z122
,
z159
,
z160
,
z161
,
z162
,
z163
,
z164
,
z165
);
end
if
(
MA
>
14
&&
MA
<=
16
)
begin
:
mxsz64k
xfft_64k
fft_core
(
clk
,!
rst
,
z149
,
z157
,
z157
,
{
z152
,
z151
},
z124
,
z156
,
z158
,
{
z154
,
z153
},
z150
,
z155
,
z122
,
z159
,
z160
,
z161
,
z162
,
z163
,
z164
,
z165
);
end
if
(
n
==
0
)
assign
z125
=
z155
&&
z122
&&
(
z150
<=
size
);
if
(
n
==
0
)
assign
virdy
=
z156
;
assign
z126
[(
1
+
k
)*
OBW
-
1
:(
0
+
k
)*
OBW
]
=
z153
[
XBW
-
1
:
XBW
-
OBW
];
assign
z126
[(
2
+
k
)*
OBW
-
1
:(
1
+
k
)*
OBW
]
=
z154
[
XBW
-
1
:
XBW
-
OBW
];
if
(
n
==
0
)
assign
test
=
{
z103
,
virdy
,
z157
,
z122
,
z159
,
z160
,
z155
,
z124
};
end
endgenerate
`endif
wire
z166
;
wire
[
NPC
*
2
*
OBW
-
1
:
0
]
z167
;
generate
if
(
NIC
>
1
)
begin
:
iychn
reg
[
MA
:
0
]
z168
,
z169
;
reg
z170
,
z171
,
z172
;
wire
z173
=
((
z168
==
size
)
&&
z125
)
||
rst
;
wire
z174
=
((
z169
=={
size
,
z2
})
&&
z125
)
||
rst
||
!
z170
;
always
@(
posedge
clk
)
begin
if
(
z173
)
z168
<=
0
;
else
if
(
z125
)
z168
<=
z168
+
1
;
if
(
z174
)
z169
<=
0
;
else
if
(
z125
)
z169
<=
z169
+
1
;
if
(
rst
)
z170
<=
z1
;
else
if
(
z173
)
z170
<=
z2
;
if
(
rst
)
z171
<=
z1
;
else
if
(
z173
)
z171
<=
!
z171
;
z172
<=
z170
&&
z125
;
end
sdpram
#
(
KDR
,
2
*
OBW
,
2
*
OBW
,`WFIRST
,`WFIRST
)
pram
(
clk
,
z2
,
{
z168
,
z171
},
z125
,
z126
,
clk
,
z2
,
z169
,
z167
);
assign
z166
=
z172
;
end
if
(
NPC
>
1
)
begin
:
pychn
reg
[
MA
:
0
]
z168
,
z169
;
reg
[
2
*
OBW
-
1
:
0
]
z175
;
reg
z170
,
z171
,
z176
,
z172
,
z177
,
z178
,
z179
;
wire
z173
=
((
z168
==
size
)
&&
z125
)
||
rst
;
wire
z180
=
((
z168
==
size
[
MA
-
1
:
1
])
&&
z125
);
wire
z174
=
((
z169
==
size
[
MA
-
1
:
1
])
&&
z172
)
||
rst
;
wire
[
4
*
OBW
-
1
:
0
]
z181
,
z182
;
always
@(
posedge
clk
)
begin
if
(
z173
)
z168
<=
0
;
else
if
(
z125
)
z168
<=
z168
+
1
;
if
(
z174
)
z169
<=
0
;
else
if
(
z172
)
z169
<=
z169
+
1
;
if
(
rst
)
z170
<=
z1
;
else
if
(
z180
)
z170
<=
z2
;
if
(
rst
)
z171
<=
z1
;
else
if
(
z174
)
z171
<=
!
z171
;
z172
<=
z170
&&
z125
;
z177
<=
z172
;
z176
<=
z171
;
end
wire
z183
;
wire
[
MA
:
0
]
z184
;
wire
[
4
*
OBW
-
1
:
0
]
z185
;
delaypipe
#
(
4
,
1
,
4
*
OBW
+
MA
+
1
+
1
)
dlp
(
clk
,{
z125
,
z168
,
z126
},{
z183
,
z184
,
z185
});
sdpram
#
(
KDR
/
2
,
2
*
OBW
,
4
*
OBW
)
pram1
(
clk
,
z2
,
z168
,
z125
,
z126
[
2
*
OBW
-
1
:
0
*
OBW
],
clk
,
z2
,
z169
,
z181
);
sdpram
#
(
KDR
/
2
,
2
*
OBW
,
4
*
OBW
)
pram2
(
clk
,
z2
,
z184
,
z183
,
z185
[
4
*
OBW
-
1
:
2
*
OBW
],
clk
,
z2
,
z169
,
z182
);
assign
z166
=
z177
;
assign
z167
=
z176
?
z182
:
z181
;
end
endgenerate
always
@(
posedge
clk
)
begin
vout
<=
z105
?
z166
:
z125
;
dout
<=
z105
?
z167
:
z126
;
end
endmodule
module
butterfly
(
clk
,
z33
,
z48
,
z135
,
z127
,
z136
,
ain
,
din
,
z139
,
z137
,
aout
,
dout
);
parameter
MX
=
0
;
parameter
MA
=
8
;
parameter
DBW
=
32
;
parameter
CBW
=
16
;
parameter
SBW
=
DBW
+
CBW
-
1
;
parameter
LS
=
MA
-
MX
;
parameter
MY
=(
MX
==
0
)?
1
:
MX
;
input
clk
,
z48
,
z127
,
z139
;
input
[
7
:
0
]
z33
,
z135
;
input
[
MA
:
0
]
z136
,
z137
,
aout
;
output
[
MA
:
0
]
ain
;
input
[
2
*
DBW
-
1
:
0
]
din
;
output
[
2
*
DBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
wire
signed
[
CBW
-
1
:
0
]
z186
,
z187
;
reg
signed
[
DBW
-
1
:
0
]
z188
,
z189
;
reg
signed
[
SBW
-
1
:
0
]
z190
,
z191
,
z192
,
z193
,
z194
,
z195
;
reg
signed
[
DBW
-
1
:
0
]
z153
,
z154
;
wire
[
MA
-
1
:
0
]
z196
,
z197
,
z198
;
butrev
#
(
MA
,
MX
)
brard
(
z136
,
z197
);
butrev
#
(
MA
,
MX
)
brawr
(
z137
,
z198
);
assign
ain
=
{!
z136
[
MA
],
z197
};
assign
z196
=
(
MX
==
0
)?
0
:
z136
[
MY
:
1
]<<(
LS
-
1
);
twiddle
#
(
MA
,
CBW
)
tw
(
clk
,
z2
,
z48
,
z196
,
z187
,
z186
);
xpram
#
(
MA
+
1
,
2
*
DBW
)
ram
(
clk
,
z139
,
{
z137
[
MA
],
z198
},{
z154
,
z153
},
aout
,
dout
);
reg
z199
,
z200
,
z201
;
wire
signed
[
DBW
-
1
:
0
]
z151
=
$signed
(
din
[
DBW
-
1
:
1
]);
wire
signed
[
DBW
-
1
:
0
]
z152
=
$signed
(
din
[
2
*
DBW
-
1
:
DBW
+
1
]);
wire
signed
[
DBW
-
1
:
0
]
z202
=
z190
[
SBW
-
1
:
SBW
-
DBW
];
wire
signed
[
DBW
-
1
:
0
]
z203
=
z191
[
SBW
-
1
:
SBW
-
DBW
];
wire
signed
[
DBW
-
1
:
0
]
z204
=
z200
?
-
z202
:
z202
;
wire
signed
[
DBW
-
1
:
0
]
z205
=
z200
?
-
z203
:
z203
;
always
@(
posedge
clk
)
begin
z199
<=
z127
&&
z136
[
0
];
z200
<=
z199
;
z201
<=
z200
;
z192
<=
z151
*
z186
;
z193
<=
z152
*
z186
;
z194
<=
z151
*
z187
;
z195
<=
z152
*
z187
;
if
(
z199
)
z188
<=
z151
;
if
(
z199
)
z189
<=
z152
;
if
(
z199
)
z190
<=
z192
-
z195
;
if
(
z199
)
z191
<=
z193
+
z194
;
z153
<=
z188
+
z204
;
z154
<=
z189
+
z205
;
end
endmodule
module
bitrev
(
fbus
,
rbus
);
parameter
MA
=
8
;
input
[
MA
-
1
:
0
]
fbus
;
output
[
MA
-
1
:
0
]
rbus
;
genvar
i
;
generate
for
(
i
=
0
;
i
<
MA
;
i
=
i
+
1
)
begin
:
bits
assign
rbus
[
i
]
=
fbus
[
MA
-
1
-
i
];
end
endgenerate
endmodule
module
butrev
(
fbus
,
rbus
);
parameter
MA
=
8
;
parameter
MX
=
8
;
input
[
MA
-
1
:
0
]
fbus
;
output
[
MA
-
1
:
0
]
rbus
;
wire
[
MA
-
1
:
0
]
z16
,
z17
;
assign
z16
=
fbus
^
1
;
genvar
i
;
generate
for
(
i
=
0
;
i
<
MA
;
i
=
i
+
1
)
begin
:
bits
assign
z17
[
i
]
=
z16
[
(
i
>
MX
)?
i
:
(
i
<
MX
)?
i
+
1
:
0
];
assign
rbus
[
i
]
=
z17
[
MA
-
1
-
i
];
end
endgenerate
endmodule
module
xpram
(
clk
,
we
,
iadr
,
z143
,
oadr
,
odat
);
parameter
MA
=
12
;
parameter
DBW
=
8
;
parameter
RW
=
2
**
MA
;
input
clk
,
we
;
input
[
MA
-
1
:
0
]
iadr
,
oadr
;
input
[
DBW
-
1
:
0
]
z143
;
output
reg
[
DBW
-
1
:
0
]
odat
;
reg
[
DBW
-
1
:
0
]
z206
[
RW
-
1
:
0
];
always
@(
posedge
clk
)
begin
if
(
we
)
z206
[
iadr
]
<=
z143
;
odat
<=
z206
[
oadr
];
end
endmodule
module
twiddle
(
clk
,
ce
,
z48
,
z136
,
sin
,
cos
);
parameter
LW
=
10
;
parameter
CW
=
16
;
parameter
MW
=
12
;
parameter
RW
=
(
2
**
MW
);
parameter
LS
=
(
MW
>
LW
)?
MW
-
LW
:
0
;
parameter
LT
=
(
MW
>
LW
)?
0
:
LW
-
MW
;
input
clk
,
ce
,
z48
;
input
[
LW
-
1
:
0
]
z136
;
output
[
CW
-
1
:
0
]
sin
,
cos
;
wire
z1
=
0
,
z2
=
1
;
wire
[
1
:
0
]
z207
=
z136
[
LW
-
1
:
LW
-
2
];
wire
[
1
:
0
]
z208
=
z207
^{!
z48
,
z1
};
wire
[
1
:
0
]
z209
=
z207
+
1
;
wire
[
MW
-
1
:
0
]
z210
=
{
z208
,
z136
[
LW
-
3
:
LT
],{
LS
{
z1
}}};
wire
[
MW
-
1
:
0
]
z211
=
{
z209
,
z136
[
LW
-
3
:
LT
],{
LS
{
z1
}}};
`ifdef verilator
wire
[
31
:
0
]
z206
[
RW
-
1
:
0
];
`include "../lib/twiddle.hv"
reg
signed
[
CW
-
1
:
0
]
z212
,
z213
;
always
@(
posedge
clk
)
begin
if
(
ce
)
z212
<=
z206
[
z210
][
32
-
1
:
32
-
CW
];
if
(
ce
)
z213
<=
z206
[
z211
][
32
-
1
:
32
-
CW
];
end
`else
wire
[
31
:
0
]
z214
,
z215
;
dpram_1024x32x32
sinlut
(
clk
,
ce
,
z210
,
1'b0
,
32'b0
,
z214
,
clk
,
ce
,
z211
,
1'b0
,
32'b0
,
z215
);
`include "../lib/twiddle.hx"
assign
z212
=
z214
[
32
-
1
:
32
-
CW
];
assign
z213
=
z215
[
32
-
1
:
32
-
CW
];
`endif
endmodule
