/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class peakpick
extends Primitive {
    private static final boolean DEBUG = false;
    private DataFile inFile;
    private DataFile outFileAbs;
    private DataFile outFileVal;
    private Data inBuf;
    private Data outBufAbs;
    private Data outBufVal;
    private String labelTbl;
    private String labelAbs;
    private String labelVal;
    private int outType;
    private boolean is2d;
    private float padValue;
    private float hysteresis;
    private long index;
    private double start;
    private double delta;
    private int maxPeaks;
    private long[] peakInd;
    private float[] peakAbs;
    private float[] peakVal;
    private int peakCount;
    private float findLast;
    private float findMaxVal;
    private double findMaxAbs;
    private long findMaxInd;
    private long findLogged;
    private boolean complex;
    private int cxmode;
    private final int M_MAG = 1;
    private final int M_PHASE = 2;
    private final int M_REAL = 3;
    private final int M_IMAG = 4;
    private final int M_10LOG = 5;
    private final int M_20LOG = 6;
    private static final String modeList = "Mag,Phase,Real,Imag,10Log,20Log";

    public int open() {
        this.maxPeaks = this.MA.getL("MAX_PEAKS");
        this.inFile = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.inFile.open();
        int defXfer = 0;
        int typeClass = this.inFile.getType() / 1000;
        if (typeClass == 1) {
            defXfer = 8192;
            this.is2d = false;
            this.outType = 1000;
        } else if (typeClass == 2) {
            defXfer = 1;
            this.is2d = true;
            this.outType = this.maxPeaks == 1 ? 1000 : 2000;
        }
        this.xfer = this.MA.getL("/TL", defXfer);
        this.padValue = this.MA.getF("PAD");
        this.padValue = this.MA.getF("PAD_VALUE", this.padValue);
        boolean bl = this.complex = this.inFile.getFormatMode() == 67;
        if (this.complex) {
            String arg = this.MA.getS("CXMODE", "MAG");
            this.cxmode = Parser.find((String)modeList, (String)arg, (int)1, (int)0, (int)1);
        }
        this.hysteresis = this.MA.getF("/HYSTER", 0.0f);
        if (!this.is2d && (double)this.hysteresis > 0.0) {
            this.M.deprecate((CharSequence)"PEAKPICK: The algorithm used for Type 1000 files with a hysteresis greater than 0.0 is not accurate and has been deprecated since NeXtMidas 2.5.0.");
            this.xfer = 8192;
        }
        this.inBuf = this.inFile.getDataBuffer(this.xfer, (byte)70);
        this.start = this.inFile.getXStart();
        this.delta = this.inFile.getXDelta();
        this.peakInd = new long[this.maxPeaks];
        this.peakAbs = new float[this.maxPeaks];
        this.peakVal = new float[this.maxPeaks];
        this.peakCount = 0;
        this.index = 0L;
        this.labelTbl = this.MA.getU("TABLE", null);
        if (!this.is2d && this.maxPeaks == 1) {
            this.M.deprecate((CharSequence)"PEAKPICK: When reading a Type 1000 file with MAX_PEAKS=1, OUT_VAL and OUT_ABS are treated as results names. This behavior has been deprecated since NeXtMidas 2.5.0, see explain file for details.");
            if (this.MA.find("OUT_VAL")) {
                this.labelVal = this.MA.getS("OUT_VAL", null);
            }
            if (this.MA.find("OUT_ABS")) {
                this.labelAbs = this.MA.getS("OUT_ABS", null);
            }
        } else {
            this.outFileAbs = this.MA.getDataFile("OUT_ABS", this.inFile, 0);
            this.outFileAbs.setDataSize(0.0);
            this.outFileAbs.setSubSize(this.maxPeaks);
            this.outFileAbs.setDefaultQualifier("TYPE", (Object)this.outType);
            Object userSpecifiedType = this.outFileAbs.getQualifier("TYPE");
            if (Convert.o2l((Object)userSpecifiedType) / 1000 != this.outType / 1000) {
                this.M.warning((CharSequence)("specified type[" + userSpecifiedType + "] for OUT_ABS= should probably be of type " + this.outType));
            }
            this.outFileAbs.setFormat("SF");
            this.outFileAbs.open(66);
            this.outBufAbs = new Data("SF", this.maxPeaks);
            this.outFileVal = this.MA.getDataFile("OUT_VAL", this.inFile, 0);
            this.outFileVal.setDataSize(0.0);
            this.outFileVal.setType(this.outType);
            this.outFileVal.setFormat("SF");
            this.outFileVal.setSubSize(this.maxPeaks);
            this.outFileVal.open(66);
            this.outBufVal = new Data("SF", this.maxPeaks);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process() {
        int nelem;
        int status = 0;
        int ngot = this.inFile.read(this.inBuf);
        if (ngot == 0) {
            return -1;
        }
        if (ngot < 0) {
            return 9;
        }
        int n = nelem = this.is2d ? this.inFile.getSubSize() * ngot : ngot;
        if (this.complex) {
            this.convertComplexDataBuffer(this.inBuf, nelem, this.cxmode);
        }
        float[] fbuf = this.inBuf.castF(true);
        if (!this.is2d) {
            int offset = 0;
            peakpick peakpick2 = this;
            synchronized (peakpick2) {
                if ((double)this.hysteresis == 0.0) {
                    this.findPeaksX(fbuf, offset, offset + nelem, this.start, this.index);
                } else {
                    this.findPeaksD(fbuf, offset + offset, nelem, this.start, this.index);
                    this.doOutput();
                }
            }
            this.start += (double)nelem * this.delta;
            this.index += (long)nelem;
            this.inBuf.uncast(fbuf, false);
        } else {
            int fs = this.inFile.getSubSize();
            int offset = 0;
            for (int frame = 0; frame < ngot; ++frame) {
                peakpick peakpick3 = this;
                synchronized (peakpick3) {
                    offset = frame * fs;
                    this.peakCount = 0;
                    if ((double)this.hysteresis == 0.0) {
                        this.findPeaksX(fbuf, offset, offset + fs, this.start, 0L);
                    } else {
                        this.findPeaksH(fbuf, offset, offset + fs, this.start, 0L, this.maxPeaks);
                    }
                    this.doOutput();
                    continue;
                }
            }
        }
        this.inBuf.uncast(fbuf, false);
        return status;
    }

    public int close() {
        if (this.findLogged != -1L) {
            this.addFindPeak();
        }
        if (this.inFile != null) {
            this.inFile.close();
        }
        if (this.outFileAbs != null) {
            this.outFileAbs.close();
        }
        if (this.outFileVal != null) {
            this.outFileVal.close();
        }
        if (this.labelAbs != null) {
            this.MR.put(this.labelAbs, this.getPeakAbscissa());
        }
        if (this.labelVal != null) {
            this.MR.put(this.labelVal, this.getPeakValue());
        }
        if (this.labelTbl != null) {
            this.MR.put(this.labelTbl, (Object)this.getPeaksTable());
        }
        return 0;
    }

    private void convertComplexDataBuffer(Data buf, int nelems, int cxmode) {
        switch (cxmode) {
            case 1: {
                DataOp.mag((Data)buf, (Data)buf, (int)nelems, (int)18);
                break;
            }
            case 2: {
                DataOp.phase((Data)buf, (Data)buf, (int)nelems, (int)18);
                break;
            }
            case 3: {
                DataOp.real((Data)buf, (Data)buf, (int)nelems, (int)18);
                break;
            }
            case 4: {
                DataOp.imag((Data)buf, (Data)buf, (int)nelems, (int)18);
                break;
            }
            case 5: {
                DataOp.dblogb((Data)buf, (Data)buf, (int)nelems, (int)18);
                break;
            }
            case 6: {
                DataOp.dblogb2((Data)buf, (Data)buf, (int)nelems, (int)18);
                break;
            }
            default: {
                DataOp.mag((Data)buf, (Data)buf, (int)nelems, (int)18);
            }
        }
    }

    private void doOutput() {
        int numOut = this.outType == 2000 ? 1 : this.maxPeaks;
        for (int i = this.peakCount; i < this.maxPeaks; ++i) {
            this.peakInd[i] = -1L;
            this.peakAbs[i] = this.padValue;
            this.peakVal[i] = this.padValue;
        }
        if (this.outFileAbs != null && this.outFileAbs.isOpen()) {
            this.outBufAbs.fromArray((Object)this.peakAbs);
            this.outFileAbs.write(this.outBufAbs, numOut);
        }
        if (this.outFileVal != null && this.outFileVal.isOpen()) {
            this.outBufVal.fromArray((Object)this.peakVal);
            this.outFileVal.write(this.outBufVal, numOut);
        }
    }

    public Table getPeaksTable() {
        Table tbl = new Table();
        for (int i = 0; i < this.peakCount; ++i) {
            Table t = new Table();
            tbl.put("PEAK_" + i, (Object)t);
            t.put("INDEX", this.peakInd[i]);
            t.put("ABSCISSA", this.peakAbs[i]);
            t.put("VALUE", this.peakVal[i]);
        }
        return tbl;
    }

    public synchronized long getPeakIndex(int i) {
        return i < this.peakCount ? this.peakInd[i] : -1L;
    }

    public synchronized double getPeakAbscissa(int i) {
        return i < this.peakCount ? (double)this.peakAbs[i] : Double.NaN;
    }

    public synchronized double getPeakValue(int i) {
        return i < this.peakCount ? (double)this.peakVal[i] : Double.NaN;
    }

    public final long getPeakIndex() {
        return this.getPeakIndex(0);
    }

    public final double getPeakAbscissa() {
        return this.getPeakAbscissa(0);
    }

    public final double getPeakValue() {
        return this.getPeakValue(0);
    }

    public int getMaxPeaks() {
        return this.maxPeaks;
    }

    public int getPeakCount() {
        return this.peakCount;
    }

    private void debug(String msg) {
        System.out.println("PEAKPICK: " + msg);
    }

    private void debug(int peaks, String msg) {
        String pad = StringUtil.padLeft((String)"", (int)((this.maxPeaks - peaks) * 2));
        System.out.println("PEAKPICK: " + pad + msg);
    }

    private void findPeaksX(float[] buf, int offset, int end, double start, long fileOffset) {
        int i = offset;
        if (this.is2d) {
            this.findMaxInd = -1L;
            this.findLogged = -1L;
        } else if (fileOffset != 0L) {
            while (i + 1 < end && buf[i + 1] < this.findLast) {
                this.findLast = buf[++i];
            }
        }
        while (i < end) {
            while (i + 1 < end && buf[i + 1] > this.findLast) {
                this.findLast = buf[++i];
            }
            this.findMaxVal = buf[i];
            this.findMaxAbs = start + (double)i * this.delta;
            this.findMaxInd = fileOffset + (long)i;
            this.addFindPeak();
            while (i + 1 < end && buf[i + 1] < this.findLast) {
                this.findLast = buf[++i];
            }
            ++i;
        }
    }

    @Deprecated
    private void findPeaksD(float[] buf, int offset, int end, double abs, long fileOffset) {
        float maxVal = buf[offset];
        double maxAbs = abs;
        int maxInd = 0;
        boolean logged = false;
        for (int i = offset; i < end; ++i) {
            float val = buf[i];
            if (val > maxVal) {
                maxVal = val;
                maxAbs = abs;
                maxInd = i;
                logged = false;
            } else if (!logged && maxVal - val > this.hysteresis) {
                this.addPeak(fileOffset + (long)maxInd, (float)maxAbs, maxVal);
                maxVal = val;
                maxAbs = abs;
                maxInd = i;
                logged = true;
            } else if (logged) {
                maxVal = val;
            }
            abs += this.delta;
        }
    }

    private void findPeaksH(float[] buf, int offset, int end, double start, long fileOffset, int peaks) {
        double abscissa = start;
        float val = Float.NEGATIVE_INFINITY;
        double abs = 0.0;
        int ind = -1;
        for (int i = offset; i < end; ++i) {
            float v = buf[i];
            if (v > val) {
                val = v;
                abs = abscissa;
                ind = i;
            }
            abscissa += this.delta;
        }
        if (ind != -1) {
            boolean added = this.addPeak(fileOffset + (long)ind, (float)abs, val);
            if (peaks > 1 && added) {
                float min = val - this.hysteresis;
                if ((long)end - this.index < this.index - (long)offset) {
                    this.findPeaksL(buf, offset, end, start, fileOffset, peaks - 1, ind, min);
                    this.findPeaksR(buf, offset, end, start, fileOffset, peaks - 1, ind, min);
                } else {
                    this.findPeaksR(buf, offset, end, start, fileOffset, peaks - 1, ind, min);
                    this.findPeaksL(buf, offset, end, start, fileOffset, peaks - 1, ind, min);
                }
            }
        }
    }

    private void findPeaksL(float[] buf, int offset, int end, double start, long fileOffset, int peaks, int ind, float min) {
        for (end = ind - 1; end >= offset && (buf[end] > min || buf[end] < buf[end + 1]); --end) {
        }
        this.findPeaksH(buf, offset, end, start, fileOffset, peaks);
    }

    private void findPeaksR(float[] buf, int offset, int end, double start, long fileOffset, int peaks, int ind, float min) {
        start += (double)(ind + 1 - offset) * this.delta;
        offset = ind + 1;
        while (offset < end && (buf[offset] > min || buf[offset] < buf[offset - 1])) {
            ++offset;
            start += this.delta;
        }
        this.findPeaksH(buf, offset, end, start, fileOffset, peaks);
    }

    private void addFindPeak() {
        this.addPeak(this.findMaxInd, (float)this.findMaxAbs, this.findMaxVal);
        this.findLogged = this.findMaxInd;
        this.findMaxInd = -1L;
    }

    private boolean addPeak(long ind, float abs, float val) {
        int len;
        boolean added = true;
        int index = 0;
        for (int i = this.peakCount - 1; i >= 0 && index == 0; --i) {
            if (!(this.peakVal[i] > val)) continue;
            index = i + 1;
        }
        if (index == this.peakCount) {
            if (index < this.maxPeaks) {
                ++this.peakCount;
            } else {
                added = false;
            }
        } else if (this.peakCount < this.maxPeaks) {
            len = this.peakCount - index;
            System.arraycopy(this.peakInd, index, this.peakInd, index + 1, len);
            System.arraycopy(this.peakAbs, index, this.peakAbs, index + 1, len);
            System.arraycopy(this.peakVal, index, this.peakVal, index + 1, len);
            ++this.peakCount;
        } else {
            len = this.maxPeaks - index - 1;
            System.arraycopy(this.peakInd, index, this.peakInd, index + 1, len);
            System.arraycopy(this.peakAbs, index, this.peakAbs, index + 1, len);
            System.arraycopy(this.peakVal, index, this.peakVal, index + 1, len);
        }
        if (added) {
            this.peakInd[index] = ind;
            this.peakAbs[index] = abs;
            this.peakVal[index] = val;
        }
        return added;
    }
}

