/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Primitive;

public class fsvi
extends Primitive {
    public static final String modeList = "Integrate,Average,Exponetial,Maximum";
    public static final int M_INT = 1;
    public static final int M_AVG = 2;
    public static final int M_EXP = 3;
    public static final int M_MAX = 4;
    private DataFile hi;
    private DataFile ho;
    private Data dbi;
    private Data dbo;
    private Data dbf;
    private int mag;
    private boolean in2d;
    private boolean cxm;
    private boolean out1d;
    private int mode;
    private int frame;
    private int nblk;
    private int iblk;
    private double pri;
    private double delx;
    private double size;
    private double factor;

    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.hi.open(131072);
        this.in2d = this.hi.typeClass == 2;
        this.cxm = this.hi.spa == 2;
        this.delx = this.hi.getXDelta();
        this.size = this.hi.getSize();
        this.nblk = this.MA.getL("BLOCKS");
        this.pri = this.MA.getD("PRI");
        this.mode = this.MA.getSelectionIndex("MODE", modeList, 0);
        this.mag = this.MA.getL("/MAG", this.cxm ? 1 : 0);
        this.out1d = this.MA.getState("/1D", this.nblk < 0);
        if (this.pri > 0.0) {
            this.frame = (int)Math.round(this.pri / this.delx);
        } else if (this.pri < 0.0) {
            this.frame = (int)Math.max(1.0, -this.pri);
        } else if (this.in2d) {
            this.frame = this.hi.getSubSize();
        } else {
            this.M.error("Illegal PRI value = " + this.pri);
        }
        if (this.in2d) {
            this.size *= (double)this.frame;
        }
        if (this.nblk < 0) {
            this.nblk = (int)Math.floor(this.size / (double)this.frame);
        }
        this.factor = 1.0 / (double)this.nblk;
        int nblko = this.mode == 3 ? 1 : this.nblk;
        this.size = Math.floor(this.size / (double)this.frame / (double)nblko);
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        if (this.in2d) {
            this.ho.setYDelta(this.hi.getYDelta() * (double)nblko);
        } else {
            this.ho.setType(2000);
            this.ho.setSubSize(this.frame);
            this.ho.setYStart(this.hi.getXStart());
            this.ho.setYDelta(this.delx * (double)this.frame * (double)nblko);
            this.ho.setYUnits(1);
            this.ho.setXStart(0.0);
        }
        this.ho.setSize(this.size);
        byte dtype = 70;
        this.ho.setFormatType(dtype);
        if (this.mag > 0) {
            this.ho.setFormatMode((byte)83);
        }
        this.ho.open(131072);
        int fsi = this.in2d && this.frame == this.hi.getSubSize() ? 1 : this.frame;
        this.dbi = this.hi.getDataBuffer(fsi, dtype);
        this.dbo = this.ho.getDataBuffer(1, dtype);
        this.dbf = this.ho.getDataBuffer(1, dtype);
        this.iblk = 1;
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dbi);
        if (n < 0) {
            return 9;
        }
        if (this.mag == 2) {
            DataOp.mag2((Data)this.dbi, (Data)this.dbf);
        } else if (this.mag == 1) {
            DataOp.mag((Data)this.dbi, (Data)this.dbf);
        } else {
            this.dbf = this.dbi;
        }
        if (this.mode == 3 && this.iblk > 1) {
            DataOp.scale((Data)this.dbf, (Data)this.dbf, (int)this.frame, (double)this.factor);
            DataOp.scale((Data)this.dbo, (Data)this.dbo, (int)this.frame, (double)(1.0 - this.factor));
        }
        if (this.iblk == 1) {
            DataOp.copy((Data)this.dbf, (Data)this.dbo);
        } else if (this.mode == 4) {
            DataOp.max((Data)this.dbf, (Data)this.dbo, (Data)this.dbo);
        } else {
            DataOp.add((Data)this.dbf, (Data)this.dbo, (Data)this.dbo);
        }
        if (++this.iblk > this.nblk) {
            if (this.mode == 2) {
                DataOp.scale((Data)this.dbo, (Data)this.dbo, (int)this.frame, (double)this.factor);
            }
            this.ho.write(this.dbo);
            if (this.mode != 3) {
                this.iblk = 1;
            }
        }
        return 0;
    }

    public int close() {
        if (this.out1d) {
            this.ho.setFS(0);
        }
        this.hi.close();
        this.ho.close();
        return 0;
    }

    public int getBlock() {
        return this.nblk;
    }

    public double getPRI() {
        return this.pri;
    }

    public void setBlock(int value) {
        this.nblk = value;
        this.factor = 1.0 / (double)this.nblk;
    }

    public void setPRI(double value) {
        if (value == this.pri) {
            return;
        }
        this.MA.put("PRI", "" + value);
        this.setState(7);
    }
}

